/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.Consumer;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSAck;
import com.sun.messaging.jmq.jmsservice.JMSPacket;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jms.ra.DirectSession;
import com.sun.messaging.jms.ra.TemporaryDestination;
import java.util.logging.Logger;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class DirectConsumer
implements MessageConsumer,
QueueReceiver,
TopicSubscriber,
Consumer {
    private JMSService jmsservice;
    private DirectSession ds;
    private long connectionId;
    private long sessionId;
    private long consumerId = 0L;
    private javax.jms.Destination destination;
    private Destination jmsservice_destination;
    private String msgSelector;
    private String durableName;
    private String clientId;
    private MessageListener msgListener;
    private boolean noLocal;
    private boolean isClosed;
    private boolean isClosing;
    private static final transient String _className = "com.sun.messaging.jms.ra.DirectConsumer";
    private static final transient String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final transient String _lgrNameJMSConsumer = "javax.jms.MessageConsumer.mqjmsra";
    private static final transient Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final transient Logger _loggerJMC = Logger.getLogger("javax.jms.MessageConsumer.mqjmsra");
    private static final transient String _lgrMIDPrefix = "MQJMSRA_DP";
    private static final transient String _lgrMID_EET = "MQJMSRA_DP1001: ";
    private static final transient String _lgrMID_INF = "MQJMSRA_DP1101: ";
    private static final transient String _lgrMID_WRN = "MQJMSRA_DP2001: ";
    private static final transient String _lgrMID_ERR = "MQJMSRA_DP3001: ";
    private static final transient String _lgrMID_EXC = "MQJMSRA_DP4001: ";

    public DirectConsumer(DirectSession directSession, JMSService jMSService, javax.jms.Destination destination, Destination destination2, boolean bl, String string, String string2) {
        Object[] objectArray = new Object[]{directSession, jMSService, destination, destination2, bl, string, string2};
        _loggerOC.entering(_className, "constructor()", objectArray);
        this.ds = directSession;
        this.jmsservice = jMSService;
        this.consumerId = this.consumerId;
        this.destination = destination;
        this.jmsservice_destination = destination2;
        this.connectionId = directSession.getConnectionId();
        this.sessionId = directSession.getSessionId();
        this.msgSelector = string;
        this.durableName = string2;
        this.clientId = directSession.getConnection()._getClientID();
        this.noLocal = bl;
    }

    public synchronized void close() throws JMSException {
        _loggerJMC.fine("MQJMSRA_DP1101: consumerId=" + this.consumerId + ":" + "close()");
        if (this.isClosed) {
            return;
        }
        this.ds.removeConsumer(this);
        if (this.durableName != null) {
            this.ds.dc.removeDurableConsumer(this);
        }
        if (this.destination != null && this.destination instanceof TemporaryDestination) {
            this.ds.dc._decrementTemporaryDestinationUsage((TemporaryDestination)this.destination);
        }
        this._close();
    }

    public MessageListener getMessageListener() throws JMSException {
        this._checkIfClosed("getMessageListener()");
        return this.msgListener;
    }

    public String getMessageSelector() throws JMSException {
        this._checkIfClosed("getMessageSelector()");
        return this.msgSelector;
    }

    public Message receive() throws JMSException {
        String string = "receive()";
        this._checkIfClosed(string);
        return this.ds._fetchMessage(this.consumerId, 0L, string);
    }

    public Message receive(long l) throws JMSException {
        String string = "receive(timeout)";
        this._checkIfClosed(string);
        return this.ds._fetchMessage(this.consumerId, l, string);
    }

    public Message receiveNoWait() throws JMSException {
        String string = "receiveNoWait()";
        this._checkIfClosed(string);
        return this.ds._fetchMessage(this.consumerId, -1L, string);
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        String string = "setMessageListener()";
        JMSServiceReply jMSServiceReply = null;
        _loggerJMC.fine("MQJMSRA_DP1101: connectionId=" + this.connectionId + ":" + string + "=" + messageListener);
        this._checkIfClosed(string);
        if (messageListener == null) {
            this.msgListener = null;
            this.ds._setAsync(false);
        } else {
            this.msgListener = messageListener;
            this.ds._setAsync(true);
        }
        try {
            jMSServiceReply = this.jmsservice.setConsumerAsync(this.connectionId, this.sessionId, this.consumerId, messageListener == null ? null : this);
        }
        catch (JMSServiceException jMSServiceException) {
            String string2;
            JMSServiceReply.Status status = jMSServiceException.getJMSServiceReply().getStatus();
            switch (status) {
                case NOT_FOUND: {
                    string2 = "consumer not found.";
                    break;
                }
                default: {
                    string2 = "unkown JMSService server error:" + jMSServiceException.getMessage();
                }
            }
            String string3 = "setMessageListener on JMSService:" + this.jmsservice.getJMSServiceID() + " failed for connectionId:" + this.connectionId + ", sessionId:" + this.sessionId + ", consumerId:" + this.consumerId + " due to " + string2;
            _loggerJMC.severe(string3);
            JMSException jMSException = new JMSException(string3);
            jMSException.initCause((Throwable)jMSServiceException);
            throw jMSException;
        }
    }

    public Queue getQueue() throws JMSException {
        this._checkIfClosed("getQueue()");
        if (this.destination instanceof Queue) {
            return (Queue)this.destination;
        }
        String string = "MQJMSRA_DP4001: getQueue():Invalid to Topic destination=" + this.destination;
        _loggerJMC.warning(string);
        throw new JMSException(string);
    }

    public Topic getTopic() throws JMSException {
        this._checkIfClosed("getTopic()");
        if (this.destination instanceof Topic) {
            return (Topic)this.destination;
        }
        String string = "MQJMSRA_DP4001: getTopic():Invalid to Queue destination=" + this.destination;
        _loggerJMC.warning(string);
        throw new JMSException(string);
    }

    public boolean getNoLocal() throws JMSException {
        this._checkIfClosed("getNoLocal()");
        if (this.destination instanceof Queue) {
            String string = "MQJMSRA_DP4001: getNoLocal():Invalid on Queue destination=" + this.destination;
            _loggerJMC.warning(string);
            throw new JMSException(string);
        }
        return this.noLocal;
    }

    public JMSAck deliver(JMSPacket jMSPacket) {
        return this.ds._deliverMessage(this.msgListener, jMSPacket, this.consumerId);
    }

    protected synchronized void _setConsumerId(long l) {
        if (this.consumerId != 0L) {
            String string = "MQJMSRA_DP2001: _setConsumerId():Attempt to reset Id of:" + this.consumerId + ":to:" + l + ":Ignoring.";
            _loggerJMC.warning(string);
        } else {
            this.consumerId = l;
        }
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getConsumerId() {
        return this.consumerId;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private void _checkIfClosed(String string) throws JMSException {
        if (this.isClosed()) {
            String string2 = _lgrMID_EXC + string + "MessageConsumer is closed:Id=" + this.consumerId;
            _loggerJMC.warning(string2);
            throw new IllegalStateException(string2);
        }
    }

    private void _unsupported(String string) throws JMSException {
        String string2 = "MQJMSRA_DP2001: consumerId=" + this.consumerId + ":" + string;
        _loggerJMC.warning(string2);
        throw new JMSException(string2);
    }

    protected synchronized void _close() throws JMSException {
        if (this.isClosed) {
            return;
        }
        this.isClosing = true;
        try {
            this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, this.consumerId, null, this.clientId);
        }
        catch (JMSServiceException jMSServiceException) {
            _loggerJMC.warning("MQJMSRA_DP2001: consumerId=" + this.consumerId + ":" + "close():" + "JMSService.deleteConsumer():" + "JMSServiceException=" + jMSServiceException.getMessage());
        }
        this.isClosed = true;
        this.isClosing = false;
    }
}

