/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.client;

import com.sun.appserv.management.client.ConnectionSource;
import com.sun.enterprise.deployapi.ProgressObjectImpl;
import com.sun.enterprise.deployapi.SunTarget;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.client.DeploymentClientUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeStateAction
extends ProgressObjectImpl {
    private static final Set<ModuleType> unchangeableStateModuleTypes = ChangeStateAction.initUnchangeableStateModuleTypes();

    private static Set<ModuleType> initUnchangeableStateModuleTypes() {
        HashSet<ModuleType> result = new HashSet<ModuleType>();
        result.add(ModuleType.CAR);
        return result;
    }

    public ChangeStateAction(SunTarget[] targets) {
        super(targets);
    }

    @Override
    public void run() {
        ModuleType moduleType;
        ConnectionSource dasConnection = (ConnectionSource)this.args[0];
        SunTarget[] targets = (SunTarget[])this.args[1];
        this.moduleID = (String)this.args[2];
        CommandType newState = (CommandType)this.args[3];
        SunTarget domain = (SunTarget)this.args[4];
        StringManager localStrings = StringManager.getManager(this.getClass());
        try {
            moduleType = DeploymentClientUtils.getModuleType(dasConnection.getExistingMBeanServerConnection(), this.moduleID);
        }
        catch (Throwable ioex) {
            this.finalDeploymentStatus.setStageException(ioex);
            this.setupForAbnormalExit(localStrings.getString("enterprise.deployment.client.unrecognized_module_type", this.moduleID, ioex.getMessage()), domain);
            return;
        }
        boolean state = false;
        String action = "Disable";
        if (CommandType.START.equals(newState)) {
            state = true;
            action = "Enable";
        }
        ArrayList<SunTargetModuleID> resultTargetModuleIDs = new ArrayList<SunTargetModuleID>();
        for (int i = 0; i < targets.length; ++i) {
            DeploymentStatus stat = new DeploymentStatus();
            stat.setStageDescription(localStrings.getString("enterprise.deployment.client.state_change_desc", action, this.moduleID));
            try {
                int deplStatus;
                String messageKey;
                if (!unchangeableStateModuleTypes.contains(moduleType)) {
                    messageKey = "enterprise.deployment.client.state_change_success";
                    deplStatus = 2;
                    DeploymentClientUtils.changeStateOfModule(dasConnection.getExistingMBeanServerConnection(), this.moduleID, moduleType == null ? null : moduleType.toString(), targets[i], state);
                } else {
                    messageKey = "enterprise.deployment.client.state_change_noop";
                    deplStatus = 2;
                }
                stat.setStageStatus(deplStatus);
                stat.setStageStatusMessage(localStrings.getString(messageKey, action, this.moduleID));
            }
            catch (Throwable ex) {
                String msg = CommandType.START.equals(newState) ? localStrings.getString("enterprise.deployment.client.start.failed") : localStrings.getString("enterprise.deployment.client.stop.failed");
                stat.setStageException(ex);
                stat.setStageStatus(0);
                stat.setStageStatusMessage(msg + ex.getMessage());
            }
            if (!this.checkStatusAndAddStage(targets[i], null, localStrings.getString("enterprise.deployment.client.change_state", action, this.moduleID, targets[i].getName()), dasConnection, stat, state)) {
                return;
            }
            resultTargetModuleIDs.add(new SunTargetModuleID(this.moduleID, targets[i]));
        }
        this.targetModuleIDs = new TargetModuleID[resultTargetModuleIDs.size()];
        this.targetModuleIDs = resultTargetModuleIDs.toArray(this.targetModuleIDs);
        this.setupForNormalExit(localStrings.getString("enterprise.deployment.client.change_state_all", action), domain);
    }
}

