/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.HTTPListenerConfig;
import com.sun.appserv.management.config.IIOPListenerConfig;
import com.sun.appserv.management.config.JMXConnectorConfig;
import com.sun.appserv.management.config.NodeAgentConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SSLConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.enterprise.tools.admingui.handlers.ConfigurationHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.faces.model.SelectItem;
import javax.management.Attribute;
import javax.net.ssl.SSLServerSocketFactory;

public class JmxHandlers {
    static String[] COMMON_CIPHERS = new String[]{"SSL_RSA_WITH_RC4_128_MD5", "SSL_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"};
    static String[] BIT_CIPHERS = new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"};

    public static void getAdminServiceProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        handlerCtx.setOutputValue("JmxConnectorName", (Object)config.getAdminServiceConfig().getSystemJMXConnectorName());
        handlerCtx.setOutputValue("Properties", (Object)config.getAdminServiceConfig().getProperties());
    }

    public static void saveAdminServiceProps(HandlerContext handlerCtx) {
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        AMXUtil.editProperties(handlerCtx, (PropertiesAccess)config.getAdminServiceConfig());
    }

    public static void getJmxConnectorSettings(HandlerContext handlerCtx) {
        String jmxConnName = (String)handlerCtx.getInputValue("JmxName");
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        JMXConnectorConfig connectorConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(jmxConnName);
        handlerCtx.setOutputValue("JmxProtocol", (Object)connectorConfig.getProtocol());
        handlerCtx.setOutputValue("JmxServUrl", (Object)JmxHandlers.getJMXConnectorServURL(jmxConnName, configName));
        handlerCtx.setOutputValue("Address", (Object)connectorConfig.getAddress());
        handlerCtx.setOutputValue("security", (Object)connectorConfig.getSecurityEnabled());
        handlerCtx.setOutputValue("Port", (Object)connectorConfig.getPort());
        handlerCtx.setOutputValue("RealmName", (Object)connectorConfig.getAuthRealmName());
        if (AMXUtil.isEE()) {
            String client = "";
            if (connectorConfig.existsProperty("client-hostname")) {
                client = connectorConfig.getPropertyValue("client-hostname");
            }
            handlerCtx.setOutputValue("clientHostname", (Object)client);
        }
    }

    public static void getSSLProperties(HandlerContext handlerCtx) {
        String oName = (String)handlerCtx.getInputValue("Name");
        ConfigConfig config = AMXUtil.getConfig((String)handlerCtx.getInputValue("ConfigName"));
        String selectedCiphers = null;
        String type = (String)handlerCtx.getInputValue("Type");
        JMXConnectorConfig sslContainerConfig = null;
        boolean ssl3Prop = false;
        boolean ssl2Prop = false;
        boolean tlsProp = false;
        boolean clientAuth = false;
        boolean isEdit = (Boolean)handlerCtx.getInputValue("Edit");
        Map sslProps = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("sslProps");
        if (isEdit) {
            if (type.equals("jmx")) {
                JMXConnectorConfig jmxConfig;
                sslContainerConfig = jmxConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(oName);
            } else if (type.equals("iiop")) {
                IIOPListenerConfig iiopConfig = (IIOPListenerConfig)config.getIIOPServiceConfig().getIIOPListenerConfigMap().get(oName);
                sslContainerConfig = iiopConfig;
            } else if (type.equals("http")) {
                HTTPListenerConfig httpConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(oName);
                sslContainerConfig = httpConfig;
            } else if (type.equals("nodeagent")) {
                JMXConnectorConfig jmxConfig;
                NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(oName);
                sslContainerConfig = jmxConfig = agentConfig.getJMXConnectorConfig();
            }
            SSLConfig sslConfig = sslContainerConfig.getSSLConfig();
            if (sslConfig != null) {
                clientAuth = sslConfig.getClientAuthEnabled();
                handlerCtx.setOutputValue("CertNickname", (Object)sslConfig.getCertNickname());
                ssl3Prop = sslConfig.getSSL3Enabled();
                ssl2Prop = sslConfig.getSSL2Enabled();
                tlsProp = sslConfig.getTLSEnabled();
                selectedCiphers = sslConfig.getSSL3TLSCiphers();
            }
        } else if (sslProps != null) {
            clientAuth = (Boolean)sslProps.get("clientAuth");
            ssl3Prop = (Boolean)sslProps.get("ssl3Prop");
            ssl2Prop = (Boolean)sslProps.get("ssl2Prop");
            tlsProp = (Boolean)sslProps.get("tlsProp");
            handlerCtx.setOutputValue("CertNickname", sslProps.get("certNickname"));
        }
        SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
        String[] supportedCiphers = factory.getDefaultCipherSuites();
        Vector ciphers = JmxHandlers.getCiphersVector(supportedCiphers);
        SelectItem[] commonCiphers = ConfigurationHandlers.getOptions(JmxHandlers.getCommonCiphers(ciphers));
        SelectItem[] ephemeralCiphers = ConfigurationHandlers.getOptions(JmxHandlers.getEphemeralCiphers(ciphers));
        SelectItem[] otherCiphers = ConfigurationHandlers.getOptions(JmxHandlers.getOtherCiphers(ciphers));
        SelectItem[] eccCiphers = ConfigurationHandlers.getOptions(JmxHandlers.getEccCiphers(ciphers));
        handlerCtx.setOutputValue("ClientAuth", (Object)clientAuth);
        handlerCtx.setOutputValue("SSL3Prop", (Object)ssl3Prop);
        handlerCtx.setOutputValue("SSL2Prop", (Object)ssl2Prop);
        handlerCtx.setOutputValue("TLSProp", (Object)tlsProp);
        handlerCtx.setOutputValue("CommonCiphersList", (Object)commonCiphers);
        handlerCtx.setOutputValue("EphemeralCiphersList", (Object)ephemeralCiphers);
        handlerCtx.setOutputValue("OtherCiphersList", (Object)otherCiphers);
        handlerCtx.setOutputValue("EccCiphersList", (Object)eccCiphers);
        if (sslProps == null) {
            String[] ciphersArr = JmxHandlers.getSelectedCiphersList(selectedCiphers);
            Vector selValues = JmxHandlers.getCiphersVector(ciphersArr);
            handlerCtx.setOutputValue("SelectedCommon", (Object)JmxHandlers.getCommonCiphers(selValues));
            handlerCtx.setOutputValue("SelectedEph", (Object)JmxHandlers.getEphemeralCiphers(selValues));
            handlerCtx.setOutputValue("SelectedOther", (Object)JmxHandlers.getOtherCiphers(selValues));
            handlerCtx.setOutputValue("SelectedEcc", (Object)JmxHandlers.getEccCiphers(selValues));
        } else {
            handlerCtx.setOutputValue("SelectedCommon", sslProps.get("selectedCommon"));
            handlerCtx.setOutputValue("SelectedEph", sslProps.get("selectedEph"));
            handlerCtx.setOutputValue("SelectedOther", sslProps.get("selectedOther"));
            handlerCtx.setOutputValue("SelectedEcc", sslProps.get("selectedEcc"));
        }
    }

    public static void getDefaultJmxConnectorSettings(HandlerContext handlerCtx) {
        String jmxConnName = (String)handlerCtx.getInputValue("JmxName");
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        JMXConnectorConfig connectorConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(jmxConnName);
        handlerCtx.setOutputValue("JmxProtocol", (Object)connectorConfig.getDefaultValue("Protocol"));
        handlerCtx.setOutputValue("JmxServUrl", (Object)JmxHandlers.getJMXConnectorServURL(jmxConnName, configName));
        handlerCtx.setOutputValue("Address", (Object)connectorConfig.getDefaultValue("Address"));
        handlerCtx.setOutputValue("Port", (Object)connectorConfig.getDefaultValue("Port"));
        handlerCtx.setOutputValue("RealmName", (Object)connectorConfig.getDefaultValue("AuthRealmName"));
    }

    public static void saveJmxConnectorSettings(HandlerContext handlerCtx) {
        String jmxConnName = (String)handlerCtx.getInputValue("JmxName");
        String configName = (String)handlerCtx.getInputValue("ConfigName");
        ConfigConfig config = AMXUtil.getConfig(configName);
        JMXConnectorConfig connectorConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(jmxConnName);
        String objName = "com.sun.appserv:type=jmx-connector,name=" + jmxConnName + ",config=" + configName + ",category=config";
        try {
            Boolean security = (Boolean)handlerCtx.getInputValue("security");
            JMXUtil.setAttribute(objName, new Attribute("security-enabled", security == null ? Boolean.FALSE : security));
            JMXUtil.setAttribute(objName, new Attribute("port", handlerCtx.getInputValue("Port")));
            JMXUtil.setAttribute(objName, new Attribute("address", handlerCtx.getInputValue("Address")));
            JMXUtil.setAttribute(objName, new Attribute("auth-realm-name", handlerCtx.getInputValue("RealmName")));
            if (AMXUtil.isEE()) {
                String clientHostname = (String)handlerCtx.getInputValue("clientHostname");
                AMXUtil.changeProperty((PropertiesAccess)connectorConfig, "client-hostname", clientHostname);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveSSLProperties(HandlerContext handlerCtx) {
        try {
            Map options;
            Map props;
            String oName = (String)handlerCtx.getInputValue("Name");
            String configName = (String)handlerCtx.getInputValue("ConfigName");
            ConfigConfig config = AMXUtil.getConfig(configName);
            String certNickname = (String)handlerCtx.getInputValue("CertNickname");
            String type = (String)handlerCtx.getInputValue("Type");
            JMXConnectorConfig sslContainerConfig = null;
            boolean isEdit = (Boolean)handlerCtx.getInputValue("Edit");
            if (isEdit) {
                if (type.equals("jmx")) {
                    JMXConnectorConfig jmxConfig;
                    sslContainerConfig = jmxConfig = (JMXConnectorConfig)config.getAdminServiceConfig().getJMXConnectorConfigMap().get(oName);
                } else if (type.equals("iiop")) {
                    IIOPListenerConfig iiopConfig = (IIOPListenerConfig)config.getIIOPServiceConfig().getIIOPListenerConfigMap().get(oName);
                    sslContainerConfig = iiopConfig;
                } else if (type.equals("http")) {
                    HTTPListenerConfig httpConfig = (HTTPListenerConfig)config.getHTTPServiceConfig().getHTTPListenerConfigMap().get(oName);
                    sslContainerConfig = httpConfig;
                } else if (type.equals("nodeagent")) {
                    JMXConnectorConfig jmxConfig;
                    NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(oName);
                    sslContainerConfig = jmxConfig = agentConfig.getJMXConnectorConfig();
                }
                if (sslContainerConfig != null && sslContainerConfig.getSSLConfig() != null) {
                    sslContainerConfig.removeSSLConfig();
                }
            } else if (type.equals("iiop")) {
                props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("iiopProps");
                options = AMXUtil.convertToPropertiesOptionMap((Map)props.get("options"), null);
                IIOPListenerConfig iiopConfig = config.getIIOPServiceConfig().createIIOPListenerConfig((String)props.get("iiopName"), (String)props.get("address"), options);
                iiopConfig.setPort((String)props.get("port"));
                iiopConfig.setEnabled(((Boolean)props.get("listener")).booleanValue());
                iiopConfig.setSecurityEnabled(((Boolean)props.get("security")).booleanValue());
                sslContainerConfig = iiopConfig;
            } else if (type.equals("http")) {
                props = (Map)handlerCtx.getFacesContext().getExternalContext().getSessionMap().get("httpProps");
                options = AMXUtil.convertToPropertiesOptionMap((Map)props.get("options"), null);
                int port = Integer.parseInt((String)props.get("port"));
                String vs = (String)props.get("virtualServer");
                String httpName = (String)props.get("httpName");
                String serverName = (String)props.get("serverName");
                if (GuiUtil.isEmpty(serverName)) {
                    serverName = " ";
                }
                HTTPListenerConfig httpConfig = config.getHTTPServiceConfig().createHTTPListenerConfig(httpName, (String)props.get("address"), port, vs, serverName, options);
                httpConfig.setEnabled(((Boolean)props.get("enabled")).booleanValue());
                httpConfig.setSecurityEnabled(((Boolean)props.get("securityEnabled")).booleanValue());
                httpConfig.setRedirectPort((String)props.get("redirectPort"));
                httpConfig.setAcceptorThreads((String)props.get("acceptor-threads"));
                httpConfig.setXpoweredBy(((Boolean)props.get("xpowered-by")).booleanValue());
                httpConfig.setBlockingEnabled(((Boolean)props.get("blocking-enabled")).booleanValue());
                VirtualServerConfig vsConfig = (VirtualServerConfig)config.getHTTPServiceConfig().getVirtualServerConfigMap().get(vs);
                String listeners = vsConfig.getHTTPListeners();
                if (GuiUtil.isEmpty(listeners)) {
                    vsConfig.setHTTPListeners(httpName);
                } else {
                    vsConfig.setHTTPListeners(listeners + "," + httpName);
                }
                sslContainerConfig = httpConfig;
            }
            if (certNickname != null && !certNickname.equals("")) {
                SSLConfig sslConfig = sslContainerConfig.getSSLConfig();
                if (sslConfig == null) {
                    sslConfig = sslContainerConfig.createSSLConfig(certNickname, new HashMap());
                } else {
                    sslConfig.setCertNickname(certNickname);
                }
                sslConfig.setClientAuthEnabled(((Boolean)handlerCtx.getInputValue("ClientAuth")).booleanValue());
                boolean ssl3Prop = (Boolean)handlerCtx.getInputValue("SSL3Prop");
                sslConfig.setSSL3Enabled(ssl3Prop);
                if (!type.equals("iiop")) {
                    boolean ssl2Prop = (Boolean)handlerCtx.getInputValue("SSL2Prop");
                    sslConfig.setSSL2Enabled(ssl2Prop);
                }
                boolean tlsProp = (Boolean)handlerCtx.getInputValue("TLSProp");
                sslConfig.setTLSEnabled(tlsProp);
                if (ssl3Prop || tlsProp) {
                    SSLServerSocketFactory factory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
                    String[] supportedCiphers = factory.getDefaultCipherSuites();
                    Vector ciphersVector = JmxHandlers.getCiphersVector(supportedCiphers);
                    String[] selectedCiphers = JmxHandlers.getSelectedCiphersList(sslConfig.getSSL3TLSCiphers());
                    String[] selectedCommon = (String[])handlerCtx.getInputValue("SelectedCommon");
                    String[] selectedEph = (String[])handlerCtx.getInputValue("SelectedEph");
                    String[] selectedOther = (String[])handlerCtx.getInputValue("SelectedOther");
                    String[] selectedEcc = (String[])handlerCtx.getInputValue("SelectedEcc");
                    String ciphers = JmxHandlers.processSelectedCiphers(selectedCommon, "");
                    ciphers = JmxHandlers.processSelectedCiphers(selectedEph, ciphers);
                    ciphers = JmxHandlers.processSelectedCiphers(selectedOther, ciphers);
                    ciphers = JmxHandlers.processSelectedCiphers(selectedEcc, ciphers);
                    sslConfig.setSSL3TLSCiphers(ciphers);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateSSLProperties(HandlerContext handlerCtx) {
        HashMap<String, Object> sslPropsMap = new HashMap<String, Object>();
        sslPropsMap.put("certNickname", (String)handlerCtx.getInputValue("CertNickname"));
        sslPropsMap.put("clientAuth", (Boolean)handlerCtx.getInputValue("ClientAuth"));
        sslPropsMap.put("ssl3Prop", (Boolean)handlerCtx.getInputValue("SSL3Prop"));
        sslPropsMap.put("ssl2Prop", (Boolean)handlerCtx.getInputValue("SSL2Prop"));
        sslPropsMap.put("tlsProp", (Boolean)handlerCtx.getInputValue("TLSProp"));
        sslPropsMap.put("selectedCommon", (String[])handlerCtx.getInputValue("SelectedCommon"));
        sslPropsMap.put("selectedEph", (String[])handlerCtx.getInputValue("SelectedEph"));
        sslPropsMap.put("selectedOther", (String[])handlerCtx.getInputValue("SelectedOther"));
        sslPropsMap.put("selectedEcc", (String[])handlerCtx.getInputValue("SelectedEcc"));
        handlerCtx.getFacesContext().getExternalContext().getSessionMap().put("sslProps", sslPropsMap);
    }

    public static void getNodeAgentJmxSettings(HandlerContext handlerCtx) {
        String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
        Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
        NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(ndAgentName);
        JMXConnectorConfig connectorConfig = agentConfig.getJMXConnectorConfig();
        handlerCtx.setOutputValue("JmxName", (Object)agentConfig.getSystemJMXConnectorName());
        handlerCtx.setOutputValue("JmxProtocol", (Object)connectorConfig.getProtocol());
        handlerCtx.setOutputValue("Address", (Object)connectorConfig.getAddress());
        handlerCtx.setOutputValue("Port", (Object)connectorConfig.getPort());
        handlerCtx.setOutputValue("RealmName", (Object)connectorConfig.getAuthRealmName());
        handlerCtx.setOutputValue("Accept", (Object)connectorConfig.getAcceptAll());
        handlerCtx.setOutputValue("security", (Object)connectorConfig.getSecurityEnabled());
        String client = "";
        if (connectorConfig.existsProperty("client-hostname")) {
            client = connectorConfig.getPropertyValue("client-hostname");
        }
        handlerCtx.setOutputValue("clientHostname", (Object)client);
    }

    public static void saveNodeAgentJmxSettings(HandlerContext handlerCtx) {
        try {
            String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
            Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
            NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(ndAgentName);
            JMXConnectorConfig connectorConfig = agentConfig.getJMXConnectorConfig();
            String objName = "com.sun.appserv:type=jmx-connector,node-agent=" + ndAgentName + ",category=config";
            JMXUtil.setAttribute(objName, new Attribute("address", handlerCtx.getInputValue("Address")));
            JMXUtil.setAttribute(objName, new Attribute("port", handlerCtx.getInputValue("Port")));
            JMXUtil.setAttribute(objName, new Attribute("auth-realm-name", handlerCtx.getInputValue("RealmName")));
            connectorConfig.setProtocol((String)handlerCtx.getInputValue("JmxProtocol"));
            connectorConfig.setAcceptAll(((Boolean)handlerCtx.getInputValue("Accept")).booleanValue());
            connectorConfig.setSecurityEnabled(((Boolean)handlerCtx.getInputValue("security")).booleanValue());
            String clientHostname = (String)handlerCtx.getInputValue("clientHostname");
            AMXUtil.changeProperty((PropertiesAccess)connectorConfig, "client-hostname", clientHostname);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    private static String[] getSelectedCiphersList(String selectedCiphers) {
        Vector<String> selItems = new Vector<String>();
        if (selectedCiphers != null) {
            String[] sel = selectedCiphers.split(",");
            for (int i = 0; i < sel.length; ++i) {
                String cName = sel[i];
                if (!cName.startsWith("+")) continue;
                cName = cName.substring(1, cName.length());
                selItems.add(cName);
            }
        }
        return selItems.toArray(new String[selItems.size()]);
    }

    private static String processSelectedCiphers(String[] selectedCiphers, String ciphers) {
        if (selectedCiphers != null) {
            for (int i = 0; i < selectedCiphers.length; ++i) {
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "+" + selectedCiphers[i];
            }
        }
        return ciphers;
    }

    private static String processDeletedCiphers(String[] oldCiphers, String ciphers) {
        if (oldCiphers != null) {
            for (int i = 0; i < oldCiphers.length; ++i) {
                String cipVal = oldCiphers[i];
                if (ciphers.indexOf(cipVal) == -1) continue;
                if (!ciphers.equals("")) {
                    ciphers = ciphers + ",";
                }
                ciphers = ciphers + "-" + cipVal;
            }
        }
        return ciphers;
    }

    private static Vector getCiphersVector(String[] allCiphers) {
        Vector<String> ciphers = new Vector<String>();
        for (int i = 0; i < allCiphers.length; ++i) {
            ciphers.add(allCiphers[i]);
        }
        return ciphers;
    }

    private static String[] getCommonCiphers(Vector ciphers) {
        Vector commonCiphers = JmxHandlers.filterCiphers(ciphers, COMMON_CIPHERS);
        String[] ciphersList = commonCiphers.toArray(new String[commonCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEccCiphers(Vector ciphers) {
        Vector eccCiphers = JmxHandlers.breakUpCiphers(new Vector(), ciphers, "ECDH");
        eccCiphers = JmxHandlers.breakUpCiphers(eccCiphers, ciphers, "ECDHE");
        String[] ciphersList = eccCiphers.toArray(new String[eccCiphers.size()]);
        return ciphersList;
    }

    private static String[] getEphemeralCiphers(Vector ciphers) {
        Vector ephmCiphers = JmxHandlers.breakUpCiphers(new Vector(), ciphers, "DHE_RSA");
        ephmCiphers = JmxHandlers.breakUpCiphers(ephmCiphers, ciphers, "DHE_DSS");
        String[] ciphersList = ephmCiphers.toArray(new String[ephmCiphers.size()]);
        return ciphersList;
    }

    private static String[] getOtherCiphers(Vector ciphers) {
        Vector bitCiphers = JmxHandlers.filterCiphers(ciphers, BIT_CIPHERS);
        String[] ciphersList = bitCiphers.toArray(new String[bitCiphers.size()]);
        return ciphersList;
    }

    private static Vector filterCiphers(Vector ciphers, String[] filterList) {
        Vector listCiphers = new Vector();
        for (int i = 0; i < ciphers.size(); ++i) {
            String cipherName = ciphers.get(i).toString();
            if (!Arrays.asList(filterList).contains(cipherName)) continue;
            listCiphers.add(ciphers.get(i));
        }
        return listCiphers;
    }

    private static Vector breakUpCiphers(Vector cipherSubset, Vector allCiphers, String type) {
        for (int i = 0; i < allCiphers.size(); ++i) {
            String cipherName = allCiphers.get(i).toString();
            if (cipherName.indexOf(type) == -1 || Arrays.asList(BIT_CIPHERS).contains(cipherName)) continue;
            cipherSubset.add(cipherName);
        }
        return cipherSubset;
    }

    private static String getJMXConnectorServURL(String jmxConnName, String configName) {
        String objName = "com.sun.appserv:type=jmx-connector,name=" + jmxConnName + ",config=" + configName + ",category=config";
        String jmxServiceUrl = (String)JMXUtil.getAttribute(objName, "JMXServiceURL");
        return jmxServiceUrl;
    }

    public void getJMXAttribute(HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("ObjectName");
        String attributeName = (String)handlerCtx.getInputValue("AttributeName");
        Object attributeValue = JMXUtil.getAttribute(objectName, attributeName);
        handlerCtx.setOutputValue("AttributeValue", attributeValue);
    }
}

