/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.config.ClusteredServerConfig;
import com.sun.appserv.management.config.LogServiceConfig;
import com.sun.appserv.management.config.NodeAgentConfig;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.ServerConfig;
import com.sun.appserv.management.config.StandaloneServerConfig;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.tools.admingui.handlers.ConnectorsHandlers;
import com.sun.enterprise.tools.admingui.handlers.EESupportHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.JMXUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.Attribute;

public class NodeAgentHandlers {
    private static String NODE_AGENT_OBJNAME = "com.sun.appserv:type=node-agents,category=config";

    public static void getNodeAgentsList(HandlerContext handlerCtx) {
        ArrayList result = new ArrayList();
        try {
            Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
            List selectedList = (List)handlerCtx.getInputValue("selectedRows");
            boolean hasOrig = selectedList != null && selectedList.size() != 0;
            for (String key : nodeAgentMap.keySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(key);
                String name = agentConfig.getName();
                String agentStatus = agentConfig.getPropertyValue("rendezvousOccurred");
                String hostName = GuiUtil.getMessage("nodeAgent.UnknownHost");
                String status = null;
                if (agentStatus.equalsIgnoreCase("true")) {
                    hostName = agentConfig.getJMXConnectorConfig().getPropertyValue("client-hostname");
                    status = NodeAgentHandlers.getStatusString(name);
                } else {
                    status = NodeAgentHandlers.getWarningString(GuiUtil.getMessage("nodeAgent.awaitingInitialSync"));
                }
                oneRow.put("name", name == null ? " " : name);
                oneRow.put("hostName", hostName == null ? " " : hostName);
                oneRow.put("status", status == null ? " " : status);
                oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void deleteSelectedNodeAgents(HandlerContext handlerCtx) {
        List obj;
        String operName = "deleteNodeAgentConfig";
        String[] signature = new String[]{"java.lang.String"};
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                NodeAgentConfig ndAgent = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(name);
                Object[] params = new Object[]{name};
                JMXUtil.invoke(NODE_AGENT_OBJNAME, operName, params, signature);
            }
            if (File.separatorChar == '\\') {
                Thread.sleep(2000L);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getNodeAgentInstancesStatus(HandlerContext handlerCtx) {
        List instances = (List)handlerCtx.getInputValue("Instances");
        int stopped = 0;
        int restart = 0;
        if (instances != null) {
            List instanceMap = instances;
            for (Map oneRow : instanceMap) {
                String name = (String)oneRow.get("name");
                try {
                    J2EEServer j2eeServer = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name);
                    if (j2eeServer.getstate() == 2 || j2eeServer.getstate() == 3 || j2eeServer.getstate() == 4) {
                        ++stopped;
                    }
                    if (!j2eeServer.getRestartRequired()) continue;
                    ++restart;
                }
                catch (Exception ex) {}
            }
        }
        if (stopped == 0) {
            handlerCtx.setOutputValue("Stopped", (Object)"--");
        } else {
            handlerCtx.setOutputValue("Stopped", (Object)stopped);
        }
        if (restart == 0) {
            handlerCtx.setOutputValue("Restart", (Object)"--");
        } else {
            handlerCtx.setOutputValue("Restart", (Object)restart);
        }
    }

    private static Map getNodeAgentsInstances(String nodeAgentName) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Map standAloneMap = AMXUtil.getDomainConfig().getStandaloneServerConfigMap();
        for (StandaloneServerConfig serverConfig : standAloneMap.values()) {
            if (!nodeAgentName.equals(serverConfig.getReferencedNodeAgentName())) continue;
            values.put(serverConfig.getName(), serverConfig);
        }
        Map clusterMap = AMXUtil.getDomainConfig().getClusteredServerConfigMap();
        for (ClusteredServerConfig clusterConfig : clusterMap.values()) {
            if (!nodeAgentName.equals(clusterConfig.getReferencedNodeAgentName())) continue;
            values.put(clusterConfig.getName(), clusterConfig);
        }
        return values;
    }

    public static void getNodeAgentValues(HandlerContext handlerCtx) {
        String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
        try {
            boolean connected = false;
            NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(ndAgentName);
            Map props = agentConfig.getProperties();
            String agentStatus = agentConfig.getPropertyValue("rendezvousOccurred");
            String hostName = GuiUtil.getMessage("nodeAgent.UnknownHost");
            String status = null;
            if (agentStatus.equalsIgnoreCase("true")) {
                hostName = agentConfig.getJMXConnectorConfig().getPropertyValue("client-hostname");
                connected = true;
                status = NodeAgentHandlers.getStatusString(agentConfig.getName());
            } else {
                status = NodeAgentHandlers.getWarningString(GuiUtil.getMessage("nodeAgent.awaitingInitialSync"));
            }
            handlerCtx.setOutputValue("HostName", (Object)hostName);
            handlerCtx.setOutputValue("Status", (Object)status);
            handlerCtx.setOutputValue("OnInstances", (Object)agentConfig.getStartServersInStartup());
            handlerCtx.setOutputValue("Connected", (Object)connected);
            handlerCtx.setOutputValue("Properties", (Object)props);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void saveNodeAgentValues(HandlerContext handlerCtx) {
        try {
            String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
            boolean onInstances = (Boolean)handlerCtx.getInputValue("OnInstances");
            NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(ndAgentName);
            ArrayList removeProps = (ArrayList)handlerCtx.getInputValue("RemoveProps");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] remove = removeProps.toArray(new String[removeProps.size()]);
            for (int i = 0; i < remove.length; ++i) {
                agentConfig.removeProperty(remove[i]);
            }
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    agentConfig.setPropertyValue((String)key, addvalue);
                }
            }
            agentConfig.setStartServersInStartup(onInstances);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void getInstancesList(HandlerContext handlerCtx) {
        String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
        List selectedList = (List)handlerCtx.getInputValue("selectedRows");
        boolean hasOrig = selectedList != null && selectedList.size() != 0;
        ArrayList result = new ArrayList();
        if (ndAgentName != null) {
            Map nodesInstances = NodeAgentHandlers.getNodeAgentsInstances(ndAgentName);
            Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
            NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(ndAgentName);
            if (nodesInstances != null) {
                for (String key : nodesInstances.keySet()) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    ServerConfig serverConfig = (ServerConfig)nodesInstances.get(key);
                    String name = serverConfig.getName();
                    if (serverConfig instanceof ClusteredServerConfig) {
                        ClusteredServerConfig conf = (ClusteredServerConfig)serverConfig;
                        String clusterName = EESupportHandlers.getClusterForServer(name);
                        oneRow.put("clusterName", clusterName);
                        oneRow.put("isCluster", true);
                    } else {
                        oneRow.put("clusterName", "");
                        oneRow.put("isCluster", false);
                    }
                    String configuration = serverConfig.getReferencedConfigName();
                    String status = agentConfig.getPropertyValue("rendezvousOccurred");
                    if (status.equalsIgnoreCase("false")) {
                        status = GuiUtil.getMessage("nodeAgent.notRunning");
                    }
                    status = AMXUtil.getStatusForDisplay((AMX)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name), true);
                    oneRow.put("name", name);
                    oneRow.put("selected", hasOrig ? ConnectorsHandlers.isSelected(name, selectedList) : false);
                    oneRow.put("config", configuration == null ? " " : configuration);
                    oneRow.put("status", status == null ? " " : status);
                    result.add(oneRow);
                }
            }
        }
        handlerCtx.setOutputValue("Result", result);
    }

    public static void getNodeAgentLoggerSettings(HandlerContext handlerCtx) {
        String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
        Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
        NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(ndAgentName);
        LogServiceConfig lc = (LogServiceConfig)agentConfig.getContainee("X-LogServiceConfig");
        String logFile = lc.getFile();
        boolean alarms = lc.getAlarms();
        boolean systemLog = lc.getUseSystemLogging();
        String logHandler = lc.getLogHandler();
        String logFilter = lc.getLogFilter();
        String rotationLimit = lc.getLogRotationLimitInBytes();
        String rotationTimeLimit = lc.getLogRotationTimeLimitInMinutes();
        String retainErrorStats = lc.getRetainErrorStatisticsForHours();
        Map props = lc.getProperties();
        handlerCtx.setOutputValue("LogFile", (Object)logFile);
        handlerCtx.setOutputValue("Alarms", (Object)alarms);
        handlerCtx.setOutputValue("SystemLog", (Object)systemLog);
        handlerCtx.setOutputValue("LogHandler", (Object)logHandler);
        handlerCtx.setOutputValue("LogFilter", (Object)logFilter);
        handlerCtx.setOutputValue("RotationLimit", (Object)rotationLimit);
        handlerCtx.setOutputValue("RotationTimeLimit", (Object)rotationTimeLimit);
        handlerCtx.setOutputValue("RetainErrorStats", (Object)retainErrorStats);
        handlerCtx.setOutputValue("Properties", (Object)props);
    }

    public static void saveNodeAgentLoggerSettings(HandlerContext handlerCtx) {
        String ndAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
        Map nodeAgentMap = AMXUtil.getDomainConfig().getNodeAgentConfigMap();
        NodeAgentConfig agentConfig = (NodeAgentConfig)nodeAgentMap.get(ndAgentName);
        LogServiceConfig lc = (LogServiceConfig)agentConfig.getContainee("X-LogServiceConfig");
        try {
            AMXUtil.editProperties(handlerCtx, (PropertiesAccess)lc);
            lc.setFile((String)handlerCtx.getInputValue("LogFile"));
            lc.setAlarms(((Boolean)handlerCtx.getInputValue("Alarms")).booleanValue());
            lc.setUseSystemLogging(((Boolean)handlerCtx.getInputValue("SystemLog")).booleanValue());
            lc.setLogHandler((String)handlerCtx.getInputValue("LogHandler"));
            lc.setLogFilter((String)handlerCtx.getInputValue("LogFilter"));
            lc.setLogRotationLimitInBytes((String)handlerCtx.getInputValue("RotationLimit"));
            lc.setLogRotationTimeLimitInMinutes((String)handlerCtx.getInputValue("RotationTimeLimit"));
            lc.setRetainErrorStatisticsForHours((String)handlerCtx.getInputValue("RetainErrorStats"));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void createNodeAgent(HandlerContext handlerCtx) {
        try {
            String nodeAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String operName = "createNodeAgentConfig";
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new Object[]{nodeAgentName};
            JMXUtil.invoke(NODE_AGENT_OBJNAME, operName, params, signature);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void addNodeAgentProperties(HandlerContext handlerCtx) {
        try {
            String nodeAgentName = (String)handlerCtx.getInputValue("NodeAgentName");
            Map addProps = (Map)handlerCtx.getInputValue("AddProps");
            String[] type = new String[]{"javax.management.Attribute"};
            if (addProps != null) {
                for (Object key : addProps.keySet()) {
                    String addvalue = (String)addProps.get(key);
                    Attribute attr = new Attribute((String)key, addvalue);
                    Object[] params = new Object[]{attr};
                    JMXUtil.invoke("com.sun.appserv:type=node-agent,name=" + nodeAgentName + ",category=config", "setProperty", params, type);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void prepareSuccessful(HandlerContext handlerCtx) {
        Object[] msgArgs = new Object[]{handlerCtx.getInputValue("NodeAgentName")};
        GuiUtil.prepareAlert(handlerCtx, "information", GuiUtil.getMessage("nodeAgent.nodeAgentCreatedSummary", msgArgs), GuiUtil.getMessage("nodeAgent.nodeAgentCreatedDetail"));
    }

    public static void startServerInstance(HandlerContext handlerCtx) {
        List obj;
        boolean start = (Boolean)handlerCtx.getInputValue("start");
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        try {
            for (Map oneRow : selectedRows) {
                String name = (String)oneRow.get("name");
                J2EEServer instance = (J2EEServer)AMXUtil.getJ2EEDomain().getJ2EEServerMap().get(name);
                if (start) {
                    instance.start();
                    continue;
                }
                instance.stop();
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static String getNodeAgentStatus(String nodeAgentName) {
        NodeAgentConfig agentConfig = (NodeAgentConfig)AMXUtil.getDomainConfig().getNodeAgentConfigMap().get(nodeAgentName);
        String agentStatus = agentConfig.getPropertyValue("rendezvousOccurred");
        String status = NodeAgentHandlers.getWarningString(GuiUtil.getMessage("nodeAgent.awaitingInitialSync"));
        if (agentStatus.equalsIgnoreCase("true")) {
            status = NodeAgentHandlers.getStatusString(nodeAgentName);
        }
        return status;
    }

    private static String getStatusString(String nodeAgentName) {
        String status = null;
        try {
            String objName = "com.sun.appserv:type=node-agent,name=" + nodeAgentName + ",category=config";
            RuntimeStatus sts = (RuntimeStatus)JMXUtil.invoke(objName, "getRuntimeStatus", null, null);
            if (sts == null) {
                status = NodeAgentHandlers.getWarningString(GuiUtil.getMessage("nodeAgent.unknownState"));
            } else if (sts instanceof RuntimeStatus) {
                status = JMXUtil.getStatusForDisplay(objName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return status;
    }

    private static String getWarningString(String msg) {
        return GuiUtil.getMessage("common.warningImage") + "&nbsp;" + msg;
    }
}

