/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.Enabled;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.RegistryLocationConfig;
import com.sun.appserv.management.config.TransformationRuleConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.j2ee.WebServiceEndpoint;
import com.sun.appserv.management.monitor.CallFlowMonitor;
import com.sun.appserv.management.monitor.WebServiceEndpointMonitor;
import com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats;
import com.sun.enterprise.tools.admingui.bean.WebServiceBean;
import com.sun.enterprise.tools.admingui.handlers.ApplicationHandlers;
import com.sun.enterprise.tools.admingui.handlers.CallFlowHandlers;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.enterprise.tools.admingui.util.TargetUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.LogUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceHandlers {
    public static void getWebServiceHandlers(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("WebServiceBean", (Object)new WebServiceBean());
    }

    public static void getWebServiceEndpointInfoMBean(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("WebServiceEndpointInfoMBean", (Object)AMXUtil.getWebServiceEndpointInfo(handlerCtx.getInputValue("WebServiceKey")));
    }

    public static void getWebServiceInfoMap(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("WebServiceInfoMap", (Object)((WebServiceEndpointInfo)handlerCtx.getInputValue("WebServiceEndpointInfoMBean")).asMap());
    }

    public static void disableTest(HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("WebServiceKey");
        WebServiceEndpointInfo wsInfo = AMXUtil.getWebServiceEndpointInfo(webServiceKey);
        boolean disableTest = false;
        if (wsInfo.isSecure()) {
            disableTest = true;
        } else {
            Enabled app = null;
            app = !wsInfo.isAppStandaloneModule() ? (Enabled)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(wsInfo.getAppID()) : (wsInfo.getServiceImplType().equals("SERVLET") ? (Enabled)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(wsInfo.getAppID()) : (Enabled)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(wsInfo.getAppID()));
            String status = TargetUtil.getEnabledStatus(app, true);
            if (AMXUtil.supportCluster()) {
                if (!status.equals(GuiUtil.getMessage("deploy.allEnabled"))) {
                    disableTest = true;
                }
            } else if (status.equals(Boolean.toString(false))) {
                disableTest = true;
            }
        }
        handlerCtx.setOutputValue("DisableTest", (Object)disableTest);
    }

    public static void pruneEndpointUri(HandlerContext handlerCtx) {
        String uri;
        String newUri = uri = (String)handlerCtx.getInputValue("Uri");
        if (uri.startsWith("//")) {
            newUri = uri.substring(1);
        }
        handlerCtx.setOutputValue("NewUri", (Object)newUri);
    }

    public static void getWebServicesData(HandlerContext handlerCtx) {
        Map<Object, String> wsKeyMap = WebServiceHandlers.getWSKeys();
        ArrayList<Map> dataList = new ArrayList<Map>();
        for (Object wsKey : wsKeyMap.keySet()) {
            String endpointURI;
            WebServiceEndpointInfo wsInfo = AMXUtil.getWebServiceEndpointInfo(wsKey);
            Map wsInfoMap = wsInfo.asMap();
            String wsdlFileName = new File((String)wsInfoMap.get("WSDLFileLocation")).getName();
            wsInfoMap.put("WSDLFileName", wsdlFileName);
            String wsKeyEncoded = (String)wsKey;
            try {
                wsKeyEncoded = URLEncoder.encode(wsKeyEncoded, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                LogUtil.severe((String)("Error encoding " + wsKey), (Throwable)uee);
                wsKeyEncoded = URLEncoder.encode(wsKeyEncoded);
            }
            wsInfoMap.put("WebServiceKeyEncoded", wsKeyEncoded);
            String port = ApplicationHandlers.getPortForApplication(wsInfo.getAppID());
            wsInfoMap.put("Port", port);
            String endpointURIPruned = endpointURI = wsInfo.getEndpointURI();
            if (endpointURI.startsWith("/")) {
                endpointURIPruned = endpointURI.substring(1);
            }
            wsInfoMap.put("EndpointURI", endpointURIPruned);
            dataList.add(wsInfoMap);
        }
        handlerCtx.setOutputValue("WebServicesData", dataList);
    }

    public void getWsLastResetTime(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, server);
        if (!wsSet.isEmpty()) {
            Iterator it = wsSet.iterator();
            WebServiceEndpoint ws = (WebServiceEndpoint)it.next();
            if (ws != null) {
                long lastResetTime = ws.getLastResetTime();
                Date date = new Date(lastResetTime);
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
                handlerCtx.setOutputValue("Time", (Object)dateFormat.format(date));
            } else {
                handlerCtx.setOutputValue("Time", (Object)"");
            }
        } else {
            handlerCtx.setOutputValue("Time", (Object)"");
        }
    }

    public void getWSServerList(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        ArrayList<String> serverRootList = new ArrayList<String>();
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, server);
        for (WebServiceEndpoint wsEndpoint : wsSet) {
            WebServiceEndpointMonitor wsMonitor = (WebServiceEndpointMonitor)wsEndpoint.getMonitoringPeer();
            if (wsMonitor == null) continue;
            String serverRoot = wsMonitor.getServerRootMonitor().getName();
            serverRootList.add(serverRoot);
        }
        if (serverRootList.size() != 0) {
            handlerCtx.setOutputValue("DisplayServer", (Object)((String)serverRootList.get(0)));
        }
        handlerCtx.setOutputValue("ServerRootList", serverRootList);
    }

    public void getWsMonitorsList(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String selectedServer = (String)handlerCtx.getInputValue("SelectedServer");
        ArrayList<WebServiceEndpointMonitor> wsMonitorsList = new ArrayList<WebServiceEndpointMonitor>();
        ArrayList<String> serverRootList = new ArrayList<String>();
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, selectedServer);
        for (WebServiceEndpoint wsEndpoint : wsSet) {
            WebServiceEndpointMonitor wsMonitor = (WebServiceEndpointMonitor)wsEndpoint.getMonitoringPeer();
            if (wsMonitor == null) continue;
            String serverRoot = wsMonitor.getServerRootMonitor().getName();
            wsMonitorsList.add(wsMonitor);
            serverRootList.add(serverRoot);
        }
        if (wsMonitorsList.size() != 0) {
            handlerCtx.setOutputValue("DisplayServer", (Object)(selectedServer == null ? (String)serverRootList.get(0) : selectedServer));
        }
        handlerCtx.setOutputValue("WSMonitorsList", wsMonitorsList);
        handlerCtx.setOutputValue("ServerRootList", serverRootList);
        handlerCtx.setOutputValue("HasMonitors", (Object)(wsMonitorsList.size() == 0 ? new Boolean("false") : new Boolean("true")));
    }

    public static void getWebServiceEndpointAggregateStatsMBean(HandlerContext handlerCtx) {
        Iterator it;
        WebServiceEndpoint ws;
        WebServiceEndpointMonitor wsMonitor;
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, server);
        WebServiceEndpointAggregateStats statsMbean = null;
        if (!wsSet.isEmpty() && (wsMonitor = (WebServiceEndpointMonitor)(ws = (WebServiceEndpoint)(it = wsSet.iterator()).next()).getMonitoringPeer()) != null) {
            statsMbean = wsMonitor.getWebServiceEndpointAggregateStats();
        }
        handlerCtx.setOutputValue("WebServiceEndpointAggregateStatsMBean", statsMbean);
    }

    public static void getMessageTraceMBean(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        String msgID = (String)handlerCtx.getInputValue("MessageID");
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, server);
        MessageTrace[] msgs = null;
        if (!wsSet.isEmpty()) {
            Iterator it = wsSet.iterator();
            WebServiceEndpoint ws = (WebServiceEndpoint)it.next();
            msgs = ws.getMessagesInHistory();
        }
        MessageTrace mt = null;
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                if (!msgID.equals(msgs[i].getMessageID())) continue;
                mt = msgs[i];
            }
        }
        handlerCtx.setOutputValue("MessageTraceMBean", mt);
    }

    public static void getWebServiceMessageData(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        String filterValue = (String)handlerCtx.getInputValue("FilterValue");
        Set wsSet = AMXUtil.getWebServiceMgr().getWebServiceEndpointSet((Object)webServiceKey, server);
        MessageTrace[] msgs = null;
        if (!wsSet.isEmpty()) {
            Iterator it = wsSet.iterator();
            WebServiceEndpoint ws = (WebServiceEndpoint)it.next();
            msgs = ws.getMessagesInHistory();
        }
        ArrayList<Map> dataList = new ArrayList<Map>();
        if (msgs != null) {
            for (int i = 0; i < msgs.length; ++i) {
                String resHeadersEnc;
                String reqHeadersEnc;
                Map msgMap;
                block17: {
                    msgMap = msgs[i].asMap();
                    String code = msgs[i].getFaultCode();
                    if (!(filterValue == null || code == null && filterValue.equals(GuiUtil.getMessage("common.Success")) || code != null && filterValue.equals(GuiUtil.getMessage("common.Failed"))) && !filterValue.equals("")) continue;
                    Long L = new Long(msgs[i].getTimestamp());
                    long l = L;
                    Date date = new Date(l);
                    msgMap.put("TimeStampFormatted", date.toString());
                    int reqSize = msgs[i].getRequestSize();
                    int resSize = msgs[i].getResponseSize();
                    String reqResSize = reqSize + "b / " + resSize + "b";
                    msgMap.put("ReqResSize", reqResSize);
                    if (code == null) {
                        msgMap.put("Response", GuiUtil.getMessage("common.Success"));
                        msgMap.put("FaultCode", "");
                    } else {
                        msgMap.put("Response", GuiUtil.getMessage("common.Failed"));
                    }
                    if (msgs[i].getFaultActor() == null) {
                        msgMap.put("FaultActor", "");
                    }
                    if (msgMap.get("FaultString") == null) {
                        msgMap.put("FaultString", "");
                    }
                    String reqHeaders = msgs[i].getHTTPRequestHeaders();
                    String resHeaders = msgs[i].getHTTPResponseHeaders();
                    reqHeadersEnc = "";
                    resHeadersEnc = "";
                    try {
                        if (reqHeaders != null) {
                            reqHeadersEnc = URLEncoder.encode(reqHeaders, "UTF-8");
                        }
                        if (resHeaders != null) {
                            resHeadersEnc = URLEncoder.encode(resHeaders, "UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        LogUtil.severe((String)"Error encoding HTTP Request/Response Headers", (Throwable)uee);
                        if (reqHeaders != null) {
                            reqHeadersEnc = URLEncoder.encode(reqHeaders);
                        }
                        if (resHeaders == null) break block17;
                        resHeadersEnc = URLEncoder.encode(resHeaders);
                    }
                }
                msgMap.put("RequestHeadersEncoded", reqHeadersEnc);
                msgMap.put("ResponseHeadersEncoded", resHeadersEnc);
                if (msgMap.get("PrincipalName") == null) {
                    msgMap.put("PrincipalName", "");
                }
                if (msgs[i].isCallFlowEnabled()) {
                    CallFlowMonitor cfm = CallFlowHandlers.getCallFlowMonitor(server);
                    List list = cfm.queryCallStackForRequest(msgs[i].getMessageID());
                    if (list == null || list.isEmpty()) {
                        msgMap.put("IsCallFlowAvailable", Boolean.FALSE);
                    } else {
                        msgMap.put("IsCallFlowAvailable", Boolean.TRUE);
                    }
                } else {
                    msgMap.put("IsCallFlowAvailable", Boolean.FALSE);
                }
                dataList.add(msgMap);
            }
        }
        handlerCtx.setOutputValue("WebServiceMessageData", dataList);
    }

    public static void getWSMessageFilters(HandlerContext handlerCtx) {
        ArrayList<String> label = new ArrayList<String>();
        label.add(GuiUtil.getMessage("common.AllItems"));
        label.add(GuiUtil.getMessage("common.Success"));
        label.add(GuiUtil.getMessage("common.Failed"));
        ArrayList<String> value = new ArrayList<String>();
        value.add("");
        value.add(GuiUtil.getMessage("common.Success"));
        value.add(GuiUtil.getMessage("common.Failed"));
        handlerCtx.setOutputValue("FilterListValue", value);
        handlerCtx.setOutputValue("FilterListLabel", label);
    }

    public static void getWSConfig(HandlerContext handlerCtx) {
        String history;
        String level;
        Boolean isStandalone;
        String type;
        String bundleName;
        String wsName = (String)handlerCtx.getInputValue("WebServiceName");
        String appName = (String)handlerCtx.getInputValue("AppName");
        WebServiceEndpointConfig wsConfig = WebServiceHandlers.getWebServiceEndpointConfig(appName, bundleName = (String)handlerCtx.getInputValue("BundleName"), wsName, type = (String)handlerCtx.getInputValue("Type"), isStandalone = (Boolean)handlerCtx.getInputValue("IsStandalone"));
        if (wsConfig == null) {
            level = "OFF";
            history = "25";
        } else {
            level = wsConfig.getMonitoringLevel();
            history = wsConfig.getMaxHistorySize();
        }
        handlerCtx.setOutputValue("Level", (Object)level);
        handlerCtx.setOutputValue("History", (Object)history);
    }

    public static void saveWSConfig(HandlerContext handlerCtx) {
        String wsName = (String)handlerCtx.getInputValue("WebServiceName");
        String appName = (String)handlerCtx.getInputValue("AppName");
        String bundleName = (String)handlerCtx.getInputValue("BundleName");
        String type = (String)handlerCtx.getInputValue("Type");
        Boolean isStandalone = (Boolean)handlerCtx.getInputValue("IsStandalone");
        String level = (String)handlerCtx.getInputValue("Level");
        String history = (String)handlerCtx.getInputValue("History");
        try {
            WebServiceEndpointConfig wsConfig = WebServiceHandlers.getWebServiceEndpointConfig(appName, bundleName, wsName, type, isStandalone);
            if (wsConfig == null) {
                try {
                    wsConfig = WebServiceHandlers.createWebServiceEndpointConfig(appName, bundleName, wsName, type, isStandalone);
                }
                catch (Exception ex) {
                    GuiUtil.handleException(handlerCtx, ex);
                }
            }
            if (wsConfig != null) {
                wsConfig.setMonitoringLevel(level);
                wsConfig.setMaxHistorySize(history);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void resetWsStats(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        String server = (String)handlerCtx.getInputValue("Server");
        try {
            WebServiceMgr wsm = AMXUtil.getWebServiceMgr();
            Set endpointSet = wsm.getWebServiceEndpointSet((Object)webServiceKey, server);
            if (!endpointSet.isEmpty()) {
                Iterator it = endpointSet.iterator();
                WebServiceEndpoint endpoint = (WebServiceEndpoint)it.next();
                endpoint.resetStats();
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getWSPublishedRegistriesData(HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("WebServiceKey");
        Map registryConfigMap = WebServiceHandlers.getRegistryLocationConfigMap(webServiceKey);
        ArrayList dataList = new ArrayList();
        if (registryConfigMap != null && !registryConfigMap.isEmpty()) {
            for (RegistryLocationConfig registry : registryConfigMap.values()) {
                HashMap<String, Object> registryMap = new HashMap<String, Object>();
                registryMap.put("RegistryName", registry.getConnectorResourceJNDIName());
                registryMap.put("selected", false);
                dataList.add(registryMap);
            }
        }
        handlerCtx.setOutputValue("WSPublishedRegistriesData", dataList);
    }

    public void getAvailableRegistriesList(HandlerContext handlerCtx) {
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        String[] registries = wsm.listRegistryLocations();
        ArrayList<String> registryList = new ArrayList<String>();
        if (registries != null) {
            for (int i = 0; i < registries.length; ++i) {
                registryList.add(registries[i]);
            }
        }
        handlerCtx.setOutputValue("AvailableRegistriesList", registryList);
    }

    public void publishToRegistry(HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("WebServiceKey");
        String[] registries = (String[])handlerCtx.getInputValue("RegistriesSelected");
        if (registries != null && registries.length > 0) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("LBHost", (String)handlerCtx.getInputValue("LBHost"));
            map.put("LBPort", (String)handlerCtx.getInputValue("LBPort"));
            map.put("LBSecurePort", (String)handlerCtx.getInputValue("LBSSLPort"));
            map.put("Categories", (String)handlerCtx.getInputValue("Categories"));
            map.put("Description", (String)handlerCtx.getInputValue("Description"));
            map.put("Organization", (String)handlerCtx.getInputValue("Organization"));
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            try {
                wsm.publishToRegistry(registries, webServiceKey, map);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
    }

    public void unpublishFromRegistry(HandlerContext handlerCtx) {
        List obj;
        Object webServiceKey = handlerCtx.getInputValue("WebServiceKey");
        List registriesSelected = obj = (List)handlerCtx.getInputValue("RegistriesSelectedList");
        if (obj == null || obj.size() == 0) {
            return;
        }
        String[] registries = new String[obj.size()];
        try {
            int i = 0;
            for (Map registry : registriesSelected) {
                String registryName = (String)registry.get("RegistryName");
                registries[i++] = registryName;
            }
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            wsm.unpublishFromRegistry(registries, webServiceKey);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getWSRegistriesData(HandlerContext handlerCtx) {
        ArrayList dataList = new ArrayList();
        try {
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            String[] registries = wsm.listRegistryLocations();
            if (registries != null) {
                for (int i = 0; i < registries.length; ++i) {
                    HashMap<String, Object> registryMap = new HashMap<String, Object>();
                    registryMap.put("RegistryName", registries[i]);
                    registryMap.put("selected", false);
                    dataList.add(registryMap);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("RegistriesData", dataList);
    }

    public void addRegistry(HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("JNDIName");
        String registryType = (String)handlerCtx.getInputValue("RegistryType");
        String publishURL = (String)handlerCtx.getInputValue("PublishURL");
        String queryURL = (String)handlerCtx.getInputValue("QueryURL");
        String userName = (String)handlerCtx.getInputValue("UserName");
        String password = (String)handlerCtx.getInputValue("Password");
        String description = (String)handlerCtx.getInputValue("Description");
        HashMap<String, String> map = new HashMap<String, String>();
        String type = "ebxml";
        type = registryType.equalsIgnoreCase("uddi") ? "uddi" : "ebxml";
        map.put("LifeCycleManagerURL", publishURL);
        if (!GuiUtil.isEmpty(queryURL)) {
            map.put("QueryManagerURL", queryURL);
        }
        if (!GuiUtil.isEmpty(userName)) {
            map.put("username", userName);
        }
        if (!GuiUtil.isEmpty(password)) {
            map.put("password", password);
        }
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        try {
            wsm.addRegistryConnectionResources(jndiName, description, type, map);
        }
        catch (Exception e) {
            GuiUtil.handleException(handlerCtx, e);
        }
    }

    public void removeRegistries(HandlerContext handlerCtx) {
        List obj;
        List registriesSelected = obj = (List)handlerCtx.getInputValue("RegistriesList");
        if (obj == null || obj.size() == 0) {
            return;
        }
        try {
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            boolean i = false;
            for (Map registry : registriesSelected) {
                String registryName = (String)registry.get("RegistryName");
                wsm.removeRegistryConnectionResources(registryName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void getWSTransformationRulesData(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        ArrayList dataList = new ArrayList();
        List ruleList = WebServiceHandlers.getTransformationRuleConfigList(webServiceKey);
        try {
            if (ruleList != null && !ruleList.isEmpty()) {
                for (TransformationRuleConfig ruleConfig : ruleList) {
                    HashMap<String, Object> ruleMap = new HashMap<String, Object>();
                    ruleMap.put("RuleName", ruleConfig.getName());
                    if (ruleConfig.getEnabled()) {
                        ruleMap.put("RuleStatus", GuiUtil.getMessage("common.Enabled"));
                    } else {
                        ruleMap.put("RuleStatus", GuiUtil.getMessage("common.Disabled"));
                    }
                    ruleMap.put("RuleFile", ruleConfig.getRuleFileLocation());
                    ruleMap.put("ApplyTo", ruleConfig.getApplyTo());
                    ruleMap.put("selected", false);
                    dataList.add(ruleMap);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("TransformationRulesData", dataList);
    }

    public void applyTransformationRuleTableAction(HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("WebServiceKey");
        List obj = (List)handlerCtx.getInputValue("RulesSelectedList");
        String action = (String)handlerCtx.getInputValue("Action");
        List rulesSelected = obj;
        if (obj == null || obj.size() == 0) {
            return;
        }
        String[] rules = new String[obj.size()];
        try {
            int i = 0;
            for (Map rule : rulesSelected) {
                String ruleName = (String)rule.get("RuleName");
                rules[i++] = ruleName;
            }
            WebServiceEndpointConfig endpointConfig = WebServiceHandlers.getWebServiceEndpointConfig(webServiceKey);
            if (endpointConfig != null) {
                Map ruleMap = endpointConfig.getTransformationRuleConfigMap();
                for (int j = 0; j < rules.length; ++j) {
                    TransformationRuleConfig rule = (TransformationRuleConfig)ruleMap.get(rules[j]);
                    if (action.equals("enable")) {
                        rule.setEnabled(true);
                    }
                    if (action.equals("disable")) {
                        rule.setEnabled(false);
                    }
                    if (!action.equals("remove")) continue;
                    endpointConfig.removeTransformationRuleConfig(rules[j]);
                }
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public void addTransformationRule(HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("WebServiceKey");
        String name = (String)handlerCtx.getInputValue("RuleName");
        boolean enabled = (Boolean)handlerCtx.getInputValue("Enabled");
        String applyTo = (String)handlerCtx.getInputValue("ApplyTo");
        String uploadDir = (String)handlerCtx.getInputValue("UploadDir");
        Object tmpFile = null;
        if (uploadDir != null) {
            try {
                WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
                WebServiceHandlers.createTransformationRuleConfig(webServiceKey, name, enabled, applyTo, uploadDir, null);
            }
            catch (Exception ex) {
                GuiUtil.handleException(handlerCtx, ex);
            }
        }
    }

    private static RegistryLocationConfig getRegistryLocationConfig(String webServiceKey, String registryName) {
        return (RegistryLocationConfig)WebServiceHandlers.getRegistryLocationConfigMap(webServiceKey).get(registryName);
    }

    private static Map getRegistryLocationConfigMap(Object webServiceKey) {
        WebServiceEndpointConfig wseConfig = WebServiceHandlers.getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getRegistryLocationConfigMap();
    }

    private static TransformationRuleConfig createTransformationRuleConfig(Object webServiceKey, String ruleName, boolean enabled, String applyTo, String ruleFileLocation, Map map) {
        WebServiceEndpointConfig wseConfig = WebServiceHandlers.getWebServiceEndpointConfig(webServiceKey);
        if (wseConfig == null) {
            wseConfig = WebServiceHandlers.createWebServiceEndpointConfig(webServiceKey);
        }
        return wseConfig.createTransformationRuleConfig(ruleName, ruleFileLocation, enabled, applyTo, map);
    }

    private static List getTransformationRuleConfigList(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = WebServiceHandlers.getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getTransformationRuleConfigList();
    }

    private static WebServiceEndpointConfig createWebServiceEndpointConfig(String appName, String bundleName, String wsName, String type, Boolean isStandalone) {
        WebServiceEndpointConfig wsConfig = null;
        String fullQualName = WebServiceHandlers.buildFullyQualifiedWSName(bundleName, wsName, isStandalone);
        if (!isStandalone.booleanValue()) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
            wsConfig = appConfig.createWebServiceEndpointConfig(fullQualName, null);
        } else if (type.equals("SERVLET")) {
            WebModuleConfig webConfig = (WebModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
            wsConfig = webConfig.createWebServiceEndpointConfig(fullQualName, null);
        } else {
            EJBModuleConfig ejbConfig = (EJBModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(appName);
            wsConfig = ejbConfig.createWebServiceEndpointConfig(fullQualName, null);
        }
        return wsConfig;
    }

    private static WebServiceEndpointConfig createWebServiceEndpointConfig(Object webServiceKey) {
        WebServiceEndpointInfo wsInfo = AMXUtil.getWebServiceEndpointInfo(webServiceKey);
        String appName = wsInfo.getAppID();
        String wsName = wsInfo.getName();
        String bundleName = wsInfo.getBundleName();
        String type = wsInfo.getServiceImplType();
        boolean isStandalone = wsInfo.isAppStandaloneModule();
        WebServiceEndpointConfig wsConfig = null;
        String fullQualName = WebServiceHandlers.buildFullyQualifiedWSName(bundleName, wsName, isStandalone);
        if (!isStandalone) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
            wsConfig = appConfig.createWebServiceEndpointConfig(fullQualName, null);
        } else if (type.equals("SERVLET")) {
            WebModuleConfig webConfig = (WebModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
            wsConfig = webConfig.createWebServiceEndpointConfig(fullQualName, null);
        } else {
            EJBModuleConfig ejbConfig = (EJBModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(appName);
            wsConfig = ejbConfig.createWebServiceEndpointConfig(fullQualName, null);
        }
        return wsConfig;
    }

    private static WebServiceEndpointConfig getWebServiceEndpointConfig(Object webServiceKey) {
        WebServiceEndpointInfo wsInfo = AMXUtil.getWebServiceEndpointInfo(webServiceKey);
        String appName = wsInfo.getAppID();
        String bundleName = wsInfo.getBundleName();
        String wsName = wsInfo.getName();
        String type = wsInfo.getServiceImplType();
        boolean isStandalone = wsInfo.isAppStandaloneModule();
        WebServiceEndpointConfig wsConfig = null;
        Map map = null;
        if (!isStandalone) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
            map = appConfig.getWebServiceEndpointConfigMap();
        } else if (type.equals("SERVLET")) {
            WebModuleConfig webConfig = (WebModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
            map = webConfig.getWebServiceEndpointConfigMap();
        } else {
            EJBModuleConfig ejbConfig = (EJBModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(appName);
            map = ejbConfig.getWebServiceEndpointConfigMap();
        }
        String fullQualName = WebServiceHandlers.buildFullyQualifiedWSName(bundleName, wsName, isStandalone);
        wsConfig = (WebServiceEndpointConfig)map.get(fullQualName);
        return wsConfig;
    }

    private static WebServiceEndpointConfig getWebServiceEndpointConfig(String appName, String bundleName, String wsName, String type, Boolean isStandalone) {
        WebServiceEndpointConfig wsConfig = null;
        Map map = null;
        if (!isStandalone.booleanValue()) {
            J2EEApplicationConfig appConfig = (J2EEApplicationConfig)AMXUtil.getDomainConfig().getJ2EEApplicationConfigMap().get(appName);
            map = appConfig.getWebServiceEndpointConfigMap();
        } else if (type.equals("SERVLET")) {
            WebModuleConfig webConfig = (WebModuleConfig)AMXUtil.getDomainConfig().getWebModuleConfigMap().get(appName);
            map = webConfig.getWebServiceEndpointConfigMap();
        } else {
            EJBModuleConfig ejbConfig = (EJBModuleConfig)AMXUtil.getDomainConfig().getEJBModuleConfigMap().get(appName);
            map = ejbConfig.getWebServiceEndpointConfigMap();
        }
        String fullQualName = WebServiceHandlers.buildFullyQualifiedWSName(bundleName, wsName, isStandalone);
        wsConfig = (WebServiceEndpointConfig)map.get(fullQualName);
        return wsConfig;
    }

    private static Map<Object, String> getWSKeys() {
        return AMXUtil.getWebServiceMgr().getWebServiceEndpointKeys();
    }

    private static String buildFullyQualifiedWSName(String bundleName, String wsName, Boolean isStandalone) {
        String fullQualName = "";
        fullQualName = isStandalone != false ? wsName : bundleName + "#" + wsName;
        return fullQualName;
    }
}

