/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.CallflowProducerQueue;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObject;
import com.sun.enterprise.admin.monitor.callflow.DbAccessObjectImpl;
import com.sun.enterprise.admin.monitor.callflow.Handler;
import com.sun.enterprise.admin.monitor.callflow.HandlerChain;
import com.sun.enterprise.admin.monitor.callflow.TraceOnHelper;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerQProcessor
implements Runnable {
    BlockingQueue consumerQ;
    private DbAccessObject dbAccessObject;
    boolean processQ = true;
    private int sleepTime = 30000;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final String CONSUMER_SLEEP_TIME = "com.sun.enterprise.callflow.sleepms";
    boolean traceOn = false;
    private HandlerChain chain;
    private long numOfQueuesProcessed = 0L;
    private long numOfTimesQSlept = 0L;

    public ConsumerQProcessor(BlockingQueue<CallflowProducerQueue> consumerQ, HandlerChain chain) {
        this.consumerQ = consumerQ;
        this.chain = chain;
        this.dbAccessObject = DbAccessObjectImpl.getInstance();
        this.traceOn = TraceOnHelper.isTraceOn();
        this.sleepTime = Math.abs(Integer.getInteger(CONSUMER_SLEEP_TIME, 5000));
    }

    public void stopConsumerThread() {
        this.processQ = false;
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.stopConsumerThread ");
        }
    }

    @Override
    public void run() {
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.entering run ");
        }
        while (this.processQ) {
            if (!this.consumerQ.isEmpty()) {
                this.consume();
                continue;
            }
            try {
                if (this.traceOn) {
                    logger.log(Level.INFO, "Callflow: ConsumerQProcessor.Q Empty, sleeping for " + this.getSleepTime() + " ms. Sleeping for the " + this.getNumOfTimesQSlept() + " th time.");
                }
                ++this.numOfTimesQSlept;
                Thread.sleep(this.getSleepTime());
            }
            catch (InterruptedException e) {
                if (this.processQ) continue;
                if (!this.traceOn) break;
                logger.log(Level.INFO, "Callflow: ConsumerQProcessor.Disable Called, forcing consumption");
                break;
            }
        }
        this.consume();
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.exiting run.  Num of Entries Processed for each table \n" + this.dbAccessObject.getNumOfRequestsProcessedAsString() + " \n");
        }
    }

    void consume() {
        int noOfQueues = this.consumerQ.size();
        this.numOfQueuesProcessed += (long)noOfQueues;
        if (this.traceOn) {
            logger.log(Level.INFO, "Callflow: ConsumerQProcessor.consume. ConsumerQ.length =" + noOfQueues + ". Total number of " + " Q's Processed = " + this.numOfQueuesProcessed);
        }
        for (int i = 0; i < noOfQueues; ++i) {
            TransferObject[] to;
            CallflowProducerQueue q = (CallflowProducerQueue)this.consumerQ.poll();
            if (q == null) continue;
            if (this.traceOn) {
                logger.log(Level.INFO, "Callflow: ConsumerQProcessor.processProducerQ " + q.getName());
            }
            if ((to = q.getAndRemoveAll()) == null) continue;
            Handler[] handler = this.chain.getHandlers();
            for (int j = 0; j < handler.length; ++j) {
                if (this.traceOn) {
                    logger.log(Level.INFO, "Callflow: ConsumerQProcessor.processProducerQ " + handler[j]);
                }
                handler[j].handle(to);
            }
        }
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getNumOfQueuesProcessed() {
        return this.numOfQueuesProcessed;
    }

    public long getNumOfTimesQSlept() {
        return this.numOfTimesQSlept;
    }

    public String getCONSUMER_SLEEP_TIME() {
        return CONSUMER_SLEEP_TIME;
    }
}

