/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMThreadInfoStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.spi.JVMThreadStatsImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ThreadInfo;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMThreadInfoStatsImpl
implements JVMThreadInfoStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMThreadInfoStats";
    private static final StringManager localStrMgr = StringManager.getManager(JVMThreadStatsImpl.class);
    private ThreadInfo info;
    private long initTime;
    MutableCountStatistic blockedCount;
    MutableCountStatistic blockedTime;
    MutableCountStatistic lockOwnerId;
    MutableCountStatistic threadId;
    MutableCountStatistic waitingCount;
    MutableCountStatistic waitingTime;
    static String NEWLINE = "\n";

    public JVMThreadInfoStatsImpl(ThreadInfo tInfo) {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initTime = System.currentTimeMillis();
        this.info = tInfo;
        this.initializeStatistics();
    }

    public CountStatistic getBlockedCount() {
        long blockCount = this.info.getBlockedCount();
        this.blockedCount.setCount(blockCount);
        return (CountStatistic)this.blockedCount.unmodifiableView();
    }

    public CountStatistic getBlockedTime() {
        long blockTime = this.info.getBlockedTime();
        this.blockedTime.setCount(blockTime);
        return (CountStatistic)this.blockedTime.unmodifiableView();
    }

    public StringStatistic getLockName() {
        String lockName = this.info.getLockName();
        if (lockName == null || "".equals(lockName)) {
            lockName = localStrMgr.getString("monitor.stats.no_lock");
        }
        return new StringStatisticImpl(lockName, localStrMgr.getString("monitor.stats.lock_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.lock_desc"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getLockOwnerId() {
        long id = this.info.getLockOwnerId();
        this.lockOwnerId.setCount(id);
        return (CountStatistic)this.lockOwnerId.unmodifiableView();
    }

    public StringStatistic getLockOwnerName() {
        String lockOwnerName = this.info.getLockOwnerName();
        if (lockOwnerName == null || "".equals(lockOwnerName)) {
            lockOwnerName = localStrMgr.getString("monitor.stats.no_owner");
        }
        return new StringStatisticImpl(lockOwnerName, localStrMgr.getString("monitor.stats.lock_owner_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.lock_owner_desc"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getStackTrace() {
        StackTraceElement[] trace = this.info.getStackTrace();
        String traceString = new String();
        if (trace != null) {
            for (int i = 0; i < trace.length; ++i) {
                traceString = traceString.concat(trace[i].toString());
                traceString = traceString.concat(NEWLINE);
            }
        }
        return new StringStatisticImpl(traceString, localStrMgr.getString("monitor.stats.stack_trace_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.stack_trace_desc"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getThreadId() {
        long id = this.info.getThreadId();
        this.threadId.setCount(id);
        return (CountStatistic)this.threadId.unmodifiableView();
    }

    public StringStatistic getThreadName() {
        String name = this.info.getThreadName();
        return new StringStatisticImpl(name, localStrMgr.getString("monitor.stats.thread_name"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.thread_name_desc"), this.initTime, System.currentTimeMillis());
    }

    public StringStatistic getThreadState() {
        return new StringStatisticImpl(this.info.getThreadState().toString(), localStrMgr.getString("monitor.stats.thread_state"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.thread_state_desc"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getWaitedCount() {
        long waitCount = this.info.getWaitedCount();
        this.waitingCount.setCount(waitCount);
        return (CountStatistic)this.waitingCount.unmodifiableView();
    }

    public CountStatistic getWaitedTime() {
        long waitTime = this.info.getWaitedTime();
        this.waitingTime.setCount(waitTime);
        return (CountStatistic)this.waitingTime.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.blocked_time"), localStrMgr.getString("monitor.stats.milli_sec_units"), localStrMgr.getString("monitor.stats.blocked_time_desc"));
        this.blockedTime = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.blocked_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.blocked_count_desc"));
        this.blockedCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.lock_owner_id"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.lock_owner_id_desc"));
        this.blockedCount = new MutableCountStatisticImpl(c);
        this.lockOwnerId = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.thread_id"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.thread_id_desc"));
        this.threadId = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.waiting_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.waiting_count_desc"));
        this.waitingCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.waiting_time"), localStrMgr.getString("monitor.stats.milli_sec_units"), localStrMgr.getString("monitor.stats.waiting_time_desc"));
        this.waitingTime = new MutableCountStatisticImpl(c);
    }
}

