/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.admin.servermgmt.launch.ASLauncher;
import com.sun.enterprise.admin.servermgmt.launch.ASLauncherException;
import com.sun.enterprise.admin.servermgmt.pe.PEInstancesManager;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ProcessStreamDrainer;
import java.io.File;
import java.util.ArrayList;

public class ASNativeLauncher
extends ASLauncher {
    private String java;
    private String classpath;
    private String installRoot;
    private String instanceName;
    private String instanceRoot;
    private String processName;
    private String returnValue;
    private String nativeLauncher;
    private String native1;
    private String domainName;
    private String classname;
    private File currDir;
    private boolean verbose;
    private boolean userSetVerbose = false;
    private ArrayList<String> defines;
    private ArrayList<String> command;
    private ArrayList<String> args;
    private String nativeName;
    private static final String installRootTag = "com.sun.aas.installRoot";
    private static final String javaRootTag = "com.sun.aas.javaRoot";
    private static final String instanceRootTag = "com.sun.aas.instanceRoot";
    private static final String instanceNameTag = "com.sun.aas.instanceName";
    private static final String domainNameTag = "domain.name";
    private static final String verboseTag = "com.sun.aas.verboseMode";
    private static final String processNameTag = "com.sun.aas.processName";
    private static final String returnTag = "com.sun.aas.launcherReturn";
    private static final String[] jars = new String[]{"appserv-admin.jar", "appserv-rt.jar"};
    private static final boolean debugger = false;

    public ASNativeLauncher(PEInstancesManager mgr) {
        this.nativeName = mgr.getNativeName();
        this.classname = this.getClass().getSuperclass().getName();
    }

    public Process launch(String[] Args, String[] SecurityInfo) throws ASLauncherException {
        this.securityInfo = SecurityInfo;
        this.setArguments(Args);
        this.setup();
        return this.launch();
    }

    private Process launch() throws ASLauncherException {
        ProcessBuilder pb = new ProcessBuilder(this.command);
        pb.directory(this.currDir);
        try {
            Process process = pb.start();
            ProcessStreamDrainer drainer = ProcessStreamDrainer.redirect((String)"NativeLauncher", (Process)process);
            this.writeSecurityInfoToProcess(process);
            if (this.userSetVerbose) {
                process.waitFor();
            }
            return process;
        }
        catch (Exception e) {
            throw new ASLauncherException(e);
        }
    }

    private void setup() throws ASLauncherException {
        this.setJava();
        this.setInstallRoot();
        this.setInstanceRoot();
        this.setInstanceName();
        this.setProcessName();
        this.setReturn();
        this.setDomainName();
        this.setClasspath();
        this.setVerbose();
        this.setDefines();
        this.setNatives();
        this.setCommand();
        this.setCurrDir();
    }

    private void setArguments(String[] Args) throws ASLauncherException {
        this.args = new ArrayList();
        this.args.add("start");
        this.args.add("display");
        for (String arg : Args) {
            if ("native".equalsIgnoreCase(arg) || "debug".equalsIgnoreCase(arg)) continue;
            if ("verbose".equalsIgnoreCase(arg)) {
                this.userSetVerbose = true;
                this.args.add(arg);
                continue;
            }
            if (this.args.contains(arg)) continue;
            this.args.add(arg);
        }
    }

    private void setJava() throws ASLauncherException {
        String javaRoot = System.getProperty(javaRootTag);
        String exeName = OS.isWindows() ? "java.exe" : "java";
        this.java = this.verifyFile(javaRoot + "/bin/" + exeName);
    }

    private void setInstallRoot() throws ASLauncherException {
        this.installRoot = System.getProperty(installRootTag);
        this.installRoot = this.verifyFile(this.installRoot);
    }

    private void setInstanceRoot() throws ASLauncherException {
        this.instanceRoot = System.getProperty(instanceRootTag);
        this.instanceRoot = this.verifyFile(this.instanceRoot);
    }

    private void setInstanceName() {
        this.instanceName = System.getProperty(instanceNameTag);
        if (!this.ok(this.instanceName)) {
            this.instanceName = "server";
        }
    }

    private void setProcessName() {
        this.processName = System.getProperty(processNameTag);
        if (!this.ok(this.processName)) {
            this.processName = "as9-server";
        }
    }

    private void setReturn() {
        this.returnValue = System.getProperty(returnTag);
        if (!this.ok(this.returnValue)) {
            this.returnValue = null;
        }
    }

    private void setDomainName() throws ASLauncherException {
        this.domainName = System.getProperty(domainNameTag);
    }

    private void setClasspath() throws ASLauncherException {
        this.classpath = new String();
        for (int i = 0; i < jars.length; ++i) {
            if (i != 0) {
                this.classpath = this.classpath + File.pathSeparator;
            }
            this.classpath = this.classpath + this.verifyFile(this.installRoot + "/lib/" + jars[i]);
        }
    }

    private void setDefines() {
        this.defines = new ArrayList();
        this.defines.add("-Dcom.sun.aas.installRoot=" + this.installRoot);
        this.defines.add("-Dcom.sun.aas.instanceRoot=" + this.instanceRoot);
        this.defines.add("-Dcom.sun.aas.instanceName=" + this.instanceName);
        this.defines.add("-Dcom.sun.aas.processName=" + this.processName);
        this.defines.add("-Dcaller=cli");
        if (this.ok(this.returnValue)) {
            this.defines.add("-Dcom.sun.aas.launcherReturn=" + this.returnValue);
        }
    }

    private void setNatives() throws ASLauncherException {
        String exe = "";
        if (OS.isWindows()) {
            exe = ".exe";
        }
        this.nativeLauncher = this.verifyFile(this.installRoot + "/lib/" + "appservLauncher" + exe);
        this.native1 = this.verifyFile(this.installRoot + "/lib/" + this.nativeName + exe);
    }

    private void setCommand() {
        this.command = new ArrayList();
        this.command.add(this.nativeLauncher);
        this.command.add(this.native1);
        this.command.add(this.java);
        this.command.add("-cp");
        this.command.add(this.classpath);
        for (String define : this.defines) {
            this.command.add(define);
        }
        this.command.add(this.classname);
        for (String arg : this.args) {
            this.command.add(arg);
        }
    }

    private void setCurrDir() throws ASLauncherException {
        this.currDir = new File(this.verifyFile(this.instanceRoot + "/config"));
    }

    private void setVerbose() throws ASLauncherException {
        this.verbose = false;
        for (String arg : this.args) {
            if (!"verbose".equalsIgnoreCase(arg)) continue;
            this.verbose = true;
            return;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean ok(File f) {
        return f != null && f.exists();
    }

    private String verifyFile(String s) throws ASLauncherException {
        if (!this.ok(s)) {
            throw new ASLauncherException("Null filename");
        }
        File f = new File(s);
        if (!this.ok(f)) {
            throw new ASLauncherException("Bad File: " + s);
        }
        return FileUtils.safeGetCanonicalPath(f);
    }
}

