/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.launch;

import com.sun.enterprise.admin.servermgmt.launch.ASLauncherException;
import java.io.File;
import java.io.IOException;

public class DASLauncherInfo {
    public boolean verbose = false;
    public boolean debug = false;
    public File domainsDir;
    public File domainDir;
    public String domainName;
    public File installDir;
    public File configDir;
    public String instanceName = "server";
    public String xmlProcessName = "as9-server";
    private String[] args;
    private File domainsDirParent;
    private boolean valid = false;
    public static final String SCRIPT_PATH = "SCRIPT_PATH=";
    public static final String INSTALL_DIR = "INSTALL_DIR=";
    public static final String DOMAIN_DIR = "DOMAIN_DIR=";

    public DASLauncherInfo() {
    }

    public DASLauncherInfo(String ... Args) {
        this.args = Args;
        this.processArgs();
    }

    public void validate() throws ASLauncherException {
        String message = "";
        this.installDir = DASLauncherInfo.safeGetCanonicalFile(this.installDir);
        this.domainsDir = DASLauncherInfo.safeGetCanonicalFile(this.domainsDir);
        this.domainDir = DASLauncherInfo.safeGetCanonicalFile(this.domainDir);
        this.configDir = DASLauncherInfo.safeGetCanonicalFile(this.configDir);
        if (!DASLauncherInfo.safeIsDir(this.installDir)) {
            message = message + "Bad install dir: " + this.installDir + "\n";
        }
        if (!DASLauncherInfo.safeIsDir(this.domainsDir)) {
            message = message + "Bad domains dir: " + this.domainsDir + "\n";
        }
        if (!DASLauncherInfo.safeIsDir(this.configDir) && DASLauncherInfo.safeIsDir(this.installDir)) {
            this.configDir = DASLauncherInfo.safeGetCanonicalFile(new File(this.installDir, "config"));
        }
        if (!DASLauncherInfo.safeIsDir(this.configDir)) {
            message = message + "Bad config dir: " + this.configDir + "\n";
        }
        if (!DASLauncherInfo.safeIsDir(this.domainDir) && DASLauncherInfo.safeIsDir(this.domainsDir) && DASLauncherInfo.ok(this.domainName)) {
            this.domainDir = DASLauncherInfo.safeGetCanonicalFile(new File(this.domainsDir, this.domainName));
        }
        if (!DASLauncherInfo.safeIsDir(this.domainDir)) {
            message = message + "Bad domain dir: " + this.domainDir + "\n";
        }
        if (!DASLauncherInfo.ok(this.domainName)) {
            message = message + "Missing domain name\n";
        }
        if (!DASLauncherInfo.ok(this.instanceName)) {
            message = message + "No instance name\n";
        }
        if (!DASLauncherInfo.safeIsDir(this.domainDir)) {
            message = message + "Bad domain dir: " + this.domainDir + "\n";
        }
        if (!DASLauncherInfo.ok(this.xmlProcessName)) {
            message = message + "Bad process name: " + this.xmlProcessName + "\n";
        }
        if (message.length() > 0) {
            throw new ASLauncherException(message);
        }
        this.valid = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("verbose=" + this.verbose + '\n');
        sb.append("debug=" + this.debug + '\n');
        sb.append("domainsDir=" + this.domainsDir + '\n');
        sb.append("domainName=" + this.domainName + '\n');
        sb.append("installDir=" + this.installDir + '\n');
        sb.append("domainDir=" + this.domainDir + '\n');
        sb.append("configDir=" + this.configDir + '\n');
        sb.append("instanceName=" + this.instanceName + '\n');
        sb.append("xmlProcessName=" + this.xmlProcessName + '\n');
        return sb.toString();
    }

    void setSystemProps() throws ASLauncherException {
        if (!this.valid) {
            throw new ASLauncherException("Internal state is invalid");
        }
        System.setProperty("com.sun.aas.configRoot", this.configDir.getPath());
        System.setProperty("com.sun.aas.installRoot", this.installDir.getPath());
        System.setProperty("com.sun.aas.instanceName", this.instanceName);
        System.setProperty("com.sun.aas.instanceRoot", this.domainDir.getPath());
        System.setProperty("com.sun.aas.processName", this.xmlProcessName);
        System.setProperty("domain.name", this.domainName);
    }

    private void processArgs() {
        this.parseScriptPath();
        this.parseDomainDir();
        this.parseInstallDir();
        this.parseOtherStuff();
    }

    private void parseScriptPath() {
        for (String s : this.args) {
            File bindir;
            File script;
            if (!s.startsWith(SCRIPT_PATH)) continue;
            String path = s.substring(SCRIPT_PATH.length());
            if (!DASLauncherInfo.ok(path) || !DASLauncherInfo.ok(script = new File(path)) || !DASLauncherInfo.safeIsDir(bindir = script.getParentFile())) break;
            this.domainDir = DASLauncherInfo.safeGetCanonicalFile(bindir.getParentFile());
            this.extractInfoFromDomainDir();
        }
    }

    private void parseDomainDir() {
        for (String s : this.args) {
            if (!s.startsWith(DOMAIN_DIR)) continue;
            String path = s.substring(DOMAIN_DIR.length());
            this.domainDir = DASLauncherInfo.safeGetCanonicalFile(new File(path));
            this.extractInfoFromDomainDir();
        }
    }

    private void extractInfoFromDomainDir() {
        if (!DASLauncherInfo.safeIsDir(this.domainDir)) {
            return;
        }
        this.domainsDir = DASLauncherInfo.safeGetCanonicalFile(this.domainDir.getParentFile());
        if (!DASLauncherInfo.safeIsDir(this.domainsDir)) {
            return;
        }
        this.domainName = this.domainDir.getName();
        this.domainsDirParent = DASLauncherInfo.safeGetCanonicalFile(this.domainsDir.getParentFile());
    }

    private void parseInstallDir() {
        for (String s : this.args) {
            if (!s.startsWith(INSTALL_DIR)) continue;
            String path = s.substring(INSTALL_DIR.length());
            if (!DASLauncherInfo.ok(path)) break;
            this.installDir = DASLauncherInfo.safeGetCanonicalFile(new File(path));
            if (!DASLauncherInfo.safeIsDir(this.installDir)) break;
        }
        if (this.installDir != null) {
            return;
        }
        if (this.domainsDirParent != null) {
            this.installDir = this.domainsDirParent;
        }
    }

    private void parseOtherStuff() {
        for (String s : this.args) {
            String arg = s.toLowerCase();
            if (arg.equals("verbose")) {
                this.verbose = true;
            }
            if (!arg.equals("debug")) continue;
            this.debug = true;
        }
    }

    private static File safeGetCanonicalFile(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ioe) {
            return f.getAbsoluteFile();
        }
    }

    private static boolean safeIsDir(File f) {
        return f != null && f.exists() && f.isDirectory();
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static boolean ok(File f) {
        return f != null && f.exists();
    }

    public static void main(String[] Args) {
        new DASLauncherInfo(Args);
    }
}

