/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfoImpl;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.wsmgmt.registry.ConfigHelper;
import com.sun.enterprise.admin.wsmgmt.registry.RegistryAccessObject;
import com.sun.enterprise.admin.wsmgmt.registry.RegistryAccessObjectImpl;
import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryFactory;
import com.sun.enterprise.admin.wsmgmt.repository.spi.RepositoryProvider;
import com.sun.enterprise.admin.wsmgmt.repository.spi.WebServiceInfoProvider;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.TransformationRule;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.webservice.monitoring.Endpoint;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceMgrBackEnd {
    public static final String DEFAULT_VIRTUAL_SERVER = "server";
    private AppsManager appsMgr = null;
    private RepositoryProvider repPvdr;
    private WebServiceInfoProvider wsInfoPvdr;
    private WeakHashMap wsInfoMap;
    private static final String NAME_SEPERATOR = "#";
    private static WebServiceMgrBackEnd mgrImpl = null;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(WebServiceMgrBackEnd.class);
    private static final String LOCAL_HOST = "localhost";
    private static final String MINUS_ONE = "-1";
    private static final String DEFAULT_ORGANIZATION = "Sun Microsystems Inc";
    private static final String DEFAULT_DESCRIPTION = "Sun Java Application Server Web Service Default Description";
    private static final String DEFAULT_PORT = "8080";
    private static final String WEB_SERVICES_WORKAROUND_PORT = "com.sun.enterprise.admin.wsmgt.registry.workaroundPort";

    private WebServiceMgrBackEnd() {
        try {
            this.repPvdr = RepositoryFactory.getRepositoryProvider();
            this.wsInfoPvdr = RepositoryFactory.getWebServiceInfoProvider();
        }
        catch (Exception e) {
            _logger.fine("WebServiceInfoProvider could not be instantiated: " + e.getMessage());
        }
        this.wsInfoMap = new WeakHashMap();
        try {
            InstanceEnvironment ienv = ApplicationServer.getServerContext().getInstanceEnvironment();
            this.appsMgr = new AppsManager(ienv);
        }
        catch (Exception e) {
            _logger.fine("AppsManager could not be instantiated: " + e.getMessage());
        }
    }

    public static synchronized WebServiceMgrBackEnd getManager() {
        if (mgrImpl == null) {
            mgrImpl = new WebServiceMgrBackEnd();
        }
        return mgrImpl;
    }

    public Map getWebServicesMap() {
        HashMap<String, String> wsNameMap = new HashMap<String, String>();
        Map wsModMap = this.repPvdr.getWebServiceModules();
        if (wsModMap == null) {
            return wsNameMap;
        }
        Set wsModSet = wsModMap.entrySet();
        if (wsModSet == null) {
            return wsNameMap;
        }
        for (Map.Entry wsMapEntry : wsModSet) {
            String bundleName;
            String descLoc = (String)wsMapEntry.getKey();
            Map propMap = (Map)wsMapEntry.getValue();
            List wsInfoListInMod = null;
            String appName = (String)propMap.get("application.id");
            Map nMap = this.getFromCache(appName, bundleName = (String)propMap.get("bundle.name"));
            if (nMap != null) {
                wsNameMap.putAll(nMap);
                continue;
            }
            try {
                wsInfoListInMod = this.wsInfoPvdr.getWebServiceInfo(descLoc, propMap);
            }
            catch (Exception e) {
                String msg = _stringMgr.getString("ModInfoNotFound", (Object)(appName + " : " + e.getMessage()));
                _logger.log(Level.WARNING, msg);
            }
            if (wsInfoListInMod == null) continue;
            for (WebServiceEndpointInfo wsInfo : wsInfoListInMod) {
                String wsFQN = this.getFullyQualifiedName(appName, bundleName, wsInfo.isAppStandaloneModule(), wsInfo.getName());
                wsNameMap.put(wsFQN, wsInfo.getName());
                this.updateCache(wsFQN, wsInfo);
            }
        }
        return wsNameMap;
    }

    private synchronized void updateCache(String wsFQN, WebServiceEndpointInfo wsInfo) {
        this.wsInfoMap.put(wsFQN, wsInfo);
    }

    public synchronized void removeFromCache(String appName) {
        Iterator itr = this.wsInfoMap.entrySet().iterator();
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String fqn = (String)entry.getKey();
            WebServiceEndpointInfo wsInfo = (WebServiceEndpointInfo)entry.getValue();
            if (!this.isFQNMatch(fqn, appName)) continue;
            itr.remove();
        }
    }

    private Map getFromCache(String appName, String bundleName) {
        Iterator itr = this.wsInfoMap.entrySet().iterator();
        HashMap<String, String> nMap = null;
        if (itr == null) {
            return null;
        }
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            String fqn = (String)entry.getKey();
            WebServiceEndpointInfo wsInfo = (WebServiceEndpointInfo)entry.getValue();
            if (!this.isFQNMatch(fqn, appName, bundleName)) continue;
            if (nMap == null) {
                nMap = new HashMap<String, String>();
            }
            nMap.put(fqn, wsInfo.getName());
        }
        return nMap;
    }

    private boolean isFQNMatch(String fqn, String appName, String bundleName) {
        String matchFqn = bundleName != null ? appName + NAME_SEPERATOR + bundleName + NAME_SEPERATOR : appName + NAME_SEPERATOR;
        return fqn.startsWith(matchFqn);
    }

    private boolean isFQNMatch(String fqn, String appName) {
        String matchFqn = appName + NAME_SEPERATOR;
        return fqn.startsWith(matchFqn);
    }

    public String getFullyQualifiedName(String moduleID, String wsName) {
        return moduleID + NAME_SEPERATOR + wsName;
    }

    public String getModuleName(String epName) {
        String[] sStrs = epName.split(NAME_SEPERATOR);
        if (sStrs != null) {
            return sStrs[0];
        }
        return null;
    }

    public String getEndpointName(String epName) {
        String[] sStrs = epName.split(NAME_SEPERATOR);
        if (sStrs != null) {
            return sStrs[sStrs.length - 1];
        }
        return null;
    }

    public String getFullyQualifiedName(String appName, String bundleName, boolean isStandAlone, String wsName) {
        if (isStandAlone) {
            return appName + NAME_SEPERATOR + wsName;
        }
        return appName + NAME_SEPERATOR + bundleName + NAME_SEPERATOR + wsName;
    }

    public String getFullyQualifiedName(String appName, String bundleName, String wsName) {
        if (appName == null) {
            return bundleName + NAME_SEPERATOR + wsName;
        }
        return appName + NAME_SEPERATOR + bundleName + NAME_SEPERATOR + wsName;
    }

    public String getFullyQualifiedName(Endpoint ep) {
        com.sun.enterprise.deployment.WebServiceEndpoint wse = ep.getDescriptor();
        String epName = null;
        if (wse != null) {
            epName = wse.getEndpointName();
        }
        BundleDescriptor bundle = wse.getBundleDescriptor();
        Application app = bundle.getApplication();
        String fqn = this.getFullyQualifiedName(app.getRegistrationName(), bundle.getModuleDescriptor().getArchiveUri(), app.isVirtual(), epName);
        return fqn;
    }

    public Map getWebServiceInfoMap(String name) {
        WebServiceEndpointInfo wsInfo = this.getWebServiceInfo(name);
        if (wsInfo == null) {
            return null;
        }
        return ((WebServiceEndpointInfoImpl)wsInfo).asMap();
    }

    public String getEndpointURI(String name) {
        Map endpointInfoMap = this.getWebServiceInfoMap(name);
        if (endpointInfoMap != null) {
            return (String)endpointInfoMap.get("EndPointURI");
        }
        return null;
    }

    private WebServiceEndpointInfo getWebServiceInfo(String name) {
        WebServiceEndpointInfo wsInfo = (WebServiceEndpointInfo)this.wsInfoMap.get(name);
        if (wsInfo == null) {
            this.getWebServicesMap();
            wsInfo = (WebServiceEndpointInfo)this.wsInfoMap.get(name);
        }
        return wsInfo;
    }

    public RegistryAccessObject getRegistryAccessObject() {
        return new RegistryAccessObjectImpl();
    }

    public String getWebServiceEndpointObjectNames(Object key, String serverName) {
        if (key == null || !(key instanceof String)) {
            String msg = "Key passed to WebServiceEndpointObjectNames must be of type String";
            _logger.log(Level.FINE, msg);
            return null;
        }
        WebServiceEndpointInfo wsInfo = this.getWebServiceInfo((String)key);
        if (wsInfo == null) {
            return null;
        }
        String implType = wsInfo.getServiceImplType();
        boolean isEjb = false;
        if (implType.equals("EJB")) {
            isEjb = true;
        }
        String appName = wsInfo.getAppID();
        String modName = wsInfo.getBundleName();
        if (wsInfo.isAppStandaloneModule()) {
            modName = appName;
            appName = null;
        }
        return this.getWSObjectNames(appName, modName, wsInfo.getName(), this.getWebServiceEndpointContextRoot((String)key), isEjb, serverName);
    }

    private String getWebServiceEndpointContextRoot(String wsFQN) {
        String[] fqns = wsFQN.split(NAME_SEPERATOR);
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        ConfigBean cb = null;
        try {
            cb = ApplicationHelper.findApplication((ConfigContext)configCtx, (String)fqns[0]);
        }
        catch (Exception e) {
            String msg = "Could not find a deployed application/module by name " + fqns[0] + " : " + e.getMessage();
            _logger.log(Level.FINE, msg);
            return null;
        }
        boolean isStandalone = false;
        boolean isEjb = false;
        Object appId = null;
        Object modId = null;
        Object epName = null;
        Object ctxRoot = null;
        if (cb instanceof J2eeApplication) {
            assert (fqns.length == 3);
            return null;
        }
        if (cb instanceof EjbModule) {
            assert (fqns.length == 2);
            return null;
        }
        if (cb instanceof WebModule) {
            assert (fqns.length == 2);
            return ((WebModule)cb).getContextRoot();
        }
        return null;
    }

    private String getWSObjectNames(String appId, String modId, String epName, String ctxRoot, boolean isEjb, String serverName) {
        String requiredProps = Util.makeRequiredProps("WebServiceEndpoint", epName);
        String vsProps = null;
        if (!isEjb) {
            String secPart = ctxRoot;
            if (secPart == null) {
                WebBundleDescriptor wbd;
                Application app = null;
                try {
                    app = this.appsMgr.getDescriptor(appId);
                }
                catch (ConfigException ce) {
                    _logger.fine("The descriptor for application " + appId + " could not be loaded: " + ce.getMessage());
                }
                if (app != null && (wbd = app.getWebBundleDescriptorByUri(modId)) != null) {
                    secPart = wbd.getContextRoot();
                }
            }
            if (secPart == null) {
                return null;
            }
            if (secPart.charAt(0) != '/') {
                secPart = "/" + secPart;
            }
            String compositeName = "//server" + secPart;
            vsProps = Util.makeProp("WebModule", compositeName);
        } else {
            vsProps = Util.makeProp("EJBModule", modId);
        }
        requiredProps = Util.concatenateProps(requiredProps, vsProps);
        String serverProp = null;
        if (serverName != null && !serverName.equals("*")) {
            serverProp = Util.makeProp("J2EEServer", serverName);
        }
        String props = serverProp;
        if (appId == null) {
            appId = "null";
        }
        String applicationProp = Util.makeProp("J2EEApplication", appId);
        props = props != null ? Util.concatenateProps(props, applicationProp) : applicationProp;
        String finalProps = Util.concatenateProps(requiredProps, props);
        return finalProps;
    }

    public String[] listRegistryLocations() {
        RegistryAccessObject rao = this.getRegistryAccessObject();
        return rao.listRegistryLocations();
    }

    public void publishToRegistry(String[] registryLocations, Object webServiceEndpointKey, Map optional) {
        String webServiceName = (String)webServiceEndpointKey;
        boolean published = false;
        try {
            String description;
            String organization;
            String wsdl;
            RegistryAccessObject rao = this.getRegistryAccessObject();
            _logger.fine("WebServiceMgrBackEnd.publishToRegistry: publishingWebService " + webServiceName);
            String lbhost = (String)optional.get("LBHost");
            if (lbhost == null) {
                lbhost = this.getHostAddress();
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer Host is unspecified setting to " + lbhost);
            }
            if ((wsdl = this.getWSDL(lbhost, webServiceName)) == null) {
                _logger.log(Level.SEVERE, "registry.wsdl_absent_publish_failure", webServiceName);
                throw new RuntimeException(" Could not retreive WSDL for " + webServiceName);
            }
            String lbport = (String)optional.get("LBPort");
            String lbsslport = (String)optional.get("LBSecurePort");
            if (lbport == null && lbsslport == null) {
                lbport = this.getPort(webServiceName, true, wsdl);
                if (lbport == null) {
                    lbport = MINUS_ONE;
                }
                if ((lbsslport = this.getPort(webServiceName, false, wsdl)) == null) {
                    lbsslport = MINUS_ONE;
                }
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer Port Unspecified setting to default values  LoadBalancer Port = " + lbport + " LoadBalancer SSL Port = " + lbsslport);
            } else if (lbsslport == null) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer SSL Port is unspecified setting to -1");
                lbsslport = MINUS_ONE;
            } else if (lbport == null) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer Host is unspecified setting to -1");
                lbport = MINUS_ONE;
            }
            int ilbport = -1;
            int ilbsslport = -1;
            try {
                ilbport = Integer.valueOf(lbport);
            }
            catch (NumberFormatException e) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer Port is not a number. Setting to -1");
                ilbport = -1;
            }
            try {
                if (lbsslport != null) {
                    ilbsslport = Integer.valueOf(lbsslport);
                }
            }
            catch (NumberFormatException e) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Load Balancer SSL Port is not a number. Setting to -1");
                ilbsslport = -1;
            }
            String categoriesList = (String)optional.get("Categories");
            String[] categories = null;
            if (categoriesList != null) {
                StringTokenizer tokenizer = new StringTokenizer(categoriesList, ",");
                ArrayList<String> list = new ArrayList<String>();
                while (tokenizer.hasMoreElements()) {
                    list.add(tokenizer.nextToken());
                }
                categories = new String[list.size()];
                categories = list.toArray(categories);
            }
            if ((organization = (String)optional.get("Organization")) == null) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Organization  unspecified. Setting a default organization Sun Microsystems Inc");
                organization = DEFAULT_ORGANIZATION;
            }
            if ((description = (String)optional.get("Description")) == null) {
                _logger.fine("WebServiceMgrBackend.publishToRegistry: Web Service  Description unspecified. Setting a default description: Sun Java Application Server Web Service Default Description");
                description = DEFAULT_DESCRIPTION;
            }
            if (!(published = rao.publish(registryLocations, webServiceName, lbhost, ilbport, ilbsslport, categories, organization, description, wsdl))) {
                String errorMessage = _stringMgr.getString("WebServiceMgrBackend.PublishFailure", (Object)webServiceName);
                _logger.log(Level.SEVERE, "registry.publish_failure", webServiceName);
                throw new RuntimeException(errorMessage);
            }
            String message = _stringMgr.getString("WebServiceMgrBackend.PublishSuccess", (Object)webServiceName);
            _logger.log(Level.INFO, message);
        }
        catch (RuntimeException re) {
            _logger.log(Level.SEVERE, "registry.publish_failure_exception", re);
            throw re;
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "registry.publish_failure", webServiceName);
            _logger.log(Level.SEVERE, "registry.publish_failure_exception", e);
            RuntimeException r = new RuntimeException(e);
            throw r;
        }
    }

    String getPort(String webServiceName, boolean unsecure, String wsdlFile) {
        String port = DEFAULT_PORT;
        String http = unsecure ? "http" : "https";
        String pattern = "soap:address.*location.*" + http + ":.*:[0-9]+";
        Pattern soap_address_pattern = Pattern.compile(pattern);
        Matcher soap_address_matcher = soap_address_pattern.matcher(wsdlFile);
        boolean soapAddress = soap_address_matcher.find();
        if (soapAddress) {
            String soap_address = soap_address_matcher.group();
            Pattern port_pattern = Pattern.compile(":[0-9]+");
            Matcher port_matcher = port_pattern.matcher(soap_address);
            port_matcher.find();
            String portWithColon = port_matcher.group();
            port = portWithColon.substring(1);
        } else {
            port = null;
        }
        return port;
    }

    String getWSDL(String host, String webServiceName) {
        String port = DEFAULT_PORT;
        ConfigHelper ch = ConfigHelper.getInstanceToQueryRegistryLocations();
        port = ch.getInstancePort();
        if (port == null) {
            port = DEFAULT_PORT;
        }
        String wsdl = null;
        String uri = null;
        WebServiceEndpointInfo wsInfo = this.getWebServiceInfo(webServiceName);
        if (wsInfo == null) {
            throw new RuntimeException("Could not retreive WebServiceInformation. Cannot publish web service  ");
        }
        uri = wsInfo.getEndpointURI();
        String wsdlurl = "http://" + host + ":" + port + "/" + uri + "?wsdl";
        try {
            URL url = new URL(wsdlurl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer wsdlBuf = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                wsdlBuf.append(line);
            }
            reader.close();
            wsdl = wsdlBuf.toString();
        }
        catch (MalformedURLException mue) {
            _logger.log(Level.WARNING, " Malformed URL for Web Service" + webServiceName, mue);
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, " Cannot retrieve WSDL for Web Service " + webServiceName, ioe);
        }
        return wsdl;
    }

    private String getHostAddress() {
        try {
            InetAddress iaddr = InetAddress.getLocalHost();
            return iaddr.getHostAddress();
        }
        catch (Exception e) {
            return LOCAL_HOST;
        }
    }

    public void unpublishFromRegistry(String[] registryLocations, Object webServiceEndpointKey) {
        String webServiceName = (String)webServiceEndpointKey;
        boolean unpublished = false;
        try {
            RegistryAccessObject rao = this.getRegistryAccessObject();
            _logger.fine("WebServiceMgrBackEnd.unpublishFromRegistry:unpublishing web service = " + webServiceName);
            unpublished = rao.unpublishFromRegistry(registryLocations, webServiceName);
            if (!unpublished) {
                String errorMessage = _stringMgr.getString("WebServiceMgrBackend.UnpublishFailure", (Object)webServiceName);
                _logger.log(Level.SEVERE, "registry.unpublish_failure", webServiceName);
                throw new RuntimeException(errorMessage);
            }
            _logger.log(Level.INFO, "registry.unpublish_success", webServiceName);
        }
        catch (RuntimeException re) {
            _logger.log(Level.SEVERE, "registry.unpublish_failure_exception", re);
            throw re;
        }
        catch (Exception e) {
            String errorMessage = _stringMgr.getString("WebServiceMgrBackend.UnpublishFailure", (Object)webServiceName);
            _logger.log(Level.SEVERE, "registry.unpublish_failure", webServiceName);
            _logger.log(Level.SEVERE, "registry.unpublish_failure_exception", e);
            throw new RuntimeException(e);
        }
    }

    public void removeRegistryConnectionResources(String jndiNameOfRegistry) {
        ConfigHelper configHelper = ConfigHelper.getInstanceToDeleteRegistryResources();
        configHelper.removeRegistryConnectionResources(jndiNameOfRegistry);
    }

    public void addRegistryConnectionResources(String jndiName, String description, String type, Map<String, String> properties) {
        ConfigHelper configHelper = ConfigHelper.getInstanceToDeleteRegistryResources();
        configHelper.addRegistryConnectionResources(jndiName, description, type, properties);
    }

    public void removeFileFromRepository(String appId, String epName, String ruleName) {
        if (appId == null || epName == null || ruleName == null) {
            String msg = "Either appId or epName or ruleName passed is null " + appId;
            _logger.log(Level.FINE, msg);
            throw new IllegalArgumentException();
        }
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        TransformationRule tRule = null;
        try {
            tRule = ApplicationHelper.findTransformationRule((ConfigContext)configCtx, (String)appId, (String)epName, (String)ruleName);
        }
        catch (Exception e) {
            String msg = "Could not find a deployed application/module type " + appId;
            _logger.log(Level.FINE, msg);
            throw new RuntimeException(e);
        }
        File ruleFile = new File(tRule.getRuleFileLocation());
        FileUtils.liquidate(ruleFile);
    }

    public String moveFileToRepository(String curLocation, String appId) throws IOException {
        if (curLocation == null || appId == null) {
            String msg = "Either rule location or appId passed is null " + appId;
            _logger.log(Level.FINE, msg);
            throw new IllegalArgumentException();
        }
        String appType = null;
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        try {
            appType = ApplicationHelper.getApplicationType((ConfigContext)configCtx, (String)appId);
        }
        catch (Exception e) {
            String msg = "Could not find a deployed application/module type " + appId;
            _logger.log(Level.FINE, msg);
            throw new RuntimeException(e);
        }
        String rootDir = System.getProperty("com.sun.aas.instanceRoot");
        String finalLoc = null;
        File fin = new File(curLocation);
        if (appType.equals("J2eeApplication")) {
            finalLoc = rootDir + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-apps" + File.separator + appId + File.separator;
        } else if (appType.equals("EjbModule") || appType.equals("WebModule")) {
            finalLoc = rootDir + File.separator + "generated" + File.separator + "xml" + File.separator + "j2ee-modules" + File.separator + appId + File.separator;
        }
        File fout = new File(finalLoc + fin.getName());
        int fileIdx = 0;
        while (fout.exists()) {
            fout = new File(finalLoc + fileIdx + fin.getName());
            ++fileIdx;
        }
        FileUtils.copy(fin, fout);
        FileUtils.liquidate(fin);
        return finalLoc + fin.getName();
    }

    public List getTransformationRuleConfigObjectNameList(String appId, String wsepName, Map<String, ObjectName> oNameMap) {
        if (oNameMap == null) {
            return null;
        }
        ArrayList<ObjectName> retList = new ArrayList<ObjectName>(oNameMap.size());
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        ConfigBean cb = null;
        try {
            cb = ApplicationHelper.findApplication((ConfigContext)configCtx, (String)appId);
        }
        catch (Exception e) {
            String msg = "Could not find a deployed application/module by name " + appId;
            _logger.log(Level.FINE, msg);
            return null;
        }
        TransformationRule[] tRules = null;
        WebServiceEndpoint wsep = null;
        if (cb instanceof J2eeApplication) {
            wsep = ((J2eeApplication)cb).getWebServiceEndpointByName(wsepName);
        } else if (cb instanceof EjbModule) {
            wsep = ((EjbModule)cb).getWebServiceEndpointByName(wsepName);
        } else if (cb instanceof WebModule) {
            wsep = ((WebModule)cb).getWebServiceEndpointByName(wsepName);
        } else {
            return null;
        }
        if (wsep != null) {
            tRules = wsep.getTransformationRule();
        }
        for (int index = 0; index < tRules.length; ++index) {
            retList.add(oNameMap.get(tRules[index].getName()));
        }
        return retList;
    }
}

