/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.repository.impl.cache;

import com.sun.enterprise.admin.wsmgmt.WebServiceMgrBackEnd;
import com.sun.enterprise.admin.wsmgmt.repository.impl.cache.CacheMgr;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEventListener;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppServDELImpl
implements DeploymentEventListener {
    private static Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public void notifyDeploymentEvent(DeploymentEvent event) {
        try {
            DeploymentEventInfo info = null;
            if (event != null) {
                info = event.getEventInfo();
            }
            Application rootDD = null;
            DeploymentRequest dr = null;
            if (info != null) {
                rootDD = info.getApplicationDescriptor();
                dr = info.getDeploymentRequest();
            }
            CacheMgr mgr = CacheMgr.getInstance();
            if (event != null && event.getEventType() == 2) {
                if (dr.isEjbModule()) {
                    Set ws = rootDD.getWebServiceDescriptors();
                    if (ws != null && !ws.isEmpty()) {
                        mgr.addEjbModule(dr.getName());
                        mgr.save();
                    }
                } else if (dr.isWebModule()) {
                    Set ws = rootDD.getWebServiceDescriptors();
                    if (ws != null && !ws.isEmpty()) {
                        mgr.addWebModule(dr.getName());
                        mgr.save();
                    }
                } else if (dr.isApplication()) {
                    ArrayList<String> ejb = new ArrayList<String>();
                    Set ejbBundles = rootDD.getEjbBundleDescriptors();
                    for (BundleDescriptor bd : ejbBundles) {
                        WebServicesDescriptor wsDD = bd.getWebServices();
                        if (!wsDD.hasWebServices()) continue;
                        ejb.add(bd.getModuleDescriptor().getArchiveUri());
                    }
                    ArrayList<String> web = new ArrayList<String>();
                    Set webBundles = rootDD.getWebBundleDescriptors();
                    for (BundleDescriptor bd : webBundles) {
                        WebServicesDescriptor wsDD = bd.getWebServices();
                        if (!wsDD.hasWebServices()) continue;
                        web.add(bd.getModuleDescriptor().getArchiveUri());
                    }
                    if (!ejb.isEmpty() || !web.isEmpty()) {
                        mgr.addJ2eeApplication(dr.getName(), ejb, web);
                        mgr.save();
                    }
                }
                WebServiceMgrBackEnd.getManager().removeFromCache(dr.getName());
            } else if (event != null && (event.getEventType() == 4 || event.getEventType() == 1)) {
                if (dr.isEjbModule()) {
                    mgr.removeEjbModule(dr.getName());
                    mgr.save();
                } else if (dr.isWebModule()) {
                    mgr.removeWebModule(dr.getName());
                    mgr.save();
                } else if (dr.isApplication()) {
                    mgr.removeJ2eeApplication(dr.getName());
                    mgr.save();
                }
                WebServiceMgrBackEnd.getManager().removeFromCache(dr.getName());
            }
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Error in deployment event listener", e);
        }
    }
}

