/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;
import com.sun.enterprise.admin.wsmgmt.config.spi.TransformationRule;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.transform.TemplatesData;
import com.sun.enterprise.admin.wsmgmt.transform.TransformException;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class FilterChain {
    XMLReader _reader = null;
    SAXTransformerFactory _stf = null;
    Transformer _transformer = null;
    TemplatesData[] templatesData = null;
    static final int STRING_WRITER_INIT_SIZE = 4028;
    private static final Logger _logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static final StringManager _stringMgr = StringManager.getManager(FilterChain.class);

    public FilterChain(TransformationRule[] rules, boolean reverse) throws TransformException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            this._reader = parser.getXMLReader();
            this._stf = (SAXTransformerFactory)TransformerFactory.newInstance();
            this._transformer = this._stf.newTransformer();
            this.setupTemplates(rules, reverse);
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    private synchronized void setupTemplates(TransformationRule[] tRules, boolean reverse) throws TransformException {
        if (tRules == null || tRules.length == 0) {
            return;
        }
        this.templatesData = new TemplatesData[tRules.length];
        if (!reverse) {
            for (int idx = 0; idx < tRules.length; ++idx) {
                this.addTemplate(idx, tRules[idx]);
            }
        } else {
            int index = 0;
            for (int idx = tRules.length - 1; idx > -1; --idx) {
                this.addTemplate(index, tRules[idx]);
                ++index;
            }
        }
    }

    private synchronized void addTemplate(int index, TransformationRule tRule) throws TransformException {
        try {
            if (tRule == null) {
                return;
            }
            String name = tRule.getName();
            File stylesheet = new File(tRule.getRuleFileLocation());
            if (!stylesheet.isAbsolute()) {
                String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
                stylesheet = new File(instanceRoot + File.separator + tRule.getRuleFileLocation());
            }
            this.templatesData[index] = new TemplatesData(name, this._stf.newTemplates(new StreamSource(stylesheet)));
        }
        catch (Exception e) {
            String msg = _stringMgr.getString("rule_not_compiled", (Object)tRule.getRuleFileLocation(), (Object)tRule.getName());
            _logger.log(Level.WARNING, msg);
            throw new TransformException(e);
        }
    }

    private LinkedList getFilterList() throws TransformerConfigurationException {
        LinkedList filterList = new LinkedList();
        if (this.templatesData == null) {
            return filterList;
        }
        for (int i = 0; i < this.templatesData.length; ++i) {
            TemplatesData t = this.templatesData[i];
            XMLFilter f = this._stf.newXMLFilter(t.getTemplates());
            this.addToList(filterList, i, f);
        }
        return filterList;
    }

    private void addToList(LinkedList filterList, int index, XMLFilter filter) {
        XMLFilter parent = null;
        if (index == 0) {
            filter.setParent(this._reader);
        } else {
            XMLFilter child;
            parent = (XMLFilter)filterList.get(index - 1);
            filter.setParent(parent);
            if (filterList.size() - 1 > index && (child = (XMLFilter)filterList.get(index)) != null) {
                child.setParent(filter);
            }
        }
        filterList.add(index, filter);
    }

    public synchronized void process(FilterContext context) throws TransformException, TransformerConfigurationException {
        LinkedList filterList = this.getFilterList();
        if (filterList.size() == 0 || context == null) {
            return;
        }
        try {
            InputSource inputSrc;
            SOAPMessageContext smc = context.getMessageContext();
            SOAPMessage sm = smc.getMessage();
            SOAPPart sp = sm.getSOAPPart();
            Source s = sp.getContent();
            ByteArrayInputStream bis = null;
            if (s instanceof SAXSource) {
                inputSrc = SAXSource.sourceToInputSource(s);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer xtransformer = tf.newTransformer();
                xtransformer.transform(s, new StreamResult(bos));
                byte[] buf = bos.toByteArray();
                bos.flush();
                bos.close();
                bis = new ByteArrayInputStream(buf);
                inputSrc = new InputSource(bis);
            }
            SAXSource transformSource = new SAXSource((XMLFilter)filterList.getLast(), inputSrc);
            StringWriter sw = new StringWriter(4028);
            StreamResult r = new StreamResult(sw);
            this._transformer.transform(transformSource, r);
            sw.flush();
            sw.close();
            if (bis != null) {
                bis.close();
            }
            StringBufferInputStream in = new StringBufferInputStream(sw.toString());
            MessageFactory mFactory = MessageFactory.newInstance();
            SOAPMessage resMsg = mFactory.createMessage(null, (InputStream)in);
            smc.setMessage(resMsg);
        }
        catch (Exception e) {
            _logger.fine("XSLT transformation failed for " + context.getFullyQualifiedName());
            throw new TransformException(e);
        }
    }
}

