/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation.tests;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.PropertyHelper;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import java.util.Map;

public class JdbcConnectionPoolTest
extends GenericValidator {
    static boolean checked = false;
    int maxPoolSize = 0;
    static final String LAZY_CONN_ASSOCIATION = "LazyConnectionAssociation";
    static final String LAZY_CONN_ENLISTMENT = "LazyConnectionEnlistment";

    public JdbcConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    }

    public void validate(ValidationContext valCtx) {
        super.validate(valCtx);
        if (valCtx.isVALIDATE() || valCtx.isADD() || valCtx.isSET()) {
            JdbcConnectionPool pool = (JdbcConnectionPool)valCtx.getTargetBean();
            if (pool.isIsConnectionValidationRequired() && pool.getConnectionValidationMethod().equals("table") && (pool.getValidationTableName() == null || pool.getValidationTableName().equals(""))) {
                JdbcConnectionPoolTest.reportValidationError(valCtx, "requiredTableName", "Table Name is required Jdbc Connection Pool if Connection validation method is Table", null);
            }
            this.checkLazyConnectionProps(valCtx);
        }
    }

    public void validatePropertyChanges(ValidationContext propValCtx) {
        if (propValCtx.isDELETE() || propValCtx.isVALIDATE()) {
            return;
        }
        if (!PropertyHelper.isPropertyChanged(propValCtx, LAZY_CONN_ASSOCIATION) && !PropertyHelper.isPropertyChanged(propValCtx, LAZY_CONN_ENLISTMENT)) {
            return;
        }
        this.checkLazyConnectionProps(propValCtx);
    }

    private void checkLazyConnectionProps(ValidationContext valCtx) {
        ConfigBean targetBean = valCtx.getTargetBean();
        if (targetBean == null) {
            return;
        }
        Map map = targetBean instanceof ElementProperty ? PropertyHelper.getFuturePropertiesMap(valCtx) : PropertyHelper.getPropertiesMap(targetBean);
        String newAsso = (String)map.get(LAZY_CONN_ASSOCIATION);
        String newEnlist = (String)map.get(LAZY_CONN_ENLISTMENT);
        if (newAsso != null && newEnlist != null && Boolean.parseBoolean(newAsso) && !Boolean.parseBoolean(newEnlist)) {
            JdbcConnectionPoolTest.reportValidationError(valCtx, "PropsConflict", "Combination of properties {0}={1} and {2}={3} is not allowed.", new Object[]{LAZY_CONN_ASSOCIATION, newAsso, LAZY_CONN_ENLISTMENT, newEnlist});
        }
    }
}

