/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.HTTPServiceConfig;
import com.sun.appserv.management.config.VirtualServerConfig;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPListenerConfigFactory
extends ConfigFactory {
    private final OldHTTPServiceMBean mOldHTTPServiceMBean;
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("Address", "Port", "Enabled", "SecurityEnabled", "DefaultVirtualServer", "AcceptorThreads", "XpoweredBy", "XpoweredBy", "IgnoreMissingReferences");

    public HTTPListenerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
        this.mOldHTTPServiceMBean = this.getOldConfigProxies().getOldHTTPServiceMBean(this.getConfigName());
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "id");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        return this.mOldHTTPServiceMBean.createHttpListener(translatedAttrs);
    }

    private void checkVirtualServerExists(String virtualServerName) {
        HTTPServiceConfig httpService = (HTTPServiceConfig)this.getFactoryContainer();
        Map<String, VirtualServerConfig> virtualServers = httpService.getVirtualServerConfigMap();
        if (!virtualServers.containsKey(virtualServerName)) {
            throw new IllegalArgumentException("No virtual server exists with the name: " + virtualServerName);
        }
    }

    public ObjectName create(String name, String address, int port, String defaultVirtualServer, String serverName, Map<String, String> options) {
        String[] requiredParams = new String[]{"Address", address, "Port", "" + port, "DefaultVirtualServer", defaultVirtualServer, "ServerName", serverName};
        if (this.requireValidReferences(options)) {
            this.checkVirtualServerExists(defaultVirtualServer);
        }
        Map<String, String> params = this.initParams(name, requiredParams, options);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    @Override
    protected final void removeByName(String name) {
        this.mOldHTTPServiceMBean.removeHttpListenerById(name);
    }
}

