/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.config.ResourceFactoryImplBase;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JNDIResourceConfigFactory
extends ResourceFactoryImplBase {
    private static final String JNDI_LOOKUP_NAME_KEY = "JNDILookupName";
    private static final String FACTORY_CLASS_KEY = "FactoryClass";
    private static final String RES_TYPE_KEY = "ResType";

    public JNDIResourceConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs) {
        this.trace("JNDIResourceConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = this.getOldResourcesMBean().createExternalJndiResource(translatedAttrs);
        return objectName;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "jndi-name");
    }

    public ObjectName create(String jndiName, String jndiLookupName, String resType, String factoryClass, Map<String, String> optional) {
        String[] requiredParams = new String[]{JNDI_LOOKUP_NAME_KEY, jndiLookupName, RES_TYPE_KEY, resType, FACTORY_CLASS_KEY, factoryClass};
        Map<String, String> params = this.initParams(jndiName, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(jndiName, params);
        return amxName;
    }

    @Override
    protected void removeByName(String name) {
        Set<ResourceRefConfig> refs = this.findAllRefConfigs("X-JNDIResourceConfig", name);
        if (refs.size() == 0) {
            this.getOldResourcesMBean().removeExternalJndiResourceByJndiName(name);
        } else {
            for (ResourceRefConfig ref : refs) {
                String target = ref.getContainer().getName();
                this.getOldResourcesMBean().deleteExternalJndiResource(name, target);
            }
        }
    }
}

