/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.config;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.management.config.ConfigFactory;
import com.sun.enterprise.management.config.ConfigFactoryCallback;
import com.sun.enterprise.management.support.WebModuleSupport;
import com.sun.enterprise.management.support.oldconfig.OldConfigsMBean;
import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VirtualServerConfigFactory
extends ConfigFactory {
    private final Set<String> LEGAL_OPTIONAL_KEYS = GSetUtil.newUnmodifiableStringSet("HTTPListeners", "State", "property.docroot", "property.accesslog");
    public static final String HOSTS_KEY = "Hosts";

    public VirtualServerConfigFactory(ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    @Override
    protected Set<String> getLegalOptionalCreateKeys() {
        return this.LEGAL_OPTIONAL_KEYS;
    }

    @Override
    protected Map<String, String> getParamNameOverrides() {
        return MapUtil.newMap("Name", "id");
    }

    @Override
    protected ObjectName createOldChildConfig(AttributeList translatedAttrs, Properties props) {
        String target = this.getConfigName();
        OldConfigsMBean oldConfigsMBean = this.getOldConfigProxies().getOldConfigsMBean();
        this.trace("VirtualServerConfigFactory.createOldChildConfig: creating using: " + this.stringify(translatedAttrs));
        ObjectName objectName = oldConfigsMBean.createVirtualServer(translatedAttrs, props, target);
        return objectName;
    }

    public ObjectName create(String name, String hosts, Map<String, String> optional) {
        String[] requiredParams = new String[]{HOSTS_KEY, hosts};
        if (!WebModuleSupport.isLegalVirtualServerName(name)) {
            throw new IllegalArgumentException(name);
        }
        Map<String, String> params = this.initParams(name, requiredParams, optional);
        ObjectName amxName = this.createNamedChild(name, params);
        return amxName;
    }

    @Override
    public void internalRemove(ObjectName objectName) {
        OldHTTPServiceMBean oldHTTPServer = this.getOldConfigProxies().getOldHTTPServiceMBean(this.getConfigName());
        String name = Util.getName(objectName);
        oldHTTPServer.removeVirtualServerById(name);
    }
}

