/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.j2ee;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.mbeans.DomainStatusHelper;
import com.sun.enterprise.admin.mbeans.DomainStatusMBean;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.management.j2ee.J2EEServerImpl;
import com.sun.enterprise.management.support.DelegateToMBeanDelegate;
import com.sun.enterprise.management.support.DummyDelegate;
import com.sun.enterprise.management.support.QueryMgrImpl;
import com.sun.enterprise.management.support.oldconfig.OldConfigProxies;
import com.sun.enterprise.management.support.oldconfig.OldServersMBean;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DASJ2EEServerImpl
extends J2EEServerImpl
implements NotificationListener {
    private static final Class[] DOMAIN_STATUS_INTERFACES = new Class[]{DomainStatusMBean.class};
    static final String DAS_SERVER_NAME = "server";
    private MBeanInfo mMBeanInfo = null;

    public DASJ2EEServerImpl() {
        super("J2EEServer", DummyDelegate.INSTANCE);
    }

    protected DomainStatusMBean getDomainStatus() {
        DomainStatusMBean domainStatus = null;
        try {
            MBeanServer mbeanServer = this.getMBeanServer();
            Set<ObjectName> candidates = QueryMgrImpl.queryPatternObjectNameSet(mbeanServer, JMXUtil.newObjectNamePattern("*", "name=domain-status"));
            ObjectName on = GSetUtil.getSingleton(candidates);
            domainStatus = MBeanServerInvocationHandler.newProxyInstance(mbeanServer, on, DomainStatusMBean.class, false);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
        }
        return domainStatus;
    }

    private boolean remoteServerIsRunning() {
        return 1 == this.getstate();
    }

    private boolean remoteServerIsStartable() {
        int cState = this.getstate();
        return 3 == cState || 4 == cState;
    }

    private boolean remoteServerIsStoppable() {
        int cState = this.getstate();
        return 0 == cState || 1 == cState || 4 == cState;
    }

    public void handleNotification(Notification notif, Object ignore) {
        String serverName;
        String notifType = notif.getType();
        if (notifType.equals("com.sun.appserv.management.status.ServerStatusChanged") && (serverName = (String)((Object)Util.getAMXNotificationValue(notif, "ServerName"))).equals(this.getServerName())) {
            this.setDelegate();
        }
    }

    private synchronized void setDelegate() {
        if (this.remoteServerIsRunning()) {
            try {
                ManagementObjectManager mgmtObjManager = Switch.getSwitch().getManagementObjectManager();
                String strON = mgmtObjManager.getServerBaseON(false, this.getServerName());
                MBeanServerConnection remoteConn = this.getDomainStatus().getServerMBeanServerConnection(this.getServerName());
                ObjectName onPattern = new ObjectName(strON + ",*");
                Set<ObjectName> names = JMXUtil.queryNames(remoteConn, onPattern, null);
                assert (names.size() == 1);
                ObjectName serverON = GSetUtil.getSingleton(names);
                DelegateToMBeanDelegate delegate = new DelegateToMBeanDelegate(remoteConn, serverON);
                this.setDelegate(delegate);
                this.setstartTime(System.currentTimeMillis());
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtil.getRootCause(e);
                this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
                if (this.getDelegate() == null) {
                    this.setDelegate(DummyDelegate.INSTANCE);
                    this.setstartTime(0L);
                }
            }
        } else {
            this.setDelegate(DummyDelegate.INSTANCE);
            this.setstartTime(0L);
        }
    }

    public void preRegisterDone() throws Exception {
        super.preRegisterDone();
        this.setstartTime(0L);
        this.setDelegate();
    }

    protected String getServerName() {
        return this.getSelfName();
    }

    public boolean isstateManageable() {
        return true;
    }

    final RuntimeStatus getRuntimeStatus(String serverName) {
        MBeanServer mbeanServer = this.getMBeanServer();
        OldServersMBean oldServers = OldConfigProxies.getInstance(mbeanServer).getOldServersMBean();
        RuntimeStatus status2 = oldServers.getRuntimeStatus(serverName);
        return status2;
    }

    private static int serverStatusCodeToStateManageableState(int statusCode) {
        int state = 4;
        switch (statusCode) {
            default: {
                throw new IllegalArgumentException("Uknown status code: " + statusCode);
            }
            case 1: {
                state = 0;
                break;
            }
            case 0: {
                state = 1;
                break;
            }
            case 2: {
                state = 2;
                break;
            }
            case 3: {
                state = 3;
            }
        }
        return state;
    }

    public int getstate() {
        int state = 3;
        try {
            int internalStatus = this.getRuntimeStatus(this.getServerName()).getStatus().getStatusCode();
            state = DASJ2EEServerImpl.serverStatusCodeToStateManageableState(internalStatus);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    public void start() {
        if (!this.remoteServerIsStartable()) {
            throw new RuntimeException("server is not in a startable state");
        }
        this.startRemoteServer();
    }

    public void startRecursive() {
        this.start();
    }

    private boolean isDASJ2EEServer() {
        return DAS_SERVER_NAME.equals(this.getName());
    }

    public void stop() {
        if (this.isDASJ2EEServer()) {
            this.getDelegate().invoke("stop", null, null);
        } else if (this.remoteServerIsStoppable()) {
            this.stopRemoteServer();
        } else {
            throw new RuntimeException("server is not in a stoppable state");
        }
    }

    public synchronized MBeanInfo getMBeanInfo() {
        if (this.mMBeanInfo == null) {
            MBeanInfo superMBeanInfo = super.getMBeanInfo();
            this.mMBeanInfo = new MBeanInfo(superMBeanInfo.getClassName(), superMBeanInfo.getDescription(), this.mergeAttributeInfos(superMBeanInfo.getAttributes(), this.getMBeanAttributeInfo()), superMBeanInfo.getConstructors(), this.mergeOperationInfos(superMBeanInfo.getOperations(), this.getMBeanOperationInfo()), superMBeanInfo.getNotifications());
        }
        return this.mMBeanInfo;
    }

    private MBeanAttributeInfo[] mergeAttributeInfos(MBeanAttributeInfo[] infos1, MBeanAttributeInfo[] infos2) {
        MBeanAttributeInfo[] infos = new MBeanAttributeInfo[infos1.length + infos2.length];
        System.arraycopy(infos1, 0, infos, 0, infos1.length);
        System.arraycopy(infos2, 0, infos, infos1.length, infos2.length);
        return infos;
    }

    private MBeanAttributeInfo[] getMBeanAttributeInfo() {
        MBeanAttributeInfo[] dAttributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("state", "java.lang.Integer", "server state", true, false, false)};
        return dAttributes;
    }

    private MBeanOperationInfo[] mergeOperationInfos(MBeanOperationInfo[] infos1, MBeanOperationInfo[] infos2) {
        MBeanOperationInfo[] infos = new MBeanOperationInfo[infos1.length + infos2.length];
        System.arraycopy(infos1, 0, infos, 0, infos1.length);
        System.arraycopy(infos2, 0, infos, infos1.length, infos2.length);
        return infos;
    }

    private MBeanOperationInfo[] getMBeanOperationInfo() {
        MBeanOperationInfo[] dOperations = new MBeanOperationInfo[]{new MBeanOperationInfo("start", "start server instance", null, "void", 1), new MBeanOperationInfo("stop", "stop server instance", null, "void", 1), new MBeanOperationInfo("startRecursive", "start server instance", null, "void", 1)};
        return dOperations;
    }

    private void startRemoteServer() {
        try {
            ObjectName on = DomainStatusHelper.getServersConfigObjectName();
            MBeanServer server = this.getMBeanServer();
            Object[] params = new Object[]{this.getServerName()};
            String[] signature = new String[]{"java.lang.String"};
            server.invoke(on, "startServerInstance", params, signature);
        }
        catch (MalformedObjectNameException mfone) {
            Throwable rootCause = ExceptionUtil.getRootCause(mfone);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mfone);
        }
        catch (InstanceNotFoundException infe) {
            Throwable rootCause = ExceptionUtil.getRootCause(infe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(infe);
        }
        catch (MBeanException mbe) {
            Throwable rootCause = ExceptionUtil.getRootCause(mbe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mbe);
        }
        catch (ReflectionException rfe) {
            Throwable rootCause = ExceptionUtil.getRootCause(rfe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(rfe);
        }
    }

    private void stopRemoteServer() {
        try {
            ObjectName on = DomainStatusHelper.getServersConfigObjectName();
            MBeanServer server = this.getMBeanServer();
            Object[] params = new Object[]{this.getServerName()};
            String[] signature = new String[]{"java.lang.String"};
            server.invoke(on, "stopServerInstance", params, signature);
        }
        catch (MalformedObjectNameException mfone) {
            Throwable rootCause = ExceptionUtil.getRootCause(mfone);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mfone);
        }
        catch (InstanceNotFoundException infe) {
            Throwable rootCause = ExceptionUtil.getRootCause(infe);
            this.getMBeanLogger().fine(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(infe);
        }
        catch (MBeanException mbe) {
            Throwable rootCause = ExceptionUtil.getRootCause(mbe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(mbe);
        }
        catch (ReflectionException rfe) {
            Throwable rootCause = ExceptionUtil.getRootCause(rfe);
            this.getMBeanLogger().warning(rootCause.toString() + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw new RuntimeException(rfe);
        }
    }

    public boolean getRestartRequired() {
        if (this.getDelegate() == null || this.getDelegate() == DummyDelegate.INSTANCE) {
            this.setDelegate();
        }
        boolean required = true;
        int state = this.getstate();
        if (state == 3 || state == 4 || state == 2) {
            required = true;
        } else {
            try {
                Object result = this.getDelegate().getAttribute("restartRequired");
                required = Boolean.valueOf("" + result);
            }
            catch (AttributeNotFoundException e) {
                this.logWarning(ExceptionUtil.toString(e));
                required = true;
            }
        }
        return required;
    }
}

