/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.AMXDebug;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.CollectionUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.offline.ConfigBeanHelper;
import com.sun.enterprise.management.offline.ConfigBeanHelperFactory;
import com.sun.enterprise.management.offline.ConfigDelegate;
import com.sun.enterprise.management.offline.ConfigDelegateFactory;
import com.sun.enterprise.management.support.AMXDebugSupport;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.ObjectNames;
import com.sun.enterprise.management.support.OldConfigTypes;
import com.sun.enterprise.management.support.SystemInfoImpl;
import com.sun.enterprise.management.support.TypeInfo;
import com.sun.enterprise.management.support.TypeInfos;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AMXLoader
implements NotificationListener {
    private final MBeanServer mServer;
    private final String mJMXDomain;
    private final ConfigDelegateFactory mDelegateFactory;
    private ObjectNames mObjectNames;
    private final Map<ObjectName, ConfigBean> mObjectNameToConfigBean;
    private static final Class[] DELEGATE_CONSTRUCTOR_SIG = new Class[]{Delegate.class};

    public AMXLoader(MBeanServer server, ConfigDelegateFactory delegateFactory) throws Exception {
        this.mServer = server;
        new AMXDebugSupport(this.mServer);
        this.mDelegateFactory = delegateFactory;
        this.mJMXDomain = BootUtil.getInstance().getAMXJMXDomainName();
        this.mObjectNames = ObjectNames.getInstance(this.getAMXJMXDomainName());
        this.mObjectNameToConfigBean = Collections.synchronizedMap(new HashMap());
        this.loadSystemInfo(server);
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        filter.enableAllObjectNames();
        JMXUtil.listenToMBeanServerDelegate(this.mServer, this, filter, null);
    }

    protected void sdebug(Object o) {
        this.debug(o);
        System.out.println("" + o);
    }

    public String getAMXJMXDomainName() {
        return BootUtil.getInstance().getAMXJMXDomainName();
    }

    private ConfigContext getConfigContext() {
        return this.mDelegateFactory.getConfigContext();
    }

    private void debug(Object o) {
        AMXDebug.getInstance().getOutput("AMXLoader").println(o);
    }

    @Override
    public void handleNotification(Notification notifIn, Object handback) {
        String type = notifIn.getType();
        if (notifIn instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notifIn).getMBeanName();
            if (type.equals("JMX.mbean.registered")) {
                this.handleMBeanRegistered(objectName);
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.handleMBeanUnregistered(objectName);
            }
        }
    }

    public void handleMBeanRegistered(ObjectName objectName) {
    }

    public void handleMBeanUnregistered(ObjectName objectName) {
        this.mObjectNameToConfigBean.remove(objectName);
    }

    protected Class getImplClass(String j2eeType) {
        TypeInfo info = TypeInfos.getInstance().getInfo(j2eeType);
        assert (info != null);
        return info.getImplClass();
    }

    protected Object newImpl(String j2eeType, Delegate delegate) throws Exception {
        Object impl = null;
        Class implClass = this.getImplClass(j2eeType);
        try {
            Constructor constructor = implClass.getConstructor(DELEGATE_CONSTRUCTOR_SIG);
            if (constructor != null) {
                impl = constructor.newInstance(delegate);
            }
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.debug("newImpl: exception creating new impl: " + e + "\n" + ExceptionUtil.getStackTrace(rootCause));
            throw e;
        }
        return impl;
    }

    private String oldTypeToJ2EEType(String type) {
        return OldConfigTypes.getInstance().oldTypeToJ2EEType(type);
    }

    public ObjectName loadAMX(ConfigBean configBean) throws Exception {
        ConfigBeanHelperFactory factory = ConfigBeanHelperFactory.getInstance(this.mDelegateFactory.getConfigContext());
        ConfigBeanHelper helper = factory.getHelper(configBean);
        String xPath = helper.getXPath();
        List<String[]> propsList = helper.getAllObjectNameProps(OldConfigTypes.getIgnoreTypes());
        String[] firstPair = propsList.iterator().next();
        String type = firstPair[0];
        String foundName = firstPair[1];
        if (type == null || OldConfigTypes.getIgnoreTypes().contains(type)) {
            return null;
        }
        String j2eeType = this.oldTypeToJ2EEType(type);
        String name = foundName == null ? ObjectNames.getSingletonName(j2eeType) : foundName;
        String props = Util.makeRequiredProps(j2eeType, name);
        for (String[] pair : propsList) {
            String ancestorType = pair[0];
            String ancestorNameFound = pair[1];
            if (OldConfigTypes.getIgnoreTypes().contains(ancestorType)) continue;
            String ancestorJ2EEType = this.oldTypeToJ2EEType(ancestorType);
            String ancestorName = ancestorNameFound == null ? ObjectNames.getSingletonName(j2eeType) : ancestorNameFound;
            String prop = Util.makeProp(ancestorJ2EEType, ancestorName);
            props = Util.concatenateProps(props, prop);
        }
        ObjectName objectName = Util.newObjectName(this.mJMXDomain, props);
        ConfigDelegate delegate = this.mDelegateFactory.createConfigDelegate(configBean);
        AMXConfigImplBase amx = (AMXConfigImplBase)this.newImpl(j2eeType, delegate);
        this.mObjectNameToConfigBean.put(objectName, configBean);
        objectName = this.mServer.registerMBean(amx, objectName).getObjectName();
        return objectName;
    }

    private Map<String, Object> getConfigBeanAttributes(ConfigBean configBean) {
        HashMap<String, Object> pairs = new HashMap<String, Object>();
        try {
            MBeanAttributeInfo[] attrInfos;
            ConfigDelegate delegate = this.mDelegateFactory.createConfigDelegate(configBean);
            for (MBeanAttributeInfo attrInfo : attrInfos = delegate.getMBeanInfo().getAttributes()) {
                String name = attrInfo.getName();
                Object value = null;
                try {
                    value = delegate.getAttribute(name);
                }
                catch (AttributeNotFoundException e) {
                    value = "<NOT FOUND>";
                }
                pairs.put(name, value);
            }
        }
        catch (Exception e) {
            pairs.put("EXCEPTION", e.getClass().getName() + ": " + e.getMessage());
        }
        return pairs;
    }

    private void addBeanHierarchy(List<ConfigBean> configBeans, ConfigBean configBean) {
        if (configBean != null) {
            configBeans.add(configBean);
            ConfigBean[] children = configBean.getAllChildBeans();
            if (children != null) {
                for (ConfigBean child : children) {
                    this.addBeanHierarchy(configBeans, child);
                }
            }
        }
    }

    private String configBeansToString(List<ConfigBean> configBeans) {
        Object[] xPaths = new String[configBeans.size()];
        int i = 0;
        for (ConfigBean configBean : configBeans) {
            xPaths[i] = "" + configBean.getXPath();
            ++i;
        }
        Arrays.sort(xPaths);
        String NEWLINE = System.getProperty("line.separator");
        return StringUtil.toString(NEWLINE, xPaths);
    }

    private ObjectName configBeanToAMX(ConfigBean configBean) {
        assert (configBean != null);
        ObjectName objectName = null;
        try {
            objectName = this.loadAMX(configBean);
        }
        catch (Exception e) {
            Throwable rootCause = ExceptionUtil.getRootCause(e);
            this.sdebug("Exception of type " + rootCause.getClass().getName() + " trying to create AMXConfig for " + configBean.getXPath() + ": " + rootCause.getMessage());
            this.sdebug(ExceptionUtil.getStackTrace(rootCause));
        }
        return objectName;
    }

    private List<ObjectName> configBeansToAMX(List<ConfigBean> configBeans) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (ConfigBean configBean : configBeans) {
            ObjectName objectName = this.configBeanToAMX(configBean);
            if (objectName == null) continue;
            objectNames.add(objectName);
        }
        return objectNames;
    }

    public void loadAll() throws ConfigException {
        this.loadDomainRoot();
        ConfigContext configContext = this.mDelegateFactory.getConfigContext();
        assert (configContext != null);
        ConfigBean domainConfigBean = configContext.exactLookup("/domain");
        assert (domainConfigBean != null);
        ArrayList<ConfigBean> configBeans = new ArrayList<ConfigBean>();
        this.addBeanHierarchy(configBeans, domainConfigBean);
        this.debug(this.configBeansToString(configBeans));
        List<ObjectName> objectNames = this.configBeansToAMX(configBeans);
        this.debug("loadAll: loaded " + objectNames.size() + "MBeans:");
        this.debug(CollectionUtil.toString(JMXUtil.objectNamesToStrings(objectNames), "\n"));
    }

    private void loadDomainRoot() {
        try {
            TypeInfo info = TypeInfos.getInstance().getInfo("X-DomainRoot");
            Class implClass = info.getImplClass();
            ObjectName objectName = this.mObjectNames.getDomainRootObjectName();
            Object impl = implClass.newInstance();
            this.mServer.registerMBean(impl, objectName);
        }
        catch (Exception e) {
            this.debug(ExceptionUtil.toString(e));
            throw new Error(e);
        }
    }

    public ObjectName loadSystemInfo(MBeanServer server) throws Exception {
        BootUtil bootUtil = BootUtil.getInstance();
        SystemInfoImpl systemInfo = new SystemInfoImpl(server, bootUtil);
        ObjectName tempName = this.mObjectNames.getSingletonObjectName("X-SystemInfo");
        ObjectName objectName = this.mServer.registerMBean(systemInfo, tempName).getObjectName();
        this.debug("loaded SystemInfo as " + objectName);
        return objectName;
    }

    private ProxyFactory getProxyFactory() {
        return ProxyFactory.getInstance(this.mServer);
    }

    public DomainRoot getDomainRoot() {
        return this.getProxyFactory().getDomainRoot();
    }
}

