/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.offline;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.management.offline.ConfigBeanHelper;
import com.sun.enterprise.management.offline.ConfigBeanHelperFactory;
import com.sun.enterprise.management.support.DelegateBase;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanInfo;

class ConfigDelegate
extends DelegateBase {
    private final ConfigBeanHelper mHelper;

    ConfigDelegate(ConfigContext configContext, String xPath) throws ConfigException {
        super("ConfigDelegate", null);
        this.mHelper = ConfigBeanHelperFactory.getInstance(configContext).getHelper(xPath);
    }

    ConfigDelegate(ConfigContext configContext, ConfigBean configBean) throws ConfigException {
        super("ConfigDelegate", null);
        this.mHelper = ConfigBeanHelperFactory.getInstance(configContext).getHelper(configBean);
    }

    public Object getAttribute(String attrName) throws AttributeNotFoundException {
        Object result = this.mHelper.getAttribute(attrName);
        return result;
    }

    public void setAttribute(Attribute attr) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.mHelper.setAttribute(attr);
        this.flush();
    }

    public MBeanInfo getMBeanInfo() {
        return this.mHelper.getMBeanInfo();
    }

    public AttributeList getProperties() {
        return this.mHelper.getProperties();
    }

    public String getPropertyValue(String name) {
        return this.mHelper.getPropertyValue(name);
    }

    public void setProperty(Attribute attr) {
        this.mHelper.setProperty(attr);
    }

    public AttributeList getSystemProperties() {
        return this.mHelper.getSystemProperties();
    }

    public String getSystemPropertyValue(String name) {
        return this.mHelper.getSystemPropertyValue(name);
    }

    public void setSystemProperty(Attribute attr) {
        this.mHelper.setSystemProperty(attr);
    }

    public String getDescription() {
        return this.mHelper.getDescription();
    }

    public void setDescription(String description) {
        this.mHelper.setDescription(description);
    }

    public final Object invoke(String operationName, Object[] args, String[] types) {
        int numArgs;
        Object result = null;
        int n = numArgs = args == null ? 0 : args.length;
        if ("getProperties".equals(operationName) && numArgs == 0) {
            result = this.getProperties();
        } else if ("getPropertyValue".equals(operationName) && numArgs == 1 && types[0].equals(String.class.getName())) {
            result = this.getPropertyValue((String)args[0]);
        } else if ("setProperty".equals(operationName) && numArgs == 1 && types[0].equals(Attribute.class.getName())) {
            this.setProperty((Attribute)args[0]);
        } else if ("getSystemProperties".equals(operationName) && numArgs == 0) {
            result = this.getSystemProperties();
        } else if ("getSystemPropertyValue".equals(operationName) && numArgs == 1 && types[0].equals(String.class.getName())) {
            result = this.getSystemPropertyValue((String)args[0]);
        } else if ("setSystemProperty".equals(operationName) && numArgs == 1 && types[0].equals(Attribute.class.getName())) {
            this.setSystemProperty((Attribute)args[0]);
        } else {
            result = this.mHelper.handleInvoke(operationName, args, types);
        }
        this.flush();
        return result;
    }

    private void flush() {
        try {
            this.mHelper.getConfigContext().flush();
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }
}

