/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.management.support.AMXImplBase;
import com.sun.enterprise.management.support.BootUtil;
import com.sun.enterprise.management.support.SystemInfoData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemInfoImpl
extends AMXImplBase
implements SystemInfo {
    private final MBeanServer mServer;
    private BootUtil mBootUtil;
    public static final String NAME_PROP_VALUE = "system-info";
    private final Map<String, Boolean> mFeatures;
    private static long LAST_REFRESH = 0L;
    private static final String[] FEATURE_NAMES = new String[]{"SupportsClusters", "SupportsMultipleServers", "RunningInDomainAdminServer"};

    private final boolean supportsClusters() {
        ObjectName serversObjectName = this.getOldServersMBeanObjectName();
        boolean supportsClusters = false;
        if (serversObjectName != null) {
            try {
                MBeanInfo info = this.mServer.getMBeanInfo(serversObjectName);
                String operationName = "listUnclusteredServerInstancesAsString";
                Set<MBeanFeatureInfo> operations = JMXUtil.findInfoByName(info.getOperations(), "listUnclusteredServerInstancesAsString");
                supportsClusters = operations.size() != 0;
            }
            catch (JMException e) {
                throw new RuntimeException("problem with 'servers' MBean: " + serversObjectName, e);
            }
        } else {
            supportsClusters = true;
        }
        return supportsClusters;
    }

    private void checkHADBAvailable() {
        boolean available = this.mServer.isRegistered(ObjectNames.getHADBConfigObjectName());
        this.mFeatures.put("HighAvailabilityDatabase", available);
    }

    private void _refresh() {
        this.checkHADBAvailable();
    }

    private void refresh() {
        long REFRESH_MILLIS = 5000L;
        long elapsed = System.currentTimeMillis() - LAST_REFRESH;
        if (elapsed > 5000L) {
            this._refresh();
        }
    }

    private ObjectName getOldServersMBeanObjectName() {
        ObjectName pattern = Util.newObjectName("com.sun.appserv", "category=config,type=servers");
        Set<ObjectName> serversSet = JMXUtil.queryNames(this.mServer, pattern, null);
        ObjectName objectName = serversSet.size() == 0 ? null : GSetUtil.getSingleton(serversSet);
        return objectName;
    }

    private boolean isRunningInDomainAdminServer() {
        return this.getOldServersMBeanObjectName() != null;
    }

    public SystemInfoImpl(MBeanServer server, BootUtil bootUtil) {
        this.mServer = server;
        this.mBootUtil = bootUtil;
        this.mFeatures = new HashMap<String, Boolean>();
        boolean supportsClusters = this.supportsClusters();
        this.mFeatures.put("SupportsClusters", supportsClusters);
        this.mFeatures.put("SupportsMultipleServers", supportsClusters);
        this.mFeatures.put("RunningInDomainAdminServer", this.isRunningInDomainAdminServer());
    }

    @Override
    public final String getGroup() {
        return "utility";
    }

    @Override
    public String[] getFeatureNames() {
        return (String[])FEATURE_NAMES.clone();
    }

    @Override
    public boolean supportsFeature(String key) {
        boolean supports = false;
        Boolean result = this.mFeatures.get(key);
        if (result == null) {
            result = Boolean.FALSE;
        }
        return result;
    }

    @Override
    public Map<String, Long> getPerformanceMillis() {
        HashMap<String, Long> result = new HashMap<String, Long>();
        result.putAll(SystemInfoData.getInstance().getPerformanceMillis());
        return result;
    }
}

