/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.support;

import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.util.misc.StringUtil;
import javax.management.ObjectName;

public final class WebModuleSupport {
    public static final String VIRTUAL_SERVER_PREFIX = "//";
    public static final String VIRTUAL_SERVER_DELIM = "/";
    public static final String JWS_APP_CLIENTS_WEB_MODULE_NAME = "//server/__JWSappclients";
    public static final String JWS_APP_CLIENTS_WEB_MODULE_MONITOR_NAME = "//server/sys";

    private WebModuleSupport() {
    }

    public static boolean isLegalVirtualServerName(String candidate) {
        return !candidate.startsWith(VIRTUAL_SERVER_PREFIX) && candidate.indexOf(VIRTUAL_SERVER_DELIM) < 0;
    }

    public static String formCompositeName(String virtualServerName, String webModuleName) {
        return VIRTUAL_SERVER_PREFIX + virtualServerName + VIRTUAL_SERVER_DELIM + webModuleName;
    }

    public static String extractVirtualServerName(String compositeName) {
        if (!compositeName.startsWith(VIRTUAL_SERVER_PREFIX)) {
            throw new IllegalArgumentException(compositeName);
        }
        String temp = StringUtil.stripPrefix(compositeName, VIRTUAL_SERVER_PREFIX);
        int delimIdx = temp.indexOf(VIRTUAL_SERVER_DELIM);
        if (delimIdx < 0) {
            throw new IllegalArgumentException(compositeName);
        }
        String virtualServerName = temp.substring(0, delimIdx);
        return virtualServerName;
    }

    public static String extractWebModuleName(String compositeName) {
        String virtualServerName = WebModuleSupport.extractVirtualServerName(compositeName);
        String prefix = VIRTUAL_SERVER_PREFIX + virtualServerName + VIRTUAL_SERVER_DELIM;
        String name = compositeName.substring(prefix.length(), compositeName.length());
        if (name.length() == 0) {
            name = virtualServerName + ".default";
        }
        return name;
    }

    public static String getWebModuleName(ObjectName oldObjectName) {
        String webModule = oldObjectName.getKeyProperty("web-module");
        String standaloneWebModule = oldObjectName.getKeyProperty("standalone-web-module");
        String webModuleName = null;
        if (standaloneWebModule != null) {
            webModuleName = WebModuleSupport.extractWebModuleName(standaloneWebModule);
        } else if (webModule != null) {
            webModuleName = WebModuleSupport.extractWebModuleName(webModule);
        } else {
            throw new IllegalArgumentException(JMXUtil.toString(oldObjectName));
        }
        return webModuleName;
    }
}

