// ==============================================================
//	This file is part of Glest (www.glest.org)
//
//	Copyright (C) 2001-2008 Martio Figueroa
//
//	You can redistribute this code and/or modify it under 
//	the terms of the GNU General Public License as published 
//	by the Free Software Foundation; either version 2 of the 
//	License, or (at your option) any later version
// ==============================================================

#ifndef _GLEST_GAME_CONSOLE_H_
#define _GLEST_GAME_CONSOLE_H_

#include <string>
#include <list>

using std::string;
using std::list;

namespace Glest{ namespace Game{

// =====================================================
// 	class Console
//
//	In-game console that shows various types of messages
// =====================================================

class Console{
private:
	static const int consoleLines= 5;

public:
	typedef list<string> LineContainer;
	typedef LineContainer::const_iterator LineIterator;

private:
	float timeElapsed; 
	LineContainer lines;

	//this should be deleted from here someday
	bool won, lost;

	//config
	int maxLines;
	float timeout;

public:
	Console();
	
	LineIterator getLineBegin() const	{return lines.begin();}
	LineIterator getLineEnd() const		{return lines.end();}

	void addStdMessage(const string &s);
	void addLine(string line);
	void update();
	bool isEmpty();
};

}}//end namespace

#endif
