/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Stream Management sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef _SYSCODECS_H_
#define _SYSCODECS_H_

#include <gpac/intern/m4_esm_dev.h>
#include <gpac/m4_bifs.h>

typedef struct 
{
	InlineScene *pScene;
	struct _m4_client *app;
	LPBIFSDEC codec;
	u32 PL;
} BIFSPriv;

DecoderInterface *NewBIFSCodec(u32 PL);
void BIFS_DeleteDec(DecoderInterface *plug);
M4Err BIFS_SetProperties(DecoderInterface *plug, InlineScene *scene, struct _m4_client *app, Bool is_anim);



typedef struct 
{
	u16 *ESIDs;
	u32 streamCount;
	LPODCODEC codec;
	InlineScene *scene;
	LPNETSERVICE parentService;
	u32 PL;
	struct _m4_client *app;
} M4ODPriv;

DecoderInterface *NewODSysCodec(u32 PL);
void ODS_Codec_Delete(DecoderInterface *plug);

M4Err ODS_SetProperties(DecoderInterface *plug, InlineScene *scene, struct _m4_client *app);

#endif //_SYSCODECS_H_

