/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Graph sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.	
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*FILE AUTOMATICALLY GENERATED BY SGGen - DO NOT MOFIFY*/


#include <gpac/intern/m4_scenegraph_dev.h>
#include <gpac/intern/m4_node_tables.h>


/*
	Anchor Node deletion
*/

static void Anchor_Del(SFNode *node)
{
	B_Anchor *p = (B_Anchor *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFString_Del(p->description);
	MFString_Del(p->parameter);
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 Anchor_Def2All[] = { 2, 3, 4, 5};
static const u16 Anchor_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 Anchor_Out2All[] = { 2, 3, 4, 5};

static u32 Anchor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err Anchor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Anchor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Anchor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Anchor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Anchor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Anchor *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Anchor *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Anchor *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Anchor *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Anchor *)node)->children;
		return M4OK;
	case 3:
		info->name = "description";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Anchor *) node)->description;
		return M4OK;
	case 4:
		info->name = "parameter";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Anchor *) node)->parameter;
		return M4OK;
	case 5:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Anchor *) node)->url;
		return M4OK;
	case 6:
		info->name = "activate";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Anchor *)node)->on_activate;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Anchor *) node)->activate;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Anchor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Anchor_Create()
{
	B_Anchor *p;
	SAFEALLOC(p, sizeof(B_Anchor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Anchor);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Anchor";
	((SFNode *)p)->sgprivate->node_del = Anchor_Del;
	((SFNode *)p)->sgprivate->get_field_count = Anchor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Anchor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Anchor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Anchor_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	AnimationStream Node deletion
*/

static void AnimationStream_Del(SFNode *node)
{
	B_AnimationStream *p = (B_AnimationStream *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 AnimationStream_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 AnimationStream_In2All[] = { 0, 1, 2, 3, 4};
static const u16 AnimationStream_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 AnimationStream_Dyn2All[] = { 1};

static u32 AnimationStream_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 7;
	case FCM_DYN: return 1;
	default:
		return 7;
	}
}

static M4Err AnimationStream_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AnimationStream_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AnimationStream_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AnimationStream_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AnimationStream_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AnimationStream_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AnimationStream *) node)->loop;
		return M4OK;
	case 1:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AnimationStream *) node)->speed;
		return M4OK;
	case 2:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AnimationStream *) node)->startTime;
		return M4OK;
	case 3:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AnimationStream *) node)->stopTime;
		return M4OK;
	case 4:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_AnimationStream *) node)->url;
		return M4OK;
	case 5:
		info->name = "duration_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AnimationStream *) node)->duration_changed;
		return M4OK;
	case 6:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AnimationStream *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AnimationStream_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *AnimationStream_Create()
{
	B_AnimationStream *p;
	SAFEALLOC(p, sizeof(B_AnimationStream));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AnimationStream);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AnimationStream";
	((SFNode *)p)->sgprivate->node_del = AnimationStream_Del;
	((SFNode *)p)->sgprivate->get_field_count = AnimationStream_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AnimationStream_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AnimationStream_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AnimationStream_get_aq_info;

#endif


	/*default field values*/
	p->speed = (SFFloat) 1.0;
	p->startTime = 0;
	p->stopTime = 0;
	return (SFNode *)p;
}


/*
	Appearance Node deletion
*/

static void Appearance_Del(SFNode *node)
{
	B_Appearance *p = (B_Appearance *) node;
	Node_Delete((SFNode *) p->material, (SFNode *) p);	
	Node_Delete((SFNode *) p->texture, (SFNode *) p);	
	Node_Delete((SFNode *) p->textureTransform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Appearance_Def2All[] = { 0, 1, 2};
static const u16 Appearance_In2All[] = { 0, 1, 2};
static const u16 Appearance_Out2All[] = { 0, 1, 2};

static u32 Appearance_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err Appearance_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Appearance_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Appearance_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Appearance_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Appearance_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "material";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFMaterialNode;
		info->far_ptr = & ((B_Appearance *)node)->material;
		return M4OK;
	case 1:
		info->name = "texture";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureNode;
		info->far_ptr = & ((B_Appearance *)node)->texture;
		return M4OK;
	case 2:
		info->name = "textureTransform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureTransformNode;
		info->far_ptr = & ((B_Appearance *)node)->textureTransform;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Appearance_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Appearance_Create()
{
	B_Appearance *p;
	SAFEALLOC(p, sizeof(B_Appearance));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Appearance);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Appearance";
	((SFNode *)p)->sgprivate->node_del = Appearance_Del;
	((SFNode *)p)->sgprivate->get_field_count = Appearance_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Appearance_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Appearance_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Appearance_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	AudioBuffer Node deletion
*/

static void AudioBuffer_Del(SFNode *node)
{
	B_AudioBuffer *p = (B_AudioBuffer *) node;
	NodeList_Delete((Chain *) p->children, (SFNode *) p);	
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioBuffer_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 AudioBuffer_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 AudioBuffer_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 AudioBuffer_Dyn2All[] = { 1};

static u32 AudioBuffer_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 8;
	case FCM_OUT: return 10;
	case FCM_DYN: return 1;
	default:
		return 10;
	}
}

static M4Err AudioBuffer_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioBuffer_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioBuffer_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioBuffer_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AudioBuffer_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioBuffer_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AudioBuffer *) node)->loop;
		return M4OK;
	case 1:
		info->name = "pitch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AudioBuffer *) node)->pitch;
		return M4OK;
	case 2:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioBuffer *) node)->startTime;
		return M4OK;
	case 3:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioBuffer *) node)->stopTime;
		return M4OK;
	case 4:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioBuffer *)node)->children;
		return M4OK;
	case 5:
		info->name = "numChan";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioBuffer *) node)->numChan;
		return M4OK;
	case 6:
		info->name = "phaseGroup";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioBuffer *) node)->phaseGroup;
		return M4OK;
	case 7:
		info->name = "length";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AudioBuffer *) node)->length;
		return M4OK;
	case 8:
		info->name = "duration_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioBuffer *) node)->duration_changed;
		return M4OK;
	case 9:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AudioBuffer *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioBuffer_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioBuffer_Create()
{
	B_AudioBuffer *p;
	SAFEALLOC(p, sizeof(B_AudioBuffer));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioBuffer);
	p->children = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioBuffer";
	((SFNode *)p)->sgprivate->node_del = AudioBuffer_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioBuffer_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioBuffer_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioBuffer_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioBuffer_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->pitch = (SFFloat) 1;
	p->startTime = 0;
	p->stopTime = 0;
	p->numChan = 1;
	p->phaseGroup.vals = malloc(sizeof(SFInt32)*1);
	p->phaseGroup.count = 1;
	p->phaseGroup.vals[0] = 1;
	p->length = (SFFloat) 0.0;
	return (SFNode *)p;
}


/*
	AudioClip Node deletion
*/

static void AudioClip_Del(SFNode *node)
{
	B_AudioClip *p = (B_AudioClip *) node;
	SFString_Del(p->description);
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioClip_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AudioClip_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AudioClip_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 AudioClip_Dyn2All[] = { 2};

static u32 AudioClip_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 8;
	case FCM_DYN: return 1;
	default:
		return 8;
	}
}

static M4Err AudioClip_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioClip_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioClip_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioClip_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AudioClip_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioClip_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "description";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_AudioClip *) node)->description;
		return M4OK;
	case 1:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AudioClip *) node)->loop;
		return M4OK;
	case 2:
		info->name = "pitch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AudioClip *) node)->pitch;
		return M4OK;
	case 3:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioClip *) node)->startTime;
		return M4OK;
	case 4:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioClip *) node)->stopTime;
		return M4OK;
	case 5:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_AudioClip *) node)->url;
		return M4OK;
	case 6:
		info->name = "duration_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioClip *) node)->duration_changed;
		return M4OK;
	case 7:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_AudioClip *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioClip_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioClip_Create()
{
	B_AudioClip *p;
	SAFEALLOC(p, sizeof(B_AudioClip));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioClip);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioClip";
	((SFNode *)p)->sgprivate->node_del = AudioClip_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioClip_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioClip_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioClip_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioClip_get_aq_info;

#endif


	/*default field values*/
	p->pitch = (SFFloat) 1.0;
	p->startTime = 0;
	p->stopTime = 0;
	return (SFNode *)p;
}


/*
	AudioDelay Node deletion
*/

static void AudioDelay_Del(SFNode *node)
{
	B_AudioDelay *p = (B_AudioDelay *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioDelay_Def2All[] = { 2, 3, 4, 5};
static const u16 AudioDelay_In2All[] = { 0, 1, 2, 3};
static const u16 AudioDelay_Out2All[] = { 2, 3};

static u32 AudioDelay_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err AudioDelay_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioDelay_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioDelay_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioDelay_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioDelay_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioDelay *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioDelay *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioDelay *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioDelay *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioDelay *)node)->children;
		return M4OK;
	case 3:
		info->name = "delay";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioDelay *) node)->delay;
		return M4OK;
	case 4:
		info->name = "numChan";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioDelay *) node)->numChan;
		return M4OK;
	case 5:
		info->name = "phaseGroup";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioDelay *) node)->phaseGroup;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioDelay_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioDelay_Create()
{
	B_AudioDelay *p;
	SAFEALLOC(p, sizeof(B_AudioDelay));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioDelay);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioDelay";
	((SFNode *)p)->sgprivate->node_del = AudioDelay_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioDelay_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioDelay_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioDelay_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioDelay_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->delay = 0;
	p->numChan = 1;
	return (SFNode *)p;
}


/*
	AudioFX Node deletion
*/

static void AudioFX_Del(SFNode *node)
{
	B_AudioFX *p = (B_AudioFX *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFString_Del(p->orch);
	SFString_Del(p->score);
	MFFloat_Del(p->params);
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioFX_Def2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 AudioFX_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AudioFX_Out2All[] = { 2, 3, 4, 5};
static const u16 AudioFX_Dyn2All[] = { 5};

static u32 AudioFX_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 4;
	case FCM_DYN: return 1;
	default:
		return 8;
	}
}

static M4Err AudioFX_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioFX_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioFX_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioFX_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AudioFX_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioFX_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioFX *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioFX *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioFX *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioFX *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioFX *)node)->children;
		return M4OK;
	case 3:
		info->name = "orch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_AudioFX *) node)->orch;
		return M4OK;
	case 4:
		info->name = "score";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_AudioFX *) node)->score;
		return M4OK;
	case 5:
		info->name = "params";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AudioFX *) node)->params;
		return M4OK;
	case 6:
		info->name = "numChan";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioFX *) node)->numChan;
		return M4OK;
	case 7:
		info->name = "phaseGroup";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioFX *) node)->phaseGroup;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioFX_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 5:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 7:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioFX_Create()
{
	B_AudioFX *p;
	SAFEALLOC(p, sizeof(B_AudioFX));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioFX);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioFX";
	((SFNode *)p)->sgprivate->node_del = AudioFX_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioFX_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioFX_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioFX_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioFX_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->numChan = 1;
	return (SFNode *)p;
}


/*
	AudioMix Node deletion
*/

static void AudioMix_Del(SFNode *node)
{
	B_AudioMix *p = (B_AudioMix *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFFloat_Del(p->matrix);
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioMix_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 AudioMix_In2All[] = { 0, 1, 2, 3, 4};
static const u16 AudioMix_Out2All[] = { 2, 3, 4};
static const u16 AudioMix_Dyn2All[] = { 4};

static u32 AudioMix_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 3;
	case FCM_DYN: return 1;
	default:
		return 7;
	}
}

static M4Err AudioMix_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioMix_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioMix_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioMix_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AudioMix_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioMix_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioMix *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioMix *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioMix *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioMix *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioMix *)node)->children;
		return M4OK;
	case 3:
		info->name = "numInputs";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioMix *) node)->numInputs;
		return M4OK;
	case 4:
		info->name = "matrix";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AudioMix *) node)->matrix;
		return M4OK;
	case 5:
		info->name = "numChan";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioMix *) node)->numChan;
		return M4OK;
	case 6:
		info->name = "phaseGroup";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioMix *) node)->phaseGroup;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioMix_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 1;
		*b_max = (Float) 255;
		return 1;
	case 4:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 6:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioMix_Create()
{
	B_AudioMix *p;
	SAFEALLOC(p, sizeof(B_AudioMix));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioMix);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioMix";
	((SFNode *)p)->sgprivate->node_del = AudioMix_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioMix_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioMix_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioMix_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioMix_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->numInputs = 1;
	p->numChan = 1;
	return (SFNode *)p;
}


/*
	AudioSource Node deletion
*/

static void AudioSource_Del(SFNode *node)
{
	B_AudioSource *p = (B_AudioSource *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFURL_Del(p->url);
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioSource_Def2All[] = { 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 AudioSource_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 AudioSource_Out2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 AudioSource_Dyn2All[] = { 4, 5};

static u32 AudioSource_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 8;
	case FCM_OUT: return 6;
	case FCM_DYN: return 2;
	default:
		return 10;
	}
}

static M4Err AudioSource_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioSource_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioSource_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioSource_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AudioSource_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioSource_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioSource *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSource *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioSource *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSource *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSource *)node)->children;
		return M4OK;
	case 3:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_AudioSource *) node)->url;
		return M4OK;
	case 4:
		info->name = "pitch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AudioSource *) node)->pitch;
		return M4OK;
	case 5:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AudioSource *) node)->speed;
		return M4OK;
	case 6:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioSource *) node)->startTime;
		return M4OK;
	case 7:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AudioSource *) node)->stopTime;
		return M4OK;
	case 8:
		info->name = "numChan";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioSource *) node)->numChan;
		return M4OK;
	case 9:
		info->name = "phaseGroup";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioSource *) node)->phaseGroup;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioSource_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 9:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioSource_Create()
{
	B_AudioSource *p;
	SAFEALLOC(p, sizeof(B_AudioSource));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioSource);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioSource";
	((SFNode *)p)->sgprivate->node_del = AudioSource_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioSource_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioSource_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioSource_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioSource_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->pitch = (SFFloat) 1;
	p->speed = (SFFloat) 1;
	p->startTime = 0;
	p->stopTime = 0;
	p->numChan = 1;
	return (SFNode *)p;
}


/*
	AudioSwitch Node deletion
*/

static void AudioSwitch_Del(SFNode *node)
{
	B_AudioSwitch *p = (B_AudioSwitch *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFInt32_Del(p->whichChoice);
	MFInt32_Del(p->phaseGroup);
	SFNode_Delete((SFNode *) p);
}

static const u16 AudioSwitch_Def2All[] = { 2, 3, 4, 5};
static const u16 AudioSwitch_In2All[] = { 0, 1, 2, 3};
static const u16 AudioSwitch_Out2All[] = { 2, 3};

static u32 AudioSwitch_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err AudioSwitch_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AudioSwitch_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AudioSwitch_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AudioSwitch_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AudioSwitch_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioSwitch *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSwitch *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_AudioSwitch *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSwitch *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_AudioSwitch *)node)->children;
		return M4OK;
	case 3:
		info->name = "whichChoice";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioSwitch *) node)->whichChoice;
		return M4OK;
	case 4:
		info->name = "numChan";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_AudioSwitch *) node)->numChan;
		return M4OK;
	case 5:
		info->name = "phaseGroup";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_AudioSwitch *) node)->phaseGroup;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AudioSwitch_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 1;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 255;
		return 1;
	default:
		return 0;
	}
}



SFNode *AudioSwitch_Create()
{
	B_AudioSwitch *p;
	SAFEALLOC(p, sizeof(B_AudioSwitch));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AudioSwitch);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AudioSwitch";
	((SFNode *)p)->sgprivate->node_del = AudioSwitch_Del;
	((SFNode *)p)->sgprivate->get_field_count = AudioSwitch_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AudioSwitch_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AudioSwitch_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AudioSwitch_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFAudioNode;

#endif


	/*default field values*/
	p->numChan = 1;
	return (SFNode *)p;
}


/*
	Background Node deletion
*/

static void Background_Del(SFNode *node)
{
	B_Background *p = (B_Background *) node;
	MFFloat_Del(p->groundAngle);
	MFColor_Del(p->groundColor);
	MFURL_Del(p->backUrl);
	MFURL_Del(p->bottomUrl);
	MFURL_Del(p->frontUrl);
	MFURL_Del(p->leftUrl);
	MFURL_Del(p->rightUrl);
	MFURL_Del(p->topUrl);
	MFFloat_Del(p->skyAngle);
	MFColor_Del(p->skyColor);
	SFNode_Delete((SFNode *) p);
}

static const u16 Background_Def2All[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
static const u16 Background_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
static const u16 Background_Out2All[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
static const u16 Background_Dyn2All[] = { 1, 2, 9, 10};

static u32 Background_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 11;
	case FCM_DEF: return 10;
	case FCM_OUT: return 11;
	case FCM_DYN: return 4;
	default:
		return 12;
	}
}

static M4Err Background_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Background_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Background_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Background_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Background_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Background_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Background *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Background *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "groundAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_Background *) node)->groundAngle;
		return M4OK;
	case 2:
		info->name = "groundColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_Background *) node)->groundColor;
		return M4OK;
	case 3:
		info->name = "backUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->backUrl;
		return M4OK;
	case 4:
		info->name = "bottomUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->bottomUrl;
		return M4OK;
	case 5:
		info->name = "frontUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->frontUrl;
		return M4OK;
	case 6:
		info->name = "leftUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->leftUrl;
		return M4OK;
	case 7:
		info->name = "rightUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->rightUrl;
		return M4OK;
	case 8:
		info->name = "topUrl";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background *) node)->topUrl;
		return M4OK;
	case 9:
		info->name = "skyAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_Background *) node)->skyAngle;
		return M4OK;
	case 10:
		info->name = "skyColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_Background *) node)->skyColor;
		return M4OK;
	case 11:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Background *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Background_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 8;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 1.5707963;
		return 1;
	case 2:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 9:
		*AType = 8;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 3.14159265;
		return 1;
	case 10:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Background_Create()
{
	B_Background *p;
	SAFEALLOC(p, sizeof(B_Background));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Background);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Background";
	((SFNode *)p)->sgprivate->node_del = Background_Del;
	((SFNode *)p)->sgprivate->get_field_count = Background_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Background_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Background_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Background_get_aq_info;

#endif


	/*default field values*/
	p->skyColor.vals = malloc(sizeof(SFColor)*1);
	p->skyColor.count = 1;
	p->skyColor.vals[0].red = (SFFloat) 0;
	p->skyColor.vals[0].green = (SFFloat) 0;
	p->skyColor.vals[0].blue = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Background2D Node deletion
*/

static void Background2D_Del(SFNode *node)
{
	B_Background2D *p = (B_Background2D *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 Background2D_Def2All[] = { 1, 2};
static const u16 Background2D_In2All[] = { 0, 1, 2};
static const u16 Background2D_Out2All[] = { 1, 2, 3};
static const u16 Background2D_Dyn2All[] = { 1};

static u32 Background2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 1;
	default:
		return 4;
	}
}

static M4Err Background2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Background2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Background2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Background2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Background2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Background2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Background2D *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Background2D *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "backColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Background2D *) node)->backColor;
		return M4OK;
	case 2:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Background2D *) node)->url;
		return M4OK;
	case 3:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Background2D *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Background2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Background2D_Create()
{
	B_Background2D *p;
	SAFEALLOC(p, sizeof(B_Background2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Background2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Background2D";
	((SFNode *)p)->sgprivate->node_del = Background2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Background2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Background2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Background2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Background2D_get_aq_info;

#endif


	/*default field values*/
	p->backColor.red = (SFFloat) 0;
	p->backColor.green = (SFFloat) 0;
	p->backColor.blue = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Billboard Node deletion
*/

static void Billboard_Del(SFNode *node)
{
	B_Billboard *p = (B_Billboard *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Billboard_Def2All[] = { 2, 3};
static const u16 Billboard_In2All[] = { 0, 1, 2, 3};
static const u16 Billboard_Out2All[] = { 2, 3};
static const u16 Billboard_Dyn2All[] = { 3};

static u32 Billboard_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 1;
	default:
		return 4;
	}
}

static M4Err Billboard_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Billboard_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Billboard_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Billboard_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Billboard_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Billboard_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Billboard *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Billboard *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Billboard *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Billboard *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Billboard *)node)->children;
		return M4OK;
	case 3:
		info->name = "axisOfRotation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Billboard *) node)->axisOfRotation;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Billboard_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 9;
		*QType = 9;
		return 1;
	default:
		return 0;
	}
}



SFNode *Billboard_Create()
{
	B_Billboard *p;
	SAFEALLOC(p, sizeof(B_Billboard));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Billboard);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Billboard";
	((SFNode *)p)->sgprivate->node_del = Billboard_Del;
	((SFNode *)p)->sgprivate->get_field_count = Billboard_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Billboard_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Billboard_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Billboard_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->axisOfRotation.x = (SFFloat) 0;
	p->axisOfRotation.y = (SFFloat) 1;
	p->axisOfRotation.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Bitmap Node deletion
*/

static void Bitmap_Del(SFNode *node)
{
	B_Bitmap *p = (B_Bitmap *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Bitmap_Def2All[] = { 0};
static const u16 Bitmap_In2All[] = { 0};
static const u16 Bitmap_Out2All[] = { 0};
static const u16 Bitmap_Dyn2All[] = { 0};

static u32 Bitmap_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Bitmap_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Bitmap_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Bitmap_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Bitmap_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Bitmap_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Bitmap_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "scale";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Bitmap *) node)->scale;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Bitmap_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 12;
		*QType = 12;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Bitmap_Create()
{
	B_Bitmap *p;
	SAFEALLOC(p, sizeof(B_Bitmap));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Bitmap);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Bitmap";
	((SFNode *)p)->sgprivate->node_del = Bitmap_Del;
	((SFNode *)p)->sgprivate->get_field_count = Bitmap_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Bitmap_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Bitmap_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Bitmap_get_aq_info;

#endif


	/*default field values*/
	p->scale.x = (SFFloat) -1;
	p->scale.y = (SFFloat) -1;
	return (SFNode *)p;
}


/*
	Box Node deletion
*/

static void Box_Del(SFNode *node)
{
	B_Box *p = (B_Box *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Box_Def2All[] = { 0};

static u32 Box_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 1;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 1;
	}
}

static M4Err Box_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = Box_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Box_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "size";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Box *) node)->size;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Box_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Box_Create()
{
	B_Box *p;
	SAFEALLOC(p, sizeof(B_Box));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Box);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Box";
	((SFNode *)p)->sgprivate->node_del = Box_Del;
	((SFNode *)p)->sgprivate->get_field_count = Box_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Box_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Box_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Box_get_aq_info;

#endif


	/*default field values*/
	p->size.x = (SFFloat) 2;
	p->size.y = (SFFloat) 2;
	p->size.z = (SFFloat) 2;
	return (SFNode *)p;
}


/*
	Circle Node deletion
*/

static void Circle_Del(SFNode *node)
{
	B_Circle *p = (B_Circle *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Circle_Def2All[] = { 0};
static const u16 Circle_In2All[] = { 0};
static const u16 Circle_Out2All[] = { 0};
static const u16 Circle_Dyn2All[] = { 0};

static u32 Circle_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Circle_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Circle_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Circle_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Circle_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Circle_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Circle_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "radius";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Circle *) node)->radius;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Circle_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Circle_Create()
{
	B_Circle *p;
	SAFEALLOC(p, sizeof(B_Circle));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Circle);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Circle";
	((SFNode *)p)->sgprivate->node_del = Circle_Del;
	((SFNode *)p)->sgprivate->get_field_count = Circle_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Circle_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Circle_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Circle_get_aq_info;

#endif


	/*default field values*/
	p->radius = (SFFloat) 1;
	return (SFNode *)p;
}


/*
	Collision Node deletion
*/

static void Collision_Del(SFNode *node)
{
	B_Collision *p = (B_Collision *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->proxy, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Collision_Def2All[] = { 2, 3, 4};
static const u16 Collision_In2All[] = { 0, 1, 2, 3};
static const u16 Collision_Out2All[] = { 2, 3, 5};

static u32 Collision_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err Collision_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Collision_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Collision_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Collision_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Collision_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Collision *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Collision *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Collision *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Collision *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Collision *)node)->children;
		return M4OK;
	case 3:
		info->name = "collide";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Collision *) node)->collide;
		return M4OK;
	case 4:
		info->name = "proxy";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Collision *)node)->proxy;
		return M4OK;
	case 5:
		info->name = "collideTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_Collision *) node)->collideTime;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Collision_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Collision_Create()
{
	B_Collision *p;
	SAFEALLOC(p, sizeof(B_Collision));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Collision);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Collision";
	((SFNode *)p)->sgprivate->node_del = Collision_Del;
	((SFNode *)p)->sgprivate->get_field_count = Collision_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Collision_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Collision_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Collision_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->collide = 1;
	return (SFNode *)p;
}


/*
	Color Node deletion
*/

static void Color_Del(SFNode *node)
{
	B_Color *p = (B_Color *) node;
	MFColor_Del(p->color);
	SFNode_Delete((SFNode *) p);
}

static const u16 Color_Def2All[] = { 0};
static const u16 Color_In2All[] = { 0};
static const u16 Color_Out2All[] = { 0};
static const u16 Color_Dyn2All[] = { 0};

static u32 Color_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Color_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Color_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Color_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Color_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Color_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Color_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_Color *) node)->color;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Color_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Color_Create()
{
	B_Color *p;
	SAFEALLOC(p, sizeof(B_Color));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Color);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Color";
	((SFNode *)p)->sgprivate->node_del = Color_Del;
	((SFNode *)p)->sgprivate->get_field_count = Color_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Color_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Color_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Color_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	ColorInterpolator Node deletion
*/

static void ColorInterpolator_Del(SFNode *node)
{
	B_ColorInterpolator *p = (B_ColorInterpolator *) node;
	MFFloat_Del(p->key);
	MFColor_Del(p->keyValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 ColorInterpolator_Def2All[] = { 1, 2};
static const u16 ColorInterpolator_In2All[] = { 0, 1, 2};
static const u16 ColorInterpolator_Out2All[] = { 1, 2, 3};

static u32 ColorInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err ColorInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ColorInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ColorInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ColorInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ColorInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ColorInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_ColorInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_ColorInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_ColorInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ColorInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *ColorInterpolator_Create()
{
	B_ColorInterpolator *p;
	SAFEALLOC(p, sizeof(B_ColorInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ColorInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ColorInterpolator";
	((SFNode *)p)->sgprivate->node_del = ColorInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = ColorInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ColorInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ColorInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ColorInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	CompositeTexture2D Node deletion
*/

static void CompositeTexture2D_Del(SFNode *node)
{
	B_CompositeTexture2D *p = (B_CompositeTexture2D *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->background, (SFNode *) p);	
	Node_Delete((SFNode *) p->viewport, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 CompositeTexture2D_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 CompositeTexture2D_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 CompositeTexture2D_Out2All[] = { 2, 3, 4, 5, 6};

static u32 CompositeTexture2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 5;
	case FCM_OUT: return 5;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err CompositeTexture2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = CompositeTexture2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = CompositeTexture2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = CompositeTexture2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err CompositeTexture2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CompositeTexture2D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_CompositeTexture2D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CompositeTexture2D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_CompositeTexture2D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_CompositeTexture2D *)node)->children;
		return M4OK;
	case 3:
		info->name = "pixelWidth";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_CompositeTexture2D *) node)->pixelWidth;
		return M4OK;
	case 4:
		info->name = "pixelHeight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_CompositeTexture2D *) node)->pixelHeight;
		return M4OK;
	case 5:
		info->name = "background";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBackground2DNode;
		info->far_ptr = & ((B_CompositeTexture2D *)node)->background;
		return M4OK;
	case 6:
		info->name = "viewport";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFViewportNode;
		info->far_ptr = & ((B_CompositeTexture2D *)node)->viewport;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool CompositeTexture2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	default:
		return 0;
	}
}



SFNode *CompositeTexture2D_Create()
{
	B_CompositeTexture2D *p;
	SAFEALLOC(p, sizeof(B_CompositeTexture2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_CompositeTexture2D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "CompositeTexture2D";
	((SFNode *)p)->sgprivate->node_del = CompositeTexture2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = CompositeTexture2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = CompositeTexture2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = CompositeTexture2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = CompositeTexture2D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->pixelWidth = -1;
	p->pixelHeight = -1;
	return (SFNode *)p;
}


/*
	CompositeTexture3D Node deletion
*/

static void CompositeTexture3D_Del(SFNode *node)
{
	B_CompositeTexture3D *p = (B_CompositeTexture3D *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->background, (SFNode *) p);	
	Node_Delete((SFNode *) p->fog, (SFNode *) p);	
	Node_Delete((SFNode *) p->navigationInfo, (SFNode *) p);	
	Node_Delete((SFNode *) p->viewpoint, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 CompositeTexture3D_Def2All[] = { 2, 3, 4, 5, 6, 7, 8};
static const u16 CompositeTexture3D_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 CompositeTexture3D_Out2All[] = { 2, 3, 4, 5, 6, 7, 8};

static u32 CompositeTexture3D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err CompositeTexture3D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = CompositeTexture3D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = CompositeTexture3D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = CompositeTexture3D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err CompositeTexture3D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CompositeTexture3D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CompositeTexture3D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->children;
		return M4OK;
	case 3:
		info->name = "pixelWidth";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_CompositeTexture3D *) node)->pixelWidth;
		return M4OK;
	case 4:
		info->name = "pixelHeight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_CompositeTexture3D *) node)->pixelHeight;
		return M4OK;
	case 5:
		info->name = "background";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBackground3DNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->background;
		return M4OK;
	case 6:
		info->name = "fog";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFogNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->fog;
		return M4OK;
	case 7:
		info->name = "navigationInfo";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFNavigationInfoNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->navigationInfo;
		return M4OK;
	case 8:
		info->name = "viewpoint";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFViewpointNode;
		info->far_ptr = & ((B_CompositeTexture3D *)node)->viewpoint;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool CompositeTexture3D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	default:
		return 0;
	}
}



SFNode *CompositeTexture3D_Create()
{
	B_CompositeTexture3D *p;
	SAFEALLOC(p, sizeof(B_CompositeTexture3D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_CompositeTexture3D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "CompositeTexture3D";
	((SFNode *)p)->sgprivate->node_del = CompositeTexture3D_Del;
	((SFNode *)p)->sgprivate->get_field_count = CompositeTexture3D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = CompositeTexture3D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = CompositeTexture3D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = CompositeTexture3D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->pixelWidth = -1;
	p->pixelHeight = -1;
	return (SFNode *)p;
}


/*
	Conditional Node deletion
*/

static void Conditional_Del(SFNode *node)
{
	B_Conditional *p = (B_Conditional *) node;
	SFCommandBuffer_Del(p->buffer);
	SFNode_Delete((SFNode *) p);
}

static const u16 Conditional_Def2All[] = { 2};
static const u16 Conditional_In2All[] = { 0, 1, 2};
static const u16 Conditional_Out2All[] = { 2, 3};

static u32 Conditional_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 1;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err Conditional_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Conditional_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Conditional_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Conditional_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Conditional_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "activate";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Conditional *)node)->on_activate;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Conditional *) node)->activate;
		return M4OK;
	case 1:
		info->name = "reverseActivate";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Conditional *)node)->on_reverseActivate;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Conditional *) node)->reverseActivate;
		return M4OK;
	case 2:
		info->name = "buffer";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFCommandBuffer;
		info->far_ptr = & ((B_Conditional *) node)->buffer;
		return M4OK;
	case 3:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Conditional *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Conditional_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Conditional_Create()
{
	B_Conditional *p;
	SAFEALLOC(p, sizeof(B_Conditional));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Conditional);
	p->buffer.commandList = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Conditional";
	((SFNode *)p)->sgprivate->node_del = Conditional_Del;
	((SFNode *)p)->sgprivate->get_field_count = Conditional_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Conditional_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Conditional_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Conditional_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Cone Node deletion
*/

static void Cone_Del(SFNode *node)
{
	B_Cone *p = (B_Cone *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Cone_Def2All[] = { 0, 1, 2, 3};

static u32 Cone_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 4;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err Cone_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = Cone_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Cone_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bottomRadius";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Cone *) node)->bottomRadius;
		return M4OK;
	case 1:
		info->name = "height";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Cone *) node)->height;
		return M4OK;
	case 2:
		info->name = "side";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Cone *) node)->side;
		return M4OK;
	case 3:
		info->name = "bottom";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Cone *) node)->bottom;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Cone_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Cone_Create()
{
	B_Cone *p;
	SAFEALLOC(p, sizeof(B_Cone));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Cone);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Cone";
	((SFNode *)p)->sgprivate->node_del = Cone_Del;
	((SFNode *)p)->sgprivate->get_field_count = Cone_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Cone_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Cone_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Cone_get_aq_info;

#endif


	/*default field values*/
	p->bottomRadius = (SFFloat) 1;
	p->height = (SFFloat) 2;
	p->side = 1;
	p->bottom = 1;
	return (SFNode *)p;
}


/*
	Coordinate Node deletion
*/

static void Coordinate_Del(SFNode *node)
{
	B_Coordinate *p = (B_Coordinate *) node;
	MFVec3f_Del(p->point);
	SFNode_Delete((SFNode *) p);
}

static const u16 Coordinate_Def2All[] = { 0};
static const u16 Coordinate_In2All[] = { 0};
static const u16 Coordinate_Out2All[] = { 0};
static const u16 Coordinate_Dyn2All[] = { 0};

static u32 Coordinate_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Coordinate_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Coordinate_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Coordinate_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Coordinate_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Coordinate_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Coordinate_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "point";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Coordinate *) node)->point;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Coordinate_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Coordinate_Create()
{
	B_Coordinate *p;
	SAFEALLOC(p, sizeof(B_Coordinate));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Coordinate);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Coordinate";
	((SFNode *)p)->sgprivate->node_del = Coordinate_Del;
	((SFNode *)p)->sgprivate->get_field_count = Coordinate_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Coordinate_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Coordinate_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Coordinate_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Coordinate2D Node deletion
*/

static void Coordinate2D_Del(SFNode *node)
{
	B_Coordinate2D *p = (B_Coordinate2D *) node;
	MFVec2f_Del(p->point);
	SFNode_Delete((SFNode *) p);
}

static const u16 Coordinate2D_Def2All[] = { 0};
static const u16 Coordinate2D_In2All[] = { 0};
static const u16 Coordinate2D_Out2All[] = { 0};
static const u16 Coordinate2D_Dyn2All[] = { 0};

static u32 Coordinate2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Coordinate2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Coordinate2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Coordinate2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Coordinate2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Coordinate2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Coordinate2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "point";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Coordinate2D *) node)->point;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Coordinate2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Coordinate2D_Create()
{
	B_Coordinate2D *p;
	SAFEALLOC(p, sizeof(B_Coordinate2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Coordinate2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Coordinate2D";
	((SFNode *)p)->sgprivate->node_del = Coordinate2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Coordinate2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Coordinate2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Coordinate2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Coordinate2D_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	CoordinateInterpolator Node deletion
*/

static void CoordinateInterpolator_Del(SFNode *node)
{
	B_CoordinateInterpolator *p = (B_CoordinateInterpolator *) node;
	MFFloat_Del(p->key);
	MFVec3f_Del(p->keyValue);
	MFVec3f_Del(p->value_changed);
	SFNode_Delete((SFNode *) p);
}

static const u16 CoordinateInterpolator_Def2All[] = { 1, 2};
static const u16 CoordinateInterpolator_In2All[] = { 0, 1, 2};
static const u16 CoordinateInterpolator_Out2All[] = { 1, 2, 3};

static u32 CoordinateInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err CoordinateInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = CoordinateInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = CoordinateInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = CoordinateInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err CoordinateInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CoordinateInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CoordinateInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_CoordinateInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_CoordinateInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_CoordinateInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool CoordinateInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *CoordinateInterpolator_Create()
{
	B_CoordinateInterpolator *p;
	SAFEALLOC(p, sizeof(B_CoordinateInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_CoordinateInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "CoordinateInterpolator";
	((SFNode *)p)->sgprivate->node_del = CoordinateInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = CoordinateInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = CoordinateInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = CoordinateInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = CoordinateInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	CoordinateInterpolator2D Node deletion
*/

static void CoordinateInterpolator2D_Del(SFNode *node)
{
	B_CoordinateInterpolator2D *p = (B_CoordinateInterpolator2D *) node;
	MFFloat_Del(p->key);
	MFVec2f_Del(p->keyValue);
	MFVec2f_Del(p->value_changed);
	SFNode_Delete((SFNode *) p);
}

static const u16 CoordinateInterpolator2D_Def2All[] = { 1, 2};
static const u16 CoordinateInterpolator2D_In2All[] = { 0, 1, 2};
static const u16 CoordinateInterpolator2D_Out2All[] = { 1, 2, 3};

static u32 CoordinateInterpolator2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err CoordinateInterpolator2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = CoordinateInterpolator2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = CoordinateInterpolator2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = CoordinateInterpolator2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err CoordinateInterpolator2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_CoordinateInterpolator2D *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CoordinateInterpolator2D *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_CoordinateInterpolator2D *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_CoordinateInterpolator2D *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_CoordinateInterpolator2D *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool CoordinateInterpolator2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *CoordinateInterpolator2D_Create()
{
	B_CoordinateInterpolator2D *p;
	SAFEALLOC(p, sizeof(B_CoordinateInterpolator2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_CoordinateInterpolator2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "CoordinateInterpolator2D";
	((SFNode *)p)->sgprivate->node_del = CoordinateInterpolator2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = CoordinateInterpolator2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = CoordinateInterpolator2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = CoordinateInterpolator2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = CoordinateInterpolator2D_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Curve2D Node deletion
*/

static void Curve2D_Del(SFNode *node)
{
	B_Curve2D *p = (B_Curve2D *) node;
	Node_Delete((SFNode *) p->point, (SFNode *) p);	
	MFInt32_Del(p->type);
	SFNode_Delete((SFNode *) p);
}

static const u16 Curve2D_Def2All[] = { 0, 1, 2};
static const u16 Curve2D_In2All[] = { 0, 1, 2};
static const u16 Curve2D_Out2All[] = { 0, 1, 2};
static const u16 Curve2D_Dyn2All[] = { 1};

static u32 Curve2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 1;
	default:
		return 3;
	}
}

static M4Err Curve2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Curve2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Curve2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Curve2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Curve2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Curve2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "point";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinate2DNode;
		info->far_ptr = & ((B_Curve2D *)node)->point;
		return M4OK;
	case 1:
		info->name = "fineness";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Curve2D *) node)->fineness;
		return M4OK;
	case 2:
		info->name = "type";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Curve2D *) node)->type;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Curve2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) 0;
		*b_max = (Float) 3;
		return 1;
	default:
		return 0;
	}
}



SFNode *Curve2D_Create()
{
	B_Curve2D *p;
	SAFEALLOC(p, sizeof(B_Curve2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Curve2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Curve2D";
	((SFNode *)p)->sgprivate->node_del = Curve2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Curve2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Curve2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Curve2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Curve2D_get_aq_info;

#endif


	/*default field values*/
	p->fineness = (SFFloat) 0.5;
	return (SFNode *)p;
}


/*
	Cylinder Node deletion
*/

static void Cylinder_Del(SFNode *node)
{
	B_Cylinder *p = (B_Cylinder *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Cylinder_Def2All[] = { 0, 1, 2, 3, 4};

static u32 Cylinder_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 5;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 5;
	}
}

static M4Err Cylinder_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = Cylinder_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Cylinder_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bottom";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Cylinder *) node)->bottom;
		return M4OK;
	case 1:
		info->name = "height";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Cylinder *) node)->height;
		return M4OK;
	case 2:
		info->name = "radius";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Cylinder *) node)->radius;
		return M4OK;
	case 3:
		info->name = "side";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Cylinder *) node)->side;
		return M4OK;
	case 4:
		info->name = "top";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Cylinder *) node)->top;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Cylinder_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Cylinder_Create()
{
	B_Cylinder *p;
	SAFEALLOC(p, sizeof(B_Cylinder));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Cylinder);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Cylinder";
	((SFNode *)p)->sgprivate->node_del = Cylinder_Del;
	((SFNode *)p)->sgprivate->get_field_count = Cylinder_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Cylinder_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Cylinder_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Cylinder_get_aq_info;

#endif


	/*default field values*/
	p->bottom = 1;
	p->height = (SFFloat) 2;
	p->radius = (SFFloat) 1;
	p->side = 1;
	p->top = 1;
	return (SFNode *)p;
}


/*
	CylinderSensor Node deletion
*/

static void CylinderSensor_Del(SFNode *node)
{
	B_CylinderSensor *p = (B_CylinderSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 CylinderSensor_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 CylinderSensor_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 CylinderSensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};

static u32 CylinderSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 9;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err CylinderSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = CylinderSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = CylinderSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = CylinderSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err CylinderSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "autoOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_CylinderSensor *) node)->autoOffset;
		return M4OK;
	case 1:
		info->name = "diskAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CylinderSensor *) node)->diskAngle;
		return M4OK;
	case 2:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_CylinderSensor *) node)->enabled;
		return M4OK;
	case 3:
		info->name = "maxAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CylinderSensor *) node)->maxAngle;
		return M4OK;
	case 4:
		info->name = "minAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CylinderSensor *) node)->minAngle;
		return M4OK;
	case 5:
		info->name = "offset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_CylinderSensor *) node)->offset;
		return M4OK;
	case 6:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_CylinderSensor *) node)->isActive;
		return M4OK;
	case 7:
		info->name = "rotation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_CylinderSensor *) node)->rotation_changed;
		return M4OK;
	case 8:
		info->name = "trackPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_CylinderSensor *) node)->trackPoint_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool CylinderSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 1.5707963;
		return 1;
	case 3:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) -6.2831853;
		*b_max = (Float) 6.2831853;
		return 1;
	case 4:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) -6.2831853;
		*b_max = (Float) 6.2831853;
		return 1;
	case 5:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	default:
		return 0;
	}
}



SFNode *CylinderSensor_Create()
{
	B_CylinderSensor *p;
	SAFEALLOC(p, sizeof(B_CylinderSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_CylinderSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "CylinderSensor";
	((SFNode *)p)->sgprivate->node_del = CylinderSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = CylinderSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = CylinderSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = CylinderSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = CylinderSensor_get_aq_info;

#endif


	/*default field values*/
	p->autoOffset = 1;
	p->diskAngle = (SFFloat) 0.262;
	p->enabled = 1;
	p->maxAngle = (SFFloat) -1;
	p->minAngle = (SFFloat) 0;
	p->offset = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	DirectionalLight Node deletion
*/

static void DirectionalLight_Del(SFNode *node)
{
	B_DirectionalLight *p = (B_DirectionalLight *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 DirectionalLight_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 DirectionalLight_In2All[] = { 0, 1, 2, 3, 4};
static const u16 DirectionalLight_Out2All[] = { 0, 1, 2, 3, 4};
static const u16 DirectionalLight_Dyn2All[] = { 0, 1, 2, 3};

static u32 DirectionalLight_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 5;
	case FCM_DYN: return 4;
	default:
		return 5;
	}
}

static M4Err DirectionalLight_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = DirectionalLight_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = DirectionalLight_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = DirectionalLight_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = DirectionalLight_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err DirectionalLight_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "ambientIntensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DirectionalLight *) node)->ambientIntensity;
		return M4OK;
	case 1:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_DirectionalLight *) node)->color;
		return M4OK;
	case 2:
		info->name = "direction";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_DirectionalLight *) node)->direction;
		return M4OK;
	case 3:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DirectionalLight *) node)->intensity;
		return M4OK;
	case 4:
		info->name = "on";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DirectionalLight *) node)->on;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool DirectionalLight_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 9;
		*QType = 9;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *DirectionalLight_Create()
{
	B_DirectionalLight *p;
	SAFEALLOC(p, sizeof(B_DirectionalLight));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_DirectionalLight);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "DirectionalLight";
	((SFNode *)p)->sgprivate->node_del = DirectionalLight_Del;
	((SFNode *)p)->sgprivate->get_field_count = DirectionalLight_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = DirectionalLight_get_field_index;
	((SFNode *)p)->sgprivate->get_field = DirectionalLight_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = DirectionalLight_get_aq_info;

#endif


	/*default field values*/
	p->ambientIntensity = (SFFloat) 0;
	p->color.red = (SFFloat) 1;
	p->color.green = (SFFloat) 1;
	p->color.blue = (SFFloat) 1;
	p->direction.x = (SFFloat) 0;
	p->direction.y = (SFFloat) 0;
	p->direction.z = (SFFloat) -1;
	p->intensity = (SFFloat) 1;
	p->on = 1;
	return (SFNode *)p;
}


/*
	DiscSensor Node deletion
*/

static void DiscSensor_Del(SFNode *node)
{
	B_DiscSensor *p = (B_DiscSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 DiscSensor_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 DiscSensor_In2All[] = { 0, 1, 2, 3, 4};
static const u16 DiscSensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};

static u32 DiscSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 8;
	case FCM_DYN: return 0;
	default:
		return 8;
	}
}

static M4Err DiscSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = DiscSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = DiscSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = DiscSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err DiscSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "autoOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DiscSensor *) node)->autoOffset;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DiscSensor *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "maxAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DiscSensor *) node)->maxAngle;
		return M4OK;
	case 3:
		info->name = "minAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DiscSensor *) node)->minAngle;
		return M4OK;
	case 4:
		info->name = "offset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DiscSensor *) node)->offset;
		return M4OK;
	case 5:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DiscSensor *) node)->isActive;
		return M4OK;
	case 6:
		info->name = "rotation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DiscSensor *) node)->rotation_changed;
		return M4OK;
	case 7:
		info->name = "trackPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_DiscSensor *) node)->trackPoint_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool DiscSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) -6.2831853;
		*b_max = (Float) 6.2831853;
		return 1;
	case 3:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) -6.2831853;
		*b_max = (Float) 6.2831853;
		return 1;
	case 4:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	default:
		return 0;
	}
}



SFNode *DiscSensor_Create()
{
	B_DiscSensor *p;
	SAFEALLOC(p, sizeof(B_DiscSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_DiscSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "DiscSensor";
	((SFNode *)p)->sgprivate->node_del = DiscSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = DiscSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = DiscSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = DiscSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = DiscSensor_get_aq_info;

#endif


	/*default field values*/
	p->autoOffset = 1;
	p->enabled = 1;
	p->maxAngle = (SFFloat) -1;
	p->minAngle = (SFFloat) 0;
	p->offset = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	ElevationGrid Node deletion
*/

static void ElevationGrid_Del(SFNode *node)
{
	B_ElevationGrid *p = (B_ElevationGrid *) node;
	MFFloat_Del(p->set_height);
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->normal, (SFNode *) p);	
	Node_Delete((SFNode *) p->texCoord, (SFNode *) p);	
	MFFloat_Del(p->height);
	SFNode_Delete((SFNode *) p);
}

static const u16 ElevationGrid_Def2All[] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
static const u16 ElevationGrid_In2All[] = { 0, 1, 2, 3};
static const u16 ElevationGrid_Out2All[] = { 1, 2, 3};

static u32 ElevationGrid_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 13;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 14;
	}
}

static M4Err ElevationGrid_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ElevationGrid_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ElevationGrid_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ElevationGrid_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ElevationGrid_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_height";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ElevationGrid *)node)->on_set_height;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_ElevationGrid *) node)->set_height;
		return M4OK;
	case 1:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_ElevationGrid *)node)->color;
		return M4OK;
	case 2:
		info->name = "normal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFNormalNode;
		info->far_ptr = & ((B_ElevationGrid *)node)->normal;
		return M4OK;
	case 3:
		info->name = "texCoord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureCoordinateNode;
		info->far_ptr = & ((B_ElevationGrid *)node)->texCoord;
		return M4OK;
	case 4:
		info->name = "height";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_ElevationGrid *) node)->height;
		return M4OK;
	case 5:
		info->name = "ccw";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ElevationGrid *) node)->ccw;
		return M4OK;
	case 6:
		info->name = "colorPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ElevationGrid *) node)->colorPerVertex;
		return M4OK;
	case 7:
		info->name = "creaseAngle";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ElevationGrid *) node)->creaseAngle;
		return M4OK;
	case 8:
		info->name = "normalPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ElevationGrid *) node)->normalPerVertex;
		return M4OK;
	case 9:
		info->name = "solid";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ElevationGrid *) node)->solid;
		return M4OK;
	case 10:
		info->name = "xDimension";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_ElevationGrid *) node)->xDimension;
		return M4OK;
	case 11:
		info->name = "xSpacing";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ElevationGrid *) node)->xSpacing;
		return M4OK;
	case 12:
		info->name = "zDimension";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_ElevationGrid *) node)->zDimension;
		return M4OK;
	case 13:
		info->name = "zSpacing";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ElevationGrid *) node)->zSpacing;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ElevationGrid_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 7;
		*QType = 11;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 10:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ElevationGrid_Create()
{
	B_ElevationGrid *p;
	SAFEALLOC(p, sizeof(B_ElevationGrid));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ElevationGrid);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ElevationGrid";
	((SFNode *)p)->sgprivate->node_del = ElevationGrid_Del;
	((SFNode *)p)->sgprivate->get_field_count = ElevationGrid_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ElevationGrid_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ElevationGrid_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ElevationGrid_get_aq_info;

#endif


	/*default field values*/
	p->ccw = 1;
	p->colorPerVertex = 1;
	p->creaseAngle = (SFFloat) 0.0;
	p->normalPerVertex = 1;
	p->solid = 1;
	p->xDimension = 0;
	p->xSpacing = (SFFloat) 1.0;
	p->zDimension = 0;
	p->zSpacing = (SFFloat) 1.0;
	return (SFNode *)p;
}


/*
	Expression Node deletion
*/

static void Expression_Del(SFNode *node)
{
	B_Expression *p = (B_Expression *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Expression_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Expression_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Expression_Out2All[] = { 0, 1, 2, 3, 4, 5};

static u32 Expression_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err Expression_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Expression_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Expression_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Expression_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Expression_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "expression_select1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Expression *) node)->expression_select1;
		return M4OK;
	case 1:
		info->name = "expression_intensity1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Expression *) node)->expression_intensity1;
		return M4OK;
	case 2:
		info->name = "expression_select2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Expression *) node)->expression_select2;
		return M4OK;
	case 3:
		info->name = "expression_intensity2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Expression *) node)->expression_intensity2;
		return M4OK;
	case 4:
		info->name = "init_face";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Expression *) node)->init_face;
		return M4OK;
	case 5:
		info->name = "expression_def";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Expression *) node)->expression_def;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Expression_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 63;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 63;
		return 1;
	default:
		return 0;
	}
}



SFNode *Expression_Create()
{
	B_Expression *p;
	SAFEALLOC(p, sizeof(B_Expression));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Expression);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Expression";
	((SFNode *)p)->sgprivate->node_del = Expression_Del;
	((SFNode *)p)->sgprivate->get_field_count = Expression_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Expression_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Expression_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Expression_get_aq_info;

#endif


	/*default field values*/
	p->expression_select1 = 0;
	p->expression_intensity1 = 0;
	p->expression_select2 = 0;
	p->expression_intensity2 = 0;
	return (SFNode *)p;
}


/*
	Extrusion Node deletion
*/

static void Extrusion_Del(SFNode *node)
{
	B_Extrusion *p = (B_Extrusion *) node;
	MFVec2f_Del(p->set_crossSection);
	MFRotation_Del(p->set_orientation);
	MFVec2f_Del(p->set_scale);
	MFVec3f_Del(p->set_spine);
	MFVec2f_Del(p->crossSection);
	MFRotation_Del(p->orientation);
	MFVec2f_Del(p->scale);
	MFVec3f_Del(p->spine);
	SFNode_Delete((SFNode *) p);
}

static const u16 Extrusion_Def2All[] = { 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
static const u16 Extrusion_In2All[] = { 0, 1, 2, 3};

static u32 Extrusion_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 10;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 14;
	}
}

static M4Err Extrusion_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Extrusion_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Extrusion_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Extrusion_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_crossSection";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Extrusion *)node)->on_set_crossSection;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Extrusion *) node)->set_crossSection;
		return M4OK;
	case 1:
		info->name = "set_orientation";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Extrusion *)node)->on_set_orientation;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_Extrusion *) node)->set_orientation;
		return M4OK;
	case 2:
		info->name = "set_scale";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Extrusion *)node)->on_set_scale;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Extrusion *) node)->set_scale;
		return M4OK;
	case 3:
		info->name = "set_spine";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Extrusion *)node)->on_set_spine;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Extrusion *) node)->set_spine;
		return M4OK;
	case 4:
		info->name = "beginCap";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Extrusion *) node)->beginCap;
		return M4OK;
	case 5:
		info->name = "ccw";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Extrusion *) node)->ccw;
		return M4OK;
	case 6:
		info->name = "convex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Extrusion *) node)->convex;
		return M4OK;
	case 7:
		info->name = "creaseAngle";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Extrusion *) node)->creaseAngle;
		return M4OK;
	case 8:
		info->name = "crossSection";
		info->eventType = ET_Field;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Extrusion *) node)->crossSection;
		return M4OK;
	case 9:
		info->name = "endCap";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Extrusion *) node)->endCap;
		return M4OK;
	case 10:
		info->name = "orientation";
		info->eventType = ET_Field;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_Extrusion *) node)->orientation;
		return M4OK;
	case 11:
		info->name = "scale";
		info->eventType = ET_Field;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Extrusion *) node)->scale;
		return M4OK;
	case 12:
		info->name = "solid";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Extrusion *) node)->solid;
		return M4OK;
	case 13:
		info->name = "spine";
		info->eventType = ET_Field;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Extrusion *) node)->spine;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Extrusion_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 7:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 8:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 0;
		*QType = 10;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 7;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Extrusion_Create()
{
	B_Extrusion *p;
	SAFEALLOC(p, sizeof(B_Extrusion));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Extrusion);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Extrusion";
	((SFNode *)p)->sgprivate->node_del = Extrusion_Del;
	((SFNode *)p)->sgprivate->get_field_count = Extrusion_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Extrusion_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Extrusion_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Extrusion_get_aq_info;

#endif


	/*default field values*/
	p->beginCap = 1;
	p->ccw = 1;
	p->convex = 1;
	p->creaseAngle = (SFFloat) 0.0;
	p->crossSection.vals = malloc(sizeof(SFVec2f)*5);
	p->crossSection.count = 5;
	p->crossSection.vals[0].x = (SFFloat) 1;
	p->crossSection.vals[0].y = (SFFloat) 1;
	p->crossSection.vals[1].x = (SFFloat) 1;
	p->crossSection.vals[1].y = (SFFloat) -1;
	p->crossSection.vals[2].x = (SFFloat) -1;
	p->crossSection.vals[2].y = (SFFloat) -1;
	p->crossSection.vals[3].x = (SFFloat) -1;
	p->crossSection.vals[3].y = (SFFloat) 1;
	p->crossSection.vals[4].x = (SFFloat) 1;
	p->crossSection.vals[4].y = (SFFloat) 1;
	p->endCap = 1;
	p->orientation.vals = malloc(sizeof(SFRotation)*1);
	p->orientation.count = 1;
	p->orientation.vals[0].xAxis = (SFFloat) 0;
	p->orientation.vals[0].yAxis = (SFFloat) 0;
	p->orientation.vals[0].zAxis = (SFFloat) 1;
	p->orientation.vals[0].angle = (SFFloat) 0;
	p->scale.vals = malloc(sizeof(SFVec2f)*1);
	p->scale.count = 1;
	p->scale.vals[0].x = (SFFloat) 1;
	p->scale.vals[0].y = (SFFloat) 1;
	p->solid = 1;
	p->spine.vals = malloc(sizeof(SFVec3f)*2);
	p->spine.count = 2;
	p->spine.vals[0].x = (SFFloat) 0;
	p->spine.vals[0].y = (SFFloat) 0;
	p->spine.vals[0].z = (SFFloat) 0;
	p->spine.vals[1].x = (SFFloat) 0;
	p->spine.vals[1].y = (SFFloat) 1;
	p->spine.vals[1].z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Face Node deletion
*/

static void Face_Del(SFNode *node)
{
	B_Face *p = (B_Face *) node;
	Node_Delete((SFNode *) p->fap, (SFNode *) p);	
	Node_Delete((SFNode *) p->fdp, (SFNode *) p);	
	Node_Delete((SFNode *) p->fit, (SFNode *) p);	
	Node_Delete((SFNode *) p->ttsSource, (SFNode *) p);	
	NodeList_Delete((Chain *) p->renderedFace, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Face_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 Face_In2All[] = { 0, 1, 2, 3, 4};
static const u16 Face_Out2All[] = { 0, 1, 2, 3, 4};

static u32 Face_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 5;
	case FCM_DYN: return 0;
	default:
		return 5;
	}
}

static M4Err Face_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Face_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Face_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Face_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Face_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "fap";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFAPNode;
		info->far_ptr = & ((B_Face *)node)->fap;
		return M4OK;
	case 1:
		info->name = "fdp";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFDPNode;
		info->far_ptr = & ((B_Face *)node)->fdp;
		return M4OK;
	case 2:
		info->name = "fit";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFITNode;
		info->far_ptr = & ((B_Face *)node)->fit;
		return M4OK;
	case 3:
		info->name = "ttsSource";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_Face *)node)->ttsSource;
		return M4OK;
	case 4:
		info->name = "renderedFace";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Face *)node)->renderedFace;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Face_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Face_Create()
{
	B_Face *p;
	SAFEALLOC(p, sizeof(B_Face));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Face);
	p->renderedFace = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Face";
	((SFNode *)p)->sgprivate->node_del = Face_Del;
	((SFNode *)p)->sgprivate->get_field_count = Face_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Face_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Face_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Face_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	FaceDefMesh Node deletion
*/

static void FaceDefMesh_Del(SFNode *node)
{
	B_FaceDefMesh *p = (B_FaceDefMesh *) node;
	Node_Delete((SFNode *) p->faceSceneGraphNode, (SFNode *) p);	
	MFInt32_Del(p->intervalBorders);
	MFInt32_Del(p->coordIndex);
	MFVec3f_Del(p->displacements);
	SFNode_Delete((SFNode *) p);
}

static const u16 FaceDefMesh_Def2All[] = { 0, 1, 2, 3};

static u32 FaceDefMesh_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 4;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err FaceDefMesh_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = FaceDefMesh_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FaceDefMesh_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "faceSceneGraphNode";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_FaceDefMesh *)node)->faceSceneGraphNode;
		return M4OK;
	case 1:
		info->name = "intervalBorders";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FaceDefMesh *) node)->intervalBorders;
		return M4OK;
	case 2:
		info->name = "coordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FaceDefMesh *) node)->coordIndex;
		return M4OK;
	case 3:
		info->name = "displacements";
		info->eventType = ET_Field;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_FaceDefMesh *) node)->displacements;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FaceDefMesh_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 0;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		return 1;
	default:
		return 0;
	}
}



SFNode *FaceDefMesh_Create()
{
	B_FaceDefMesh *p;
	SAFEALLOC(p, sizeof(B_FaceDefMesh));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FaceDefMesh);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FaceDefMesh";
	((SFNode *)p)->sgprivate->node_del = FaceDefMesh_Del;
	((SFNode *)p)->sgprivate->get_field_count = FaceDefMesh_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FaceDefMesh_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FaceDefMesh_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FaceDefMesh_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	FaceDefTables Node deletion
*/

static void FaceDefTables_Del(SFNode *node)
{
	B_FaceDefTables *p = (B_FaceDefTables *) node;
	NodeList_Delete((Chain *) p->faceDefMesh, (SFNode *) p);	
	NodeList_Delete((Chain *) p->faceDefTransform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 FaceDefTables_Def2All[] = { 0, 1, 2, 3};
static const u16 FaceDefTables_In2All[] = { 2, 3};
static const u16 FaceDefTables_Out2All[] = { 2, 3};

static u32 FaceDefTables_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 4;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err FaceDefTables_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = FaceDefTables_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = FaceDefTables_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = FaceDefTables_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FaceDefTables_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "fapID";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FaceDefTables *) node)->fapID;
		return M4OK;
	case 1:
		info->name = "highLevelSelect";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FaceDefTables *) node)->highLevelSelect;
		return M4OK;
	case 2:
		info->name = "faceDefMesh";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFFaceDefMeshNode;
		info->far_ptr = & ((B_FaceDefTables *)node)->faceDefMesh;
		return M4OK;
	case 3:
		info->name = "faceDefTransform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFFaceDefTransformNode;
		info->far_ptr = & ((B_FaceDefTables *)node)->faceDefTransform;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FaceDefTables_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 7;
		*b_min = (Float) 1;
		*b_max = (Float)  68;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 6;
		*b_min = (Float) 1;
		*b_max = (Float)  64;
		return 1;
	default:
		return 0;
	}
}



SFNode *FaceDefTables_Create()
{
	B_FaceDefTables *p;
	SAFEALLOC(p, sizeof(B_FaceDefTables));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FaceDefTables);
	p->faceDefMesh = NewChain();	
	p->faceDefTransform = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FaceDefTables";
	((SFNode *)p)->sgprivate->node_del = FaceDefTables_Del;
	((SFNode *)p)->sgprivate->get_field_count = FaceDefTables_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FaceDefTables_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FaceDefTables_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FaceDefTables_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFFaceDefMeshNode;

#endif


	/*default field values*/
	p->fapID = 1;
	p->highLevelSelect = 1;
	return (SFNode *)p;
}


/*
	FaceDefTransform Node deletion
*/

static void FaceDefTransform_Del(SFNode *node)
{
	B_FaceDefTransform *p = (B_FaceDefTransform *) node;
	Node_Delete((SFNode *) p->faceSceneGraphNode, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 FaceDefTransform_Def2All[] = { 0, 1, 2, 3, 4};

static u32 FaceDefTransform_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 5;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 5;
	}
}

static M4Err FaceDefTransform_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = FaceDefTransform_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FaceDefTransform_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "faceSceneGraphNode";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_FaceDefTransform *)node)->faceSceneGraphNode;
		return M4OK;
	case 1:
		info->name = "fieldId";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FaceDefTransform *) node)->fieldId;
		return M4OK;
	case 2:
		info->name = "rotationDef";
		info->eventType = ET_Field;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_FaceDefTransform *) node)->rotationDef;
		return M4OK;
	case 3:
		info->name = "scaleDef";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_FaceDefTransform *) node)->scaleDef;
		return M4OK;
	case 4:
		info->name = "translationDef";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_FaceDefTransform *) node)->translationDef;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FaceDefTransform_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 10;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 7;
		return 1;
	case 4:
		*AType = 0;
		*QType = 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *FaceDefTransform_Create()
{
	B_FaceDefTransform *p;
	SAFEALLOC(p, sizeof(B_FaceDefTransform));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FaceDefTransform);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FaceDefTransform";
	((SFNode *)p)->sgprivate->node_del = FaceDefTransform_Del;
	((SFNode *)p)->sgprivate->get_field_count = FaceDefTransform_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FaceDefTransform_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FaceDefTransform_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FaceDefTransform_get_aq_info;

#endif


	/*default field values*/
	p->fieldId = 1;
	p->rotationDef.xAxis = (SFFloat) 0;
	p->rotationDef.yAxis = (SFFloat) 0;
	p->rotationDef.zAxis = (SFFloat) 1;
	p->rotationDef.angle = (SFFloat) 0;
	p->scaleDef.x = (SFFloat) 1;
	p->scaleDef.y = (SFFloat) 1;
	p->scaleDef.z = (SFFloat) 1;
	p->translationDef.x = (SFFloat) 0;
	p->translationDef.y = (SFFloat) 0;
	p->translationDef.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	FAP Node deletion
*/

static void FAP_Del(SFNode *node)
{
	B_FAP *p = (B_FAP *) node;
	Node_Delete((SFNode *) p->viseme, (SFNode *) p);	
	Node_Delete((SFNode *) p->expression, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 FAP_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
static const u16 FAP_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
static const u16 FAP_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};

static u32 FAP_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 68;
	case FCM_DEF: return 68;
	case FCM_OUT: return 68;
	case FCM_DYN: return 0;
	default:
		return 68;
	}
}

static M4Err FAP_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = FAP_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = FAP_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = FAP_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FAP_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "viseme";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFVisemeNode;
		info->far_ptr = & ((B_FAP *)node)->viseme;
		return M4OK;
	case 1:
		info->name = "expression";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFExpressionNode;
		info->far_ptr = & ((B_FAP *)node)->expression;
		return M4OK;
	case 2:
		info->name = "open_jaw";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->open_jaw;
		return M4OK;
	case 3:
		info->name = "lower_t_midlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_midlip;
		return M4OK;
	case 4:
		info->name = "raise_b_midlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_b_midlip;
		return M4OK;
	case 5:
		info->name = "stretch_l_corner";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_l_corner;
		return M4OK;
	case 6:
		info->name = "stretch_r_corner";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_r_corner;
		return M4OK;
	case 7:
		info->name = "lower_t_lip_lm";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_lip_lm;
		return M4OK;
	case 8:
		info->name = "lower_t_lip_rm";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_lip_rm;
		return M4OK;
	case 9:
		info->name = "lower_b_lip_lm";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_b_lip_lm;
		return M4OK;
	case 10:
		info->name = "lower_b_lip_rm";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_b_lip_rm;
		return M4OK;
	case 11:
		info->name = "raise_l_cornerlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_cornerlip;
		return M4OK;
	case 12:
		info->name = "raise_r_cornerlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_cornerlip;
		return M4OK;
	case 13:
		info->name = "thrust_jaw";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->thrust_jaw;
		return M4OK;
	case 14:
		info->name = "shift_jaw";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->shift_jaw;
		return M4OK;
	case 15:
		info->name = "push_b_lip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->push_b_lip;
		return M4OK;
	case 16:
		info->name = "push_t_lip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->push_t_lip;
		return M4OK;
	case 17:
		info->name = "depress_chin";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->depress_chin;
		return M4OK;
	case 18:
		info->name = "close_t_l_eyelid";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->close_t_l_eyelid;
		return M4OK;
	case 19:
		info->name = "close_t_r_eyelid";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->close_t_r_eyelid;
		return M4OK;
	case 20:
		info->name = "close_b_l_eyelid";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->close_b_l_eyelid;
		return M4OK;
	case 21:
		info->name = "close_b_r_eyelid";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->close_b_r_eyelid;
		return M4OK;
	case 22:
		info->name = "yaw_l_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->yaw_l_eyeball;
		return M4OK;
	case 23:
		info->name = "yaw_r_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->yaw_r_eyeball;
		return M4OK;
	case 24:
		info->name = "pitch_l_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->pitch_l_eyeball;
		return M4OK;
	case 25:
		info->name = "pitch_r_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->pitch_r_eyeball;
		return M4OK;
	case 26:
		info->name = "thrust_l_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->thrust_l_eyeball;
		return M4OK;
	case 27:
		info->name = "thrust_r_eyeball";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->thrust_r_eyeball;
		return M4OK;
	case 28:
		info->name = "dilate_l_pupil";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->dilate_l_pupil;
		return M4OK;
	case 29:
		info->name = "dilate_r_pupil";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->dilate_r_pupil;
		return M4OK;
	case 30:
		info->name = "raise_l_i_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_i_eyebrow;
		return M4OK;
	case 31:
		info->name = "raise_r_i_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_i_eyebrow;
		return M4OK;
	case 32:
		info->name = "raise_l_m_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_m_eyebrow;
		return M4OK;
	case 33:
		info->name = "raise_r_m_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_m_eyebrow;
		return M4OK;
	case 34:
		info->name = "raise_l_o_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_o_eyebrow;
		return M4OK;
	case 35:
		info->name = "raise_r_o_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_o_eyebrow;
		return M4OK;
	case 36:
		info->name = "squeeze_l_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->squeeze_l_eyebrow;
		return M4OK;
	case 37:
		info->name = "squeeze_r_eyebrow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->squeeze_r_eyebrow;
		return M4OK;
	case 38:
		info->name = "puff_l_cheek";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->puff_l_cheek;
		return M4OK;
	case 39:
		info->name = "puff_r_cheek";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->puff_r_cheek;
		return M4OK;
	case 40:
		info->name = "lift_l_cheek";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lift_l_cheek;
		return M4OK;
	case 41:
		info->name = "lift_r_cheek";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lift_r_cheek;
		return M4OK;
	case 42:
		info->name = "shift_tongue_tip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->shift_tongue_tip;
		return M4OK;
	case 43:
		info->name = "raise_tongue_tip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_tongue_tip;
		return M4OK;
	case 44:
		info->name = "thrust_tongue_tip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->thrust_tongue_tip;
		return M4OK;
	case 45:
		info->name = "raise_tongue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_tongue;
		return M4OK;
	case 46:
		info->name = "tongue_roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->tongue_roll;
		return M4OK;
	case 47:
		info->name = "head_pitch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->head_pitch;
		return M4OK;
	case 48:
		info->name = "head_yaw";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->head_yaw;
		return M4OK;
	case 49:
		info->name = "head_roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->head_roll;
		return M4OK;
	case 50:
		info->name = "lower_t_midlip_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_midlip_o;
		return M4OK;
	case 51:
		info->name = "raise_b_midlip_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_b_midlip_o;
		return M4OK;
	case 52:
		info->name = "stretch_l_cornerlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_l_cornerlip;
		return M4OK;
	case 53:
		info->name = "stretch_r_cornerlip";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_r_cornerlip;
		return M4OK;
	case 54:
		info->name = "lower_t_lip_lm_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_lip_lm_o;
		return M4OK;
	case 55:
		info->name = "lower_t_lip_rm_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->lower_t_lip_rm_o;
		return M4OK;
	case 56:
		info->name = "raise_b_lip_lm_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_b_lip_lm_o;
		return M4OK;
	case 57:
		info->name = "raise_b_lip_rm_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_b_lip_rm_o;
		return M4OK;
	case 58:
		info->name = "raise_l_cornerlip_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_cornerlip_o;
		return M4OK;
	case 59:
		info->name = "raise_r_cornerlip_o";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_cornerlip_o;
		return M4OK;
	case 60:
		info->name = "stretch_l_nose";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_l_nose;
		return M4OK;
	case 61:
		info->name = "stretch_r_nose";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->stretch_r_nose;
		return M4OK;
	case 62:
		info->name = "raise_nose";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_nose;
		return M4OK;
	case 63:
		info->name = "bend_nose";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->bend_nose;
		return M4OK;
	case 64:
		info->name = "raise_l_ear";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_l_ear;
		return M4OK;
	case 65:
		info->name = "raise_r_ear";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->raise_r_ear;
		return M4OK;
	case 66:
		info->name = "pull_l_ear";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->pull_l_ear;
		return M4OK;
	case 67:
		info->name = "pull_r_ear";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_FAP *) node)->pull_r_ear;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FAP_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 14:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 15:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 16:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 17:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 18:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 19:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 20:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 21:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 22:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 23:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 24:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 25:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 26:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 27:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 28:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 29:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 30:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 31:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 32:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 33:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 34:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 35:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 36:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 37:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 38:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 39:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 40:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 41:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 42:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 43:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 44:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 45:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 46:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 47:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 48:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 49:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 50:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 51:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 52:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 53:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 54:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 55:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 56:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 57:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 58:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 59:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 60:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 61:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 62:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 63:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 64:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 65:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 66:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 67:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *FAP_Create()
{
	B_FAP *p;
	SAFEALLOC(p, sizeof(B_FAP));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FAP);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FAP";
	((SFNode *)p)->sgprivate->node_del = FAP_Del;
	((SFNode *)p)->sgprivate->get_field_count = FAP_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FAP_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FAP_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FAP_get_aq_info;

#endif


	/*default field values*/
	p->open_jaw = 2 << 31;
	p->lower_t_midlip = 2 << 31;
	p->raise_b_midlip = 2 << 31;
	p->stretch_l_corner = 2 << 31;
	p->stretch_r_corner = 2 << 31;
	p->lower_t_lip_lm = 2 << 31;
	p->lower_t_lip_rm = 2 << 31;
	p->lower_b_lip_lm = 2 << 31;
	p->lower_b_lip_rm = 2 << 31;
	p->raise_l_cornerlip = 2 << 31;
	p->raise_r_cornerlip = 2 << 31;
	p->thrust_jaw = 2 << 31;
	p->shift_jaw = 2 << 31;
	p->push_b_lip = 2 << 31;
	p->push_t_lip = 2 << 31;
	p->depress_chin = 2 << 31;
	p->close_t_l_eyelid = 2 << 31;
	p->close_t_r_eyelid = 2 << 31;
	p->close_b_l_eyelid = 2 << 31;
	p->close_b_r_eyelid = 2 << 31;
	p->yaw_l_eyeball = 2 << 31;
	p->yaw_r_eyeball = 2 << 31;
	p->pitch_l_eyeball = 2 << 31;
	p->pitch_r_eyeball = 2 << 31;
	p->thrust_l_eyeball = 2 << 31;
	p->thrust_r_eyeball = 2 << 31;
	p->dilate_l_pupil = 2 << 31;
	p->dilate_r_pupil = 2 << 31;
	p->raise_l_i_eyebrow = 2 << 31;
	p->raise_r_i_eyebrow = 2 << 31;
	p->raise_l_m_eyebrow = 2 << 31;
	p->raise_r_m_eyebrow = 2 << 31;
	p->raise_l_o_eyebrow = 2 << 31;
	p->raise_r_o_eyebrow = 2 << 31;
	p->squeeze_l_eyebrow = 2 << 31;
	p->squeeze_r_eyebrow = 2 << 31;
	p->puff_l_cheek = 2 << 31;
	p->puff_r_cheek = 2 << 31;
	p->lift_l_cheek = 2 << 31;
	p->lift_r_cheek = 2 << 31;
	p->shift_tongue_tip = 2 << 31;
	p->raise_tongue_tip = 2 << 31;
	p->thrust_tongue_tip = 2 << 31;
	p->raise_tongue = 2 << 31;
	p->tongue_roll = 2 << 31;
	p->head_pitch = 2 << 31;
	p->head_yaw = 2 << 31;
	p->head_roll = 2 << 31;
	p->lower_t_midlip_o = 2 << 31;
	p->raise_b_midlip_o = 2 << 31;
	p->stretch_l_cornerlip = 2 << 31;
	p->stretch_r_cornerlip = 2 << 31;
	p->lower_t_lip_lm_o = 2 << 31;
	p->lower_t_lip_rm_o = 2 << 31;
	p->raise_b_lip_lm_o = 2 << 31;
	p->raise_b_lip_rm_o = 2 << 31;
	p->raise_l_cornerlip_o = 2 << 31;
	p->raise_r_cornerlip_o = 2 << 31;
	p->stretch_l_nose = 2 << 31;
	p->stretch_r_nose = 2 << 31;
	p->raise_nose = 2 << 31;
	p->bend_nose = 2 << 31;
	p->raise_l_ear = 2 << 31;
	p->raise_r_ear = 2 << 31;
	p->pull_l_ear = 2 << 31;
	p->pull_r_ear = 2 << 31;
	return (SFNode *)p;
}


/*
	FDP Node deletion
*/

static void FDP_Del(SFNode *node)
{
	B_FDP *p = (B_FDP *) node;
	Node_Delete((SFNode *) p->featurePointsCoord, (SFNode *) p);	
	Node_Delete((SFNode *) p->textureCoord, (SFNode *) p);	
	NodeList_Delete((Chain *) p->faceDefTables, (SFNode *) p);	
	NodeList_Delete((Chain *) p->faceSceneGraph, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 FDP_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 FDP_In2All[] = { 0, 1, 2, 3};
static const u16 FDP_Out2All[] = { 0, 1, 2, 3};

static u32 FDP_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 5;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 5;
	}
}

static M4Err FDP_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = FDP_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = FDP_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = FDP_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FDP_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "featurePointsCoord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinateNode;
		info->far_ptr = & ((B_FDP *)node)->featurePointsCoord;
		return M4OK;
	case 1:
		info->name = "textureCoord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureCoordinateNode;
		info->far_ptr = & ((B_FDP *)node)->textureCoord;
		return M4OK;
	case 2:
		info->name = "faceDefTables";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFFaceDefTablesNode;
		info->far_ptr = & ((B_FDP *)node)->faceDefTables;
		return M4OK;
	case 3:
		info->name = "faceSceneGraph";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_FDP *)node)->faceSceneGraph;
		return M4OK;
	case 4:
		info->name = "useOrthoTexture";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_FDP *) node)->useOrthoTexture;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FDP_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *FDP_Create()
{
	B_FDP *p;
	SAFEALLOC(p, sizeof(B_FDP));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FDP);
	p->faceDefTables = NewChain();	
	p->faceSceneGraph = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FDP";
	((SFNode *)p)->sgprivate->node_del = FDP_Del;
	((SFNode *)p)->sgprivate->get_field_count = FDP_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FDP_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FDP_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FDP_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFFaceDefTablesNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	FIT Node deletion
*/

static void FIT_Del(SFNode *node)
{
	B_FIT *p = (B_FIT *) node;
	MFInt32_Del(p->FAPs);
	MFInt32_Del(p->Graph);
	MFInt32_Del(p->numeratorExp);
	MFInt32_Del(p->denominatorExp);
	MFInt32_Del(p->numeratorImpulse);
	MFInt32_Del(p->numeratorTerms);
	MFInt32_Del(p->denominatorTerms);
	MFFloat_Del(p->numeratorCoefs);
	MFFloat_Del(p->denominatorCoefs);
	SFNode_Delete((SFNode *) p);
}

static const u16 FIT_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 FIT_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 FIT_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};

static u32 FIT_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 9;
	case FCM_OUT: return 9;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err FIT_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = FIT_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = FIT_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = FIT_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FIT_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "FAPs";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->FAPs;
		return M4OK;
	case 1:
		info->name = "Graph";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->Graph;
		return M4OK;
	case 2:
		info->name = "numeratorExp";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->numeratorExp;
		return M4OK;
	case 3:
		info->name = "denominatorExp";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->denominatorExp;
		return M4OK;
	case 4:
		info->name = "numeratorImpulse";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->numeratorImpulse;
		return M4OK;
	case 5:
		info->name = "numeratorTerms";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->numeratorTerms;
		return M4OK;
	case 6:
		info->name = "denominatorTerms";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_FIT *) node)->denominatorTerms;
		return M4OK;
	case 7:
		info->name = "numeratorCoefs";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_FIT *) node)->numeratorCoefs;
		return M4OK;
	case 8:
		info->name = "denominatorCoefs";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_FIT *) node)->denominatorCoefs;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FIT_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 7;
		*b_min = (Float) -1;
		*b_max = (Float) 68;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 7;
		*b_min = (Float) 0;
		*b_max = (Float) 68;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 15;
		return 1;
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 15;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 10;
		*b_min = (Float) 0;
		*b_max = (Float) 1023;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 10;
		return 1;
	case 6:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 10;
		return 1;
	default:
		return 0;
	}
}



SFNode *FIT_Create()
{
	B_FIT *p;
	SAFEALLOC(p, sizeof(B_FIT));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FIT);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FIT";
	((SFNode *)p)->sgprivate->node_del = FIT_Del;
	((SFNode *)p)->sgprivate->get_field_count = FIT_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FIT_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FIT_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FIT_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Fog Node deletion
*/

static void Fog_Del(SFNode *node)
{
	B_Fog *p = (B_Fog *) node;
	SFString_Del(p->fogType);
	SFNode_Delete((SFNode *) p);
}

static const u16 Fog_Def2All[] = { 0, 1, 2};
static const u16 Fog_In2All[] = { 0, 1, 2, 3};
static const u16 Fog_Out2All[] = { 0, 1, 2, 4};
static const u16 Fog_Dyn2All[] = { 0, 2};

static u32 Fog_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 3;
	case FCM_OUT: return 4;
	case FCM_DYN: return 2;
	default:
		return 5;
	}
}

static M4Err Fog_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Fog_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Fog_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Fog_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Fog_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Fog_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Fog *) node)->color;
		return M4OK;
	case 1:
		info->name = "fogType";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Fog *) node)->fogType;
		return M4OK;
	case 2:
		info->name = "visibilityRange";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Fog *) node)->visibilityRange;
		return M4OK;
	case 3:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Fog *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Fog *) node)->set_bind;
		return M4OK;
	case 4:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Fog *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Fog_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Fog_Create()
{
	B_Fog *p;
	SAFEALLOC(p, sizeof(B_Fog));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Fog);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Fog";
	((SFNode *)p)->sgprivate->node_del = Fog_Del;
	((SFNode *)p)->sgprivate->get_field_count = Fog_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Fog_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Fog_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Fog_get_aq_info;

#endif


	/*default field values*/
	p->color.red = (SFFloat) 1;
	p->color.green = (SFFloat) 1;
	p->color.blue = (SFFloat) 1;
	p->fogType.buffer = malloc(sizeof(char) * 7);
	strcpy(p->fogType.buffer, "LINEAR");
	p->visibilityRange = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	FontStyle Node deletion
*/

static void FontStyle_Del(SFNode *node)
{
	B_FontStyle *p = (B_FontStyle *) node;
	MFString_Del(p->family);
	MFString_Del(p->justify);
	SFString_Del(p->language);
	SFString_Del(p->style);
	SFNode_Delete((SFNode *) p);
}

static const u16 FontStyle_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 FontStyle_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 FontStyle_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};

static u32 FontStyle_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 9;
	case FCM_OUT: return 9;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err FontStyle_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = FontStyle_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = FontStyle_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = FontStyle_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err FontStyle_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "family";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_FontStyle *) node)->family;
		return M4OK;
	case 1:
		info->name = "horizontal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_FontStyle *) node)->horizontal;
		return M4OK;
	case 2:
		info->name = "justify";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_FontStyle *) node)->justify;
		return M4OK;
	case 3:
		info->name = "language";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_FontStyle *) node)->language;
		return M4OK;
	case 4:
		info->name = "leftToRight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_FontStyle *) node)->leftToRight;
		return M4OK;
	case 5:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_FontStyle *) node)->size;
		return M4OK;
	case 6:
		info->name = "spacing";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_FontStyle *) node)->spacing;
		return M4OK;
	case 7:
		info->name = "style";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_FontStyle *) node)->style;
		return M4OK;
	case 8:
		info->name = "topToBottom";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_FontStyle *) node)->topToBottom;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool FontStyle_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 5:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *FontStyle_Create()
{
	B_FontStyle *p;
	SAFEALLOC(p, sizeof(B_FontStyle));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_FontStyle);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "FontStyle";
	((SFNode *)p)->sgprivate->node_del = FontStyle_Del;
	((SFNode *)p)->sgprivate->get_field_count = FontStyle_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = FontStyle_get_field_index;
	((SFNode *)p)->sgprivate->get_field = FontStyle_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = FontStyle_get_aq_info;

#endif


	/*default field values*/
	p->family.vals = malloc(sizeof(SFString)*1);
	p->family.count = 1;
	p->family.vals[0] = malloc(sizeof(char) * 6);
	strcpy(p->family.vals[0], "SERIF");
	p->horizontal = 1;
	p->justify.vals = malloc(sizeof(SFString)*1);
	p->justify.count = 1;
	p->justify.vals[0] = malloc(sizeof(char) * 6);
	strcpy(p->justify.vals[0], "BEGIN");
	p->leftToRight = 1;
	p->size = (SFFloat) 1.0;
	p->spacing = (SFFloat) 1.0;
	p->style.buffer = malloc(sizeof(char) * 6);
	strcpy(p->style.buffer, "PLAIN");
	p->topToBottom = 1;
	return (SFNode *)p;
}


/*
	Form Node deletion
*/

static void Form_Del(SFNode *node)
{
	B_Form *p = (B_Form *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFInt32_Del(p->groups);
	MFString_Del(p->constraints);
	MFInt32_Del(p->groupsIndex);
	SFNode_Delete((SFNode *) p);
}

static const u16 Form_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 Form_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 Form_Out2All[] = { 2, 3, 4, 5, 6};
static const u16 Form_Dyn2All[] = { 3};

static u32 Form_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 5;
	case FCM_OUT: return 5;
	case FCM_DYN: return 1;
	default:
		return 7;
	}
}

static M4Err Form_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Form_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Form_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Form_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Form_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Form_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Form *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Form *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Form *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Form *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Form *)node)->children;
		return M4OK;
	case 3:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Form *) node)->size;
		return M4OK;
	case 4:
		info->name = "groups";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Form *) node)->groups;
		return M4OK;
	case 5:
		info->name = "constraints";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Form *) node)->constraints;
		return M4OK;
	case 6:
		info->name = "groupsIndex";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Form *) node)->groupsIndex;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Form_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 12;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 10;
		*b_min = (Float) -1;
		*b_max = (Float) 1022;
		return 1;
	case 6:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 10;
		*b_min = (Float) -1;
		*b_max = (Float) 1022;
		return 1;
	default:
		return 0;
	}
}



SFNode *Form_Create()
{
	B_Form *p;
	SAFEALLOC(p, sizeof(B_Form));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Form);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Form";
	((SFNode *)p)->sgprivate->node_del = Form_Del;
	((SFNode *)p)->sgprivate->get_field_count = Form_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Form_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Form_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Form_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->size.x = (SFFloat) -1;
	p->size.y = (SFFloat) -1;
	return (SFNode *)p;
}


/*
	Group Node deletion
*/

static void Group_Del(SFNode *node)
{
	B_Group *p = (B_Group *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Group_Def2All[] = { 2};
static const u16 Group_In2All[] = { 0, 1, 2};
static const u16 Group_Out2All[] = { 2};

static u32 Group_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err Group_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Group_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Group_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Group_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Group_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Group *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Group *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Group *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Group *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Group *)node)->children;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Group_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Group_Create()
{
	B_Group *p;
	SAFEALLOC(p, sizeof(B_Group));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Group);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Group";
	((SFNode *)p)->sgprivate->node_del = Group_Del;
	((SFNode *)p)->sgprivate->get_field_count = Group_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Group_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Group_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Group_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	ImageTexture Node deletion
*/

static void ImageTexture_Del(SFNode *node)
{
	B_ImageTexture *p = (B_ImageTexture *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 ImageTexture_Def2All[] = { 0, 1, 2};
static const u16 ImageTexture_In2All[] = { 0};
static const u16 ImageTexture_Out2All[] = { 0};

static u32 ImageTexture_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 3;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err ImageTexture_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ImageTexture_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ImageTexture_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ImageTexture_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ImageTexture_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_ImageTexture *) node)->url;
		return M4OK;
	case 1:
		info->name = "repeatS";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ImageTexture *) node)->repeatS;
		return M4OK;
	case 2:
		info->name = "repeatT";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ImageTexture *) node)->repeatT;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ImageTexture_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *ImageTexture_Create()
{
	B_ImageTexture *p;
	SAFEALLOC(p, sizeof(B_ImageTexture));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ImageTexture);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ImageTexture";
	((SFNode *)p)->sgprivate->node_del = ImageTexture_Del;
	((SFNode *)p)->sgprivate->get_field_count = ImageTexture_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ImageTexture_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ImageTexture_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ImageTexture_get_aq_info;

#endif


	/*default field values*/
	p->repeatS = 1;
	p->repeatT = 1;
	return (SFNode *)p;
}


/*
	IndexedFaceSet Node deletion
*/

static void IndexedFaceSet_Del(SFNode *node)
{
	B_IndexedFaceSet *p = (B_IndexedFaceSet *) node;
	MFInt32_Del(p->set_colorIndex);
	MFInt32_Del(p->set_coordIndex);
	MFInt32_Del(p->set_normalIndex);
	MFInt32_Del(p->set_texCoordIndex);
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	Node_Delete((SFNode *) p->normal, (SFNode *) p);	
	Node_Delete((SFNode *) p->texCoord, (SFNode *) p);	
	MFInt32_Del(p->colorIndex);
	MFInt32_Del(p->coordIndex);
	MFInt32_Del(p->normalIndex);
	MFInt32_Del(p->texCoordIndex);
	SFNode_Delete((SFNode *) p);
}

static const u16 IndexedFaceSet_Def2All[] = { 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
static const u16 IndexedFaceSet_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 IndexedFaceSet_Out2All[] = { 4, 5, 6, 7};

static u32 IndexedFaceSet_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 14;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 18;
	}
}

static M4Err IndexedFaceSet_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = IndexedFaceSet_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = IndexedFaceSet_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = IndexedFaceSet_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err IndexedFaceSet_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_colorIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet *)node)->on_set_colorIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->set_colorIndex;
		return M4OK;
	case 1:
		info->name = "set_coordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet *)node)->on_set_coordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->set_coordIndex;
		return M4OK;
	case 2:
		info->name = "set_normalIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet *)node)->on_set_normalIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->set_normalIndex;
		return M4OK;
	case 3:
		info->name = "set_texCoordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet *)node)->on_set_texCoordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->set_texCoordIndex;
		return M4OK;
	case 4:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_IndexedFaceSet *)node)->color;
		return M4OK;
	case 5:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinateNode;
		info->far_ptr = & ((B_IndexedFaceSet *)node)->coord;
		return M4OK;
	case 6:
		info->name = "normal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFNormalNode;
		info->far_ptr = & ((B_IndexedFaceSet *)node)->normal;
		return M4OK;
	case 7:
		info->name = "texCoord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureCoordinateNode;
		info->far_ptr = & ((B_IndexedFaceSet *)node)->texCoord;
		return M4OK;
	case 8:
		info->name = "ccw";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->ccw;
		return M4OK;
	case 9:
		info->name = "colorIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->colorIndex;
		return M4OK;
	case 10:
		info->name = "colorPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->colorPerVertex;
		return M4OK;
	case 11:
		info->name = "convex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->convex;
		return M4OK;
	case 12:
		info->name = "coordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->coordIndex;
		return M4OK;
	case 13:
		info->name = "creaseAngle";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->creaseAngle;
		return M4OK;
	case 14:
		info->name = "normalIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->normalIndex;
		return M4OK;
	case 15:
		info->name = "normalPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->normalPerVertex;
		return M4OK;
	case 16:
		info->name = "solid";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->solid;
		return M4OK;
	case 17:
		info->name = "texCoordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet *) node)->texCoordIndex;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool IndexedFaceSet_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 9:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 14:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 17:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *IndexedFaceSet_Create()
{
	B_IndexedFaceSet *p;
	SAFEALLOC(p, sizeof(B_IndexedFaceSet));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_IndexedFaceSet);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "IndexedFaceSet";
	((SFNode *)p)->sgprivate->node_del = IndexedFaceSet_Del;
	((SFNode *)p)->sgprivate->get_field_count = IndexedFaceSet_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = IndexedFaceSet_get_field_index;
	((SFNode *)p)->sgprivate->get_field = IndexedFaceSet_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = IndexedFaceSet_get_aq_info;

#endif


	/*default field values*/
	p->ccw = 1;
	p->colorPerVertex = 1;
	p->convex = 1;
	p->creaseAngle = (SFFloat) 0.0;
	p->normalPerVertex = 1;
	p->solid = 1;
	return (SFNode *)p;
}


/*
	IndexedFaceSet2D Node deletion
*/

static void IndexedFaceSet2D_Del(SFNode *node)
{
	B_IndexedFaceSet2D *p = (B_IndexedFaceSet2D *) node;
	MFInt32_Del(p->set_colorIndex);
	MFInt32_Del(p->set_coordIndex);
	MFInt32_Del(p->set_texCoordIndex);
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	Node_Delete((SFNode *) p->texCoord, (SFNode *) p);	
	MFInt32_Del(p->colorIndex);
	MFInt32_Del(p->coordIndex);
	MFInt32_Del(p->texCoordIndex);
	SFNode_Delete((SFNode *) p);
}

static const u16 IndexedFaceSet2D_Def2All[] = { 3, 4, 5, 6, 7, 8, 9, 10};
static const u16 IndexedFaceSet2D_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 IndexedFaceSet2D_Out2All[] = { 3, 4, 5};

static u32 IndexedFaceSet2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 8;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 11;
	}
}

static M4Err IndexedFaceSet2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = IndexedFaceSet2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = IndexedFaceSet2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = IndexedFaceSet2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err IndexedFaceSet2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_colorIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet2D *)node)->on_set_colorIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->set_colorIndex;
		return M4OK;
	case 1:
		info->name = "set_coordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet2D *)node)->on_set_coordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->set_coordIndex;
		return M4OK;
	case 2:
		info->name = "set_texCoordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedFaceSet2D *)node)->on_set_texCoordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->set_texCoordIndex;
		return M4OK;
	case 3:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_IndexedFaceSet2D *)node)->color;
		return M4OK;
	case 4:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinate2DNode;
		info->far_ptr = & ((B_IndexedFaceSet2D *)node)->coord;
		return M4OK;
	case 5:
		info->name = "texCoord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureCoordinateNode;
		info->far_ptr = & ((B_IndexedFaceSet2D *)node)->texCoord;
		return M4OK;
	case 6:
		info->name = "colorIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->colorIndex;
		return M4OK;
	case 7:
		info->name = "colorPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->colorPerVertex;
		return M4OK;
	case 8:
		info->name = "convex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->convex;
		return M4OK;
	case 9:
		info->name = "coordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->coordIndex;
		return M4OK;
	case 10:
		info->name = "texCoordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedFaceSet2D *) node)->texCoordIndex;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool IndexedFaceSet2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 6:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *IndexedFaceSet2D_Create()
{
	B_IndexedFaceSet2D *p;
	SAFEALLOC(p, sizeof(B_IndexedFaceSet2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_IndexedFaceSet2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "IndexedFaceSet2D";
	((SFNode *)p)->sgprivate->node_del = IndexedFaceSet2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = IndexedFaceSet2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = IndexedFaceSet2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = IndexedFaceSet2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = IndexedFaceSet2D_get_aq_info;

#endif


	/*default field values*/
	p->colorPerVertex = 1;
	p->convex = 1;
	return (SFNode *)p;
}


/*
	IndexedLineSet Node deletion
*/

static void IndexedLineSet_Del(SFNode *node)
{
	B_IndexedLineSet *p = (B_IndexedLineSet *) node;
	MFInt32_Del(p->set_colorIndex);
	MFInt32_Del(p->set_coordIndex);
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	MFInt32_Del(p->colorIndex);
	MFInt32_Del(p->coordIndex);
	SFNode_Delete((SFNode *) p);
}

static const u16 IndexedLineSet_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 IndexedLineSet_In2All[] = { 0, 1, 2, 3};
static const u16 IndexedLineSet_Out2All[] = { 2, 3};

static u32 IndexedLineSet_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 5;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err IndexedLineSet_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = IndexedLineSet_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = IndexedLineSet_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = IndexedLineSet_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err IndexedLineSet_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_colorIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedLineSet *)node)->on_set_colorIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet *) node)->set_colorIndex;
		return M4OK;
	case 1:
		info->name = "set_coordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedLineSet *)node)->on_set_coordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet *) node)->set_coordIndex;
		return M4OK;
	case 2:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_IndexedLineSet *)node)->color;
		return M4OK;
	case 3:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinateNode;
		info->far_ptr = & ((B_IndexedLineSet *)node)->coord;
		return M4OK;
	case 4:
		info->name = "colorIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet *) node)->colorIndex;
		return M4OK;
	case 5:
		info->name = "colorPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedLineSet *) node)->colorPerVertex;
		return M4OK;
	case 6:
		info->name = "coordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet *) node)->coordIndex;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool IndexedLineSet_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *IndexedLineSet_Create()
{
	B_IndexedLineSet *p;
	SAFEALLOC(p, sizeof(B_IndexedLineSet));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_IndexedLineSet);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "IndexedLineSet";
	((SFNode *)p)->sgprivate->node_del = IndexedLineSet_Del;
	((SFNode *)p)->sgprivate->get_field_count = IndexedLineSet_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = IndexedLineSet_get_field_index;
	((SFNode *)p)->sgprivate->get_field = IndexedLineSet_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = IndexedLineSet_get_aq_info;

#endif


	/*default field values*/
	p->colorPerVertex = 1;
	return (SFNode *)p;
}


/*
	IndexedLineSet2D Node deletion
*/

static void IndexedLineSet2D_Del(SFNode *node)
{
	B_IndexedLineSet2D *p = (B_IndexedLineSet2D *) node;
	MFInt32_Del(p->set_colorIndex);
	MFInt32_Del(p->set_coordIndex);
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	MFInt32_Del(p->colorIndex);
	MFInt32_Del(p->coordIndex);
	SFNode_Delete((SFNode *) p);
}

static const u16 IndexedLineSet2D_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 IndexedLineSet2D_In2All[] = { 0, 1, 2, 3};
static const u16 IndexedLineSet2D_Out2All[] = { 2, 3};

static u32 IndexedLineSet2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 5;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err IndexedLineSet2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = IndexedLineSet2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = IndexedLineSet2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = IndexedLineSet2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err IndexedLineSet2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_colorIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedLineSet2D *)node)->on_set_colorIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet2D *) node)->set_colorIndex;
		return M4OK;
	case 1:
		info->name = "set_coordIndex";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_IndexedLineSet2D *)node)->on_set_coordIndex;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet2D *) node)->set_coordIndex;
		return M4OK;
	case 2:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_IndexedLineSet2D *)node)->color;
		return M4OK;
	case 3:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinate2DNode;
		info->far_ptr = & ((B_IndexedLineSet2D *)node)->coord;
		return M4OK;
	case 4:
		info->name = "colorIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet2D *) node)->colorIndex;
		return M4OK;
	case 5:
		info->name = "colorPerVertex";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_IndexedLineSet2D *) node)->colorPerVertex;
		return M4OK;
	case 6:
		info->name = "coordIndex";
		info->eventType = ET_Field;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_IndexedLineSet2D *) node)->coordIndex;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool IndexedLineSet2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 14;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *IndexedLineSet2D_Create()
{
	B_IndexedLineSet2D *p;
	SAFEALLOC(p, sizeof(B_IndexedLineSet2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_IndexedLineSet2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "IndexedLineSet2D";
	((SFNode *)p)->sgprivate->node_del = IndexedLineSet2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = IndexedLineSet2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = IndexedLineSet2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = IndexedLineSet2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = IndexedLineSet2D_get_aq_info;

#endif


	/*default field values*/
	p->colorPerVertex = 1;
	return (SFNode *)p;
}


/*
	Inline Node deletion
*/

static void Inline_Del(SFNode *node)
{
	B_Inline *p = (B_Inline *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 Inline_Def2All[] = { 0};
static const u16 Inline_In2All[] = { 0};
static const u16 Inline_Out2All[] = { 0};

static u32 Inline_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 1;
	}
}

static M4Err Inline_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Inline_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Inline_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Inline_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Inline_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Inline *) node)->url;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Inline_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Inline_Create()
{
	B_Inline *p;
	SAFEALLOC(p, sizeof(B_Inline));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Inline);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Inline";
	((SFNode *)p)->sgprivate->node_del = Inline_Del;
	((SFNode *)p)->sgprivate->get_field_count = Inline_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Inline_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Inline_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Inline_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	LOD Node deletion
*/

static void LOD_Del(SFNode *node)
{
	B_LOD *p = (B_LOD *) node;
	NodeList_Delete((Chain *) p->level, (SFNode *) p);	
	MFFloat_Del(p->range);
	SFNode_Delete((SFNode *) p);
}

static const u16 LOD_Def2All[] = { 0, 1, 2};
static const u16 LOD_In2All[] = { 0};
static const u16 LOD_Out2All[] = { 0};

static u32 LOD_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 3;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err LOD_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = LOD_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = LOD_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = LOD_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err LOD_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "level";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_LOD *)node)->level;
		return M4OK;
	case 1:
		info->name = "center";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_LOD *) node)->center;
		return M4OK;
	case 2:
		info->name = "range";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_LOD *) node)->range;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool LOD_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *LOD_Create()
{
	B_LOD *p;
	SAFEALLOC(p, sizeof(B_LOD));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_LOD);
	p->level = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "LOD";
	((SFNode *)p)->sgprivate->node_del = LOD_Del;
	((SFNode *)p)->sgprivate->get_field_count = LOD_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = LOD_get_field_index;
	((SFNode *)p)->sgprivate->get_field = LOD_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = LOD_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->center.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Layer2D Node deletion
*/

static void Layer2D_Del(SFNode *node)
{
	B_Layer2D *p = (B_Layer2D *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->background, (SFNode *) p);	
	Node_Delete((SFNode *) p->viewport, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Layer2D_Def2All[] = { 2, 3, 4, 5};
static const u16 Layer2D_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Layer2D_Out2All[] = { 2, 3, 4, 5};
static const u16 Layer2D_Dyn2All[] = { 3};

static u32 Layer2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 1;
	default:
		return 6;
	}
}

static M4Err Layer2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Layer2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Layer2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Layer2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Layer2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Layer2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layer2D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layer2D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layer2D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layer2D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layer2D *)node)->children;
		return M4OK;
	case 3:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Layer2D *) node)->size;
		return M4OK;
	case 4:
		info->name = "background";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBackground2DNode;
		info->far_ptr = & ((B_Layer2D *)node)->background;
		return M4OK;
	case 5:
		info->name = "viewport";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFViewportNode;
		info->far_ptr = & ((B_Layer2D *)node)->viewport;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Layer2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 12;
		*QType = 12;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Layer2D_Create()
{
	B_Layer2D *p;
	SAFEALLOC(p, sizeof(B_Layer2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Layer2D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Layer2D";
	((SFNode *)p)->sgprivate->node_del = Layer2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Layer2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Layer2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Layer2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Layer2D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->size.x = (SFFloat) -1;
	p->size.y = (SFFloat) -1;
	return (SFNode *)p;
}


/*
	Layer3D Node deletion
*/

static void Layer3D_Del(SFNode *node)
{
	B_Layer3D *p = (B_Layer3D *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->background, (SFNode *) p);	
	Node_Delete((SFNode *) p->fog, (SFNode *) p);	
	Node_Delete((SFNode *) p->navigationInfo, (SFNode *) p);	
	Node_Delete((SFNode *) p->viewpoint, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Layer3D_Def2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Layer3D_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 Layer3D_Out2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Layer3D_Dyn2All[] = { 3};

static u32 Layer3D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 1;
	default:
		return 8;
	}
}

static M4Err Layer3D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Layer3D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Layer3D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Layer3D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Layer3D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Layer3D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layer3D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Layer3D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layer3D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Layer3D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Layer3D *)node)->children;
		return M4OK;
	case 3:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Layer3D *) node)->size;
		return M4OK;
	case 4:
		info->name = "background";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBackground3DNode;
		info->far_ptr = & ((B_Layer3D *)node)->background;
		return M4OK;
	case 5:
		info->name = "fog";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFogNode;
		info->far_ptr = & ((B_Layer3D *)node)->fog;
		return M4OK;
	case 6:
		info->name = "navigationInfo";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFNavigationInfoNode;
		info->far_ptr = & ((B_Layer3D *)node)->navigationInfo;
		return M4OK;
	case 7:
		info->name = "viewpoint";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFViewpointNode;
		info->far_ptr = & ((B_Layer3D *)node)->viewpoint;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Layer3D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 12;
		*QType = 12;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Layer3D_Create()
{
	B_Layer3D *p;
	SAFEALLOC(p, sizeof(B_Layer3D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Layer3D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Layer3D";
	((SFNode *)p)->sgprivate->node_del = Layer3D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Layer3D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Layer3D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Layer3D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Layer3D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->size.x = (SFFloat) -1;
	p->size.y = (SFFloat) -1;
	return (SFNode *)p;
}


/*
	Layout Node deletion
*/

static void Layout_Del(SFNode *node)
{
	B_Layout *p = (B_Layout *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFString_Del(p->justify);
	SFNode_Delete((SFNode *) p);
}

static const u16 Layout_Def2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
static const u16 Layout_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
static const u16 Layout_Out2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
static const u16 Layout_Dyn2All[] = { 4, 9, 13};

static u32 Layout_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 14;
	case FCM_DEF: return 12;
	case FCM_OUT: return 12;
	case FCM_DYN: return 3;
	default:
		return 14;
	}
}

static M4Err Layout_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Layout_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Layout_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Layout_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Layout_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Layout_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layout *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layout *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Layout *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layout *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Layout *)node)->children;
		return M4OK;
	case 3:
		info->name = "wrap";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->wrap;
		return M4OK;
	case 4:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Layout *) node)->size;
		return M4OK;
	case 5:
		info->name = "horizontal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->horizontal;
		return M4OK;
	case 6:
		info->name = "justify";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Layout *) node)->justify;
		return M4OK;
	case 7:
		info->name = "leftToRight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->leftToRight;
		return M4OK;
	case 8:
		info->name = "topToBottom";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->topToBottom;
		return M4OK;
	case 9:
		info->name = "spacing";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Layout *) node)->spacing;
		return M4OK;
	case 10:
		info->name = "smoothScroll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->smoothScroll;
		return M4OK;
	case 11:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->loop;
		return M4OK;
	case 12:
		info->name = "scrollVertical";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Layout *) node)->scrollVertical;
		return M4OK;
	case 13:
		info->name = "scrollRate";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Layout *) node)->scrollRate;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Layout_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 12;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Layout_Create()
{
	B_Layout *p;
	SAFEALLOC(p, sizeof(B_Layout));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Layout);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Layout";
	((SFNode *)p)->sgprivate->node_del = Layout_Del;
	((SFNode *)p)->sgprivate->get_field_count = Layout_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Layout_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Layout_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Layout_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->size.x = (SFFloat) -1;
	p->size.y = (SFFloat) -1;
	p->horizontal = 1;
	p->justify.vals = malloc(sizeof(SFString)*1);
	p->justify.count = 1;
	p->justify.vals[0] = malloc(sizeof(char) * 6);
	strcpy(p->justify.vals[0], "BEGIN");
	p->leftToRight = 1;
	p->topToBottom = 1;
	p->spacing = (SFFloat) 1;
	p->scrollVertical = 1;
	p->scrollRate = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	LineProperties Node deletion
*/

static void LineProperties_Del(SFNode *node)
{
	B_LineProperties *p = (B_LineProperties *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 LineProperties_Def2All[] = { 0, 1, 2};
static const u16 LineProperties_In2All[] = { 0, 1, 2};
static const u16 LineProperties_Out2All[] = { 0, 1, 2};
static const u16 LineProperties_Dyn2All[] = { 0, 2};

static u32 LineProperties_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 2;
	default:
		return 3;
	}
}

static M4Err LineProperties_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = LineProperties_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = LineProperties_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = LineProperties_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = LineProperties_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err LineProperties_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "lineColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_LineProperties *) node)->lineColor;
		return M4OK;
	case 1:
		info->name = "lineStyle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_LineProperties *) node)->lineStyle;
		return M4OK;
	case 2:
		info->name = "width";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_LineProperties *) node)->width;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool LineProperties_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 5;
		return 1;
	case 2:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *LineProperties_Create()
{
	B_LineProperties *p;
	SAFEALLOC(p, sizeof(B_LineProperties));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_LineProperties);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "LineProperties";
	((SFNode *)p)->sgprivate->node_del = LineProperties_Del;
	((SFNode *)p)->sgprivate->get_field_count = LineProperties_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = LineProperties_get_field_index;
	((SFNode *)p)->sgprivate->get_field = LineProperties_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = LineProperties_get_aq_info;

#endif


	/*default field values*/
	p->lineColor.red = (SFFloat) 0;
	p->lineColor.green = (SFFloat) 0;
	p->lineColor.blue = (SFFloat) 0;
	p->lineStyle = 0;
	p->width = (SFFloat) 1;
	return (SFNode *)p;
}


/*
	ListeningPoint Node deletion
*/

static void ListeningPoint_Del(SFNode *node)
{
	B_ListeningPoint *p = (B_ListeningPoint *) node;
	SFString_Del(p->description);
	SFNode_Delete((SFNode *) p);
}

static const u16 ListeningPoint_Def2All[] = { 1, 2, 3, 4};
static const u16 ListeningPoint_In2All[] = { 0, 1, 2, 3};
static const u16 ListeningPoint_Out2All[] = { 1, 2, 3, 5, 6};
static const u16 ListeningPoint_Dyn2All[] = { 2, 3};

static u32 ListeningPoint_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 5;
	case FCM_DYN: return 2;
	default:
		return 7;
	}
}

static M4Err ListeningPoint_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ListeningPoint_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ListeningPoint_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ListeningPoint_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = ListeningPoint_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ListeningPoint_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ListeningPoint *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ListeningPoint *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "jump";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ListeningPoint *) node)->jump;
		return M4OK;
	case 2:
		info->name = "orientation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_ListeningPoint *) node)->orientation;
		return M4OK;
	case 3:
		info->name = "position";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_ListeningPoint *) node)->position;
		return M4OK;
	case 4:
		info->name = "description";
		info->eventType = ET_Field;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_ListeningPoint *) node)->description;
		return M4OK;
	case 5:
		info->name = "bindTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ListeningPoint *) node)->bindTime;
		return M4OK;
	case 6:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ListeningPoint *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ListeningPoint_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 10;
		*QType = 10;
		return 1;
	case 3:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ListeningPoint_Create()
{
	B_ListeningPoint *p;
	SAFEALLOC(p, sizeof(B_ListeningPoint));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ListeningPoint);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ListeningPoint";
	((SFNode *)p)->sgprivate->node_del = ListeningPoint_Del;
	((SFNode *)p)->sgprivate->get_field_count = ListeningPoint_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ListeningPoint_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ListeningPoint_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ListeningPoint_get_aq_info;

#endif


	/*default field values*/
	p->jump = 1;
	p->orientation.xAxis = (SFFloat) 0;
	p->orientation.yAxis = (SFFloat) 0;
	p->orientation.zAxis = (SFFloat) 1;
	p->orientation.angle = (SFFloat) 0;
	p->position.x = (SFFloat) 0;
	p->position.y = (SFFloat) 0;
	p->position.z = (SFFloat) 10;
	return (SFNode *)p;
}


/*
	Material Node deletion
*/

static void Material_Del(SFNode *node)
{
	B_Material *p = (B_Material *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Material_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Material_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Material_Out2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Material_Dyn2All[] = { 0, 1, 2, 3, 4, 5};

static u32 Material_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 6;
	default:
		return 6;
	}
}

static M4Err Material_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Material_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Material_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Material_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Material_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Material_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "ambientIntensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Material *) node)->ambientIntensity;
		return M4OK;
	case 1:
		info->name = "diffuseColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Material *) node)->diffuseColor;
		return M4OK;
	case 2:
		info->name = "emissiveColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Material *) node)->emissiveColor;
		return M4OK;
	case 3:
		info->name = "shininess";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Material *) node)->shininess;
		return M4OK;
	case 4:
		info->name = "specularColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Material *) node)->specularColor;
		return M4OK;
	case 5:
		info->name = "transparency";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Material *) node)->transparency;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Material_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Material_Create()
{
	B_Material *p;
	SAFEALLOC(p, sizeof(B_Material));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Material);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Material";
	((SFNode *)p)->sgprivate->node_del = Material_Del;
	((SFNode *)p)->sgprivate->get_field_count = Material_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Material_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Material_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Material_get_aq_info;

#endif


	/*default field values*/
	p->ambientIntensity = (SFFloat) 0.2;
	p->diffuseColor.red = (SFFloat) 0.8;
	p->diffuseColor.green = (SFFloat) 0.8;
	p->diffuseColor.blue = (SFFloat) 0.8;
	p->emissiveColor.red = (SFFloat) 0;
	p->emissiveColor.green = (SFFloat) 0;
	p->emissiveColor.blue = (SFFloat) 0;
	p->shininess = (SFFloat) 0.2;
	p->specularColor.red = (SFFloat) 0;
	p->specularColor.green = (SFFloat) 0;
	p->specularColor.blue = (SFFloat) 0;
	p->transparency = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Material2D Node deletion
*/

static void Material2D_Del(SFNode *node)
{
	B_Material2D *p = (B_Material2D *) node;
	Node_Delete((SFNode *) p->lineProps, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Material2D_Def2All[] = { 0, 1, 2, 3};
static const u16 Material2D_In2All[] = { 0, 1, 2, 3};
static const u16 Material2D_Out2All[] = { 0, 1, 2, 3};
static const u16 Material2D_Dyn2All[] = { 0, 3};

static u32 Material2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 2;
	default:
		return 4;
	}
}

static M4Err Material2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Material2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Material2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Material2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Material2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Material2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "emissiveColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Material2D *) node)->emissiveColor;
		return M4OK;
	case 1:
		info->name = "filled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Material2D *) node)->filled;
		return M4OK;
	case 2:
		info->name = "lineProps";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFLinePropertiesNode;
		info->far_ptr = & ((B_Material2D *)node)->lineProps;
		return M4OK;
	case 3:
		info->name = "transparency";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Material2D *) node)->transparency;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Material2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Material2D_Create()
{
	B_Material2D *p;
	SAFEALLOC(p, sizeof(B_Material2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Material2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Material2D";
	((SFNode *)p)->sgprivate->node_del = Material2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Material2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Material2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Material2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Material2D_get_aq_info;

#endif


	/*default field values*/
	p->emissiveColor.red = (SFFloat) 0.8;
	p->emissiveColor.green = (SFFloat) 0.8;
	p->emissiveColor.blue = (SFFloat) 0.8;
	p->transparency = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	MovieTexture Node deletion
*/

static void MovieTexture_Del(SFNode *node)
{
	B_MovieTexture *p = (B_MovieTexture *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 MovieTexture_Def2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 MovieTexture_In2All[] = { 0, 1, 2, 3, 4};
static const u16 MovieTexture_Out2All[] = { 0, 1, 2, 3, 4, 7, 8};
static const u16 MovieTexture_Dyn2All[] = { 1};

static u32 MovieTexture_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 1;
	default:
		return 9;
	}
}

static M4Err MovieTexture_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MovieTexture_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MovieTexture_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MovieTexture_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = MovieTexture_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MovieTexture_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MovieTexture *) node)->loop;
		return M4OK;
	case 1:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MovieTexture *) node)->speed;
		return M4OK;
	case 2:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MovieTexture *) node)->startTime;
		return M4OK;
	case 3:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MovieTexture *) node)->stopTime;
		return M4OK;
	case 4:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_MovieTexture *) node)->url;
		return M4OK;
	case 5:
		info->name = "repeatS";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MovieTexture *) node)->repeatS;
		return M4OK;
	case 6:
		info->name = "repeatT";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MovieTexture *) node)->repeatT;
		return M4OK;
	case 7:
		info->name = "duration_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MovieTexture *) node)->duration_changed;
		return M4OK;
	case 8:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MovieTexture *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MovieTexture_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *MovieTexture_Create()
{
	B_MovieTexture *p;
	SAFEALLOC(p, sizeof(B_MovieTexture));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MovieTexture);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MovieTexture";
	((SFNode *)p)->sgprivate->node_del = MovieTexture_Del;
	((SFNode *)p)->sgprivate->get_field_count = MovieTexture_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MovieTexture_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MovieTexture_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MovieTexture_get_aq_info;

#endif


	/*default field values*/
	p->speed = (SFFloat) 1.0;
	p->startTime = 0;
	p->stopTime = 0;
	p->repeatS = 1;
	p->repeatT = 1;
	return (SFNode *)p;
}


/*
	NavigationInfo Node deletion
*/

static void NavigationInfo_Del(SFNode *node)
{
	B_NavigationInfo *p = (B_NavigationInfo *) node;
	MFFloat_Del(p->avatarSize);
	MFString_Del(p->type);
	SFNode_Delete((SFNode *) p);
}

static const u16 NavigationInfo_Def2All[] = { 1, 2, 3, 4, 5};
static const u16 NavigationInfo_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 NavigationInfo_Out2All[] = { 1, 2, 3, 4, 5, 6};
static const u16 NavigationInfo_Dyn2All[] = { 5};

static u32 NavigationInfo_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 5;
	case FCM_OUT: return 6;
	case FCM_DYN: return 1;
	default:
		return 7;
	}
}

static M4Err NavigationInfo_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = NavigationInfo_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = NavigationInfo_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = NavigationInfo_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = NavigationInfo_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err NavigationInfo_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_NavigationInfo *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_NavigationInfo *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "avatarSize";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_NavigationInfo *) node)->avatarSize;
		return M4OK;
	case 2:
		info->name = "headlight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_NavigationInfo *) node)->headlight;
		return M4OK;
	case 3:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_NavigationInfo *) node)->speed;
		return M4OK;
	case 4:
		info->name = "type";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_NavigationInfo *) node)->type;
		return M4OK;
	case 5:
		info->name = "visibilityLimit";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_NavigationInfo *) node)->visibilityLimit;
		return M4OK;
	case 6:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_NavigationInfo *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool NavigationInfo_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *NavigationInfo_Create()
{
	B_NavigationInfo *p;
	SAFEALLOC(p, sizeof(B_NavigationInfo));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_NavigationInfo);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "NavigationInfo";
	((SFNode *)p)->sgprivate->node_del = NavigationInfo_Del;
	((SFNode *)p)->sgprivate->get_field_count = NavigationInfo_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = NavigationInfo_get_field_index;
	((SFNode *)p)->sgprivate->get_field = NavigationInfo_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = NavigationInfo_get_aq_info;

#endif


	/*default field values*/
	p->avatarSize.vals = malloc(sizeof(SFFloat)*3);
	p->avatarSize.count = 3;
	p->avatarSize.vals[0] = (SFFloat) 0.25;
	p->avatarSize.vals[1] = (SFFloat) 1.6;
	p->avatarSize.vals[2] = (SFFloat) 0.75;
	p->headlight = 1;
	p->speed = (SFFloat) 1.0;
	p->type.vals = malloc(sizeof(SFString)*2);
	p->type.count = 2;
	p->type.vals[0] = malloc(sizeof(char) * 5);
	strcpy(p->type.vals[0], "WALK");
	p->type.vals[1] = malloc(sizeof(char) * 4);
	strcpy(p->type.vals[1], "ANY");
	p->visibilityLimit = (SFFloat) 0.0;
	return (SFNode *)p;
}


/*
	Normal Node deletion
*/

static void Normal_Del(SFNode *node)
{
	B_Normal *p = (B_Normal *) node;
	MFVec3f_Del(p->vector);
	SFNode_Delete((SFNode *) p);
}

static const u16 Normal_Def2All[] = { 0};
static const u16 Normal_In2All[] = { 0};
static const u16 Normal_Out2All[] = { 0};
static const u16 Normal_Dyn2All[] = { 0};

static u32 Normal_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Normal_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Normal_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Normal_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Normal_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Normal_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Normal_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "vector";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Normal *) node)->vector;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Normal_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 9;
		*QType = 9;
		return 1;
	default:
		return 0;
	}
}



SFNode *Normal_Create()
{
	B_Normal *p;
	SAFEALLOC(p, sizeof(B_Normal));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Normal);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Normal";
	((SFNode *)p)->sgprivate->node_del = Normal_Del;
	((SFNode *)p)->sgprivate->get_field_count = Normal_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Normal_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Normal_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Normal_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	NormalInterpolator Node deletion
*/

static void NormalInterpolator_Del(SFNode *node)
{
	B_NormalInterpolator *p = (B_NormalInterpolator *) node;
	MFFloat_Del(p->key);
	MFVec3f_Del(p->keyValue);
	MFVec3f_Del(p->value_changed);
	SFNode_Delete((SFNode *) p);
}

static const u16 NormalInterpolator_Def2All[] = { 1, 2};
static const u16 NormalInterpolator_In2All[] = { 0, 1, 2};
static const u16 NormalInterpolator_Out2All[] = { 1, 2, 3};

static u32 NormalInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err NormalInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = NormalInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = NormalInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = NormalInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err NormalInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_NormalInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_NormalInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_NormalInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_NormalInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_NormalInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool NormalInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 9;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *NormalInterpolator_Create()
{
	B_NormalInterpolator *p;
	SAFEALLOC(p, sizeof(B_NormalInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_NormalInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "NormalInterpolator";
	((SFNode *)p)->sgprivate->node_del = NormalInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = NormalInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = NormalInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = NormalInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = NormalInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	OrderedGroup Node deletion
*/

static void OrderedGroup_Del(SFNode *node)
{
	B_OrderedGroup *p = (B_OrderedGroup *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFFloat_Del(p->order);
	SFNode_Delete((SFNode *) p);
}

static const u16 OrderedGroup_Def2All[] = { 2, 3};
static const u16 OrderedGroup_In2All[] = { 0, 1, 2, 3};
static const u16 OrderedGroup_Out2All[] = { 2, 3};

static u32 OrderedGroup_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err OrderedGroup_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = OrderedGroup_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = OrderedGroup_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = OrderedGroup_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err OrderedGroup_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_OrderedGroup *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_OrderedGroup *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_OrderedGroup *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_OrderedGroup *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_OrderedGroup *)node)->children;
		return M4OK;
	case 3:
		info->name = "order";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_OrderedGroup *) node)->order;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool OrderedGroup_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 0;
		*QType = 3;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *OrderedGroup_Create()
{
	B_OrderedGroup *p;
	SAFEALLOC(p, sizeof(B_OrderedGroup));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_OrderedGroup);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "OrderedGroup";
	((SFNode *)p)->sgprivate->node_del = OrderedGroup_Del;
	((SFNode *)p)->sgprivate->get_field_count = OrderedGroup_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = OrderedGroup_get_field_index;
	((SFNode *)p)->sgprivate->get_field = OrderedGroup_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = OrderedGroup_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	OrientationInterpolator Node deletion
*/

static void OrientationInterpolator_Del(SFNode *node)
{
	B_OrientationInterpolator *p = (B_OrientationInterpolator *) node;
	MFFloat_Del(p->key);
	MFRotation_Del(p->keyValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 OrientationInterpolator_Def2All[] = { 1, 2};
static const u16 OrientationInterpolator_In2All[] = { 0, 1, 2};
static const u16 OrientationInterpolator_Out2All[] = { 1, 2, 3};

static u32 OrientationInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err OrientationInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = OrientationInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = OrientationInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = OrientationInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err OrientationInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_OrientationInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_OrientationInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_OrientationInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_OrientationInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_OrientationInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool OrientationInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 10;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *OrientationInterpolator_Create()
{
	B_OrientationInterpolator *p;
	SAFEALLOC(p, sizeof(B_OrientationInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_OrientationInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "OrientationInterpolator";
	((SFNode *)p)->sgprivate->node_del = OrientationInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = OrientationInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = OrientationInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = OrientationInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = OrientationInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	PixelTexture Node deletion
*/

static void PixelTexture_Del(SFNode *node)
{
	B_PixelTexture *p = (B_PixelTexture *) node;
	SFImage_Del(p->image);
	SFNode_Delete((SFNode *) p);
}

static const u16 PixelTexture_Def2All[] = { 0, 1, 2};
static const u16 PixelTexture_In2All[] = { 0};
static const u16 PixelTexture_Out2All[] = { 0};

static u32 PixelTexture_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 3;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err PixelTexture_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PixelTexture_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PixelTexture_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PixelTexture_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PixelTexture_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "image";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFImage;
		info->far_ptr = & ((B_PixelTexture *) node)->image;
		return M4OK;
	case 1:
		info->name = "repeatS";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PixelTexture *) node)->repeatS;
		return M4OK;
	case 2:
		info->name = "repeatT";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PixelTexture *) node)->repeatT;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PixelTexture_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 0;
		return 1;
	default:
		return 0;
	}
}



SFNode *PixelTexture_Create()
{
	B_PixelTexture *p;
	SAFEALLOC(p, sizeof(B_PixelTexture));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PixelTexture);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PixelTexture";
	((SFNode *)p)->sgprivate->node_del = PixelTexture_Del;
	((SFNode *)p)->sgprivate->get_field_count = PixelTexture_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PixelTexture_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PixelTexture_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PixelTexture_get_aq_info;

#endif


	/*default field values*/
	p->repeatS = 1;
	p->repeatT = 1;
	return (SFNode *)p;
}


/*
	PlaneSensor Node deletion
*/

static void PlaneSensor_Del(SFNode *node)
{
	B_PlaneSensor *p = (B_PlaneSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 PlaneSensor_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 PlaneSensor_In2All[] = { 0, 1, 2, 3, 4};
static const u16 PlaneSensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};

static u32 PlaneSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 8;
	case FCM_DYN: return 0;
	default:
		return 8;
	}
}

static M4Err PlaneSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PlaneSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PlaneSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PlaneSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PlaneSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "autoOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor *) node)->autoOffset;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "maxPosition";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor *) node)->maxPosition;
		return M4OK;
	case 3:
		info->name = "minPosition";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor *) node)->minPosition;
		return M4OK;
	case 4:
		info->name = "offset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PlaneSensor *) node)->offset;
		return M4OK;
	case 5:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor *) node)->isActive;
		return M4OK;
	case 6:
		info->name = "trackPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PlaneSensor *) node)->trackPoint_changed;
		return M4OK;
	case 7:
		info->name = "translation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PlaneSensor *) node)->translation_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PlaneSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PlaneSensor_Create()
{
	B_PlaneSensor *p;
	SAFEALLOC(p, sizeof(B_PlaneSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PlaneSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PlaneSensor";
	((SFNode *)p)->sgprivate->node_del = PlaneSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = PlaneSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PlaneSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PlaneSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PlaneSensor_get_aq_info;

#endif


	/*default field values*/
	p->autoOffset = 1;
	p->enabled = 1;
	p->maxPosition.x = (SFFloat) -1;
	p->maxPosition.y = (SFFloat) -1;
	p->minPosition.x = (SFFloat) 0;
	p->minPosition.y = (SFFloat) 0;
	p->offset.x = (SFFloat) 0;
	p->offset.y = (SFFloat) 0;
	p->offset.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	PlaneSensor2D Node deletion
*/

static void PlaneSensor2D_Del(SFNode *node)
{
	B_PlaneSensor2D *p = (B_PlaneSensor2D *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 PlaneSensor2D_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 PlaneSensor2D_In2All[] = { 0, 1, 2, 3, 4};
static const u16 PlaneSensor2D_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};

static u32 PlaneSensor2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 8;
	case FCM_DYN: return 0;
	default:
		return 8;
	}
}

static M4Err PlaneSensor2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PlaneSensor2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PlaneSensor2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PlaneSensor2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PlaneSensor2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "autoOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->autoOffset;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "maxPosition";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->maxPosition;
		return M4OK;
	case 3:
		info->name = "minPosition";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->minPosition;
		return M4OK;
	case 4:
		info->name = "offset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->offset;
		return M4OK;
	case 5:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->isActive;
		return M4OK;
	case 6:
		info->name = "trackPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->trackPoint_changed;
		return M4OK;
	case 7:
		info->name = "translation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PlaneSensor2D *) node)->translation_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PlaneSensor2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 12;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PlaneSensor2D_Create()
{
	B_PlaneSensor2D *p;
	SAFEALLOC(p, sizeof(B_PlaneSensor2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PlaneSensor2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PlaneSensor2D";
	((SFNode *)p)->sgprivate->node_del = PlaneSensor2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = PlaneSensor2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PlaneSensor2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PlaneSensor2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PlaneSensor2D_get_aq_info;

#endif


	/*default field values*/
	p->autoOffset = 1;
	p->enabled = 1;
	p->maxPosition.x = (SFFloat) 0;
	p->maxPosition.y = (SFFloat) 0;
	p->minPosition.x = (SFFloat) 0;
	p->minPosition.y = (SFFloat) 0;
	p->offset.x = (SFFloat) 0;
	p->offset.y = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	PointLight Node deletion
*/

static void PointLight_Del(SFNode *node)
{
	B_PointLight *p = (B_PointLight *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 PointLight_Def2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 PointLight_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 PointLight_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 PointLight_Dyn2All[] = { 0, 1, 2, 3, 4, 6};

static u32 PointLight_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 6;
	default:
		return 7;
	}
}

static M4Err PointLight_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PointLight_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PointLight_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PointLight_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = PointLight_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PointLight_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "ambientIntensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PointLight *) node)->ambientIntensity;
		return M4OK;
	case 1:
		info->name = "attenuation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PointLight *) node)->attenuation;
		return M4OK;
	case 2:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_PointLight *) node)->color;
		return M4OK;
	case 3:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PointLight *) node)->intensity;
		return M4OK;
	case 4:
		info->name = "location";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PointLight *) node)->location;
		return M4OK;
	case 5:
		info->name = "on";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PointLight *) node)->on;
		return M4OK;
	case 6:
		info->name = "radius";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PointLight *) node)->radius;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PointLight_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 1;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PointLight_Create()
{
	B_PointLight *p;
	SAFEALLOC(p, sizeof(B_PointLight));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PointLight);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PointLight";
	((SFNode *)p)->sgprivate->node_del = PointLight_Del;
	((SFNode *)p)->sgprivate->get_field_count = PointLight_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PointLight_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PointLight_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PointLight_get_aq_info;

#endif


	/*default field values*/
	p->ambientIntensity = (SFFloat) 0;
	p->attenuation.x = (SFFloat) 1;
	p->attenuation.y = (SFFloat) 0;
	p->attenuation.z = (SFFloat) 0;
	p->color.red = (SFFloat) 1;
	p->color.green = (SFFloat) 1;
	p->color.blue = (SFFloat) 1;
	p->intensity = (SFFloat) 1;
	p->location.x = (SFFloat) 0;
	p->location.y = (SFFloat) 0;
	p->location.z = (SFFloat) 0;
	p->on = 1;
	p->radius = (SFFloat) 100;
	return (SFNode *)p;
}


/*
	PointSet Node deletion
*/

static void PointSet_Del(SFNode *node)
{
	B_PointSet *p = (B_PointSet *) node;
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 PointSet_Def2All[] = { 0, 1};
static const u16 PointSet_In2All[] = { 0, 1};
static const u16 PointSet_Out2All[] = { 0, 1};

static u32 PointSet_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err PointSet_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PointSet_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PointSet_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PointSet_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PointSet_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_PointSet *)node)->color;
		return M4OK;
	case 1:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinateNode;
		info->far_ptr = & ((B_PointSet *)node)->coord;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PointSet_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *PointSet_Create()
{
	B_PointSet *p;
	SAFEALLOC(p, sizeof(B_PointSet));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PointSet);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PointSet";
	((SFNode *)p)->sgprivate->node_del = PointSet_Del;
	((SFNode *)p)->sgprivate->get_field_count = PointSet_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PointSet_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PointSet_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PointSet_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	PointSet2D Node deletion
*/

static void PointSet2D_Del(SFNode *node)
{
	B_PointSet2D *p = (B_PointSet2D *) node;
	Node_Delete((SFNode *) p->color, (SFNode *) p);	
	Node_Delete((SFNode *) p->coord, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 PointSet2D_Def2All[] = { 0, 1};
static const u16 PointSet2D_In2All[] = { 0, 1};
static const u16 PointSet2D_Out2All[] = { 0, 1};

static u32 PointSet2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err PointSet2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PointSet2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PointSet2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PointSet2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PointSet2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFColorNode;
		info->far_ptr = & ((B_PointSet2D *)node)->color;
		return M4OK;
	case 1:
		info->name = "coord";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinate2DNode;
		info->far_ptr = & ((B_PointSet2D *)node)->coord;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PointSet2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *PointSet2D_Create()
{
	B_PointSet2D *p;
	SAFEALLOC(p, sizeof(B_PointSet2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PointSet2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PointSet2D";
	((SFNode *)p)->sgprivate->node_del = PointSet2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = PointSet2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PointSet2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PointSet2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PointSet2D_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	PositionInterpolator Node deletion
*/

static void PositionInterpolator_Del(SFNode *node)
{
	B_PositionInterpolator *p = (B_PositionInterpolator *) node;
	MFFloat_Del(p->key);
	MFVec3f_Del(p->keyValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 PositionInterpolator_Def2All[] = { 1, 2};
static const u16 PositionInterpolator_In2All[] = { 0, 1, 2};
static const u16 PositionInterpolator_Out2All[] = { 1, 2, 3};

static u32 PositionInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err PositionInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PositionInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PositionInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PositionInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PositionInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_PositionInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PositionInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_PositionInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_PositionInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_PositionInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PositionInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PositionInterpolator_Create()
{
	B_PositionInterpolator *p;
	SAFEALLOC(p, sizeof(B_PositionInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PositionInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PositionInterpolator";
	((SFNode *)p)->sgprivate->node_del = PositionInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = PositionInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PositionInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PositionInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PositionInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	PositionInterpolator2D Node deletion
*/

static void PositionInterpolator2D_Del(SFNode *node)
{
	B_PositionInterpolator2D *p = (B_PositionInterpolator2D *) node;
	MFFloat_Del(p->key);
	MFVec2f_Del(p->keyValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 PositionInterpolator2D_Def2All[] = { 1, 2};
static const u16 PositionInterpolator2D_In2All[] = { 0, 1, 2};
static const u16 PositionInterpolator2D_Out2All[] = { 1, 2, 3};

static u32 PositionInterpolator2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err PositionInterpolator2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PositionInterpolator2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PositionInterpolator2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PositionInterpolator2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PositionInterpolator2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_PositionInterpolator2D *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PositionInterpolator2D *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_PositionInterpolator2D *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_PositionInterpolator2D *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_PositionInterpolator2D *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PositionInterpolator2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PositionInterpolator2D_Create()
{
	B_PositionInterpolator2D *p;
	SAFEALLOC(p, sizeof(B_PositionInterpolator2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PositionInterpolator2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PositionInterpolator2D";
	((SFNode *)p)->sgprivate->node_del = PositionInterpolator2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = PositionInterpolator2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PositionInterpolator2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PositionInterpolator2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PositionInterpolator2D_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	ProximitySensor2D Node deletion
*/

static void ProximitySensor2D_Del(SFNode *node)
{
	B_ProximitySensor2D *p = (B_ProximitySensor2D *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 ProximitySensor2D_Def2All[] = { 0, 1, 2};
static const u16 ProximitySensor2D_In2All[] = { 0, 1, 2};
static const u16 ProximitySensor2D_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};

static u32 ProximitySensor2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 8;
	case FCM_DYN: return 0;
	default:
		return 8;
	}
}

static M4Err ProximitySensor2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ProximitySensor2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ProximitySensor2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ProximitySensor2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ProximitySensor2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->center;
		return M4OK;
	case 1:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->size;
		return M4OK;
	case 2:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->enabled;
		return M4OK;
	case 3:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->isActive;
		return M4OK;
	case 4:
		info->name = "position_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->position_changed;
		return M4OK;
	case 5:
		info->name = "orientation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->orientation_changed;
		return M4OK;
	case 6:
		info->name = "enterTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->enterTime;
		return M4OK;
	case 7:
		info->name = "exitTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ProximitySensor2D *) node)->exitTime;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ProximitySensor2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 2;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ProximitySensor2D_Create()
{
	B_ProximitySensor2D *p;
	SAFEALLOC(p, sizeof(B_ProximitySensor2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ProximitySensor2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ProximitySensor2D";
	((SFNode *)p)->sgprivate->node_del = ProximitySensor2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = ProximitySensor2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ProximitySensor2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ProximitySensor2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ProximitySensor2D_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->size.x = (SFFloat) 0;
	p->size.y = (SFFloat) 0;
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	ProximitySensor Node deletion
*/

static void ProximitySensor_Del(SFNode *node)
{
	B_ProximitySensor *p = (B_ProximitySensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 ProximitySensor_Def2All[] = { 0, 1, 2};
static const u16 ProximitySensor_In2All[] = { 0, 1, 2};
static const u16 ProximitySensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};

static u32 ProximitySensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 8;
	case FCM_DYN: return 0;
	default:
		return 8;
	}
}

static M4Err ProximitySensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ProximitySensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ProximitySensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ProximitySensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ProximitySensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_ProximitySensor *) node)->center;
		return M4OK;
	case 1:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_ProximitySensor *) node)->size;
		return M4OK;
	case 2:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ProximitySensor *) node)->enabled;
		return M4OK;
	case 3:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ProximitySensor *) node)->isActive;
		return M4OK;
	case 4:
		info->name = "position_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_ProximitySensor *) node)->position_changed;
		return M4OK;
	case 5:
		info->name = "orientation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_ProximitySensor *) node)->orientation_changed;
		return M4OK;
	case 6:
		info->name = "enterTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ProximitySensor *) node)->enterTime;
		return M4OK;
	case 7:
		info->name = "exitTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ProximitySensor *) node)->exitTime;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ProximitySensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ProximitySensor_Create()
{
	B_ProximitySensor *p;
	SAFEALLOC(p, sizeof(B_ProximitySensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ProximitySensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ProximitySensor";
	((SFNode *)p)->sgprivate->node_del = ProximitySensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = ProximitySensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ProximitySensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ProximitySensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ProximitySensor_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->center.z = (SFFloat) 0;
	p->size.x = (SFFloat) 0;
	p->size.y = (SFFloat) 0;
	p->size.z = (SFFloat) 0;
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	QuantizationParameter Node deletion
*/

static void QuantizationParameter_Del(SFNode *node)
{
	B_QuantizationParameter *p = (B_QuantizationParameter *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 QuantizationParameter_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};

static u32 QuantizationParameter_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 40;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 40;
	}
}

static M4Err QuantizationParameter_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = QuantizationParameter_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err QuantizationParameter_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "isLocal";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->isLocal;
		return M4OK;
	case 1:
		info->name = "position3DQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position3DQuant;
		return M4OK;
	case 2:
		info->name = "position3DMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position3DMin;
		return M4OK;
	case 3:
		info->name = "position3DMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position3DMax;
		return M4OK;
	case 4:
		info->name = "position3DNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position3DNbBits;
		return M4OK;
	case 5:
		info->name = "position2DQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position2DQuant;
		return M4OK;
	case 6:
		info->name = "position2DMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position2DMin;
		return M4OK;
	case 7:
		info->name = "position2DMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position2DMax;
		return M4OK;
	case 8:
		info->name = "position2DNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->position2DNbBits;
		return M4OK;
	case 9:
		info->name = "drawOrderQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->drawOrderQuant;
		return M4OK;
	case 10:
		info->name = "drawOrderMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->drawOrderMin;
		return M4OK;
	case 11:
		info->name = "drawOrderMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->drawOrderMax;
		return M4OK;
	case 12:
		info->name = "drawOrderNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->drawOrderNbBits;
		return M4OK;
	case 13:
		info->name = "colorQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->colorQuant;
		return M4OK;
	case 14:
		info->name = "colorMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->colorMin;
		return M4OK;
	case 15:
		info->name = "colorMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->colorMax;
		return M4OK;
	case 16:
		info->name = "colorNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->colorNbBits;
		return M4OK;
	case 17:
		info->name = "textureCoordinateQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->textureCoordinateQuant;
		return M4OK;
	case 18:
		info->name = "textureCoordinateMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->textureCoordinateMin;
		return M4OK;
	case 19:
		info->name = "textureCoordinateMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->textureCoordinateMax;
		return M4OK;
	case 20:
		info->name = "textureCoordinateNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->textureCoordinateNbBits;
		return M4OK;
	case 21:
		info->name = "angleQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->angleQuant;
		return M4OK;
	case 22:
		info->name = "angleMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->angleMin;
		return M4OK;
	case 23:
		info->name = "angleMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->angleMax;
		return M4OK;
	case 24:
		info->name = "angleNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->angleNbBits;
		return M4OK;
	case 25:
		info->name = "scaleQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->scaleQuant;
		return M4OK;
	case 26:
		info->name = "scaleMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->scaleMin;
		return M4OK;
	case 27:
		info->name = "scaleMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->scaleMax;
		return M4OK;
	case 28:
		info->name = "scaleNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->scaleNbBits;
		return M4OK;
	case 29:
		info->name = "keyQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->keyQuant;
		return M4OK;
	case 30:
		info->name = "keyMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->keyMin;
		return M4OK;
	case 31:
		info->name = "keyMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->keyMax;
		return M4OK;
	case 32:
		info->name = "keyNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->keyNbBits;
		return M4OK;
	case 33:
		info->name = "normalQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->normalQuant;
		return M4OK;
	case 34:
		info->name = "normalNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->normalNbBits;
		return M4OK;
	case 35:
		info->name = "sizeQuant";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->sizeQuant;
		return M4OK;
	case 36:
		info->name = "sizeMin";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->sizeMin;
		return M4OK;
	case 37:
		info->name = "sizeMax";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_QuantizationParameter *) node)->sizeMax;
		return M4OK;
	case 38:
		info->name = "sizeNbBits";
		info->eventType = ET_Field;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_QuantizationParameter *) node)->sizeNbBits;
		return M4OK;
	case 39:
		info->name = "useEfficientCoding";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_QuantizationParameter *) node)->useEfficientCoding;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool QuantizationParameter_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 6:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 10:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 14:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 15:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 16:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 18:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 19:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 20:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 22:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 23:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 24:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 26:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 27:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 28:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 30:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 31:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 32:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 34:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 36:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 37:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 38:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	default:
		return 0;
	}
}



SFNode *QuantizationParameter_Create()
{
	B_QuantizationParameter *p;
	SAFEALLOC(p, sizeof(B_QuantizationParameter));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_QuantizationParameter);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "QuantizationParameter";
	((SFNode *)p)->sgprivate->node_del = QuantizationParameter_Del;
	((SFNode *)p)->sgprivate->get_field_count = QuantizationParameter_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = QuantizationParameter_get_field_index;
	((SFNode *)p)->sgprivate->get_field = QuantizationParameter_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = QuantizationParameter_get_aq_info;

#endif


	/*default field values*/
	p->position3DMin.x = (SFFloat) M4_MIN_FLOAT;
	p->position3DMin.y = (SFFloat) M4_MIN_FLOAT;
	p->position3DMin.z = (SFFloat) M4_MIN_FLOAT;
	p->position3DMax.x = (SFFloat) M4_MAX_FLOAT;
	p->position3DMax.y = (SFFloat) M4_MAX_FLOAT;
	p->position3DMax.z = (SFFloat) M4_MAX_FLOAT;
	p->position3DNbBits = 16;
	p->position2DMin.x = (SFFloat) M4_MIN_FLOAT;
	p->position2DMin.y = (SFFloat) M4_MIN_FLOAT;
	p->position2DMax.x = (SFFloat) M4_MAX_FLOAT;
	p->position2DMax.y = (SFFloat) M4_MAX_FLOAT;
	p->position2DNbBits = 16;
	p->drawOrderMin = (SFFloat) M4_MIN_FLOAT;
	p->drawOrderMax = (SFFloat) M4_MAX_FLOAT;
	p->drawOrderNbBits = 8;
	p->colorQuant = 1;
	p->colorMin = (SFFloat) 0.0;
	p->colorMax = (SFFloat) 1.0;
	p->colorNbBits = 8;
	p->textureCoordinateQuant = 1;
	p->textureCoordinateMin = (SFFloat) 0;
	p->textureCoordinateMax = (SFFloat) 1;
	p->textureCoordinateNbBits = 16;
	p->angleQuant = 1;
	p->angleMin = (SFFloat) 0.0;
	p->angleMax = (SFFloat) 6.2831853;
	p->angleNbBits = 16;
	p->scaleMin = (SFFloat) 0.0;
	p->scaleMax = (SFFloat) M4_MAX_FLOAT;
	p->scaleNbBits = 8;
	p->keyQuant = 1;
	p->keyMin = (SFFloat) 0.0;
	p->keyMax = (SFFloat) 1.0;
	p->keyNbBits = 8;
	p->normalQuant = 1;
	p->normalNbBits = 8;
	p->sizeMin = (SFFloat) 0;
	p->sizeMax = (SFFloat) M4_MAX_FLOAT;
	p->sizeNbBits = 8;
	return (SFNode *)p;
}


/*
	Rectangle Node deletion
*/

static void Rectangle_Del(SFNode *node)
{
	B_Rectangle *p = (B_Rectangle *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Rectangle_Def2All[] = { 0};
static const u16 Rectangle_In2All[] = { 0};
static const u16 Rectangle_Out2All[] = { 0};
static const u16 Rectangle_Dyn2All[] = { 0};

static u32 Rectangle_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Rectangle_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Rectangle_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Rectangle_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Rectangle_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Rectangle_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Rectangle_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Rectangle *) node)->size;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Rectangle_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Rectangle_Create()
{
	B_Rectangle *p;
	SAFEALLOC(p, sizeof(B_Rectangle));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Rectangle);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Rectangle";
	((SFNode *)p)->sgprivate->node_del = Rectangle_Del;
	((SFNode *)p)->sgprivate->get_field_count = Rectangle_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Rectangle_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Rectangle_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Rectangle_get_aq_info;

#endif


	/*default field values*/
	p->size.x = (SFFloat) 2;
	p->size.y = (SFFloat) 2;
	return (SFNode *)p;
}


/*
	ScalarInterpolator Node deletion
*/

static void ScalarInterpolator_Del(SFNode *node)
{
	B_ScalarInterpolator *p = (B_ScalarInterpolator *) node;
	MFFloat_Del(p->key);
	MFFloat_Del(p->keyValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 ScalarInterpolator_Def2All[] = { 1, 2};
static const u16 ScalarInterpolator_In2All[] = { 0, 1, 2};
static const u16 ScalarInterpolator_Out2All[] = { 1, 2, 3};

static u32 ScalarInterpolator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 2;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err ScalarInterpolator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ScalarInterpolator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ScalarInterpolator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ScalarInterpolator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ScalarInterpolator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_fraction";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ScalarInterpolator *)node)->on_set_fraction;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ScalarInterpolator *) node)->set_fraction;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_ScalarInterpolator *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_ScalarInterpolator *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "value_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ScalarInterpolator *) node)->value_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ScalarInterpolator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ScalarInterpolator_Create()
{
	B_ScalarInterpolator *p;
	SAFEALLOC(p, sizeof(B_ScalarInterpolator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ScalarInterpolator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ScalarInterpolator";
	((SFNode *)p)->sgprivate->node_del = ScalarInterpolator_Del;
	((SFNode *)p)->sgprivate->get_field_count = ScalarInterpolator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ScalarInterpolator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ScalarInterpolator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ScalarInterpolator_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Script Node deletion
*/

static void Script_Del(SFNode *node)
{
	B_Script *p = (B_Script *) node;
	MFScript_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 Script_Def2All[] = { 0, 1, 2};
static const u16 Script_In2All[] = { 0};
static const u16 Script_Out2All[] = { 0};

static u32 Script_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 3;
	case FCM_OUT: return 1;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err Script_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Script_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Script_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Script_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Script_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFScript;
		info->far_ptr = & ((B_Script *) node)->url;
		return M4OK;
	case 1:
		info->name = "directOutput";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Script *) node)->directOutput;
		return M4OK;
	case 2:
		info->name = "mustEvaluate";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Script *) node)->mustEvaluate;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Script_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Script_Create()
{
	B_Script *p;
	SAFEALLOC(p, sizeof(B_Script));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Script);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Script";
	((SFNode *)p)->sgprivate->node_del = Script_Del;
	((SFNode *)p)->sgprivate->get_field_count = Script_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Script_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Script_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Script_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Shape Node deletion
*/

static void Shape_Del(SFNode *node)
{
	B_Shape *p = (B_Shape *) node;
	Node_Delete((SFNode *) p->appearance, (SFNode *) p);	
	Node_Delete((SFNode *) p->geometry, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Shape_Def2All[] = { 0, 1};
static const u16 Shape_In2All[] = { 0, 1};
static const u16 Shape_Out2All[] = { 0, 1};

static u32 Shape_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err Shape_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Shape_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Shape_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Shape_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Shape_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "appearance";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFAppearanceNode;
		info->far_ptr = & ((B_Shape *)node)->appearance;
		return M4OK;
	case 1:
		info->name = "geometry";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFGeometryNode;
		info->far_ptr = & ((B_Shape *)node)->geometry;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Shape_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Shape_Create()
{
	B_Shape *p;
	SAFEALLOC(p, sizeof(B_Shape));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Shape);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Shape";
	((SFNode *)p)->sgprivate->node_del = Shape_Del;
	((SFNode *)p)->sgprivate->get_field_count = Shape_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Shape_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Shape_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Shape_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Sound Node deletion
*/

static void Sound_Del(SFNode *node)
{
	B_Sound *p = (B_Sound *) node;
	Node_Delete((SFNode *) p->source, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Sound_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 Sound_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 Sound_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 Sound_Dyn2All[] = { 1, 2, 3, 4, 5, 6};

static u32 Sound_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 10;
	case FCM_OUT: return 9;
	case FCM_DYN: return 6;
	default:
		return 10;
	}
}

static M4Err Sound_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Sound_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Sound_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Sound_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Sound_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Sound_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "direction";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Sound *) node)->direction;
		return M4OK;
	case 1:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->intensity;
		return M4OK;
	case 2:
		info->name = "location";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Sound *) node)->location;
		return M4OK;
	case 3:
		info->name = "maxBack";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->maxBack;
		return M4OK;
	case 4:
		info->name = "maxFront";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->maxFront;
		return M4OK;
	case 5:
		info->name = "minBack";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->minBack;
		return M4OK;
	case 6:
		info->name = "minFront";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->minFront;
		return M4OK;
	case 7:
		info->name = "priority";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound *) node)->priority;
		return M4OK;
	case 8:
		info->name = "source";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_Sound *)node)->source;
		return M4OK;
	case 9:
		info->name = "spatialize";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Sound *) node)->spatialize;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Sound_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 9;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 7;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *Sound_Create()
{
	B_Sound *p;
	SAFEALLOC(p, sizeof(B_Sound));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Sound);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Sound";
	((SFNode *)p)->sgprivate->node_del = Sound_Del;
	((SFNode *)p)->sgprivate->get_field_count = Sound_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Sound_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Sound_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Sound_get_aq_info;

#endif


	/*default field values*/
	p->direction.x = (SFFloat) 0;
	p->direction.y = (SFFloat) 0;
	p->direction.z = (SFFloat) 1;
	p->intensity = (SFFloat) 1;
	p->location.x = (SFFloat) 0;
	p->location.y = (SFFloat) 0;
	p->location.z = (SFFloat) 0;
	p->maxBack = (SFFloat) 10;
	p->maxFront = (SFFloat) 10;
	p->minBack = (SFFloat) 1;
	p->minFront = (SFFloat) 1;
	p->priority = (SFFloat) 0;
	p->spatialize = 1;
	return (SFNode *)p;
}


/*
	Sound2D Node deletion
*/

static void Sound2D_Del(SFNode *node)
{
	B_Sound2D *p = (B_Sound2D *) node;
	Node_Delete((SFNode *) p->source, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Sound2D_Def2All[] = { 0, 1, 2, 3};
static const u16 Sound2D_In2All[] = { 0, 1, 2};
static const u16 Sound2D_Out2All[] = { 0, 1, 2};
static const u16 Sound2D_Dyn2All[] = { 0, 1};

static u32 Sound2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 4;
	case FCM_OUT: return 3;
	case FCM_DYN: return 2;
	default:
		return 4;
	}
}

static M4Err Sound2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Sound2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Sound2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Sound2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Sound2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Sound2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sound2D *) node)->intensity;
		return M4OK;
	case 1:
		info->name = "location";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Sound2D *) node)->location;
		return M4OK;
	case 2:
		info->name = "source";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_Sound2D *)node)->source;
		return M4OK;
	case 3:
		info->name = "spatialize";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Sound2D *) node)->spatialize;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Sound2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 7;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Sound2D_Create()
{
	B_Sound2D *p;
	SAFEALLOC(p, sizeof(B_Sound2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Sound2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Sound2D";
	((SFNode *)p)->sgprivate->node_del = Sound2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Sound2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Sound2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Sound2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Sound2D_get_aq_info;

#endif


	/*default field values*/
	p->intensity = (SFFloat) 1;
	p->location.x = (SFFloat) 0;
	p->location.y = (SFFloat) 0;
	p->spatialize = 1;
	return (SFNode *)p;
}


/*
	Sphere Node deletion
*/

static void Sphere_Del(SFNode *node)
{
	B_Sphere *p = (B_Sphere *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Sphere_Def2All[] = { 0};

static u32 Sphere_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 1;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 1;
	}
}

static M4Err Sphere_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = Sphere_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Sphere_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "radius";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Sphere *) node)->radius;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Sphere_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Sphere_Create()
{
	B_Sphere *p;
	SAFEALLOC(p, sizeof(B_Sphere));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Sphere);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Sphere";
	((SFNode *)p)->sgprivate->node_del = Sphere_Del;
	((SFNode *)p)->sgprivate->get_field_count = Sphere_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Sphere_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Sphere_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Sphere_get_aq_info;

#endif


	/*default field values*/
	p->radius = (SFFloat) 1;
	return (SFNode *)p;
}


/*
	SphereSensor Node deletion
*/

static void SphereSensor_Del(SFNode *node)
{
	B_SphereSensor *p = (B_SphereSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 SphereSensor_Def2All[] = { 0, 1, 2};
static const u16 SphereSensor_In2All[] = { 0, 1, 2};
static const u16 SphereSensor_Out2All[] = { 0, 1, 2, 3, 4, 5};

static u32 SphereSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 6;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err SphereSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = SphereSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = SphereSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = SphereSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err SphereSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "autoOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SphereSensor *) node)->autoOffset;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SphereSensor *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "offset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_SphereSensor *) node)->offset;
		return M4OK;
	case 3:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SphereSensor *) node)->isActive;
		return M4OK;
	case 4:
		info->name = "rotation_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_SphereSensor *) node)->rotation_changed;
		return M4OK;
	case 5:
		info->name = "trackPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_SphereSensor *) node)->trackPoint_changed;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool SphereSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 10;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *SphereSensor_Create()
{
	B_SphereSensor *p;
	SAFEALLOC(p, sizeof(B_SphereSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_SphereSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "SphereSensor";
	((SFNode *)p)->sgprivate->node_del = SphereSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = SphereSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = SphereSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = SphereSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = SphereSensor_get_aq_info;

#endif


	/*default field values*/
	p->autoOffset = 1;
	p->enabled = 1;
	p->offset.xAxis = (SFFloat) 0;
	p->offset.yAxis = (SFFloat) 1;
	p->offset.zAxis = (SFFloat) 0;
	p->offset.angle = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	SpotLight Node deletion
*/

static void SpotLight_Del(SFNode *node)
{
	B_SpotLight *p = (B_SpotLight *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 SpotLight_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 SpotLight_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 SpotLight_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 SpotLight_Dyn2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 9};

static u32 SpotLight_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 10;
	case FCM_DEF: return 10;
	case FCM_OUT: return 10;
	case FCM_DYN: return 9;
	default:
		return 10;
	}
}

static M4Err SpotLight_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = SpotLight_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = SpotLight_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = SpotLight_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = SpotLight_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err SpotLight_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "ambientIntensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SpotLight *) node)->ambientIntensity;
		return M4OK;
	case 1:
		info->name = "attenuation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_SpotLight *) node)->attenuation;
		return M4OK;
	case 2:
		info->name = "beamWidth";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SpotLight *) node)->beamWidth;
		return M4OK;
	case 3:
		info->name = "color";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_SpotLight *) node)->color;
		return M4OK;
	case 4:
		info->name = "cutOffAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SpotLight *) node)->cutOffAngle;
		return M4OK;
	case 5:
		info->name = "direction";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_SpotLight *) node)->direction;
		return M4OK;
	case 6:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SpotLight *) node)->intensity;
		return M4OK;
	case 7:
		info->name = "location";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_SpotLight *) node)->location;
		return M4OK;
	case 8:
		info->name = "on";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SpotLight *) node)->on;
		return M4OK;
	case 9:
		info->name = "radius";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SpotLight *) node)->radius;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool SpotLight_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 1;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 8;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 1.5707963;
		return 1;
	case 3:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 8;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 1.5707963;
		return 1;
	case 5:
		*AType = 9;
		*QType = 9;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 7:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *SpotLight_Create()
{
	B_SpotLight *p;
	SAFEALLOC(p, sizeof(B_SpotLight));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_SpotLight);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "SpotLight";
	((SFNode *)p)->sgprivate->node_del = SpotLight_Del;
	((SFNode *)p)->sgprivate->get_field_count = SpotLight_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = SpotLight_get_field_index;
	((SFNode *)p)->sgprivate->get_field = SpotLight_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = SpotLight_get_aq_info;

#endif


	/*default field values*/
	p->ambientIntensity = (SFFloat) 0;
	p->attenuation.x = (SFFloat) 1;
	p->attenuation.y = (SFFloat) 0;
	p->attenuation.z = (SFFloat) 0;
	p->beamWidth = (SFFloat) 1.570796;
	p->color.red = (SFFloat) 1;
	p->color.green = (SFFloat) 1;
	p->color.blue = (SFFloat) 1;
	p->cutOffAngle = (SFFloat) 0.785398;
	p->direction.x = (SFFloat) 0;
	p->direction.y = (SFFloat) 0;
	p->direction.z = (SFFloat) -1;
	p->intensity = (SFFloat) 1;
	p->location.x = (SFFloat) 0;
	p->location.y = (SFFloat) 0;
	p->location.z = (SFFloat) 0;
	p->on = 1;
	p->radius = (SFFloat) 100;
	return (SFNode *)p;
}


/*
	Switch Node deletion
*/

static void Switch_Del(SFNode *node)
{
	B_Switch *p = (B_Switch *) node;
	NodeList_Delete((Chain *) p->choice, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Switch_Def2All[] = { 0, 1};
static const u16 Switch_In2All[] = { 0, 1};
static const u16 Switch_Out2All[] = { 0, 1};

static u32 Switch_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err Switch_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Switch_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Switch_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Switch_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Switch_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "choice";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Switch *)node)->choice;
		return M4OK;
	case 1:
		info->name = "whichChoice";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Switch *) node)->whichChoice;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Switch_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 10;
		*b_min = (Float) -1;
		*b_max = (Float)  1022;
		return 1;
	default:
		return 0;
	}
}



SFNode *Switch_Create()
{
	B_Switch *p;
	SAFEALLOC(p, sizeof(B_Switch));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Switch);
	p->choice = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Switch";
	((SFNode *)p)->sgprivate->node_del = Switch_Del;
	((SFNode *)p)->sgprivate->get_field_count = Switch_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Switch_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Switch_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Switch_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->whichChoice = -1;
	return (SFNode *)p;
}


/*
	TermCap Node deletion
*/

static void TermCap_Del(SFNode *node)
{
	B_TermCap *p = (B_TermCap *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 TermCap_Def2All[] = { 1};
static const u16 TermCap_In2All[] = { 0, 1};
static const u16 TermCap_Out2All[] = { 1, 2};

static u32 TermCap_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 1;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err TermCap_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TermCap_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TermCap_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TermCap_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TermCap_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "evaluate";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TermCap *)node)->on_evaluate;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TermCap *) node)->evaluate;
		return M4OK;
	case 1:
		info->name = "capability";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_TermCap *) node)->capability;
		return M4OK;
	case 2:
		info->name = "value";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_TermCap *) node)->value;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TermCap_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 7;
		*b_min = (Float) 0;
		*b_max = (Float) 127;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 7;
		return 1;
	default:
		return 0;
	}
}



SFNode *TermCap_Create()
{
	B_TermCap *p;
	SAFEALLOC(p, sizeof(B_TermCap));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TermCap);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TermCap";
	((SFNode *)p)->sgprivate->node_del = TermCap_Del;
	((SFNode *)p)->sgprivate->get_field_count = TermCap_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TermCap_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TermCap_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TermCap_get_aq_info;

#endif


	/*default field values*/
	p->capability = 0;
	return (SFNode *)p;
}


/*
	Text Node deletion
*/

static void Text_Del(SFNode *node)
{
	B_Text *p = (B_Text *) node;
	MFString_Del(p->string);
	MFFloat_Del(p->length);
	Node_Delete((SFNode *) p->fontStyle, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Text_Def2All[] = { 0, 1, 2, 3};
static const u16 Text_In2All[] = { 0, 1, 2, 3};
static const u16 Text_Out2All[] = { 0, 1, 2, 3};
static const u16 Text_Dyn2All[] = { 1, 3};

static u32 Text_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 2;
	default:
		return 4;
	}
}

static M4Err Text_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Text_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Text_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Text_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Text_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Text_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "string";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Text *) node)->string;
		return M4OK;
	case 1:
		info->name = "length";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_Text *) node)->length;
		return M4OK;
	case 2:
		info->name = "fontStyle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFFontStyleNode;
		info->far_ptr = & ((B_Text *)node)->fontStyle;
		return M4OK;
	case 3:
		info->name = "maxExtent";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Text *) node)->maxExtent;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Text_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 7;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Text_Create()
{
	B_Text *p;
	SAFEALLOC(p, sizeof(B_Text));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Text);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Text";
	((SFNode *)p)->sgprivate->node_del = Text_Del;
	((SFNode *)p)->sgprivate->get_field_count = Text_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Text_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Text_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Text_get_aq_info;

#endif


	/*default field values*/
	p->maxExtent = (SFFloat) 0.0;
	return (SFNode *)p;
}


/*
	TextureCoordinate Node deletion
*/

static void TextureCoordinate_Del(SFNode *node)
{
	B_TextureCoordinate *p = (B_TextureCoordinate *) node;
	MFVec2f_Del(p->point);
	SFNode_Delete((SFNode *) p);
}

static const u16 TextureCoordinate_Def2All[] = { 0};
static const u16 TextureCoordinate_In2All[] = { 0};
static const u16 TextureCoordinate_Out2All[] = { 0};
static const u16 TextureCoordinate_Dyn2All[] = { 0};

static u32 TextureCoordinate_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err TextureCoordinate_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TextureCoordinate_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TextureCoordinate_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TextureCoordinate_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = TextureCoordinate_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TextureCoordinate_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "point";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_TextureCoordinate *) node)->point;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TextureCoordinate_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 5;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *TextureCoordinate_Create()
{
	B_TextureCoordinate *p;
	SAFEALLOC(p, sizeof(B_TextureCoordinate));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TextureCoordinate);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TextureCoordinate";
	((SFNode *)p)->sgprivate->node_del = TextureCoordinate_Del;
	((SFNode *)p)->sgprivate->get_field_count = TextureCoordinate_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TextureCoordinate_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TextureCoordinate_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TextureCoordinate_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	TextureTransform Node deletion
*/

static void TextureTransform_Del(SFNode *node)
{
	B_TextureTransform *p = (B_TextureTransform *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 TextureTransform_Def2All[] = { 0, 1, 2, 3};
static const u16 TextureTransform_In2All[] = { 0, 1, 2, 3};
static const u16 TextureTransform_Out2All[] = { 0, 1, 2, 3};
static const u16 TextureTransform_Dyn2All[] = { 0, 1, 2, 3};

static u32 TextureTransform_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 4;
	default:
		return 4;
	}
}

static M4Err TextureTransform_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TextureTransform_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TextureTransform_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TextureTransform_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = TextureTransform_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TextureTransform_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_TextureTransform *) node)->center;
		return M4OK;
	case 1:
		info->name = "rotation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TextureTransform *) node)->rotation;
		return M4OK;
	case 2:
		info->name = "scale";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_TextureTransform *) node)->scale;
		return M4OK;
	case 3:
		info->name = "translation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_TextureTransform *) node)->translation;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TextureTransform_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 6;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 2:
		*AType = 12;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *TextureTransform_Create()
{
	B_TextureTransform *p;
	SAFEALLOC(p, sizeof(B_TextureTransform));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TextureTransform);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TextureTransform";
	((SFNode *)p)->sgprivate->node_del = TextureTransform_Del;
	((SFNode *)p)->sgprivate->get_field_count = TextureTransform_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TextureTransform_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TextureTransform_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TextureTransform_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->rotation = (SFFloat) 0;
	p->scale.x = (SFFloat) 1;
	p->scale.y = (SFFloat) 1;
	p->translation.x = (SFFloat) 0;
	p->translation.y = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	TimeSensor Node deletion
*/

static void TimeSensor_Del(SFNode *node)
{
	B_TimeSensor *p = (B_TimeSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 TimeSensor_Def2All[] = { 0, 1, 2, 3, 4};
static const u16 TimeSensor_In2All[] = { 0, 1, 2, 3, 4};
static const u16 TimeSensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};

static u32 TimeSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 9;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err TimeSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TimeSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TimeSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TimeSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TimeSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "cycleInterval";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TimeSensor *) node)->cycleInterval;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TimeSensor *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TimeSensor *) node)->loop;
		return M4OK;
	case 3:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TimeSensor *) node)->startTime;
		return M4OK;
	case 4:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TimeSensor *) node)->stopTime;
		return M4OK;
	case 5:
		info->name = "cycleTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TimeSensor *) node)->cycleTime;
		return M4OK;
	case 6:
		info->name = "fraction_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TimeSensor *) node)->fraction_changed;
		return M4OK;
	case 7:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TimeSensor *) node)->isActive;
		return M4OK;
	case 8:
		info->name = "time";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TimeSensor *) node)->time;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TimeSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *TimeSensor_Create()
{
	B_TimeSensor *p;
	SAFEALLOC(p, sizeof(B_TimeSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TimeSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TimeSensor";
	((SFNode *)p)->sgprivate->node_del = TimeSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = TimeSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TimeSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TimeSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TimeSensor_get_aq_info;

#endif


	/*default field values*/
	p->cycleInterval = 1;
	p->enabled = 1;
	p->startTime = 0;
	p->stopTime = 0;
	return (SFNode *)p;
}


/*
	TouchSensor Node deletion
*/

static void TouchSensor_Del(SFNode *node)
{
	B_TouchSensor *p = (B_TouchSensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 TouchSensor_Def2All[] = { 0};
static const u16 TouchSensor_In2All[] = { 0};
static const u16 TouchSensor_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};

static u32 TouchSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 7;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err TouchSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TouchSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TouchSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TouchSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TouchSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TouchSensor *) node)->enabled;
		return M4OK;
	case 1:
		info->name = "hitNormal_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_TouchSensor *) node)->hitNormal_changed;
		return M4OK;
	case 2:
		info->name = "hitPoint_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_TouchSensor *) node)->hitPoint_changed;
		return M4OK;
	case 3:
		info->name = "hitTexCoord_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_TouchSensor *) node)->hitTexCoord_changed;
		return M4OK;
	case 4:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TouchSensor *) node)->isActive;
		return M4OK;
	case 5:
		info->name = "isOver";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TouchSensor *) node)->isOver;
		return M4OK;
	case 6:
		info->name = "touchTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TouchSensor *) node)->touchTime;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TouchSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *TouchSensor_Create()
{
	B_TouchSensor *p;
	SAFEALLOC(p, sizeof(B_TouchSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TouchSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TouchSensor";
	((SFNode *)p)->sgprivate->node_del = TouchSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = TouchSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TouchSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TouchSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TouchSensor_get_aq_info;

#endif


	/*default field values*/
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	Transform Node deletion
*/

static void Transform_Del(SFNode *node)
{
	B_Transform *p = (B_Transform *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Transform_Def2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Transform_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 Transform_Out2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Transform_Dyn2All[] = { 2, 4, 5, 6, 7};

static u32 Transform_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 5;
	default:
		return 8;
	}
}

static M4Err Transform_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Transform_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Transform_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Transform_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Transform_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Transform_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Transform *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Transform *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Transform *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Transform *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Transform *) node)->center;
		return M4OK;
	case 3:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Transform *)node)->children;
		return M4OK;
	case 4:
		info->name = "rotation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_Transform *) node)->rotation;
		return M4OK;
	case 5:
		info->name = "scale";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Transform *) node)->scale;
		return M4OK;
	case 6:
		info->name = "scaleOrientation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_Transform *) node)->scaleOrientation;
		return M4OK;
	case 7:
		info->name = "translation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Transform *) node)->translation;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Transform_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 10;
		*QType = 10;
		return 1;
	case 5:
		*AType = 11;
		*QType = 7;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 10;
		*QType = 10;
		return 1;
	case 7:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Transform_Create()
{
	B_Transform *p;
	SAFEALLOC(p, sizeof(B_Transform));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Transform);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Transform";
	((SFNode *)p)->sgprivate->node_del = Transform_Del;
	((SFNode *)p)->sgprivate->get_field_count = Transform_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Transform_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Transform_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Transform_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->center.z = (SFFloat) 0;
	p->rotation.xAxis = (SFFloat) 0;
	p->rotation.yAxis = (SFFloat) 0;
	p->rotation.zAxis = (SFFloat) 1;
	p->rotation.angle = (SFFloat) 0;
	p->scale.x = (SFFloat) 1;
	p->scale.y = (SFFloat) 1;
	p->scale.z = (SFFloat) 1;
	p->scaleOrientation.xAxis = (SFFloat) 0;
	p->scaleOrientation.yAxis = (SFFloat) 0;
	p->scaleOrientation.zAxis = (SFFloat) 1;
	p->scaleOrientation.angle = (SFFloat) 0;
	p->translation.x = (SFFloat) 0;
	p->translation.y = (SFFloat) 0;
	p->translation.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Transform2D Node deletion
*/

static void Transform2D_Del(SFNode *node)
{
	B_Transform2D *p = (B_Transform2D *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Transform2D_Def2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Transform2D_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 Transform2D_Out2All[] = { 2, 3, 4, 5, 6, 7};
static const u16 Transform2D_Dyn2All[] = { 3, 4, 5, 6, 7};

static u32 Transform2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 5;
	default:
		return 8;
	}
}

static M4Err Transform2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Transform2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Transform2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Transform2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Transform2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Transform2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Transform2D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Transform2D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Transform2D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Transform2D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Transform2D *)node)->children;
		return M4OK;
	case 3:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Transform2D *) node)->center;
		return M4OK;
	case 4:
		info->name = "rotationAngle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Transform2D *) node)->rotationAngle;
		return M4OK;
	case 5:
		info->name = "scale";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Transform2D *) node)->scale;
		return M4OK;
	case 6:
		info->name = "scaleOrientation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Transform2D *) node)->scaleOrientation;
		return M4OK;
	case 7:
		info->name = "translation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Transform2D *) node)->translation;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Transform2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 6;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 5:
		*AType = 12;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 6;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 7:
		*AType = 2;
		*QType = 2;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Transform2D_Create()
{
	B_Transform2D *p;
	SAFEALLOC(p, sizeof(B_Transform2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Transform2D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Transform2D";
	((SFNode *)p)->sgprivate->node_del = Transform2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Transform2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Transform2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Transform2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Transform2D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->rotationAngle = (SFFloat) 0;
	p->scale.x = (SFFloat) 1;
	p->scale.y = (SFFloat) 1;
	p->scaleOrientation = (SFFloat) 0;
	p->translation.x = (SFFloat) 0;
	p->translation.y = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Valuator Node deletion
*/

static void Valuator_Del(SFNode *node)
{
	B_Valuator *p = (B_Valuator *) node;
	MFColor_Del(p->inMFColor);
	MFFloat_Del(p->inMFFloat);
	MFInt32_Del(p->inMFInt32);
	MFRotation_Del(p->inMFRotation);
	SFString_Del(p->inSFString);
	MFString_Del(p->inMFString);
	MFVec2f_Del(p->inMFVec2f);
	MFVec3f_Del(p->inMFVec3f);
	MFColor_Del(p->outMFColor);
	MFFloat_Del(p->outMFFloat);
	MFInt32_Del(p->outMFInt32);
	MFRotation_Del(p->outMFRotation);
	SFString_Del(p->outSFString);
	MFString_Del(p->outMFString);
	MFVec2f_Del(p->outMFVec2f);
	MFVec3f_Del(p->outMFVec3f);
	SFNode_Delete((SFNode *) p);
}

static const u16 Valuator_Def2All[] = { 32, 33, 34, 35, 36, 37, 38, 39, 40};
static const u16 Valuator_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 32, 33, 34, 35, 36, 37, 38, 39, 40};
static const u16 Valuator_Out2All[] = { 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40};

static u32 Valuator_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 25;
	case FCM_DEF: return 9;
	case FCM_OUT: return 25;
	case FCM_DYN: return 0;
	default:
		return 41;
	}
}

static M4Err Valuator_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Valuator_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Valuator_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Valuator_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Valuator_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "inSFBool";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFBool;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Valuator *) node)->inSFBool;
		return M4OK;
	case 1:
		info->name = "inSFColor";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFColor;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Valuator *) node)->inSFColor;
		return M4OK;
	case 2:
		info->name = "inMFColor";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFColor;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_Valuator *) node)->inMFColor;
		return M4OK;
	case 3:
		info->name = "inSFFloat";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFFloat;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->inSFFloat;
		return M4OK;
	case 4:
		info->name = "inMFFloat";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFFloat;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_Valuator *) node)->inMFFloat;
		return M4OK;
	case 5:
		info->name = "inSFInt32";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFInt32;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Valuator *) node)->inSFInt32;
		return M4OK;
	case 6:
		info->name = "inMFInt32";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFInt32;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Valuator *) node)->inMFInt32;
		return M4OK;
	case 7:
		info->name = "inSFRotation";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFRotation;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_Valuator *) node)->inSFRotation;
		return M4OK;
	case 8:
		info->name = "inMFRotation";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFRotation;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_Valuator *) node)->inMFRotation;
		return M4OK;
	case 9:
		info->name = "inSFString";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFString;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Valuator *) node)->inSFString;
		return M4OK;
	case 10:
		info->name = "inMFString";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFString;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Valuator *) node)->inMFString;
		return M4OK;
	case 11:
		info->name = "inSFTime";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFTime;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_Valuator *) node)->inSFTime;
		return M4OK;
	case 12:
		info->name = "inSFVec2f";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFVec2f;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Valuator *) node)->inSFVec2f;
		return M4OK;
	case 13:
		info->name = "inMFVec2f";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFVec2f;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Valuator *) node)->inMFVec2f;
		return M4OK;
	case 14:
		info->name = "inSFVec3f";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inSFVec3f;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Valuator *) node)->inSFVec3f;
		return M4OK;
	case 15:
		info->name = "inMFVec3f";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Valuator *)node)->on_inMFVec3f;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Valuator *) node)->inMFVec3f;
		return M4OK;
	case 16:
		info->name = "outSFBool";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Valuator *) node)->outSFBool;
		return M4OK;
	case 17:
		info->name = "outSFColor";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_Valuator *) node)->outSFColor;
		return M4OK;
	case 18:
		info->name = "outMFColor";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_Valuator *) node)->outMFColor;
		return M4OK;
	case 19:
		info->name = "outSFFloat";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->outSFFloat;
		return M4OK;
	case 20:
		info->name = "outMFFloat";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_Valuator *) node)->outMFFloat;
		return M4OK;
	case 21:
		info->name = "outSFInt32";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Valuator *) node)->outSFInt32;
		return M4OK;
	case 22:
		info->name = "outMFInt32";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Valuator *) node)->outMFInt32;
		return M4OK;
	case 23:
		info->name = "outSFRotation";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_Valuator *) node)->outSFRotation;
		return M4OK;
	case 24:
		info->name = "outMFRotation";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_Valuator *) node)->outMFRotation;
		return M4OK;
	case 25:
		info->name = "outSFString";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Valuator *) node)->outSFString;
		return M4OK;
	case 26:
		info->name = "outMFString";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_Valuator *) node)->outMFString;
		return M4OK;
	case 27:
		info->name = "outSFTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_Valuator *) node)->outSFTime;
		return M4OK;
	case 28:
		info->name = "outSFVec2f";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Valuator *) node)->outSFVec2f;
		return M4OK;
	case 29:
		info->name = "outMFVec2f";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFVec2f;
		info->far_ptr = & ((B_Valuator *) node)->outMFVec2f;
		return M4OK;
	case 30:
		info->name = "outSFVec3f";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Valuator *) node)->outSFVec3f;
		return M4OK;
	case 31:
		info->name = "outMFVec3f";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_Valuator *) node)->outMFVec3f;
		return M4OK;
	case 32:
		info->name = "Factor1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Factor1;
		return M4OK;
	case 33:
		info->name = "Factor2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Factor2;
		return M4OK;
	case 34:
		info->name = "Factor3";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Factor3;
		return M4OK;
	case 35:
		info->name = "Factor4";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Factor4;
		return M4OK;
	case 36:
		info->name = "Offset1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Offset1;
		return M4OK;
	case 37:
		info->name = "Offset2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Offset2;
		return M4OK;
	case 38:
		info->name = "Offset3";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Offset3;
		return M4OK;
	case 39:
		info->name = "Offset4";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Valuator *) node)->Offset4;
		return M4OK;
	case 40:
		info->name = "Sum";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Valuator *) node)->Sum;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Valuator_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 32:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 33:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 34:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 35:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 36:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 37:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 38:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 39:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Valuator_Create()
{
	B_Valuator *p;
	SAFEALLOC(p, sizeof(B_Valuator));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Valuator);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Valuator";
	((SFNode *)p)->sgprivate->node_del = Valuator_Del;
	((SFNode *)p)->sgprivate->get_field_count = Valuator_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Valuator_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Valuator_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Valuator_get_aq_info;

#endif


	/*default field values*/
	p->Factor1 = (SFFloat) 1.0;
	p->Factor2 = (SFFloat) 1.0;
	p->Factor3 = (SFFloat) 1.0;
	p->Factor4 = (SFFloat) 1.0;
	p->Offset1 = (SFFloat) 0.0;
	p->Offset2 = (SFFloat) 0.0;
	p->Offset3 = (SFFloat) 0.0;
	p->Offset4 = (SFFloat) 0.0;
	return (SFNode *)p;
}


/*
	Viewpoint Node deletion
*/

static void Viewpoint_Del(SFNode *node)
{
	B_Viewpoint *p = (B_Viewpoint *) node;
	SFString_Del(p->description);
	SFNode_Delete((SFNode *) p);
}

static const u16 Viewpoint_Def2All[] = { 1, 2, 3, 4, 5};
static const u16 Viewpoint_In2All[] = { 0, 1, 2, 3, 4};
static const u16 Viewpoint_Out2All[] = { 1, 2, 3, 4, 6, 7};
static const u16 Viewpoint_Dyn2All[] = { 1, 3, 4};

static u32 Viewpoint_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 6;
	case FCM_DYN: return 3;
	default:
		return 8;
	}
}

static M4Err Viewpoint_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Viewpoint_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Viewpoint_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Viewpoint_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Viewpoint_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Viewpoint_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Viewpoint *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viewpoint *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "fieldOfView";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Viewpoint *) node)->fieldOfView;
		return M4OK;
	case 2:
		info->name = "jump";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viewpoint *) node)->jump;
		return M4OK;
	case 3:
		info->name = "orientation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFRotation;
		info->far_ptr = & ((B_Viewpoint *) node)->orientation;
		return M4OK;
	case 4:
		info->name = "position";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_Viewpoint *) node)->position;
		return M4OK;
	case 5:
		info->name = "description";
		info->eventType = ET_Field;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Viewpoint *) node)->description;
		return M4OK;
	case 6:
		info->name = "bindTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_Viewpoint *) node)->bindTime;
		return M4OK;
	case 7:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viewpoint *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Viewpoint_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 8;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 3.1415927;
		return 1;
	case 3:
		*AType = 10;
		*QType = 10;
		return 1;
	case 4:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Viewpoint_Create()
{
	B_Viewpoint *p;
	SAFEALLOC(p, sizeof(B_Viewpoint));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Viewpoint);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Viewpoint";
	((SFNode *)p)->sgprivate->node_del = Viewpoint_Del;
	((SFNode *)p)->sgprivate->get_field_count = Viewpoint_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Viewpoint_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Viewpoint_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Viewpoint_get_aq_info;

#endif


	/*default field values*/
	p->fieldOfView = (SFFloat) 0.785398;
	p->jump = 1;
	p->orientation.xAxis = (SFFloat) 0;
	p->orientation.yAxis = (SFFloat) 0;
	p->orientation.zAxis = (SFFloat) 1;
	p->orientation.angle = (SFFloat) 0;
	p->position.x = (SFFloat) 0;
	p->position.y = (SFFloat) 0;
	p->position.z = (SFFloat) 10;
	return (SFNode *)p;
}


/*
	VisibilitySensor Node deletion
*/

static void VisibilitySensor_Del(SFNode *node)
{
	B_VisibilitySensor *p = (B_VisibilitySensor *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 VisibilitySensor_Def2All[] = { 0, 1, 2};
static const u16 VisibilitySensor_In2All[] = { 0, 1, 2};
static const u16 VisibilitySensor_Out2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 VisibilitySensor_Dyn2All[] = { 0, 2};

static u32 VisibilitySensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 6;
	case FCM_DYN: return 2;
	default:
		return 6;
	}
}

static M4Err VisibilitySensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = VisibilitySensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = VisibilitySensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = VisibilitySensor_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = VisibilitySensor_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err VisibilitySensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_VisibilitySensor *) node)->center;
		return M4OK;
	case 1:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_VisibilitySensor *) node)->enabled;
		return M4OK;
	case 2:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_VisibilitySensor *) node)->size;
		return M4OK;
	case 3:
		info->name = "enterTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_VisibilitySensor *) node)->enterTime;
		return M4OK;
	case 4:
		info->name = "exitTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_VisibilitySensor *) node)->exitTime;
		return M4OK;
	case 5:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_VisibilitySensor *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool VisibilitySensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 11;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *VisibilitySensor_Create()
{
	B_VisibilitySensor *p;
	SAFEALLOC(p, sizeof(B_VisibilitySensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_VisibilitySensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "VisibilitySensor";
	((SFNode *)p)->sgprivate->node_del = VisibilitySensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = VisibilitySensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = VisibilitySensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = VisibilitySensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = VisibilitySensor_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->center.z = (SFFloat) 0;
	p->enabled = 1;
	p->size.x = (SFFloat) 0;
	p->size.y = (SFFloat) 0;
	p->size.z = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Viseme Node deletion
*/

static void Viseme_Del(SFNode *node)
{
	B_Viseme *p = (B_Viseme *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Viseme_Def2All[] = { 0, 1, 2, 3};
static const u16 Viseme_In2All[] = { 0, 1, 2, 3};
static const u16 Viseme_Out2All[] = { 0, 1, 2, 3};

static u32 Viseme_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err Viseme_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Viseme_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Viseme_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Viseme_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Viseme_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "viseme_select1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Viseme *) node)->viseme_select1;
		return M4OK;
	case 1:
		info->name = "viseme_select2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Viseme *) node)->viseme_select2;
		return M4OK;
	case 2:
		info->name = "viseme_blend";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Viseme *) node)->viseme_blend;
		return M4OK;
	case 3:
		info->name = "viseme_def";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viseme *) node)->viseme_def;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Viseme_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 5;
		*b_min = (Float) 0;
		*b_max = (Float) 31;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 63;
		return 1;
	default:
		return 0;
	}
}



SFNode *Viseme_Create()
{
	B_Viseme *p;
	SAFEALLOC(p, sizeof(B_Viseme));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Viseme);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Viseme";
	((SFNode *)p)->sgprivate->node_del = Viseme_Del;
	((SFNode *)p)->sgprivate->get_field_count = Viseme_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Viseme_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Viseme_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Viseme_get_aq_info;

#endif


	/*default field values*/
	p->viseme_select1 = 0;
	p->viseme_select2 = 0;
	p->viseme_blend = 0;
	return (SFNode *)p;
}


/*
	WorldInfo Node deletion
*/

static void WorldInfo_Del(SFNode *node)
{
	B_WorldInfo *p = (B_WorldInfo *) node;
	MFString_Del(p->info);
	SFString_Del(p->title);
	SFNode_Delete((SFNode *) p);
}

static const u16 WorldInfo_Def2All[] = { 0, 1};

static u32 WorldInfo_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 0;
	case FCM_DEF: return 2;
	case FCM_OUT: return 0;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err WorldInfo_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_DEF:
		*allField = WorldInfo_Def2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err WorldInfo_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "info";
		info->eventType = ET_Field;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_WorldInfo *) node)->info;
		return M4OK;
	case 1:
		info->name = "title";
		info->eventType = ET_Field;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_WorldInfo *) node)->title;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool WorldInfo_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *WorldInfo_Create()
{
	B_WorldInfo *p;
	SAFEALLOC(p, sizeof(B_WorldInfo));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_WorldInfo);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "WorldInfo";
	((SFNode *)p)->sgprivate->node_del = WorldInfo_Del;
	((SFNode *)p)->sgprivate->get_field_count = WorldInfo_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = WorldInfo_get_field_index;
	((SFNode *)p)->sgprivate->get_field = WorldInfo_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = WorldInfo_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	AcousticMaterial Node deletion
*/

static void AcousticMaterial_Del(SFNode *node)
{
	B_AcousticMaterial *p = (B_AcousticMaterial *) node;
	MFFloat_Del(p->reffunc);
	MFFloat_Del(p->transfunc);
	MFFloat_Del(p->refFrequency);
	MFFloat_Del(p->transFrequency);
	SFNode_Delete((SFNode *) p);
}

static const u16 AcousticMaterial_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 AcousticMaterial_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AcousticMaterial_Out2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AcousticMaterial_Dyn2All[] = { 0, 1, 2, 3, 4, 5};

static u32 AcousticMaterial_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 10;
	case FCM_OUT: return 6;
	case FCM_DYN: return 6;
	default:
		return 10;
	}
}

static M4Err AcousticMaterial_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AcousticMaterial_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AcousticMaterial_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AcousticMaterial_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AcousticMaterial_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AcousticMaterial_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "ambientIntensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->ambientIntensity;
		return M4OK;
	case 1:
		info->name = "diffuseColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_AcousticMaterial *) node)->diffuseColor;
		return M4OK;
	case 2:
		info->name = "emissiveColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_AcousticMaterial *) node)->emissiveColor;
		return M4OK;
	case 3:
		info->name = "shininess";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->shininess;
		return M4OK;
	case 4:
		info->name = "specularColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_AcousticMaterial *) node)->specularColor;
		return M4OK;
	case 5:
		info->name = "transparency";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->transparency;
		return M4OK;
	case 6:
		info->name = "reffunc";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->reffunc;
		return M4OK;
	case 7:
		info->name = "transfunc";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->transfunc;
		return M4OK;
	case 8:
		info->name = "refFrequency";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->refFrequency;
		return M4OK;
	case 9:
		info->name = "transFrequency";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AcousticMaterial *) node)->transFrequency;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AcousticMaterial_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 6:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *AcousticMaterial_Create()
{
	B_AcousticMaterial *p;
	SAFEALLOC(p, sizeof(B_AcousticMaterial));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AcousticMaterial);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AcousticMaterial";
	((SFNode *)p)->sgprivate->node_del = AcousticMaterial_Del;
	((SFNode *)p)->sgprivate->get_field_count = AcousticMaterial_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AcousticMaterial_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AcousticMaterial_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AcousticMaterial_get_aq_info;

#endif


	/*default field values*/
	p->ambientIntensity = (SFFloat) 0.2;
	p->diffuseColor.red = (SFFloat) 0.8;
	p->diffuseColor.green = (SFFloat) 0.8;
	p->diffuseColor.blue = (SFFloat) 0.8;
	p->emissiveColor.red = (SFFloat) 0;
	p->emissiveColor.green = (SFFloat) 0;
	p->emissiveColor.blue = (SFFloat) 0;
	p->shininess = (SFFloat) 0.2;
	p->specularColor.red = (SFFloat) 0;
	p->specularColor.green = (SFFloat) 0;
	p->specularColor.blue = (SFFloat) 0;
	p->transparency = (SFFloat) 0;
	p->reffunc.vals = malloc(sizeof(SFFloat)*1);
	p->reffunc.count = 1;
	p->reffunc.vals[0] = (SFFloat) 0;
	p->transfunc.vals = malloc(sizeof(SFFloat)*1);
	p->transfunc.count = 1;
	p->transfunc.vals[0] = (SFFloat) 1;
	p->refFrequency.vals = malloc(sizeof(SFFloat)*1);
	p->refFrequency.count = 1;
	p->refFrequency.vals[0] = (SFFloat) 0;
	p->transFrequency.vals = malloc(sizeof(SFFloat)*1);
	p->transFrequency.count = 1;
	p->transFrequency.vals[0] = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	AcousticScene Node deletion
*/

static void AcousticScene_Del(SFNode *node)
{
	B_AcousticScene *p = (B_AcousticScene *) node;
	MFTime_Del(p->reverbTime);
	MFFloat_Del(p->reverbFreq);
	SFNode_Delete((SFNode *) p);
}

static const u16 AcousticScene_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 AcousticScene_In2All[] = { 4, 5};
static const u16 AcousticScene_Out2All[] = { 4, 5};
static const u16 AcousticScene_Dyn2All[] = { 4};

static u32 AcousticScene_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 6;
	case FCM_OUT: return 2;
	case FCM_DYN: return 1;
	default:
		return 6;
	}
}

static M4Err AcousticScene_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = AcousticScene_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = AcousticScene_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = AcousticScene_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = AcousticScene_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err AcousticScene_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_AcousticScene *) node)->center;
		return M4OK;
	case 1:
		info->name = "Size";
		info->eventType = ET_Field;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_AcousticScene *) node)->Size;
		return M4OK;
	case 2:
		info->name = "reverbTime";
		info->eventType = ET_Field;
		info->fieldType = FT_MFTime;
		info->far_ptr = & ((B_AcousticScene *) node)->reverbTime;
		return M4OK;
	case 3:
		info->name = "reverbFreq";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_AcousticScene *) node)->reverbFreq;
		return M4OK;
	case 4:
		info->name = "reverbLevel";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_AcousticScene *) node)->reverbLevel;
		return M4OK;
	case 5:
		info->name = "reverbDelay";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_AcousticScene *) node)->reverbDelay;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool AcousticScene_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 11;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0 ;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0 ;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0 ;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0 ;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *AcousticScene_Create()
{
	B_AcousticScene *p;
	SAFEALLOC(p, sizeof(B_AcousticScene));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_AcousticScene);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "AcousticScene";
	((SFNode *)p)->sgprivate->node_del = AcousticScene_Del;
	((SFNode *)p)->sgprivate->get_field_count = AcousticScene_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = AcousticScene_get_field_index;
	((SFNode *)p)->sgprivate->get_field = AcousticScene_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = AcousticScene_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0;
	p->center.y = (SFFloat) 0;
	p->center.z = (SFFloat) 0;
	p->Size.x = (SFFloat) -1;
	p->Size.y = (SFFloat) -1;
	p->Size.z = (SFFloat) -1;
	p->reverbTime.vals = malloc(sizeof(SFTime)*1);
	p->reverbTime.count = 1;
	p->reverbTime.vals[0] = 0;
	p->reverbFreq.vals = malloc(sizeof(SFFloat)*1);
	p->reverbFreq.count = 1;
	p->reverbFreq.vals[0] = (SFFloat) 1000;
	p->reverbLevel = (SFFloat) 0.4;
	p->reverbDelay = 0.5;
	return (SFNode *)p;
}


/*
	ApplicationWindow Node deletion
*/

static void ApplicationWindow_Del(SFNode *node)
{
	B_ApplicationWindow *p = (B_ApplicationWindow *) node;
	SFString_Del(p->description);
	MFString_Del(p->parameter);
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 ApplicationWindow_Def2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 ApplicationWindow_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 ApplicationWindow_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 ApplicationWindow_Dyn2All[] = { 6};

static u32 ApplicationWindow_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 1;
	default:
		return 7;
	}
}

static M4Err ApplicationWindow_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ApplicationWindow_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ApplicationWindow_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ApplicationWindow_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = ApplicationWindow_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ApplicationWindow_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "isActive";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ApplicationWindow *) node)->isActive;
		return M4OK;
	case 1:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ApplicationWindow *) node)->startTime;
		return M4OK;
	case 2:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_ApplicationWindow *) node)->stopTime;
		return M4OK;
	case 3:
		info->name = "description";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_ApplicationWindow *) node)->description;
		return M4OK;
	case 4:
		info->name = "parameter";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_ApplicationWindow *) node)->parameter;
		return M4OK;
	case 5:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_ApplicationWindow *) node)->url;
		return M4OK;
	case 6:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_ApplicationWindow *) node)->size;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ApplicationWindow_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 12;
		*QType = 12;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ApplicationWindow_Create()
{
	B_ApplicationWindow *p;
	SAFEALLOC(p, sizeof(B_ApplicationWindow));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ApplicationWindow);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ApplicationWindow";
	((SFNode *)p)->sgprivate->node_del = ApplicationWindow_Del;
	((SFNode *)p)->sgprivate->get_field_count = ApplicationWindow_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ApplicationWindow_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ApplicationWindow_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ApplicationWindow_get_aq_info;

#endif


	/*default field values*/
	p->startTime = 0;
	p->stopTime = 0;
	p->size.x = (SFFloat) 0;
	p->size.y = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	BAP Node deletion
*/

static void BAP_Del(SFNode *node)
{
	B_BAP *p = (B_BAP *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 BAP_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295};
static const u16 BAP_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295};
static const u16 BAP_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295};

static u32 BAP_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 296;
	case FCM_DEF: return 296;
	case FCM_OUT: return 296;
	case FCM_DYN: return 0;
	default:
		return 296;
	}
}

static M4Err BAP_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = BAP_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = BAP_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = BAP_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err BAP_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "sacroiliac_tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->sacroiliac_tilt;
		return M4OK;
	case 1:
		info->name = "sacroiliac_torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->sacroiliac_torsion;
		return M4OK;
	case 2:
		info->name = "sacroiliac_roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->sacroiliac_roll;
		return M4OK;
	case 3:
		info->name = "l_hip_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_hip_flexion;
		return M4OK;
	case 4:
		info->name = "r_hip_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_hip_flexion;
		return M4OK;
	case 5:
		info->name = "l_hip_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_hip_abduct;
		return M4OK;
	case 6:
		info->name = "r_hip_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_hip_abduct;
		return M4OK;
	case 7:
		info->name = "l_hip_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_hip_twisting;
		return M4OK;
	case 8:
		info->name = "r_hip_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_hip_twisting;
		return M4OK;
	case 9:
		info->name = "l_knee_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_knee_flexion;
		return M4OK;
	case 10:
		info->name = "r_knee_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_knee_flexion;
		return M4OK;
	case 11:
		info->name = "l_knee_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_knee_twisting;
		return M4OK;
	case 12:
		info->name = "r_knee_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_knee_twisting;
		return M4OK;
	case 13:
		info->name = "l_ankle_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ankle_flexion;
		return M4OK;
	case 14:
		info->name = "r_ankle_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ankle_flexion;
		return M4OK;
	case 15:
		info->name = "l_ankle_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ankle_twisting;
		return M4OK;
	case 16:
		info->name = "r_ankle_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ankle_twisting;
		return M4OK;
	case 17:
		info->name = "l_subtalar_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_subtalar_flexion;
		return M4OK;
	case 18:
		info->name = "r_subtalar_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_subtalar_flexion;
		return M4OK;
	case 19:
		info->name = "l_midtarsal_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_midtarsal_flexion;
		return M4OK;
	case 20:
		info->name = "r_midtarsal_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_midtarsal_flexion;
		return M4OK;
	case 21:
		info->name = "l_metatarsal_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_metatarsal_flexion;
		return M4OK;
	case 22:
		info->name = "r_metatarsal_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_metatarsal_flexion;
		return M4OK;
	case 23:
		info->name = "l_sternoclavicular_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_sternoclavicular_abduct;
		return M4OK;
	case 24:
		info->name = "r_sternoclavicular_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_sternoclavicular_abduct;
		return M4OK;
	case 25:
		info->name = "l_sternoclavicular_rotate";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_sternoclavicular_rotate;
		return M4OK;
	case 26:
		info->name = "r_sternoclavicular_rotate";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_sternoclavicular_rotate;
		return M4OK;
	case 27:
		info->name = "l_acromioclavicular_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_acromioclavicular_abduct;
		return M4OK;
	case 28:
		info->name = "r_acromioclavicular_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_acromioclavicular_abduct;
		return M4OK;
	case 29:
		info->name = "l_acromioclavicular_rotate";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_acromioclavicular_rotate;
		return M4OK;
	case 30:
		info->name = "r_acromioclavicular_rotate";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_acromioclavicular_rotate;
		return M4OK;
	case 31:
		info->name = "l_shoulder_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_shoulder_flexion;
		return M4OK;
	case 32:
		info->name = "r_shoulder_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_shoulder_flexion;
		return M4OK;
	case 33:
		info->name = "l_shoulder_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_shoulder_abduct;
		return M4OK;
	case 34:
		info->name = "r_shoulder_abduct";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_shoulder_abduct;
		return M4OK;
	case 35:
		info->name = "l_shoulder_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_shoulder_twisting;
		return M4OK;
	case 36:
		info->name = "r_shoulder_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_shoulder_twisting;
		return M4OK;
	case 37:
		info->name = "l_elbow_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_elbow_flexion;
		return M4OK;
	case 38:
		info->name = "r_elbow_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_elbow_flexion;
		return M4OK;
	case 39:
		info->name = "l_elbow_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_elbow_twisting;
		return M4OK;
	case 40:
		info->name = "r_elbow_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_elbow_twisting;
		return M4OK;
	case 41:
		info->name = "l_wrist_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_wrist_flexion;
		return M4OK;
	case 42:
		info->name = "r_wrist_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_wrist_flexion;
		return M4OK;
	case 43:
		info->name = "l_wrist_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_wrist_pivot;
		return M4OK;
	case 44:
		info->name = "r_wrist_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_wrist_pivot;
		return M4OK;
	case 45:
		info->name = "l_wrist_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_wrist_twisting;
		return M4OK;
	case 46:
		info->name = "r_wrist_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_wrist_twisting;
		return M4OK;
	case 47:
		info->name = "skullbase_roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->skullbase_roll;
		return M4OK;
	case 48:
		info->name = "skullbase_torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->skullbase_torsion;
		return M4OK;
	case 49:
		info->name = "skullbase_tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->skullbase_tilt;
		return M4OK;
	case 50:
		info->name = "vc1roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc1roll;
		return M4OK;
	case 51:
		info->name = "vc1torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc1torsion;
		return M4OK;
	case 52:
		info->name = "vc1tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc1tilt;
		return M4OK;
	case 53:
		info->name = "vc2roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc2roll;
		return M4OK;
	case 54:
		info->name = "vc2torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc2torsion;
		return M4OK;
	case 55:
		info->name = "vc2tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc2tilt;
		return M4OK;
	case 56:
		info->name = "vc3roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc3roll;
		return M4OK;
	case 57:
		info->name = "vc3torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc3torsion;
		return M4OK;
	case 58:
		info->name = "vc3tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc3tilt;
		return M4OK;
	case 59:
		info->name = "vc4roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc4roll;
		return M4OK;
	case 60:
		info->name = "vc4torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc4torsion;
		return M4OK;
	case 61:
		info->name = "vc4tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc4tilt;
		return M4OK;
	case 62:
		info->name = "vc5roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc5roll;
		return M4OK;
	case 63:
		info->name = "vc5torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc5torsion;
		return M4OK;
	case 64:
		info->name = "vc5tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc5tilt;
		return M4OK;
	case 65:
		info->name = "vc6roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc6roll;
		return M4OK;
	case 66:
		info->name = "vc6torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc6torsion;
		return M4OK;
	case 67:
		info->name = "vc6tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc6tilt;
		return M4OK;
	case 68:
		info->name = "vc7roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc7roll;
		return M4OK;
	case 69:
		info->name = "vc7torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc7torsion;
		return M4OK;
	case 70:
		info->name = "vc7tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vc7tilt;
		return M4OK;
	case 71:
		info->name = "vt1roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt1roll;
		return M4OK;
	case 72:
		info->name = "vt1torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt1torsion;
		return M4OK;
	case 73:
		info->name = "vt1tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt1tilt;
		return M4OK;
	case 74:
		info->name = "vt2roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt2roll;
		return M4OK;
	case 75:
		info->name = "vt2torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt2torsion;
		return M4OK;
	case 76:
		info->name = "vt2tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt2tilt;
		return M4OK;
	case 77:
		info->name = "vt3roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt3roll;
		return M4OK;
	case 78:
		info->name = "vt3torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt3torsion;
		return M4OK;
	case 79:
		info->name = "vt3tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt3tilt;
		return M4OK;
	case 80:
		info->name = "vt4roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt4roll;
		return M4OK;
	case 81:
		info->name = "vt4torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt4torsion;
		return M4OK;
	case 82:
		info->name = "vt4tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt4tilt;
		return M4OK;
	case 83:
		info->name = "vt5roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt5roll;
		return M4OK;
	case 84:
		info->name = "vt5torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt5torsion;
		return M4OK;
	case 85:
		info->name = "vt5tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt5tilt;
		return M4OK;
	case 86:
		info->name = "vt6roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt6roll;
		return M4OK;
	case 87:
		info->name = "vt6torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt6torsion;
		return M4OK;
	case 88:
		info->name = "vt6tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt6tilt;
		return M4OK;
	case 89:
		info->name = "vt7roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt7roll;
		return M4OK;
	case 90:
		info->name = "vt7torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt7torsion;
		return M4OK;
	case 91:
		info->name = "vt7tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt7tilt;
		return M4OK;
	case 92:
		info->name = "vt8roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt8roll;
		return M4OK;
	case 93:
		info->name = "vt8torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt8torsion;
		return M4OK;
	case 94:
		info->name = "vt8tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt8tilt;
		return M4OK;
	case 95:
		info->name = "vt9roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt9roll;
		return M4OK;
	case 96:
		info->name = "vt9torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt9torsion;
		return M4OK;
	case 97:
		info->name = "vt9tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt9tilt;
		return M4OK;
	case 98:
		info->name = "vt10roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt10roll;
		return M4OK;
	case 99:
		info->name = "vt10torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt10torsion;
		return M4OK;
	case 100:
		info->name = "vt10tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt10tilt;
		return M4OK;
	case 101:
		info->name = "vt11roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt11roll;
		return M4OK;
	case 102:
		info->name = "vt11torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt11torsion;
		return M4OK;
	case 103:
		info->name = "vt11tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt11tilt;
		return M4OK;
	case 104:
		info->name = "vt12roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt12roll;
		return M4OK;
	case 105:
		info->name = "vt12torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt12torsion;
		return M4OK;
	case 106:
		info->name = "vt12tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vt12tilt;
		return M4OK;
	case 107:
		info->name = "vl1roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl1roll;
		return M4OK;
	case 108:
		info->name = "vl1torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl1torsion;
		return M4OK;
	case 109:
		info->name = "vl1tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl1tilt;
		return M4OK;
	case 110:
		info->name = "vl2roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl2roll;
		return M4OK;
	case 111:
		info->name = "vl2torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl2torsion;
		return M4OK;
	case 112:
		info->name = "vl2tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl2tilt;
		return M4OK;
	case 113:
		info->name = "vl3roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl3roll;
		return M4OK;
	case 114:
		info->name = "vl3torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl3torsion;
		return M4OK;
	case 115:
		info->name = "vl3tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl3tilt;
		return M4OK;
	case 116:
		info->name = "vl4roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl4roll;
		return M4OK;
	case 117:
		info->name = "vl4torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl4torsion;
		return M4OK;
	case 118:
		info->name = "vl4tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl4tilt;
		return M4OK;
	case 119:
		info->name = "vl5roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl5roll;
		return M4OK;
	case 120:
		info->name = "vl5torsion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl5torsion;
		return M4OK;
	case 121:
		info->name = "vl5tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->vl5tilt;
		return M4OK;
	case 122:
		info->name = "l_pinky0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky0_flexion;
		return M4OK;
	case 123:
		info->name = "r_pinky0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky0_flexion;
		return M4OK;
	case 124:
		info->name = "l_pinky1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky1_flexion;
		return M4OK;
	case 125:
		info->name = "r_pinky1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky1_flexion;
		return M4OK;
	case 126:
		info->name = "l_pinky1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky1_pivot;
		return M4OK;
	case 127:
		info->name = "r_pinky1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky1_pivot;
		return M4OK;
	case 128:
		info->name = "l_pinky1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky1_twisting;
		return M4OK;
	case 129:
		info->name = "r_pinky1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky1_twisting;
		return M4OK;
	case 130:
		info->name = "l_pinky2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky2_flexion;
		return M4OK;
	case 131:
		info->name = "r_pinky2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky2_flexion;
		return M4OK;
	case 132:
		info->name = "l_pinky3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_pinky3_flexion;
		return M4OK;
	case 133:
		info->name = "r_pinky3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_pinky3_flexion;
		return M4OK;
	case 134:
		info->name = "l_ring0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring0_flexion;
		return M4OK;
	case 135:
		info->name = "r_ring0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring0_flexion;
		return M4OK;
	case 136:
		info->name = "l_ring1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring1_flexion;
		return M4OK;
	case 137:
		info->name = "r_ring1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring1_flexion;
		return M4OK;
	case 138:
		info->name = "l_ring1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring1_pivot;
		return M4OK;
	case 139:
		info->name = "r_ring1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring1_pivot;
		return M4OK;
	case 140:
		info->name = "l_ring1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring1_twisting;
		return M4OK;
	case 141:
		info->name = "r_ring1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring1_twisting;
		return M4OK;
	case 142:
		info->name = "l_ring2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring2_flexion;
		return M4OK;
	case 143:
		info->name = "r_ring2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring2_flexion;
		return M4OK;
	case 144:
		info->name = "l_ring3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_ring3_flexion;
		return M4OK;
	case 145:
		info->name = "r_ring3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_ring3_flexion;
		return M4OK;
	case 146:
		info->name = "l_middle0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle0_flexion;
		return M4OK;
	case 147:
		info->name = "r_middle0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle0_flexion;
		return M4OK;
	case 148:
		info->name = "l_middle1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle1_flexion;
		return M4OK;
	case 149:
		info->name = "r_middle1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle1_flexion;
		return M4OK;
	case 150:
		info->name = "l_middle1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle1_pivot;
		return M4OK;
	case 151:
		info->name = "r_middle1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle1_pivot;
		return M4OK;
	case 152:
		info->name = "l_middle1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle1_twisting;
		return M4OK;
	case 153:
		info->name = "r_middle1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle1_twisting;
		return M4OK;
	case 154:
		info->name = "l_middle2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle2_flexion;
		return M4OK;
	case 155:
		info->name = "r_middle2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle2_flexion;
		return M4OK;
	case 156:
		info->name = "l_middle3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_middle3_flexion;
		return M4OK;
	case 157:
		info->name = "r_middle3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_middle3_flexion;
		return M4OK;
	case 158:
		info->name = "l_index0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index0_flexion;
		return M4OK;
	case 159:
		info->name = "r_index0_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index0_flexion;
		return M4OK;
	case 160:
		info->name = "l_index1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index1_flexion;
		return M4OK;
	case 161:
		info->name = "r_index1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index1_flexion;
		return M4OK;
	case 162:
		info->name = "l_index1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index1_pivot;
		return M4OK;
	case 163:
		info->name = "r_index1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index1_pivot;
		return M4OK;
	case 164:
		info->name = "l_index1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index1_twisting;
		return M4OK;
	case 165:
		info->name = "r_index1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index1_twisting;
		return M4OK;
	case 166:
		info->name = "l_index2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index2_flexion;
		return M4OK;
	case 167:
		info->name = "r_index2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index2_flexion;
		return M4OK;
	case 168:
		info->name = "l_index3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_index3_flexion;
		return M4OK;
	case 169:
		info->name = "r_index3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_index3_flexion;
		return M4OK;
	case 170:
		info->name = "l_thumb1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_thumb1_flexion;
		return M4OK;
	case 171:
		info->name = "r_thumb1_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_thumb1_flexion;
		return M4OK;
	case 172:
		info->name = "l_thumb1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_thumb1_pivot;
		return M4OK;
	case 173:
		info->name = "r_thumb1_pivot";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_thumb1_pivot;
		return M4OK;
	case 174:
		info->name = "l_thumb1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_thumb1_twisting;
		return M4OK;
	case 175:
		info->name = "r_thumb1_twisting";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_thumb1_twisting;
		return M4OK;
	case 176:
		info->name = "l_thumb2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_thumb2_flexion;
		return M4OK;
	case 177:
		info->name = "r_thumb2_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_thumb2_flexion;
		return M4OK;
	case 178:
		info->name = "l_thumb3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->l_thumb3_flexion;
		return M4OK;
	case 179:
		info->name = "r_thumb3_flexion";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->r_thumb3_flexion;
		return M4OK;
	case 180:
		info->name = "HumanoidRoot_tr_vertical";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_tr_vertical;
		return M4OK;
	case 181:
		info->name = "HumanoidRoot_tr_lateral";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_tr_lateral;
		return M4OK;
	case 182:
		info->name = "HumanoidRoot_tr_frontal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_tr_frontal;
		return M4OK;
	case 183:
		info->name = "HumanoidRoot_rt_body_turn";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_rt_body_turn;
		return M4OK;
	case 184:
		info->name = "HumanoidRoot_rt_body_roll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_rt_body_roll;
		return M4OK;
	case 185:
		info->name = "HumanoidRoot_rt_body_tilt";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->HumanoidRoot_rt_body_tilt;
		return M4OK;
	case 186:
		info->name = "extensionBap187";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap187;
		return M4OK;
	case 187:
		info->name = "extensionBap188";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap188;
		return M4OK;
	case 188:
		info->name = "extensionBap189";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap189;
		return M4OK;
	case 189:
		info->name = "extensionBap190";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap190;
		return M4OK;
	case 190:
		info->name = "extensionBap191";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap191;
		return M4OK;
	case 191:
		info->name = "extensionBap192";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap192;
		return M4OK;
	case 192:
		info->name = "extensionBap193";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap193;
		return M4OK;
	case 193:
		info->name = "extensionBap194";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap194;
		return M4OK;
	case 194:
		info->name = "extensionBap195";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap195;
		return M4OK;
	case 195:
		info->name = "extensionBap196";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap196;
		return M4OK;
	case 196:
		info->name = "extensionBap197";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap197;
		return M4OK;
	case 197:
		info->name = "extensionBap198";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap198;
		return M4OK;
	case 198:
		info->name = "extensionBap199";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap199;
		return M4OK;
	case 199:
		info->name = "extensionBap200";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap200;
		return M4OK;
	case 200:
		info->name = "extensionBap201";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap201;
		return M4OK;
	case 201:
		info->name = "extensionBap202";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap202;
		return M4OK;
	case 202:
		info->name = "extensionBap203";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap203;
		return M4OK;
	case 203:
		info->name = "extensionBap204";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap204;
		return M4OK;
	case 204:
		info->name = "extensionBap205";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap205;
		return M4OK;
	case 205:
		info->name = "extensionBap206";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap206;
		return M4OK;
	case 206:
		info->name = "extensionBap207";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap207;
		return M4OK;
	case 207:
		info->name = "extensionBap208";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap208;
		return M4OK;
	case 208:
		info->name = "extensionBap209";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap209;
		return M4OK;
	case 209:
		info->name = "extensionBap210";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap210;
		return M4OK;
	case 210:
		info->name = "extensionBap211";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap211;
		return M4OK;
	case 211:
		info->name = "extensionBap212";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap212;
		return M4OK;
	case 212:
		info->name = "extensionBap213";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap213;
		return M4OK;
	case 213:
		info->name = "extensionBap214";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap214;
		return M4OK;
	case 214:
		info->name = "extensionBap215";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap215;
		return M4OK;
	case 215:
		info->name = "extensionBap216";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap216;
		return M4OK;
	case 216:
		info->name = "extensionBap217";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap217;
		return M4OK;
	case 217:
		info->name = "extensionBap218";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap218;
		return M4OK;
	case 218:
		info->name = "extensionBap219";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap219;
		return M4OK;
	case 219:
		info->name = "extensionBap220";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap220;
		return M4OK;
	case 220:
		info->name = "extensionBap221";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap221;
		return M4OK;
	case 221:
		info->name = "extensionBap222";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap222;
		return M4OK;
	case 222:
		info->name = "extensionBap223";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap223;
		return M4OK;
	case 223:
		info->name = "extensionBap224";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap224;
		return M4OK;
	case 224:
		info->name = "extensionBap225";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap225;
		return M4OK;
	case 225:
		info->name = "extensionBap226";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap226;
		return M4OK;
	case 226:
		info->name = "extensionBap227";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap227;
		return M4OK;
	case 227:
		info->name = "extensionBap228";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap228;
		return M4OK;
	case 228:
		info->name = "extensionBap229";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap229;
		return M4OK;
	case 229:
		info->name = "extensionBap230";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap230;
		return M4OK;
	case 230:
		info->name = "extensionBap231";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap231;
		return M4OK;
	case 231:
		info->name = "extensionBap232";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap232;
		return M4OK;
	case 232:
		info->name = "extensionBap233";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap233;
		return M4OK;
	case 233:
		info->name = "extensionBap234";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap234;
		return M4OK;
	case 234:
		info->name = "extensionBap235";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap235;
		return M4OK;
	case 235:
		info->name = "extensionBap236";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap236;
		return M4OK;
	case 236:
		info->name = "extensionBap237";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap237;
		return M4OK;
	case 237:
		info->name = "extensionBap238";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap238;
		return M4OK;
	case 238:
		info->name = "extensionBap239";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap239;
		return M4OK;
	case 239:
		info->name = "extensionBap240";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap240;
		return M4OK;
	case 240:
		info->name = "extensionBap241";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap241;
		return M4OK;
	case 241:
		info->name = "extensionBap242";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap242;
		return M4OK;
	case 242:
		info->name = "extensionBap243";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap243;
		return M4OK;
	case 243:
		info->name = "extensionBap244";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap244;
		return M4OK;
	case 244:
		info->name = "extensionBap245";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap245;
		return M4OK;
	case 245:
		info->name = "extensionBap246";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap246;
		return M4OK;
	case 246:
		info->name = "extensionBap247";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap247;
		return M4OK;
	case 247:
		info->name = "extensionBap248";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap248;
		return M4OK;
	case 248:
		info->name = "extensionBap249";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap249;
		return M4OK;
	case 249:
		info->name = "extensionBap250";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap250;
		return M4OK;
	case 250:
		info->name = "extensionBap251";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap251;
		return M4OK;
	case 251:
		info->name = "extensionBap252";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap252;
		return M4OK;
	case 252:
		info->name = "extensionBap253";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap253;
		return M4OK;
	case 253:
		info->name = "extensionBap254";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap254;
		return M4OK;
	case 254:
		info->name = "extensionBap255";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap255;
		return M4OK;
	case 255:
		info->name = "extensionBap256";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap256;
		return M4OK;
	case 256:
		info->name = "extensionBap257";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap257;
		return M4OK;
	case 257:
		info->name = "extensionBap258";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap258;
		return M4OK;
	case 258:
		info->name = "extensionBap259";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap259;
		return M4OK;
	case 259:
		info->name = "extensionBap260";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap260;
		return M4OK;
	case 260:
		info->name = "extensionBap261";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap261;
		return M4OK;
	case 261:
		info->name = "extensionBap262";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap262;
		return M4OK;
	case 262:
		info->name = "extensionBap263";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap263;
		return M4OK;
	case 263:
		info->name = "extensionBap264";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap264;
		return M4OK;
	case 264:
		info->name = "extensionBap265";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap265;
		return M4OK;
	case 265:
		info->name = "extensionBap266";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap266;
		return M4OK;
	case 266:
		info->name = "extensionBap267";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap267;
		return M4OK;
	case 267:
		info->name = "extensionBap268";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap268;
		return M4OK;
	case 268:
		info->name = "extensionBap269";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap269;
		return M4OK;
	case 269:
		info->name = "extensionBap270";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap270;
		return M4OK;
	case 270:
		info->name = "extensionBap271";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap271;
		return M4OK;
	case 271:
		info->name = "extensionBap272";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap272;
		return M4OK;
	case 272:
		info->name = "extensionBap273";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap273;
		return M4OK;
	case 273:
		info->name = "extensionBap274";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap274;
		return M4OK;
	case 274:
		info->name = "extensionBap275";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap275;
		return M4OK;
	case 275:
		info->name = "extensionBap276";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap276;
		return M4OK;
	case 276:
		info->name = "extensionBap277";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap277;
		return M4OK;
	case 277:
		info->name = "extensionBap278";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap278;
		return M4OK;
	case 278:
		info->name = "extensionBap279";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap279;
		return M4OK;
	case 279:
		info->name = "extensionBap280";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap280;
		return M4OK;
	case 280:
		info->name = "extensionBap281";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap281;
		return M4OK;
	case 281:
		info->name = "extensionBap282";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap282;
		return M4OK;
	case 282:
		info->name = "extensionBap283";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap283;
		return M4OK;
	case 283:
		info->name = "extensionBap284";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap284;
		return M4OK;
	case 284:
		info->name = "extensionBap285";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap285;
		return M4OK;
	case 285:
		info->name = "extensionBap286";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap286;
		return M4OK;
	case 286:
		info->name = "extensionBap287";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap287;
		return M4OK;
	case 287:
		info->name = "extensionBap288";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap288;
		return M4OK;
	case 288:
		info->name = "extensionBap289";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap289;
		return M4OK;
	case 289:
		info->name = "extensionBap290";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap290;
		return M4OK;
	case 290:
		info->name = "extensionBap291";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap291;
		return M4OK;
	case 291:
		info->name = "extensionBap292";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap292;
		return M4OK;
	case 292:
		info->name = "extensionBap293";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap293;
		return M4OK;
	case 293:
		info->name = "extensionBap294";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap294;
		return M4OK;
	case 294:
		info->name = "extensionBap295";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap295;
		return M4OK;
	case 295:
		info->name = "extensionBap296";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BAP *) node)->extensionBap296;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool BAP_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 14:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 15:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 16:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 17:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 18:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 19:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 20:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 21:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 22:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 23:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 24:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 25:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 26:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 27:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 28:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 29:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 30:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 31:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 32:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 33:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 34:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 35:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 36:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 37:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 38:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 39:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 40:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 41:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 42:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 43:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 44:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 45:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 46:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 47:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 48:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 49:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 50:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 51:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 52:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 53:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 54:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 55:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 56:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 57:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 58:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 59:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 60:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 61:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 62:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 63:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 64:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 65:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 66:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 67:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 68:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 69:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 70:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 71:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 72:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 73:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 74:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 75:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 76:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 77:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 78:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 79:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 80:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 81:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 82:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 83:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 84:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 85:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 86:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 87:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 88:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 89:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 90:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 91:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 92:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 93:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 94:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 95:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 96:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 97:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 98:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 99:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 100:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 101:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 102:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 103:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 104:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 105:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 106:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 107:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 108:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 109:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 110:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 111:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 112:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 113:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 114:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 115:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 116:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 117:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 118:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 119:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 120:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 121:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 122:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 123:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 124:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 125:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 126:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 127:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 128:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 129:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 130:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 131:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 132:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 133:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 134:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 135:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 136:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 137:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 138:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 139:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 140:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 141:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 142:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 143:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 144:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 145:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 146:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 147:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 148:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 149:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 150:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 151:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 152:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 153:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 154:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 155:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 156:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 157:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 158:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 159:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 160:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 161:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 162:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 163:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 164:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 165:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 166:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 167:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 168:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 169:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 170:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 171:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 172:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 173:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 174:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 175:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 176:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 177:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 178:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 179:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 180:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 181:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 182:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 183:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 184:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 185:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 186:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 187:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 188:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 189:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 190:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 191:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 192:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 193:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 194:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 195:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 196:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 197:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 198:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 199:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 200:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 201:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 202:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 203:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 204:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 205:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 206:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 207:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 208:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 209:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 210:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 211:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 212:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 213:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 214:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 215:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 216:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 217:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 218:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 219:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 220:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 221:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 222:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 223:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 224:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 225:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 226:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 227:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 228:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 229:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 230:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 231:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 232:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 233:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 234:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 235:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 236:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 237:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 238:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 239:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 240:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 241:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 242:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 243:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 244:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 245:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 246:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 247:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 248:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 249:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 250:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 251:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 252:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 253:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 254:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 255:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 256:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 257:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 258:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 259:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 260:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 261:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 262:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 263:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 264:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 265:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 266:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 267:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 268:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 269:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 270:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 271:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 272:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 273:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 274:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 275:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 276:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 277:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 278:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 279:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 280:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 281:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 282:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 283:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 284:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 285:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 286:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 287:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 288:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 289:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 290:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 291:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 292:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 293:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 294:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 295:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *BAP_Create()
{
	B_BAP *p;
	SAFEALLOC(p, sizeof(B_BAP));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_BAP);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "BAP";
	((SFNode *)p)->sgprivate->node_del = BAP_Del;
	((SFNode *)p)->sgprivate->get_field_count = BAP_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = BAP_get_field_index;
	((SFNode *)p)->sgprivate->get_field = BAP_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = BAP_get_aq_info;

#endif


	/*default field values*/
	p->sacroiliac_tilt = 2 << 31;
	p->sacroiliac_torsion = 2 << 31;
	p->sacroiliac_roll = 2 << 31;
	p->l_hip_flexion = 2 << 31;
	p->r_hip_flexion = 2 << 31;
	p->l_hip_abduct = 2 << 31;
	p->r_hip_abduct = 2 << 31;
	p->l_hip_twisting = 2 << 31;
	p->r_hip_twisting = 2 << 31;
	p->l_knee_flexion = 2 << 31;
	p->r_knee_flexion = 2 << 31;
	p->l_knee_twisting = 2 << 31;
	p->r_knee_twisting = 2 << 31;
	p->l_ankle_flexion = 2 << 31;
	p->r_ankle_flexion = 2 << 31;
	p->l_ankle_twisting = 2 << 31;
	p->r_ankle_twisting = 2 << 31;
	p->l_subtalar_flexion = 2 << 31;
	p->r_subtalar_flexion = 2 << 31;
	p->l_midtarsal_flexion = 2 << 31;
	p->r_midtarsal_flexion = 2 << 31;
	p->l_metatarsal_flexion = 2 << 31;
	p->r_metatarsal_flexion = 2 << 31;
	p->l_sternoclavicular_abduct = 2 << 31;
	p->r_sternoclavicular_abduct = 2 << 31;
	p->l_sternoclavicular_rotate = 2 << 31;
	p->r_sternoclavicular_rotate = 2 << 31;
	p->l_acromioclavicular_abduct = 2 << 31;
	p->r_acromioclavicular_abduct = 2 << 31;
	p->l_acromioclavicular_rotate = 2 << 31;
	p->r_acromioclavicular_rotate = 2 << 31;
	p->l_shoulder_flexion = 2 << 31;
	p->r_shoulder_flexion = 2 << 31;
	p->l_shoulder_abduct = 2 << 31;
	p->r_shoulder_abduct = 2 << 31;
	p->l_shoulder_twisting = 2 << 31;
	p->r_shoulder_twisting = 2 << 31;
	p->l_elbow_flexion = 2 << 31;
	p->r_elbow_flexion = 2 << 31;
	p->l_elbow_twisting = 2 << 31;
	p->r_elbow_twisting = 2 << 31;
	p->l_wrist_flexion = 2 << 31;
	p->r_wrist_flexion = 2 << 31;
	p->l_wrist_pivot = 2 << 31;
	p->r_wrist_pivot = 2 << 31;
	p->l_wrist_twisting = 2 << 31;
	p->r_wrist_twisting = 2 << 31;
	p->skullbase_roll = 2 << 31;
	p->skullbase_torsion = 2 << 31;
	p->skullbase_tilt = 2 << 31;
	p->vc1roll = 2 << 31;
	p->vc1torsion = 2 << 31;
	p->vc1tilt = 2 << 31;
	p->vc2roll = 2 << 31;
	p->vc2torsion = 2 << 31;
	p->vc2tilt = 2 << 31;
	p->vc3roll = 2 << 31;
	p->vc3torsion = 2 << 31;
	p->vc3tilt = 2 << 31;
	p->vc4roll = 2 << 31;
	p->vc4torsion = 2 << 31;
	p->vc4tilt = 2 << 31;
	p->vc5roll = 2 << 31;
	p->vc5torsion = 2 << 31;
	p->vc5tilt = 2 << 31;
	p->vc6roll = 2 << 31;
	p->vc6torsion = 2 << 31;
	p->vc6tilt = 2 << 31;
	p->vc7roll = 2 << 31;
	p->vc7torsion = 2 << 31;
	p->vc7tilt = 2 << 31;
	p->vt1roll = 2 << 31;
	p->vt1torsion = 2 << 31;
	p->vt1tilt = 2 << 31;
	p->vt2roll = 2 << 31;
	p->vt2torsion = 2 << 31;
	p->vt2tilt = 2 << 31;
	p->vt3roll = 2 << 31;
	p->vt3torsion = 2 << 31;
	p->vt3tilt = 2 << 31;
	p->vt4roll = 2 << 31;
	p->vt4torsion = 2 << 31;
	p->vt4tilt = 2 << 31;
	p->vt5roll = 2 << 31;
	p->vt5torsion = 2 << 31;
	p->vt5tilt = 2 << 31;
	p->vt6roll = 2 << 31;
	p->vt6torsion = 2 << 31;
	p->vt6tilt = 2 << 31;
	p->vt7roll = 2 << 31;
	p->vt7torsion = 2 << 31;
	p->vt7tilt = 2 << 31;
	p->vt8roll = 2 << 31;
	p->vt8torsion = 2 << 31;
	p->vt8tilt = 2 << 31;
	p->vt9roll = 2 << 31;
	p->vt9torsion = 2 << 31;
	p->vt9tilt = 2 << 31;
	p->vt10roll = 2 << 31;
	p->vt10torsion = 2 << 31;
	p->vt10tilt = 2 << 31;
	p->vt11roll = 2 << 31;
	p->vt11torsion = 2 << 31;
	p->vt11tilt = 2 << 31;
	p->vt12roll = 2 << 31;
	p->vt12torsion = 2 << 31;
	p->vt12tilt = 2 << 31;
	p->vl1roll = 2 << 31;
	p->vl1torsion = 2 << 31;
	p->vl1tilt = 2 << 31;
	p->vl2roll = 2 << 31;
	p->vl2torsion = 2 << 31;
	p->vl2tilt = 2 << 31;
	p->vl3roll = 2 << 31;
	p->vl3torsion = 2 << 31;
	p->vl3tilt = 2 << 31;
	p->vl4roll = 2 << 31;
	p->vl4torsion = 2 << 31;
	p->vl4tilt = 2 << 31;
	p->vl5roll = 2 << 31;
	p->vl5torsion = 2 << 31;
	p->vl5tilt = 2 << 31;
	p->l_pinky0_flexion = 2 << 31;
	p->r_pinky0_flexion = 2 << 31;
	p->l_pinky1_flexion = 2 << 31;
	p->r_pinky1_flexion = 2 << 31;
	p->l_pinky1_pivot = 2 << 31;
	p->r_pinky1_pivot = 2 << 31;
	p->l_pinky1_twisting = 2 << 31;
	p->r_pinky1_twisting = 2 << 31;
	p->l_pinky2_flexion = 2 << 31;
	p->r_pinky2_flexion = 2 << 31;
	p->l_pinky3_flexion = 2 << 31;
	p->r_pinky3_flexion = 2 << 31;
	p->l_ring0_flexion = 2 << 31;
	p->r_ring0_flexion = 2 << 31;
	p->l_ring1_flexion = 2 << 31;
	p->r_ring1_flexion = 2 << 31;
	p->l_ring1_pivot = 2 << 31;
	p->r_ring1_pivot = 2 << 31;
	p->l_ring1_twisting = 2 << 31;
	p->r_ring1_twisting = 2 << 31;
	p->l_ring2_flexion = 2 << 31;
	p->r_ring2_flexion = 2 << 31;
	p->l_ring3_flexion = 2 << 31;
	p->r_ring3_flexion = 2 << 31;
	p->l_middle0_flexion = 2 << 31;
	p->r_middle0_flexion = 2 << 31;
	p->l_middle1_flexion = 2 << 31;
	p->r_middle1_flexion = 2 << 31;
	p->l_middle1_pivot = 2 << 31;
	p->r_middle1_pivot = 2 << 31;
	p->l_middle1_twisting = 2 << 31;
	p->r_middle1_twisting = 2 << 31;
	p->l_middle2_flexion = 2 << 31;
	p->r_middle2_flexion = 2 << 31;
	p->l_middle3_flexion = 2 << 31;
	p->r_middle3_flexion = 2 << 31;
	p->l_index0_flexion = 2 << 31;
	p->r_index0_flexion = 2 << 31;
	p->l_index1_flexion = 2 << 31;
	p->r_index1_flexion = 2 << 31;
	p->l_index1_pivot = 2 << 31;
	p->r_index1_pivot = 2 << 31;
	p->l_index1_twisting = 2 << 31;
	p->r_index1_twisting = 2 << 31;
	p->l_index2_flexion = 2 << 31;
	p->r_index2_flexion = 2 << 31;
	p->l_index3_flexion = 2 << 31;
	p->r_index3_flexion = 2 << 31;
	p->l_thumb1_flexion = 2 << 31;
	p->r_thumb1_flexion = 2 << 31;
	p->l_thumb1_pivot = 2 << 31;
	p->r_thumb1_pivot = 2 << 31;
	p->l_thumb1_twisting = 2 << 31;
	p->r_thumb1_twisting = 2 << 31;
	p->l_thumb2_flexion = 2 << 31;
	p->r_thumb2_flexion = 2 << 31;
	p->l_thumb3_flexion = 2 << 31;
	p->r_thumb3_flexion = 2 << 31;
	p->HumanoidRoot_tr_vertical = 2 << 31;
	p->HumanoidRoot_tr_lateral = 2 << 31;
	p->HumanoidRoot_tr_frontal = 2 << 31;
	p->HumanoidRoot_rt_body_turn = 2 << 31;
	p->HumanoidRoot_rt_body_roll = 2 << 31;
	p->HumanoidRoot_rt_body_tilt = 2 << 31;
	p->extensionBap187 = 2 << 31;
	p->extensionBap188 = 2 << 31;
	p->extensionBap189 = 2 << 31;
	p->extensionBap190 = 2 << 31;
	p->extensionBap191 = 2 << 31;
	p->extensionBap192 = 2 << 31;
	p->extensionBap193 = 2 << 31;
	p->extensionBap194 = 2 << 31;
	p->extensionBap195 = 2 << 31;
	p->extensionBap196 = 2 << 31;
	p->extensionBap197 = 2 << 31;
	p->extensionBap198 = 2 << 31;
	p->extensionBap199 = 2 << 31;
	p->extensionBap200 = 2 << 31;
	p->extensionBap201 = 2 << 31;
	p->extensionBap202 = 2 << 31;
	p->extensionBap203 = 2 << 31;
	p->extensionBap204 = 2 << 31;
	p->extensionBap205 = 2 << 31;
	p->extensionBap206 = 2 << 31;
	p->extensionBap207 = 2 << 31;
	p->extensionBap208 = 2 << 31;
	p->extensionBap209 = 2 << 31;
	p->extensionBap210 = 2 << 31;
	p->extensionBap211 = 2 << 31;
	p->extensionBap212 = 2 << 31;
	p->extensionBap213 = 2 << 31;
	p->extensionBap214 = 2 << 31;
	p->extensionBap215 = 2 << 31;
	p->extensionBap216 = 2 << 31;
	p->extensionBap217 = 2 << 31;
	p->extensionBap218 = 2 << 31;
	p->extensionBap219 = 2 << 31;
	p->extensionBap220 = 2 << 31;
	p->extensionBap221 = 2 << 31;
	p->extensionBap222 = 2 << 31;
	p->extensionBap223 = 2 << 31;
	p->extensionBap224 = 2 << 31;
	p->extensionBap225 = 2 << 31;
	p->extensionBap226 = 2 << 31;
	p->extensionBap227 = 2 << 31;
	p->extensionBap228 = 2 << 31;
	p->extensionBap229 = 2 << 31;
	p->extensionBap230 = 2 << 31;
	p->extensionBap231 = 2 << 31;
	p->extensionBap232 = 2 << 31;
	p->extensionBap233 = 2 << 31;
	p->extensionBap234 = 2 << 31;
	p->extensionBap235 = 2 << 31;
	p->extensionBap236 = 2 << 31;
	p->extensionBap237 = 2 << 31;
	p->extensionBap238 = 2 << 31;
	p->extensionBap239 = 2 << 31;
	p->extensionBap240 = 2 << 31;
	p->extensionBap241 = 2 << 31;
	p->extensionBap242 = 2 << 31;
	p->extensionBap243 = 2 << 31;
	p->extensionBap244 = 2 << 31;
	p->extensionBap245 = 2 << 31;
	p->extensionBap246 = 2 << 31;
	p->extensionBap247 = 2 << 31;
	p->extensionBap248 = 2 << 31;
	p->extensionBap249 = 2 << 31;
	p->extensionBap250 = 2 << 31;
	p->extensionBap251 = 2 << 31;
	p->extensionBap252 = 2 << 31;
	p->extensionBap253 = 2 << 31;
	p->extensionBap254 = 2 << 31;
	p->extensionBap255 = 2 << 31;
	p->extensionBap256 = 2 << 31;
	p->extensionBap257 = 2 << 31;
	p->extensionBap258 = 2 << 31;
	p->extensionBap259 = 2 << 31;
	p->extensionBap260 = 2 << 31;
	p->extensionBap261 = 2 << 31;
	p->extensionBap262 = 2 << 31;
	p->extensionBap263 = 2 << 31;
	p->extensionBap264 = 2 << 31;
	p->extensionBap265 = 2 << 31;
	p->extensionBap266 = 2 << 31;
	p->extensionBap267 = 2 << 31;
	p->extensionBap268 = 2 << 31;
	p->extensionBap269 = 2 << 31;
	p->extensionBap270 = 2 << 31;
	p->extensionBap271 = 2 << 31;
	p->extensionBap272 = 2 << 31;
	p->extensionBap273 = 2 << 31;
	p->extensionBap274 = 2 << 31;
	p->extensionBap275 = 2 << 31;
	p->extensionBap276 = 2 << 31;
	p->extensionBap277 = 2 << 31;
	p->extensionBap278 = 2 << 31;
	p->extensionBap279 = 2 << 31;
	p->extensionBap280 = 2 << 31;
	p->extensionBap281 = 2 << 31;
	p->extensionBap282 = 2 << 31;
	p->extensionBap283 = 2 << 31;
	p->extensionBap284 = 2 << 31;
	p->extensionBap285 = 2 << 31;
	p->extensionBap286 = 2 << 31;
	p->extensionBap287 = 2 << 31;
	p->extensionBap288 = 2 << 31;
	p->extensionBap289 = 2 << 31;
	p->extensionBap290 = 2 << 31;
	p->extensionBap291 = 2 << 31;
	p->extensionBap292 = 2 << 31;
	p->extensionBap293 = 2 << 31;
	p->extensionBap294 = 2 << 31;
	p->extensionBap295 = 2 << 31;
	p->extensionBap296 = 2 << 31;
	return (SFNode *)p;
}


/*
	BDP Node deletion
*/

static void BDP_Del(SFNode *node)
{
	B_BDP *p = (B_BDP *) node;
	NodeList_Delete((Chain *) p->bodyDefTables, (SFNode *) p);	
	NodeList_Delete((Chain *) p->bodySceneGraph, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 BDP_Def2All[] = { 0, 1};
static const u16 BDP_In2All[] = { 0, 1};
static const u16 BDP_Out2All[] = { 0, 1};

static u32 BDP_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 2;
	}
}

static M4Err BDP_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = BDP_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = BDP_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = BDP_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err BDP_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bodyDefTables";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFBodyDefTableNode;
		info->far_ptr = & ((B_BDP *)node)->bodyDefTables;
		return M4OK;
	case 1:
		info->name = "bodySceneGraph";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_BDP *)node)->bodySceneGraph;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool BDP_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *BDP_Create()
{
	B_BDP *p;
	SAFEALLOC(p, sizeof(B_BDP));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_BDP);
	p->bodyDefTables = NewChain();	
	p->bodySceneGraph = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "BDP";
	((SFNode *)p)->sgprivate->node_del = BDP_Del;
	((SFNode *)p)->sgprivate->get_field_count = BDP_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = BDP_get_field_index;
	((SFNode *)p)->sgprivate->get_field = BDP_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = BDP_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFBodyDefTableNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Body Node deletion
*/

static void Body_Del(SFNode *node)
{
	B_Body *p = (B_Body *) node;
	Node_Delete((SFNode *) p->bdp, (SFNode *) p);	
	Node_Delete((SFNode *) p->bap, (SFNode *) p);	
	NodeList_Delete((Chain *) p->renderedBody, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Body_Def2All[] = { 0, 1, 2};
static const u16 Body_In2All[] = { 0, 1, 2};
static const u16 Body_Out2All[] = { 0, 1, 2};

static u32 Body_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 3;
	}
}

static M4Err Body_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Body_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Body_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Body_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Body_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bdp";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBDPNode;
		info->far_ptr = & ((B_Body *)node)->bdp;
		return M4OK;
	case 1:
		info->name = "bap";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFBAPNode;
		info->far_ptr = & ((B_Body *)node)->bap;
		return M4OK;
	case 2:
		info->name = "renderedBody";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_Body *)node)->renderedBody;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Body_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Body_Create()
{
	B_Body *p;
	SAFEALLOC(p, sizeof(B_Body));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Body);
	p->renderedBody = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Body";
	((SFNode *)p)->sgprivate->node_del = Body_Del;
	((SFNode *)p)->sgprivate->get_field_count = Body_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Body_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Body_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Body_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	BodyDefTable Node deletion
*/

static void BodyDefTable_Del(SFNode *node)
{
	B_BodyDefTable *p = (B_BodyDefTable *) node;
	SFString_Del(p->bodySceneGraphNodeName);
	MFInt32_Del(p->bapIDs);
	MFInt32_Del(p->vertexIds);
	MFInt32_Del(p->bapCombinations);
	MFVec3f_Del(p->displacements);
	SFNode_Delete((SFNode *) p);
}

static const u16 BodyDefTable_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 BodyDefTable_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 BodyDefTable_Out2All[] = { 0, 1, 2, 3, 4, 5};

static u32 BodyDefTable_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err BodyDefTable_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = BodyDefTable_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = BodyDefTable_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = BodyDefTable_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err BodyDefTable_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bodySceneGraphNodeName";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_BodyDefTable *) node)->bodySceneGraphNodeName;
		return M4OK;
	case 1:
		info->name = "bapIDs";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_BodyDefTable *) node)->bapIDs;
		return M4OK;
	case 2:
		info->name = "vertexIds";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_BodyDefTable *) node)->vertexIds;
		return M4OK;
	case 3:
		info->name = "bapCombinations";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_BodyDefTable *) node)->bapCombinations;
		return M4OK;
	case 4:
		info->name = "displacements";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_BodyDefTable *) node)->displacements;
		return M4OK;
	case 5:
		info->name = "numInterpolateKeys";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_BodyDefTable *) node)->numInterpolateKeys;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool BodyDefTable_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 9;
		*b_min = (Float) 1;
		*b_max = (Float) 296;
		return 1;
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 2;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *BodyDefTable_Create()
{
	B_BodyDefTable *p;
	SAFEALLOC(p, sizeof(B_BodyDefTable));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_BodyDefTable);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "BodyDefTable";
	((SFNode *)p)->sgprivate->node_del = BodyDefTable_Del;
	((SFNode *)p)->sgprivate->get_field_count = BodyDefTable_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = BodyDefTable_get_field_index;
	((SFNode *)p)->sgprivate->get_field = BodyDefTable_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = BodyDefTable_get_aq_info;

#endif


	/*default field values*/
	p->numInterpolateKeys = 2;
	return (SFNode *)p;
}


/*
	BodySegmentConnectionHint Node deletion
*/

static void BodySegmentConnectionHint_Del(SFNode *node)
{
	B_BodySegmentConnectionHint *p = (B_BodySegmentConnectionHint *) node;
	SFString_Del(p->firstSegmentNodeName);
	SFString_Del(p->secondSegmentNodeName);
	MFInt32_Del(p->firstVertexIdList);
	MFInt32_Del(p->secondVertexIdList);
	SFNode_Delete((SFNode *) p);
}

static const u16 BodySegmentConnectionHint_Def2All[] = { 0, 1, 2, 3};
static const u16 BodySegmentConnectionHint_In2All[] = { 0, 1, 2, 3};
static const u16 BodySegmentConnectionHint_Out2All[] = { 0, 1, 2, 3};

static u32 BodySegmentConnectionHint_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 4;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err BodySegmentConnectionHint_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = BodySegmentConnectionHint_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = BodySegmentConnectionHint_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = BodySegmentConnectionHint_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err BodySegmentConnectionHint_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "firstSegmentNodeName";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_BodySegmentConnectionHint *) node)->firstSegmentNodeName;
		return M4OK;
	case 1:
		info->name = "secondSegmentNodeName";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_BodySegmentConnectionHint *) node)->secondSegmentNodeName;
		return M4OK;
	case 2:
		info->name = "firstVertexIdList";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_BodySegmentConnectionHint *) node)->firstVertexIdList;
		return M4OK;
	case 3:
		info->name = "secondVertexIdList";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_BodySegmentConnectionHint *) node)->secondVertexIdList;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool BodySegmentConnectionHint_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *BodySegmentConnectionHint_Create()
{
	B_BodySegmentConnectionHint *p;
	SAFEALLOC(p, sizeof(B_BodySegmentConnectionHint));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_BodySegmentConnectionHint);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "BodySegmentConnectionHint";
	((SFNode *)p)->sgprivate->node_del = BodySegmentConnectionHint_Del;
	((SFNode *)p)->sgprivate->get_field_count = BodySegmentConnectionHint_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = BodySegmentConnectionHint_get_field_index;
	((SFNode *)p)->sgprivate->get_field = BodySegmentConnectionHint_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = BodySegmentConnectionHint_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	DirectiveSound Node deletion
*/

static void DirectiveSound_Del(SFNode *node)
{
	B_DirectiveSound *p = (B_DirectiveSound *) node;
	Node_Delete((SFNode *) p->source, (SFNode *) p);	
	Node_Delete((SFNode *) p->perceptualParameters, (SFNode *) p);	
	MFFloat_Del(p->directivity);
	MFFloat_Del(p->angles);
	MFFloat_Del(p->frequency);
	SFNode_Delete((SFNode *) p);
}

static const u16 DirectiveSound_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
static const u16 DirectiveSound_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 DirectiveSound_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 DirectiveSound_Dyn2All[] = { 0, 1, 2};

static u32 DirectiveSound_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 13;
	case FCM_OUT: return 7;
	case FCM_DYN: return 3;
	default:
		return 13;
	}
}

static M4Err DirectiveSound_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = DirectiveSound_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = DirectiveSound_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = DirectiveSound_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = DirectiveSound_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err DirectiveSound_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "direction";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_DirectiveSound *) node)->direction;
		return M4OK;
	case 1:
		info->name = "intensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->intensity;
		return M4OK;
	case 2:
		info->name = "location";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec3f;
		info->far_ptr = & ((B_DirectiveSound *) node)->location;
		return M4OK;
	case 3:
		info->name = "source";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFAudioNode;
		info->far_ptr = & ((B_DirectiveSound *)node)->source;
		return M4OK;
	case 4:
		info->name = "perceptualParameters";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFPerceptualParameterNode;
		info->far_ptr = & ((B_DirectiveSound *)node)->perceptualParameters;
		return M4OK;
	case 5:
		info->name = "roomEffect";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DirectiveSound *) node)->roomEffect;
		return M4OK;
	case 6:
		info->name = "spatialize";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DirectiveSound *) node)->spatialize;
		return M4OK;
	case 7:
		info->name = "directivity";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->directivity;
		return M4OK;
	case 8:
		info->name = "angles";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->angles;
		return M4OK;
	case 9:
		info->name = "frequency";
		info->eventType = ET_Field;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->frequency;
		return M4OK;
	case 10:
		info->name = "speedOfSound";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->speedOfSound;
		return M4OK;
	case 11:
		info->name = "distance";
		info->eventType = ET_Field;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_DirectiveSound *) node)->distance;
		return M4OK;
	case 12:
		info->name = "useAirabs";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_DirectiveSound *) node)->useAirabs;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool DirectiveSound_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 9;
		*QType = 9;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 3.14159265;
		return 1;
	case 9:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 0;
		*QType = 1;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *DirectiveSound_Create()
{
	B_DirectiveSound *p;
	SAFEALLOC(p, sizeof(B_DirectiveSound));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_DirectiveSound);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "DirectiveSound";
	((SFNode *)p)->sgprivate->node_del = DirectiveSound_Del;
	((SFNode *)p)->sgprivate->get_field_count = DirectiveSound_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = DirectiveSound_get_field_index;
	((SFNode *)p)->sgprivate->get_field = DirectiveSound_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = DirectiveSound_get_aq_info;

#endif


	/*default field values*/
	p->direction.x = (SFFloat) 0;
	p->direction.y = (SFFloat) 0;
	p->direction.z = (SFFloat) -1;
	p->intensity = (SFFloat) 1;
	p->location.x = (SFFloat) 0;
	p->location.y = (SFFloat) 0;
	p->location.z = (SFFloat) 0;
	p->spatialize = 1;
	p->directivity.vals = malloc(sizeof(SFFloat)*1);
	p->directivity.count = 1;
	p->directivity.vals[0] = (SFFloat) 1;
	p->angles.vals = malloc(sizeof(SFFloat)*1);
	p->angles.count = 1;
	p->angles.vals[0] = (SFFloat) 1;
	p->speedOfSound = (SFFloat) 340;
	p->distance = (SFFloat) 100;
	return (SFNode *)p;
}


/*
	Hierarchical3DMesh Node deletion
*/

static void Hierarchical3DMesh_Del(SFNode *node)
{
	B_Hierarchical3DMesh *p = (B_Hierarchical3DMesh *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 Hierarchical3DMesh_Def2All[] = { 1, 2};
static const u16 Hierarchical3DMesh_In2All[] = { 0, 1};
static const u16 Hierarchical3DMesh_Out2All[] = { 1, 3};

static u32 Hierarchical3DMesh_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 2;
	case FCM_DEF: return 2;
	case FCM_OUT: return 2;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err Hierarchical3DMesh_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Hierarchical3DMesh_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Hierarchical3DMesh_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Hierarchical3DMesh_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Hierarchical3DMesh_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "triangleBudget";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Hierarchical3DMesh *)node)->on_triangleBudget;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Hierarchical3DMesh *) node)->triangleBudget;
		return M4OK;
	case 1:
		info->name = "level";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Hierarchical3DMesh *) node)->level;
		return M4OK;
	case 2:
		info->name = "url";
		info->eventType = ET_Field;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_Hierarchical3DMesh *) node)->url;
		return M4OK;
	case 3:
		info->name = "doneLoading";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Hierarchical3DMesh *) node)->doneLoading;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Hierarchical3DMesh_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 0;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Hierarchical3DMesh_Create()
{
	B_Hierarchical3DMesh *p;
	SAFEALLOC(p, sizeof(B_Hierarchical3DMesh));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Hierarchical3DMesh);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Hierarchical3DMesh";
	((SFNode *)p)->sgprivate->node_del = Hierarchical3DMesh_Del;
	((SFNode *)p)->sgprivate->get_field_count = Hierarchical3DMesh_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Hierarchical3DMesh_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Hierarchical3DMesh_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Hierarchical3DMesh_get_aq_info;

#endif


	/*default field values*/
	p->level = (SFFloat) 1;
	return (SFNode *)p;
}


/*
	MaterialKey Node deletion
*/

static void MaterialKey_Del(SFNode *node)
{
	B_MaterialKey *p = (B_MaterialKey *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 MaterialKey_Def2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 MaterialKey_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 MaterialKey_Out2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 MaterialKey_Dyn2All[] = { 2, 3, 4, 5};

static u32 MaterialKey_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 6;
	case FCM_DYN: return 4;
	default:
		return 6;
	}
}

static M4Err MaterialKey_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MaterialKey_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MaterialKey_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MaterialKey_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = MaterialKey_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MaterialKey_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "isKeyed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MaterialKey *) node)->isKeyed;
		return M4OK;
	case 1:
		info->name = "isRGB";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MaterialKey *) node)->isRGB;
		return M4OK;
	case 2:
		info->name = "keyColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_MaterialKey *) node)->keyColor;
		return M4OK;
	case 3:
		info->name = "lowThreshold";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MaterialKey *) node)->lowThreshold;
		return M4OK;
	case 4:
		info->name = "highThreshold";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MaterialKey *) node)->highThreshold;
		return M4OK;
	case 5:
		info->name = "transparency";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MaterialKey *) node)->transparency;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MaterialKey_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 2:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *MaterialKey_Create()
{
	B_MaterialKey *p;
	SAFEALLOC(p, sizeof(B_MaterialKey));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MaterialKey);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MaterialKey";
	((SFNode *)p)->sgprivate->node_del = MaterialKey_Del;
	((SFNode *)p)->sgprivate->get_field_count = MaterialKey_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MaterialKey_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MaterialKey_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MaterialKey_get_aq_info;

#endif


	/*default field values*/
	p->isKeyed = 1;
	p->isRGB = 1;
	p->keyColor.red = (SFFloat) 0;
	p->keyColor.green = (SFFloat) 0;
	p->keyColor.blue = (SFFloat) 0;
	p->lowThreshold = (SFFloat) 0;
	p->highThreshold = (SFFloat) 0;
	p->transparency = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	PerceptualParameters Node deletion
*/

static void PerceptualParameters_Del(SFNode *node)
{
	B_PerceptualParameters *p = (B_PerceptualParameters *) node;
	MFFloat_Del(p->omniDirectivity);
	MFFloat_Del(p->directFilterGains);
	MFFloat_Del(p->inputFilterGains);
	SFNode_Delete((SFNode *) p);
}

static const u16 PerceptualParameters_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
static const u16 PerceptualParameters_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
static const u16 PerceptualParameters_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
static const u16 PerceptualParameters_Dyn2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14};

static u32 PerceptualParameters_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 19;
	case FCM_DEF: return 19;
	case FCM_OUT: return 19;
	case FCM_DYN: return 15;
	default:
		return 19;
	}
}

static M4Err PerceptualParameters_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PerceptualParameters_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PerceptualParameters_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PerceptualParameters_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = PerceptualParameters_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PerceptualParameters_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "sourcePresence";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->sourcePresence;
		return M4OK;
	case 1:
		info->name = "sourceWarmth";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->sourceWarmth;
		return M4OK;
	case 2:
		info->name = "sourceBrilliance";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->sourceBrilliance;
		return M4OK;
	case 3:
		info->name = "roomPresence";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->roomPresence;
		return M4OK;
	case 4:
		info->name = "runningReverberance";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->runningReverberance;
		return M4OK;
	case 5:
		info->name = "envelopment";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->envelopment;
		return M4OK;
	case 6:
		info->name = "lateReverberance";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->lateReverberance;
		return M4OK;
	case 7:
		info->name = "heavyness";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->heavyness;
		return M4OK;
	case 8:
		info->name = "liveness";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->liveness;
		return M4OK;
	case 9:
		info->name = "omniDirectivity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->omniDirectivity;
		return M4OK;
	case 10:
		info->name = "directFilterGains";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->directFilterGains;
		return M4OK;
	case 11:
		info->name = "inputFilterGains";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->inputFilterGains;
		return M4OK;
	case 12:
		info->name = "refDistance";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->refDistance;
		return M4OK;
	case 13:
		info->name = "freqLow";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->freqLow;
		return M4OK;
	case 14:
		info->name = "freqHigh";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PerceptualParameters *) node)->freqHigh;
		return M4OK;
	case 15:
		info->name = "timeLimit1";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_PerceptualParameters *) node)->timeLimit1;
		return M4OK;
	case 16:
		info->name = "timeLimit2";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_PerceptualParameters *) node)->timeLimit2;
		return M4OK;
	case 17:
		info->name = "timeLimit3";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_PerceptualParameters *) node)->timeLimit3;
		return M4OK;
	case 18:
		info->name = "modalDensity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_PerceptualParameters *) node)->modalDensity;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PerceptualParameters_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 14:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 15:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 16:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 17:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 18:
		*AType = 0;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *PerceptualParameters_Create()
{
	B_PerceptualParameters *p;
	SAFEALLOC(p, sizeof(B_PerceptualParameters));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PerceptualParameters);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PerceptualParameters";
	((SFNode *)p)->sgprivate->node_del = PerceptualParameters_Del;
	((SFNode *)p)->sgprivate->get_field_count = PerceptualParameters_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PerceptualParameters_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PerceptualParameters_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PerceptualParameters_get_aq_info;

#endif


	/*default field values*/
	p->sourcePresence = (SFFloat) 1.0;
	p->sourceWarmth = (SFFloat) 1.0;
	p->sourceBrilliance = (SFFloat) 1.0;
	p->roomPresence = (SFFloat) 1.0;
	p->runningReverberance = (SFFloat) 1.0;
	p->envelopment = (SFFloat) 0.0;
	p->lateReverberance = (SFFloat) 1.0;
	p->heavyness = (SFFloat) 1.0;
	p->liveness = (SFFloat) 1.0;
	p->omniDirectivity.vals = malloc(sizeof(SFFloat)*1);
	p->omniDirectivity.count = 1;
	p->omniDirectivity.vals[0] = (SFFloat) 1.0;
	p->directFilterGains.vals = malloc(sizeof(SFFloat)*3);
	p->directFilterGains.count = 3;
	p->directFilterGains.vals[0] = (SFFloat) 1.0;
	p->directFilterGains.vals[1] = (SFFloat) 1.0;
	p->directFilterGains.vals[2] = (SFFloat) 1.0;
	p->inputFilterGains.vals = malloc(sizeof(SFFloat)*3);
	p->inputFilterGains.count = 3;
	p->inputFilterGains.vals[0] = (SFFloat) 1.0;
	p->inputFilterGains.vals[1] = (SFFloat) 1.0;
	p->inputFilterGains.vals[2] = (SFFloat) 1.0;
	p->refDistance = (SFFloat) 1.0;
	p->freqLow = (SFFloat) 250.0;
	p->freqHigh = (SFFloat) 4000.0;
	p->timeLimit1 = 0.02;
	p->timeLimit2 = 0.04;
	p->timeLimit3 = 0.1;
	p->modalDensity = 0.8;
	return (SFNode *)p;
}


/*
	TemporalTransform Node deletion
*/

static void TemporalTransform_Del(SFNode *node)
{
	B_TemporalTransform *p = (B_TemporalTransform *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFURL_Del(p->url);
	MFInt32_Del(p->stretchMode);
	MFInt32_Del(p->shrinkMode);
	SFNode_Delete((SFNode *) p);
}

static const u16 TemporalTransform_Def2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
static const u16 TemporalTransform_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
static const u16 TemporalTransform_Out2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
static const u16 TemporalTransform_Dyn2All[] = { 7, 8};

static u32 TemporalTransform_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 12;
	case FCM_DEF: return 10;
	case FCM_OUT: return 11;
	case FCM_DYN: return 2;
	default:
		return 13;
	}
}

static M4Err TemporalTransform_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TemporalTransform_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TemporalTransform_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TemporalTransform_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = TemporalTransform_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TemporalTransform_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TemporalTransform *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_TemporalTransform *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TemporalTransform *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_TemporalTransform *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_TemporalTransform *)node)->children;
		return M4OK;
	case 3:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_TemporalTransform *) node)->url;
		return M4OK;
	case 4:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TemporalTransform *) node)->startTime;
		return M4OK;
	case 5:
		info->name = "optimalDuration";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TemporalTransform *) node)->optimalDuration;
		return M4OK;
	case 6:
		info->name = "active";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TemporalTransform *) node)->active;
		return M4OK;
	case 7:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TemporalTransform *) node)->speed;
		return M4OK;
	case 8:
		info->name = "scalability";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_TemporalTransform *) node)->scalability;
		return M4OK;
	case 9:
		info->name = "stretchMode";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_TemporalTransform *) node)->stretchMode;
		return M4OK;
	case 10:
		info->name = "shrinkMode";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_TemporalTransform *) node)->shrinkMode;
		return M4OK;
	case 11:
		info->name = "maxDelay";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TemporalTransform *) node)->maxDelay;
		return M4OK;
	case 12:
		info->name = "actualDuration";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_TemporalTransform *) node)->actualDuration;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TemporalTransform_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 7:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 12;
		*QType = 12;
		*b_min = (Float) -1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	case 10:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 1;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	default:
		return 0;
	}
}



SFNode *TemporalTransform_Create()
{
	B_TemporalTransform *p;
	SAFEALLOC(p, sizeof(B_TemporalTransform));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TemporalTransform);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TemporalTransform";
	((SFNode *)p)->sgprivate->node_del = TemporalTransform_Del;
	((SFNode *)p)->sgprivate->get_field_count = TemporalTransform_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TemporalTransform_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TemporalTransform_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TemporalTransform_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->startTime = -1.0;
	p->optimalDuration = -1.0;
	p->speed = (SFFloat) 1.0;
	p->scalability.x = (SFFloat) 1.0;
	p->scalability.y = (SFFloat) 1.0;
	p->stretchMode.vals = malloc(sizeof(SFInt32)*1);
	p->stretchMode.count = 1;
	p->stretchMode.vals[0] = 0;
	p->shrinkMode.vals = malloc(sizeof(SFInt32)*1);
	p->shrinkMode.count = 1;
	p->shrinkMode.vals[0] = 0;
	p->maxDelay = 0;
	return (SFNode *)p;
}


/*
	TemporalGroup Node deletion
*/

static void TemporalGroup_Del(SFNode *node)
{
	B_TemporalGroup *p = (B_TemporalGroup *) node;
	DestroyChildrenNode((SFNode *) p);	
	MFFloat_Del(p->priority);
	SFNode_Delete((SFNode *) p);
}

static const u16 TemporalGroup_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 TemporalGroup_In2All[] = { 0, 1, 2, 6};
static const u16 TemporalGroup_Out2All[] = { 2, 6, 7, 8};

static u32 TemporalGroup_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 5;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err TemporalGroup_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TemporalGroup_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TemporalGroup_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TemporalGroup_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TemporalGroup_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TemporalGroup *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFTemporalNode;
		info->far_ptr = & ((B_TemporalGroup *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TemporalGroup *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFTemporalNode;
		info->far_ptr = & ((B_TemporalGroup *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SFTemporalNode;
		info->far_ptr = & ((B_TemporalGroup *)node)->children;
		return M4OK;
	case 3:
		info->name = "costart";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TemporalGroup *) node)->costart;
		return M4OK;
	case 4:
		info->name = "coend";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TemporalGroup *) node)->coend;
		return M4OK;
	case 5:
		info->name = "meet";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TemporalGroup *) node)->meet;
		return M4OK;
	case 6:
		info->name = "priority";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_TemporalGroup *) node)->priority;
		return M4OK;
	case 7:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_TemporalGroup *) node)->isActive;
		return M4OK;
	case 8:
		info->name = "activeChild";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_TemporalGroup *) node)->activeChild;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TemporalGroup_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 6:
		*AType = 0;
		*QType = 3;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *TemporalGroup_Create()
{
	B_TemporalGroup *p;
	SAFEALLOC(p, sizeof(B_TemporalGroup));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TemporalGroup);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TemporalGroup";
	((SFNode *)p)->sgprivate->node_del = TemporalGroup_Del;
	((SFNode *)p)->sgprivate->get_field_count = TemporalGroup_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TemporalGroup_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TemporalGroup_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TemporalGroup_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SFTemporalNode;

#endif


	/*default field values*/
	p->costart = 1;
	return (SFNode *)p;
}


/*
	ServerCommand Node deletion
*/

static void ServerCommand_Del(SFNode *node)
{
	B_ServerCommand *p = (B_ServerCommand *) node;
	MFURL_Del(p->url);
	SFString_Del(p->command);
	SFNode_Delete((SFNode *) p);
}

static const u16 ServerCommand_Def2All[] = { 1, 2, 3};
static const u16 ServerCommand_In2All[] = { 0, 1, 2, 3};
static const u16 ServerCommand_Out2All[] = { 1, 2, 3};

static u32 ServerCommand_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 4;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err ServerCommand_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ServerCommand_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ServerCommand_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ServerCommand_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ServerCommand_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "trigger";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ServerCommand *)node)->on_trigger;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ServerCommand *) node)->trigger;
		return M4OK;
	case 1:
		info->name = "enable";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_ServerCommand *) node)->enable;
		return M4OK;
	case 2:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_ServerCommand *) node)->url;
		return M4OK;
	case 3:
		info->name = "command";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_ServerCommand *) node)->command;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ServerCommand_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *ServerCommand_Create()
{
	B_ServerCommand *p;
	SAFEALLOC(p, sizeof(B_ServerCommand));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ServerCommand);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ServerCommand";
	((SFNode *)p)->sgprivate->node_del = ServerCommand_Del;
	((SFNode *)p)->sgprivate->get_field_count = ServerCommand_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ServerCommand_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ServerCommand_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ServerCommand_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	InputSensor Node deletion
*/

static void InputSensor_Del(SFNode *node)
{
	B_InputSensor *p = (B_InputSensor *) node;
	SFCommandBuffer_Del(p->buffer);
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 InputSensor_Def2All[] = { 0, 1, 2};
static const u16 InputSensor_In2All[] = { 0, 1, 2};
static const u16 InputSensor_Out2All[] = { 0, 1, 2, 3};

static u32 InputSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 4;
	case FCM_DYN: return 0;
	default:
		return 4;
	}
}

static M4Err InputSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = InputSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = InputSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = InputSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err InputSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_InputSensor *) node)->enabled;
		return M4OK;
	case 1:
		info->name = "buffer";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFCommandBuffer;
		info->far_ptr = & ((B_InputSensor *) node)->buffer;
		return M4OK;
	case 2:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_InputSensor *) node)->url;
		return M4OK;
	case 3:
		info->name = "eventTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_InputSensor *) node)->eventTime;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool InputSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *InputSensor_Create()
{
	B_InputSensor *p;
	SAFEALLOC(p, sizeof(B_InputSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_InputSensor);
	p->buffer.commandList = NewChain();	

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "InputSensor";
	((SFNode *)p)->sgprivate->node_del = InputSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = InputSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = InputSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = InputSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = InputSensor_get_aq_info;

#endif


	/*default field values*/
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	MatteTexture Node deletion
*/

static void MatteTexture_Del(SFNode *node)
{
	B_MatteTexture *p = (B_MatteTexture *) node;
	Node_Delete((SFNode *) p->surfaceA, (SFNode *) p);	
	Node_Delete((SFNode *) p->surfaceB, (SFNode *) p);	
	Node_Delete((SFNode *) p->alphaSurface, (SFNode *) p);	
	SFString_Del(p->operation);
	MFFloat_Del(p->parameter);
	SFNode_Delete((SFNode *) p);
}

static const u16 MatteTexture_Def2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 MatteTexture_In2All[] = { 3, 5, 6};
static const u16 MatteTexture_Out2All[] = { 3, 5, 6};

static u32 MatteTexture_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 7;
	case FCM_OUT: return 3;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err MatteTexture_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MatteTexture_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MatteTexture_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MatteTexture_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MatteTexture_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "surfaceA";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureNode;
		info->far_ptr = & ((B_MatteTexture *)node)->surfaceA;
		return M4OK;
	case 1:
		info->name = "surfaceB";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureNode;
		info->far_ptr = & ((B_MatteTexture *)node)->surfaceB;
		return M4OK;
	case 2:
		info->name = "alphaSurface";
		info->eventType = ET_Field;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureNode;
		info->far_ptr = & ((B_MatteTexture *)node)->alphaSurface;
		return M4OK;
	case 3:
		info->name = "operation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_MatteTexture *) node)->operation;
		return M4OK;
	case 4:
		info->name = "overwrite";
		info->eventType = ET_Field;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MatteTexture *) node)->overwrite;
		return M4OK;
	case 5:
		info->name = "fraction";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MatteTexture *) node)->fraction;
		return M4OK;
	case 6:
		info->name = "parameter";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_MatteTexture *) node)->parameter;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MatteTexture_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *MatteTexture_Create()
{
	B_MatteTexture *p;
	SAFEALLOC(p, sizeof(B_MatteTexture));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MatteTexture);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MatteTexture";
	((SFNode *)p)->sgprivate->node_del = MatteTexture_Del;
	((SFNode *)p)->sgprivate->get_field_count = MatteTexture_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MatteTexture_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MatteTexture_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MatteTexture_get_aq_info;

#endif


	/*default field values*/
	p->fraction = (SFFloat) 0;
	p->parameter.vals = malloc(sizeof(SFFloat)*1);
	p->parameter.count = 1;
	p->parameter.vals[0] = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	MediaBuffer Node deletion
*/

static void MediaBuffer_Del(SFNode *node)
{
	B_MediaBuffer *p = (B_MediaBuffer *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 MediaBuffer_Def2All[] = { 0, 1, 2, 3, 5};
static const u16 MediaBuffer_In2All[] = { 0, 1, 2, 3, 5};
static const u16 MediaBuffer_Out2All[] = { 0, 1, 2, 3, 4, 5};

static u32 MediaBuffer_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 5;
	case FCM_DEF: return 5;
	case FCM_OUT: return 6;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err MediaBuffer_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MediaBuffer_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MediaBuffer_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MediaBuffer_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MediaBuffer_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "bufferSize";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MediaBuffer *) node)->bufferSize;
		return M4OK;
	case 1:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_MediaBuffer *) node)->url;
		return M4OK;
	case 2:
		info->name = "mediaStartTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaBuffer *) node)->mediaStartTime;
		return M4OK;
	case 3:
		info->name = "mediaStopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaBuffer *) node)->mediaStopTime;
		return M4OK;
	case 4:
		info->name = "isBuffered";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaBuffer *) node)->isBuffered;
		return M4OK;
	case 5:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaBuffer *) node)->enabled;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MediaBuffer_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *MediaBuffer_Create()
{
	B_MediaBuffer *p;
	SAFEALLOC(p, sizeof(B_MediaBuffer));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MediaBuffer);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MediaBuffer";
	((SFNode *)p)->sgprivate->node_del = MediaBuffer_Del;
	((SFNode *)p)->sgprivate->get_field_count = MediaBuffer_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MediaBuffer_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MediaBuffer_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MediaBuffer_get_aq_info;

#endif


	/*default field values*/
	p->bufferSize = (SFFloat) 0.0;
	p->mediaStartTime = -1;
	p->mediaStopTime = M4_MAX_FLOAT;
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	MediaControl Node deletion
*/

static void MediaControl_Del(SFNode *node)
{
	B_MediaControl *p = (B_MediaControl *) node;
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 MediaControl_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 MediaControl_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 MediaControl_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};

static u32 MediaControl_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 8;
	case FCM_OUT: return 9;
	case FCM_DYN: return 0;
	default:
		return 9;
	}
}

static M4Err MediaControl_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MediaControl_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MediaControl_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MediaControl_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MediaControl_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_MediaControl *) node)->url;
		return M4OK;
	case 1:
		info->name = "mediaStartTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaControl *) node)->mediaStartTime;
		return M4OK;
	case 2:
		info->name = "mediaStopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaControl *) node)->mediaStopTime;
		return M4OK;
	case 3:
		info->name = "mediaSpeed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_MediaControl *) node)->mediaSpeed;
		return M4OK;
	case 4:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaControl *) node)->loop;
		return M4OK;
	case 5:
		info->name = "preRoll";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaControl *) node)->preRoll;
		return M4OK;
	case 6:
		info->name = "mute";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaControl *) node)->mute;
		return M4OK;
	case 7:
		info->name = "enabled";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaControl *) node)->enabled;
		return M4OK;
	case 8:
		info->name = "isPreRolled";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaControl *) node)->isPreRolled;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MediaControl_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *MediaControl_Create()
{
	B_MediaControl *p;
	SAFEALLOC(p, sizeof(B_MediaControl));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MediaControl);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MediaControl";
	((SFNode *)p)->sgprivate->node_del = MediaControl_Del;
	((SFNode *)p)->sgprivate->get_field_count = MediaControl_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MediaControl_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MediaControl_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MediaControl_get_aq_info;

#endif


	/*default field values*/
	p->mediaStartTime = -1;
	p->mediaStopTime = M4_MAX_FLOAT;
	p->mediaSpeed = (SFFloat) 1.0;
	p->preRoll = 1;
	p->enabled = 1;
	return (SFNode *)p;
}


/*
	MediaSensor Node deletion
*/

static void MediaSensor_Del(SFNode *node)
{
	B_MediaSensor *p = (B_MediaSensor *) node;
	MFURL_Del(p->url);
	MFString_Del(p->info);
	SFNode_Delete((SFNode *) p);
}

static const u16 MediaSensor_Def2All[] = { 0};
static const u16 MediaSensor_In2All[] = { 0};
static const u16 MediaSensor_Out2All[] = { 0, 1, 2, 3, 4, 5};

static u32 MediaSensor_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 6;
	case FCM_DYN: return 0;
	default:
		return 6;
	}
}

static M4Err MediaSensor_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = MediaSensor_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = MediaSensor_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = MediaSensor_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err MediaSensor_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_MediaSensor *) node)->url;
		return M4OK;
	case 1:
		info->name = "mediaCurrentTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaSensor *) node)->mediaCurrentTime;
		return M4OK;
	case 2:
		info->name = "streamObjectStartTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaSensor *) node)->streamObjectStartTime;
		return M4OK;
	case 3:
		info->name = "mediaDuration";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_MediaSensor *) node)->mediaDuration;
		return M4OK;
	case 4:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_MediaSensor *) node)->isActive;
		return M4OK;
	case 5:
		info->name = "info";
		info->eventType = ET_EventOut;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_MediaSensor *) node)->info;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool MediaSensor_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *MediaSensor_Create()
{
	B_MediaSensor *p;
	SAFEALLOC(p, sizeof(B_MediaSensor));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_MediaSensor);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "MediaSensor";
	((SFNode *)p)->sgprivate->node_del = MediaSensor_Del;
	((SFNode *)p)->sgprivate->get_field_count = MediaSensor_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = MediaSensor_get_field_index;
	((SFNode *)p)->sgprivate->get_field = MediaSensor_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = MediaSensor_get_aq_info;

#endif


	/*default field values*/
	return (SFNode *)p;
}


/*
	Clipper2D Node deletion
*/

static void Clipper2D_Del(SFNode *node)
{
	B_Clipper2D *p = (B_Clipper2D *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->geometry, (SFNode *) p);	
	Node_Delete((SFNode *) p->transform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 Clipper2D_Def2All[] = { 2, 3, 4, 5, 6};
static const u16 Clipper2D_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 Clipper2D_Out2All[] = { 2, 3, 4, 5, 6};

static u32 Clipper2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 5;
	case FCM_OUT: return 5;
	case FCM_DYN: return 0;
	default:
		return 7;
	}
}

static M4Err Clipper2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Clipper2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Clipper2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Clipper2D_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Clipper2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Clipper2D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Clipper2D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Clipper2D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Clipper2D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Clipper2D *)node)->children;
		return M4OK;
	case 3:
		info->name = "geometry";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFGeometryNode;
		info->far_ptr = & ((B_Clipper2D *)node)->geometry;
		return M4OK;
	case 4:
		info->name = "inside";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Clipper2D *) node)->inside;
		return M4OK;
	case 5:
		info->name = "transform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_Clipper2D *)node)->transform;
		return M4OK;
	case 6:
		info->name = "XOR";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Clipper2D *) node)->XOR;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Clipper2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	default:
		return 0;
	}
}



SFNode *Clipper2D_Create()
{
	B_Clipper2D *p;
	SAFEALLOC(p, sizeof(B_Clipper2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Clipper2D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Clipper2D";
	((SFNode *)p)->sgprivate->node_del = Clipper2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = Clipper2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Clipper2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Clipper2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Clipper2D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->inside = 1;
	return (SFNode *)p;
}


/*
	ColorTransform Node deletion
*/

static void ColorTransform_Del(SFNode *node)
{
	B_ColorTransform *p = (B_ColorTransform *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 ColorTransform_Def2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
static const u16 ColorTransform_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
static const u16 ColorTransform_Out2All[] = { 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
static const u16 ColorTransform_Dyn2All[] = { 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};

static u32 ColorTransform_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 23;
	case FCM_DEF: return 21;
	case FCM_OUT: return 21;
	case FCM_DYN: return 20;
	default:
		return 23;
	}
}

static M4Err ColorTransform_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = ColorTransform_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = ColorTransform_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = ColorTransform_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = ColorTransform_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err ColorTransform_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ColorTransform *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_ColorTransform *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_ColorTransform *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_ColorTransform *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_ColorTransform *)node)->children;
		return M4OK;
	case 3:
		info->name = "mrr";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mrr;
		return M4OK;
	case 4:
		info->name = "mrg";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mrg;
		return M4OK;
	case 5:
		info->name = "mrb";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mrb;
		return M4OK;
	case 6:
		info->name = "mra";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mra;
		return M4OK;
	case 7:
		info->name = "tr";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->tr;
		return M4OK;
	case 8:
		info->name = "mgr";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mgr;
		return M4OK;
	case 9:
		info->name = "mgg";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mgg;
		return M4OK;
	case 10:
		info->name = "mgb";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mgb;
		return M4OK;
	case 11:
		info->name = "mga";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mga;
		return M4OK;
	case 12:
		info->name = "tg";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->tg;
		return M4OK;
	case 13:
		info->name = "mbr";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mbr;
		return M4OK;
	case 14:
		info->name = "mbg";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mbg;
		return M4OK;
	case 15:
		info->name = "mbb";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mbb;
		return M4OK;
	case 16:
		info->name = "mba";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mba;
		return M4OK;
	case 17:
		info->name = "tb";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->tb;
		return M4OK;
	case 18:
		info->name = "mar";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mar;
		return M4OK;
	case 19:
		info->name = "mag";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mag;
		return M4OK;
	case 20:
		info->name = "mab";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->mab;
		return M4OK;
	case 21:
		info->name = "maa";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->maa;
		return M4OK;
	case 22:
		info->name = "ta";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_ColorTransform *) node)->ta;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool ColorTransform_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 7;
		*QType = 4;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 11:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 12:
		*AType = 7;
		*QType = 4;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 13:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 14:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 15:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 16:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 17:
		*AType = 7;
		*QType = 4;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 18:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 19:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 20:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 21:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 22:
		*AType = 7;
		*QType = 4;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *ColorTransform_Create()
{
	B_ColorTransform *p;
	SAFEALLOC(p, sizeof(B_ColorTransform));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_ColorTransform);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "ColorTransform";
	((SFNode *)p)->sgprivate->node_del = ColorTransform_Del;
	((SFNode *)p)->sgprivate->get_field_count = ColorTransform_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = ColorTransform_get_field_index;
	((SFNode *)p)->sgprivate->get_field = ColorTransform_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = ColorTransform_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF3DNode;

#endif


	/*default field values*/
	p->mrr = (SFFloat) 1;
	p->mrg = (SFFloat) 0;
	p->mrb = (SFFloat) 0;
	p->mra = (SFFloat) 0;
	p->tr = (SFFloat) 0;
	p->mgr = (SFFloat) 0;
	p->mgg = (SFFloat) 1;
	p->mgb = (SFFloat) 0;
	p->mga = (SFFloat) 0;
	p->tg = (SFFloat) 0;
	p->mbr = (SFFloat) 0;
	p->mbg = (SFFloat) 0;
	p->mbb = (SFFloat) 1;
	p->mba = (SFFloat) 0;
	p->tb = (SFFloat) 0;
	p->mar = (SFFloat) 0;
	p->mag = (SFFloat) 0;
	p->mab = (SFFloat) 0;
	p->maa = (SFFloat) 1;
	p->ta = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Ellipse Node deletion
*/

static void Ellipse_Del(SFNode *node)
{
	B_Ellipse *p = (B_Ellipse *) node;
	SFNode_Delete((SFNode *) p);
}

static const u16 Ellipse_Def2All[] = { 0};
static const u16 Ellipse_In2All[] = { 0};
static const u16 Ellipse_Out2All[] = { 0};
static const u16 Ellipse_Dyn2All[] = { 0};

static u32 Ellipse_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 1;
	case FCM_DEF: return 1;
	case FCM_OUT: return 1;
	case FCM_DYN: return 1;
	default:
		return 1;
	}
}

static M4Err Ellipse_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Ellipse_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Ellipse_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Ellipse_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Ellipse_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Ellipse_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "radius";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Ellipse *) node)->radius;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Ellipse_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *Ellipse_Create()
{
	B_Ellipse *p;
	SAFEALLOC(p, sizeof(B_Ellipse));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Ellipse);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Ellipse";
	((SFNode *)p)->sgprivate->node_del = Ellipse_Del;
	((SFNode *)p)->sgprivate->get_field_count = Ellipse_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Ellipse_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Ellipse_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Ellipse_get_aq_info;

#endif


	/*default field values*/
	p->radius.x = (SFFloat) 1;
	p->radius.y = (SFFloat) 1;
	return (SFNode *)p;
}


/*
	LinearGradient Node deletion
*/

static void LinearGradient_Del(SFNode *node)
{
	B_LinearGradient *p = (B_LinearGradient *) node;
	MFFloat_Del(p->key);
	MFColor_Del(p->keyValue);
	MFFloat_Del(p->opacity);
	Node_Delete((SFNode *) p->transform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 LinearGradient_Def2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 LinearGradient_In2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 LinearGradient_Out2All[] = { 0, 1, 2, 3, 4, 5, 6};
static const u16 LinearGradient_Dyn2All[] = { 0, 5};

static u32 LinearGradient_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 7;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 2;
	default:
		return 7;
	}
}

static M4Err LinearGradient_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = LinearGradient_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = LinearGradient_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = LinearGradient_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = LinearGradient_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err LinearGradient_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "endPoint";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_LinearGradient *) node)->endPoint;
		return M4OK;
	case 1:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_LinearGradient *) node)->key;
		return M4OK;
	case 2:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_LinearGradient *) node)->keyValue;
		return M4OK;
	case 3:
		info->name = "opacity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_LinearGradient *) node)->opacity;
		return M4OK;
	case 4:
		info->name = "spreadMethod";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_LinearGradient *) node)->spreadMethod;
		return M4OK;
	case 5:
		info->name = "startPoint";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_LinearGradient *) node)->startPoint;
		return M4OK;
	case 6:
		info->name = "transform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_LinearGradient *)node)->transform;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool LinearGradient_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 5;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 0;
		*QType = 7;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	case 5:
		*AType = 2;
		*QType = 5;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *LinearGradient_Create()
{
	B_LinearGradient *p;
	SAFEALLOC(p, sizeof(B_LinearGradient));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_LinearGradient);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "LinearGradient";
	((SFNode *)p)->sgprivate->node_del = LinearGradient_Del;
	((SFNode *)p)->sgprivate->get_field_count = LinearGradient_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = LinearGradient_get_field_index;
	((SFNode *)p)->sgprivate->get_field = LinearGradient_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = LinearGradient_get_aq_info;

#endif


	/*default field values*/
	p->endPoint.x = (SFFloat) 1;
	p->endPoint.y = (SFFloat) 0;
	p->opacity.vals = malloc(sizeof(SFFloat)*1);
	p->opacity.count = 1;
	p->opacity.vals[0] = (SFFloat) 1;
	p->spreadMethod = 0;
	p->startPoint.x = (SFFloat) 0;
	p->startPoint.y = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	PathLayout Node deletion
*/

static void PathLayout_Del(SFNode *node)
{
	B_PathLayout *p = (B_PathLayout *) node;
	DestroyChildrenNode((SFNode *) p);	
	Node_Delete((SFNode *) p->geometry, (SFNode *) p);	
	MFInt32_Del(p->alignment);
	SFNode_Delete((SFNode *) p);
}

static const u16 PathLayout_Def2All[] = { 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 PathLayout_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 PathLayout_Out2All[] = { 2, 3, 4, 5, 6, 7, 8, 9};
static const u16 PathLayout_Dyn2All[] = { 5, 6};

static u32 PathLayout_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 10;
	case FCM_DEF: return 8;
	case FCM_OUT: return 8;
	case FCM_DYN: return 2;
	default:
		return 10;
	}
}

static M4Err PathLayout_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = PathLayout_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = PathLayout_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = PathLayout_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = PathLayout_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err PathLayout_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_PathLayout *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_PathLayout *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_PathLayout *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_PathLayout *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_PathLayout *)node)->children;
		return M4OK;
	case 3:
		info->name = "geometry";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFGeometryNode;
		info->far_ptr = & ((B_PathLayout *)node)->geometry;
		return M4OK;
	case 4:
		info->name = "alignment";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_PathLayout *) node)->alignment;
		return M4OK;
	case 5:
		info->name = "pathOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PathLayout *) node)->pathOffset;
		return M4OK;
	case 6:
		info->name = "spacing";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_PathLayout *) node)->spacing;
		return M4OK;
	case 7:
		info->name = "reverseLayout";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PathLayout *) node)->reverseLayout;
		return M4OK;
	case 8:
		info->name = "wrapMode";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_PathLayout *) node)->wrapMode;
		return M4OK;
	case 9:
		info->name = "splitText";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_PathLayout *) node)->splitText;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool PathLayout_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) -1;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	default:
		return 0;
	}
}



SFNode *PathLayout_Create()
{
	B_PathLayout *p;
	SAFEALLOC(p, sizeof(B_PathLayout));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_PathLayout);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "PathLayout";
	((SFNode *)p)->sgprivate->node_del = PathLayout_Del;
	((SFNode *)p)->sgprivate->get_field_count = PathLayout_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = PathLayout_get_field_index;
	((SFNode *)p)->sgprivate->get_field = PathLayout_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = PathLayout_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->alignment.vals = malloc(sizeof(SFInt32)*1);
	p->alignment.count = 1;
	p->alignment.vals[0] = 0;
	p->pathOffset = (SFFloat) 0;
	p->spacing = (SFFloat) 1.0;
	p->wrapMode = 0;
	p->splitText = 1;
	return (SFNode *)p;
}


/*
	RadialGradient Node deletion
*/

static void RadialGradient_Del(SFNode *node)
{
	B_RadialGradient *p = (B_RadialGradient *) node;
	MFFloat_Del(p->key);
	MFColor_Del(p->keyValue);
	MFFloat_Del(p->opacity);
	Node_Delete((SFNode *) p->transform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 RadialGradient_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 RadialGradient_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 RadialGradient_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7};
static const u16 RadialGradient_Dyn2All[] = { 0, 1, 5};

static u32 RadialGradient_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 8;
	case FCM_DEF: return 8;
	case FCM_OUT: return 8;
	case FCM_DYN: return 3;
	default:
		return 8;
	}
}

static M4Err RadialGradient_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = RadialGradient_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = RadialGradient_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = RadialGradient_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = RadialGradient_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err RadialGradient_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "center";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_RadialGradient *) node)->center;
		return M4OK;
	case 1:
		info->name = "focalPoint";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_RadialGradient *) node)->focalPoint;
		return M4OK;
	case 2:
		info->name = "key";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_RadialGradient *) node)->key;
		return M4OK;
	case 3:
		info->name = "keyValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFColor;
		info->far_ptr = & ((B_RadialGradient *) node)->keyValue;
		return M4OK;
	case 4:
		info->name = "opacity";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_RadialGradient *) node)->opacity;
		return M4OK;
	case 5:
		info->name = "radius";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_RadialGradient *) node)->radius;
		return M4OK;
	case 6:
		info->name = "spreadMethod";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_RadialGradient *) node)->spreadMethod;
		return M4OK;
	case 7:
		info->name = "transform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SF3DNode;
		info->far_ptr = & ((B_RadialGradient *)node)->transform;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool RadialGradient_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 2;
		*QType = 5;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 2;
		*QType = 5;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 8;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 3:
		*AType = 0;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 4:
		*AType = 0;
		*QType = 7;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 2;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	default:
		return 0;
	}
}



SFNode *RadialGradient_Create()
{
	B_RadialGradient *p;
	SAFEALLOC(p, sizeof(B_RadialGradient));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_RadialGradient);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "RadialGradient";
	((SFNode *)p)->sgprivate->node_del = RadialGradient_Del;
	((SFNode *)p)->sgprivate->get_field_count = RadialGradient_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = RadialGradient_get_field_index;
	((SFNode *)p)->sgprivate->get_field = RadialGradient_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = RadialGradient_get_aq_info;

#endif


	/*default field values*/
	p->center.x = (SFFloat) 0.5;
	p->center.y = (SFFloat) 0.5;
	p->focalPoint.x = (SFFloat) 0;
	p->focalPoint.y = (SFFloat) 0;
	p->opacity.vals = malloc(sizeof(SFFloat)*1);
	p->opacity.count = 1;
	p->opacity.vals[0] = (SFFloat) 1;
	p->radius = (SFFloat) 0.5;
	p->spreadMethod = 0;
	return (SFNode *)p;
}


/*
	SynthesizedTexture Node deletion
*/

static void SynthesizedTexture_Del(SFNode *node)
{
	B_SynthesizedTexture *p = (B_SynthesizedTexture *) node;
	MFVec3f_Del(p->translation);
	MFRotation_Del(p->rotation);
	MFURL_Del(p->url);
	SFNode_Delete((SFNode *) p);
}

static const u16 SynthesizedTexture_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 SynthesizedTexture_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 SynthesizedTexture_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
static const u16 SynthesizedTexture_Dyn2All[] = { 0, 1, 5};

static u32 SynthesizedTexture_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 9;
	case FCM_OUT: return 11;
	case FCM_DYN: return 3;
	default:
		return 11;
	}
}

static M4Err SynthesizedTexture_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = SynthesizedTexture_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = SynthesizedTexture_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = SynthesizedTexture_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = SynthesizedTexture_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err SynthesizedTexture_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "translation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFVec3f;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->translation;
		return M4OK;
	case 1:
		info->name = "rotation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFRotation;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->rotation;
		return M4OK;
	case 2:
		info->name = "pixelWidth";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->pixelWidth;
		return M4OK;
	case 3:
		info->name = "pixelHeight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->pixelHeight;
		return M4OK;
	case 4:
		info->name = "loop";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->loop;
		return M4OK;
	case 5:
		info->name = "speed";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->speed;
		return M4OK;
	case 6:
		info->name = "startTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->startTime;
		return M4OK;
	case 7:
		info->name = "stopTime";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->stopTime;
		return M4OK;
	case 8:
		info->name = "url";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFURL;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->url;
		return M4OK;
	case 9:
		info->name = "duration_changed";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->duration_changed;
		return M4OK;
	case 10:
		info->name = "isActive";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_SynthesizedTexture *) node)->isActive;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool SynthesizedTexture_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 1:
		*AType = 10;
		*QType = 10;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	case 3:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 16;
		*b_min = (Float) 0;
		*b_max = (Float) 65535;
		return 1;
	case 5:
		*AType = 7;
		*QType = 0;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *SynthesizedTexture_Create()
{
	B_SynthesizedTexture *p;
	SAFEALLOC(p, sizeof(B_SynthesizedTexture));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_SynthesizedTexture);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "SynthesizedTexture";
	((SFNode *)p)->sgprivate->node_del = SynthesizedTexture_Del;
	((SFNode *)p)->sgprivate->get_field_count = SynthesizedTexture_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = SynthesizedTexture_get_field_index;
	((SFNode *)p)->sgprivate->get_field = SynthesizedTexture_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = SynthesizedTexture_get_aq_info;

#endif


	/*default field values*/
	p->pixelWidth = -1;
	p->pixelHeight = -1;
	p->speed = (SFFloat) 1.0;
	p->startTime = 0;
	p->stopTime = 0;
	return (SFNode *)p;
}


/*
	TransformMatrix2D Node deletion
*/

static void TransformMatrix2D_Del(SFNode *node)
{
	B_TransformMatrix2D *p = (B_TransformMatrix2D *) node;
	DestroyChildrenNode((SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 TransformMatrix2D_Def2All[] = { 2, 3, 4, 5, 6, 7, 8};
static const u16 TransformMatrix2D_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8};
static const u16 TransformMatrix2D_Out2All[] = { 2, 3, 4, 5, 6, 7, 8};
static const u16 TransformMatrix2D_Dyn2All[] = { 3, 4, 5, 6, 7, 8};

static u32 TransformMatrix2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 9;
	case FCM_DEF: return 7;
	case FCM_OUT: return 7;
	case FCM_DYN: return 6;
	default:
		return 9;
	}
}

static M4Err TransformMatrix2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = TransformMatrix2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = TransformMatrix2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = TransformMatrix2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = TransformMatrix2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err TransformMatrix2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "addChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TransformMatrix2D *)node)->on_addChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_TransformMatrix2D *)node)->addChildren;
		return M4OK;
	case 1:
		info->name = "removeChildren";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_TransformMatrix2D *)node)->on_removeChildren;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_TransformMatrix2D *)node)->removeChildren;
		return M4OK;
	case 2:
		info->name = "children";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFNode;
		info->NDTtype = NDT_SF2DNode;
		info->far_ptr = & ((B_TransformMatrix2D *)node)->children;
		return M4OK;
	case 3:
		info->name = "mxx";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->mxx;
		return M4OK;
	case 4:
		info->name = "mxy";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->mxy;
		return M4OK;
	case 5:
		info->name = "tx";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->tx;
		return M4OK;
	case 6:
		info->name = "myx";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->myx;
		return M4OK;
	case 7:
		info->name = "myy";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->myy;
		return M4OK;
	case 8:
		info->name = "ty";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_TransformMatrix2D *) node)->ty;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool TransformMatrix2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 3:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 4:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 5:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 6:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 7;
		*QType = 7;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *TransformMatrix2D_Create()
{
	B_TransformMatrix2D *p;
	SAFEALLOC(p, sizeof(B_TransformMatrix2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_TransformMatrix2D);
	SetupChildrenNode((SFNode *) p);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "TransformMatrix2D";
	((SFNode *)p)->sgprivate->node_del = TransformMatrix2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = TransformMatrix2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = TransformMatrix2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = TransformMatrix2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = TransformMatrix2D_get_aq_info;
	((SFNode *)p)->sgprivate->child_ndt = NDT_SF2DNode;

#endif


	/*default field values*/
	p->mxx = (SFFloat) 1;
	p->mxy = (SFFloat) 0;
	p->tx = (SFFloat) 0;
	p->myx = (SFFloat) 0;
	p->myy = (SFFloat) 1;
	p->ty = (SFFloat) 0;
	return (SFNode *)p;
}


/*
	Viewport Node deletion
*/

static void Viewport_Del(SFNode *node)
{
	B_Viewport *p = (B_Viewport *) node;
	MFInt32_Del(p->alignment);
	SFString_Del(p->description);
	SFNode_Delete((SFNode *) p);
}

static const u16 Viewport_Def2All[] = { 1, 2, 3, 4, 5, 6};
static const u16 Viewport_In2All[] = { 0, 1, 2, 3, 4, 5};
static const u16 Viewport_Out2All[] = { 1, 2, 3, 4, 5, 7, 8};
static const u16 Viewport_Dyn2All[] = { 1, 2, 3};

static u32 Viewport_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 6;
	case FCM_DEF: return 6;
	case FCM_OUT: return 7;
	case FCM_DYN: return 3;
	default:
		return 9;
	}
}

static M4Err Viewport_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = Viewport_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = Viewport_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = Viewport_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = Viewport_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err Viewport_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "set_bind";
		info->eventType = ET_EventIn;
		info->on_event_in = ((B_Viewport *)node)->on_set_bind;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viewport *) node)->set_bind;
		return M4OK;
	case 1:
		info->name = "position";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Viewport *) node)->position;
		return M4OK;
	case 2:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFVec2f;
		info->far_ptr = & ((B_Viewport *) node)->size;
		return M4OK;
	case 3:
		info->name = "orientation";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_Viewport *) node)->orientation;
		return M4OK;
	case 4:
		info->name = "alignment";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_Viewport *) node)->alignment;
		return M4OK;
	case 5:
		info->name = "fit";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_Viewport *) node)->fit;
		return M4OK;
	case 6:
		info->name = "description";
		info->eventType = ET_Field;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_Viewport *) node)->description;
		return M4OK;
	case 7:
		info->name = "bindTime";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFTime;
		info->far_ptr = & ((B_Viewport *) node)->bindTime;
		return M4OK;
	case 8:
		info->name = "isBound";
		info->eventType = ET_EventOut;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_Viewport *) node)->isBound;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool Viewport_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 1;
		*QType = 1;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 2:
		*AType = 12;
		*QType = 12;
		*b_min = M4_MIN_FLOAT;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 3:
		*AType = 6;
		*QType = 6;
		*b_min = (Float) 0;
		*b_max = (Float) 6.2831853;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) -1;
		*b_max = (Float) 1;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	default:
		return 0;
	}
}



SFNode *Viewport_Create()
{
	B_Viewport *p;
	SAFEALLOC(p, sizeof(B_Viewport));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_Viewport);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "Viewport";
	((SFNode *)p)->sgprivate->node_del = Viewport_Del;
	((SFNode *)p)->sgprivate->get_field_count = Viewport_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = Viewport_get_field_index;
	((SFNode *)p)->sgprivate->get_field = Viewport_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = Viewport_get_aq_info;

#endif


	/*default field values*/
	p->position.x = (SFFloat) 0;
	p->position.y = (SFFloat) 0;
	p->size.x = (SFFloat) -1;
	p->size.y = (SFFloat) -1;
	p->orientation = (SFFloat) 0;
	p->alignment.vals = malloc(sizeof(SFInt32)*1);
	p->alignment.count = 1;
	p->alignment.vals[0] = 0;
	p->fit = 0;
	return (SFNode *)p;
}


/*
	XCurve2D Node deletion
*/

static void XCurve2D_Del(SFNode *node)
{
	B_XCurve2D *p = (B_XCurve2D *) node;
	Node_Delete((SFNode *) p->point, (SFNode *) p);	
	MFInt32_Del(p->type);
	SFNode_Delete((SFNode *) p);
}

static const u16 XCurve2D_Def2All[] = { 0, 1, 2};
static const u16 XCurve2D_In2All[] = { 0, 1, 2};
static const u16 XCurve2D_Out2All[] = { 0, 1, 2};
static const u16 XCurve2D_Dyn2All[] = { 1};

static u32 XCurve2D_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 3;
	case FCM_DEF: return 3;
	case FCM_OUT: return 3;
	case FCM_DYN: return 1;
	default:
		return 3;
	}
}

static M4Err XCurve2D_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = XCurve2D_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = XCurve2D_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = XCurve2D_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = XCurve2D_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err XCurve2D_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "point";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFCoordinate2DNode;
		info->far_ptr = & ((B_XCurve2D *)node)->point;
		return M4OK;
	case 1:
		info->name = "fineness";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XCurve2D *) node)->fineness;
		return M4OK;
	case 2:
		info->name = "type";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_XCurve2D *) node)->type;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool XCurve2D_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 1:
		*AType = 7;
		*QType = 0;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 2:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 15;
		return 1;
	default:
		return 0;
	}
}



SFNode *XCurve2D_Create()
{
	B_XCurve2D *p;
	SAFEALLOC(p, sizeof(B_XCurve2D));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_XCurve2D);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "XCurve2D";
	((SFNode *)p)->sgprivate->node_del = XCurve2D_Del;
	((SFNode *)p)->sgprivate->get_field_count = XCurve2D_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = XCurve2D_get_field_index;
	((SFNode *)p)->sgprivate->get_field = XCurve2D_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = XCurve2D_get_aq_info;

#endif


	/*default field values*/
	p->fineness = (SFFloat) 0.5;
	return (SFNode *)p;
}


/*
	XFontStyle Node deletion
*/

static void XFontStyle_Del(SFNode *node)
{
	B_XFontStyle *p = (B_XFontStyle *) node;
	MFString_Del(p->fontName);
	MFString_Del(p->justify);
	SFString_Del(p->language);
	SFString_Del(p->stretch);
	SFString_Del(p->style);
	MFString_Del(p->featureName);
	MFInt32_Del(p->featureStartOffset);
	MFInt32_Del(p->featureLength);
	MFInt32_Del(p->featureValue);
	SFNode_Delete((SFNode *) p);
}

static const u16 XFontStyle_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
static const u16 XFontStyle_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
static const u16 XFontStyle_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

static u32 XFontStyle_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 17;
	case FCM_DEF: return 17;
	case FCM_OUT: return 17;
	case FCM_DYN: return 0;
	default:
		return 17;
	}
}

static M4Err XFontStyle_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = XFontStyle_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = XFontStyle_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = XFontStyle_Out2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err XFontStyle_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "fontName";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_XFontStyle *) node)->fontName;
		return M4OK;
	case 1:
		info->name = "horizontal";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XFontStyle *) node)->horizontal;
		return M4OK;
	case 2:
		info->name = "justify";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_XFontStyle *) node)->justify;
		return M4OK;
	case 3:
		info->name = "language";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_XFontStyle *) node)->language;
		return M4OK;
	case 4:
		info->name = "leftToRight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XFontStyle *) node)->leftToRight;
		return M4OK;
	case 5:
		info->name = "size";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XFontStyle *) node)->size;
		return M4OK;
	case 6:
		info->name = "stretch";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_XFontStyle *) node)->stretch;
		return M4OK;
	case 7:
		info->name = "letterSpacing";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XFontStyle *) node)->letterSpacing;
		return M4OK;
	case 8:
		info->name = "wordSpacing";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XFontStyle *) node)->wordSpacing;
		return M4OK;
	case 9:
		info->name = "weight";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_XFontStyle *) node)->weight;
		return M4OK;
	case 10:
		info->name = "fontKerning";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XFontStyle *) node)->fontKerning;
		return M4OK;
	case 11:
		info->name = "style";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFString;
		info->far_ptr = & ((B_XFontStyle *) node)->style;
		return M4OK;
	case 12:
		info->name = "topToBottom";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XFontStyle *) node)->topToBottom;
		return M4OK;
	case 13:
		info->name = "featureName";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFString;
		info->far_ptr = & ((B_XFontStyle *) node)->featureName;
		return M4OK;
	case 14:
		info->name = "featureStartOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_XFontStyle *) node)->featureStartOffset;
		return M4OK;
	case 15:
		info->name = "featureLength";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_XFontStyle *) node)->featureLength;
		return M4OK;
	case 16:
		info->name = "featureValue";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFInt32;
		info->far_ptr = & ((B_XFontStyle *) node)->featureValue;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool XFontStyle_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 5:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 8:
		*AType = 0;
		*QType = 11;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *XFontStyle_Create()
{
	B_XFontStyle *p;
	SAFEALLOC(p, sizeof(B_XFontStyle));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_XFontStyle);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "XFontStyle";
	((SFNode *)p)->sgprivate->node_del = XFontStyle_Del;
	((SFNode *)p)->sgprivate->get_field_count = XFontStyle_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = XFontStyle_get_field_index;
	((SFNode *)p)->sgprivate->get_field = XFontStyle_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = XFontStyle_get_aq_info;

#endif


	/*default field values*/
	p->fontName.vals = malloc(sizeof(SFString)*1);
	p->fontName.count = 1;
	p->fontName.vals[0] = malloc(sizeof(char) * 6);
	strcpy(p->fontName.vals[0], "SERIF");
	p->horizontal = 1;
	p->justify.vals = malloc(sizeof(SFString)*1);
	p->justify.count = 1;
	p->justify.vals[0] = malloc(sizeof(char) * 6);
	strcpy(p->justify.vals[0], "BEGIN");
	p->leftToRight = 1;
	p->size = (SFFloat) 1.0;
	p->stretch.buffer = malloc(sizeof(char) * 7);
	strcpy(p->stretch.buffer, "NORMAL");
	p->letterSpacing = (SFFloat) 0.0;
	p->wordSpacing = (SFFloat) 0.0;
	p->weight = 400;
	p->fontKerning = 1;
	p->style.buffer = malloc(sizeof(char) * 6);
	strcpy(p->style.buffer, "PLAIN");
	p->topToBottom = 1;
	return (SFNode *)p;
}


/*
	XLineProperties Node deletion
*/

static void XLineProperties_Del(SFNode *node)
{
	B_XLineProperties *p = (B_XLineProperties *) node;
	MFFloat_Del(p->dashes);
	Node_Delete((SFNode *) p->texture, (SFNode *) p);	
	Node_Delete((SFNode *) p->textureTransform, (SFNode *) p);	
	SFNode_Delete((SFNode *) p);
}

static const u16 XLineProperties_Def2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
static const u16 XLineProperties_In2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
static const u16 XLineProperties_Out2All[] = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
static const u16 XLineProperties_Dyn2All[] = { 0, 7, 8, 9, 10};

static u32 XLineProperties_get_field_count(SFNode *node, u8 IndexMode)
{
	switch(IndexMode) {
	case FCM_IN: return 13;
	case FCM_DEF: return 13;
	case FCM_OUT: return 13;
	case FCM_DYN: return 5;
	default:
		return 13;
	}
}

static M4Err XLineProperties_get_field_index(SFNode *n, u32 inField, u8 IndexMode, u32 *allField)
{
	switch(IndexMode) {
	case FCM_IN:
		*allField = XLineProperties_In2All[inField];
		return M4OK;
	case FCM_DEF:
		*allField = XLineProperties_Def2All[inField];
		return M4OK;
	case FCM_OUT:
		*allField = XLineProperties_Out2All[inField];
		return M4OK;
	case FCM_DYN:
		*allField = XLineProperties_Dyn2All[inField];
		return M4OK;
	default:
		return M4BadParam;
	}
}
static M4Err XLineProperties_get_field(SFNode *node, FieldInfo *info)
{
	switch (info->allIndex) {
	case 0:
		info->name = "lineColor";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFColor;
		info->far_ptr = & ((B_XLineProperties *) node)->lineColor;
		return M4OK;
	case 1:
		info->name = "lineStyle";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_XLineProperties *) node)->lineStyle;
		return M4OK;
	case 2:
		info->name = "isCenterAligned";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XLineProperties *) node)->isCenterAligned;
		return M4OK;
	case 3:
		info->name = "isScalable";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFBool;
		info->far_ptr = & ((B_XLineProperties *) node)->isScalable;
		return M4OK;
	case 4:
		info->name = "lineCap";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_XLineProperties *) node)->lineCap;
		return M4OK;
	case 5:
		info->name = "lineJoin";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFInt32;
		info->far_ptr = & ((B_XLineProperties *) node)->lineJoin;
		return M4OK;
	case 6:
		info->name = "miterLimit";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XLineProperties *) node)->miterLimit;
		return M4OK;
	case 7:
		info->name = "transparency";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XLineProperties *) node)->transparency;
		return M4OK;
	case 8:
		info->name = "width";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XLineProperties *) node)->width;
		return M4OK;
	case 9:
		info->name = "dashOffset";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFFloat;
		info->far_ptr = & ((B_XLineProperties *) node)->dashOffset;
		return M4OK;
	case 10:
		info->name = "dashes";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_MFFloat;
		info->far_ptr = & ((B_XLineProperties *) node)->dashes;
		return M4OK;
	case 11:
		info->name = "texture";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureNode;
		info->far_ptr = & ((B_XLineProperties *)node)->texture;
		return M4OK;
	case 12:
		info->name = "textureTransform";
		info->eventType = ET_ExposedField;
		info->fieldType = FT_SFNode;
		info->NDTtype = NDT_SFTextureTransformNode;
		info->far_ptr = & ((B_XLineProperties *)node)->textureTransform;
		return M4OK;
	default:
		return M4BadParam;
	}
}

static Bool XLineProperties_get_aq_info(SFNode *n, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (FieldIndex) {
	case 0:
		*AType = 4;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 1:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 5;
		return 1;
	case 4:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	case 5:
		*AType = 0;
		*QType = 13;
		*QT13_bits = 3;
		*b_min = (Float) 0;
		*b_max = (Float) 2;
		return 1;
	case 6:
		*AType = 0;
		*QType = 12;
		*b_min = (Float) 1;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 7:
		*AType = 8;
		*QType = 4;
		*b_min = (Float) 0;
		*b_max = (Float) 1;
		return 1;
	case 8:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 9:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	case 10:
		*AType = 7;
		*QType = 12;
		*b_min = (Float) 0;
		*b_max = M4_MAX_FLOAT;
		return 1;
	default:
		return 0;
	}
}



SFNode *XLineProperties_Create()
{
	B_XLineProperties *p;
	SAFEALLOC(p, sizeof(B_XLineProperties));
	if(!p) return NULL;
	Node_Setup((SFNode *)p, TAG_XLineProperties);

#ifdef NODE_USE_POINTERS

	((SFNode *)p)->sgprivate->name = "XLineProperties";
	((SFNode *)p)->sgprivate->node_del = XLineProperties_Del;
	((SFNode *)p)->sgprivate->get_field_count = XLineProperties_get_field_count;
	((SFNode *)p)->sgprivate->get_field_index = XLineProperties_get_field_index;
	((SFNode *)p)->sgprivate->get_field = XLineProperties_get_field;
	((SFNode *)p)->sgprivate->get_aq_info = XLineProperties_get_aq_info;

#endif


	/*default field values*/
	p->lineColor.red = (SFFloat) 0;
	p->lineColor.green = (SFFloat) 0;
	p->lineColor.blue = (SFFloat) 0;
	p->lineStyle = 0;
	p->isCenterAligned = 1;
	p->isScalable = 1;
	p->lineCap = 0;
	p->lineJoin = 0;
	p->miterLimit = (SFFloat) 4;
	p->transparency = (SFFloat) 0;
	p->width = (SFFloat) 1;
	p->dashOffset = (SFFloat) 0;
	return (SFNode *)p;
}




SFNode *CreateNode(u32 NodeTag)
{
	switch (NodeTag) {
	case TAG_Anchor:
		return Anchor_Create();
	case TAG_AnimationStream:
		return AnimationStream_Create();
	case TAG_Appearance:
		return Appearance_Create();
	case TAG_AudioBuffer:
		return AudioBuffer_Create();
	case TAG_AudioClip:
		return AudioClip_Create();
	case TAG_AudioDelay:
		return AudioDelay_Create();
	case TAG_AudioFX:
		return AudioFX_Create();
	case TAG_AudioMix:
		return AudioMix_Create();
	case TAG_AudioSource:
		return AudioSource_Create();
	case TAG_AudioSwitch:
		return AudioSwitch_Create();
	case TAG_Background:
		return Background_Create();
	case TAG_Background2D:
		return Background2D_Create();
	case TAG_Billboard:
		return Billboard_Create();
	case TAG_Bitmap:
		return Bitmap_Create();
	case TAG_Box:
		return Box_Create();
	case TAG_Circle:
		return Circle_Create();
	case TAG_Collision:
		return Collision_Create();
	case TAG_Color:
		return Color_Create();
	case TAG_ColorInterpolator:
		return ColorInterpolator_Create();
	case TAG_CompositeTexture2D:
		return CompositeTexture2D_Create();
	case TAG_CompositeTexture3D:
		return CompositeTexture3D_Create();
	case TAG_Conditional:
		return Conditional_Create();
	case TAG_Cone:
		return Cone_Create();
	case TAG_Coordinate:
		return Coordinate_Create();
	case TAG_Coordinate2D:
		return Coordinate2D_Create();
	case TAG_CoordinateInterpolator:
		return CoordinateInterpolator_Create();
	case TAG_CoordinateInterpolator2D:
		return CoordinateInterpolator2D_Create();
	case TAG_Curve2D:
		return Curve2D_Create();
	case TAG_Cylinder:
		return Cylinder_Create();
	case TAG_CylinderSensor:
		return CylinderSensor_Create();
	case TAG_DirectionalLight:
		return DirectionalLight_Create();
	case TAG_DiscSensor:
		return DiscSensor_Create();
	case TAG_ElevationGrid:
		return ElevationGrid_Create();
	case TAG_Expression:
		return Expression_Create();
	case TAG_Extrusion:
		return Extrusion_Create();
	case TAG_Face:
		return Face_Create();
	case TAG_FaceDefMesh:
		return FaceDefMesh_Create();
	case TAG_FaceDefTables:
		return FaceDefTables_Create();
	case TAG_FaceDefTransform:
		return FaceDefTransform_Create();
	case TAG_FAP:
		return FAP_Create();
	case TAG_FDP:
		return FDP_Create();
	case TAG_FIT:
		return FIT_Create();
	case TAG_Fog:
		return Fog_Create();
	case TAG_FontStyle:
		return FontStyle_Create();
	case TAG_Form:
		return Form_Create();
	case TAG_Group:
		return Group_Create();
	case TAG_ImageTexture:
		return ImageTexture_Create();
	case TAG_IndexedFaceSet:
		return IndexedFaceSet_Create();
	case TAG_IndexedFaceSet2D:
		return IndexedFaceSet2D_Create();
	case TAG_IndexedLineSet:
		return IndexedLineSet_Create();
	case TAG_IndexedLineSet2D:
		return IndexedLineSet2D_Create();
	case TAG_Inline:
		return Inline_Create();
	case TAG_LOD:
		return LOD_Create();
	case TAG_Layer2D:
		return Layer2D_Create();
	case TAG_Layer3D:
		return Layer3D_Create();
	case TAG_Layout:
		return Layout_Create();
	case TAG_LineProperties:
		return LineProperties_Create();
	case TAG_ListeningPoint:
		return ListeningPoint_Create();
	case TAG_Material:
		return Material_Create();
	case TAG_Material2D:
		return Material2D_Create();
	case TAG_MovieTexture:
		return MovieTexture_Create();
	case TAG_NavigationInfo:
		return NavigationInfo_Create();
	case TAG_Normal:
		return Normal_Create();
	case TAG_NormalInterpolator:
		return NormalInterpolator_Create();
	case TAG_OrderedGroup:
		return OrderedGroup_Create();
	case TAG_OrientationInterpolator:
		return OrientationInterpolator_Create();
	case TAG_PixelTexture:
		return PixelTexture_Create();
	case TAG_PlaneSensor:
		return PlaneSensor_Create();
	case TAG_PlaneSensor2D:
		return PlaneSensor2D_Create();
	case TAG_PointLight:
		return PointLight_Create();
	case TAG_PointSet:
		return PointSet_Create();
	case TAG_PointSet2D:
		return PointSet2D_Create();
	case TAG_PositionInterpolator:
		return PositionInterpolator_Create();
	case TAG_PositionInterpolator2D:
		return PositionInterpolator2D_Create();
	case TAG_ProximitySensor2D:
		return ProximitySensor2D_Create();
	case TAG_ProximitySensor:
		return ProximitySensor_Create();
	case TAG_QuantizationParameter:
		return QuantizationParameter_Create();
	case TAG_Rectangle:
		return Rectangle_Create();
	case TAG_ScalarInterpolator:
		return ScalarInterpolator_Create();
	case TAG_Script:
		return Script_Create();
	case TAG_Shape:
		return Shape_Create();
	case TAG_Sound:
		return Sound_Create();
	case TAG_Sound2D:
		return Sound2D_Create();
	case TAG_Sphere:
		return Sphere_Create();
	case TAG_SphereSensor:
		return SphereSensor_Create();
	case TAG_SpotLight:
		return SpotLight_Create();
	case TAG_Switch:
		return Switch_Create();
	case TAG_TermCap:
		return TermCap_Create();
	case TAG_Text:
		return Text_Create();
	case TAG_TextureCoordinate:
		return TextureCoordinate_Create();
	case TAG_TextureTransform:
		return TextureTransform_Create();
	case TAG_TimeSensor:
		return TimeSensor_Create();
	case TAG_TouchSensor:
		return TouchSensor_Create();
	case TAG_Transform:
		return Transform_Create();
	case TAG_Transform2D:
		return Transform2D_Create();
	case TAG_Valuator:
		return Valuator_Create();
	case TAG_Viewpoint:
		return Viewpoint_Create();
	case TAG_VisibilitySensor:
		return VisibilitySensor_Create();
	case TAG_Viseme:
		return Viseme_Create();
	case TAG_WorldInfo:
		return WorldInfo_Create();
	case TAG_AcousticMaterial:
		return AcousticMaterial_Create();
	case TAG_AcousticScene:
		return AcousticScene_Create();
	case TAG_ApplicationWindow:
		return ApplicationWindow_Create();
	case TAG_BAP:
		return BAP_Create();
	case TAG_BDP:
		return BDP_Create();
	case TAG_Body:
		return Body_Create();
	case TAG_BodyDefTable:
		return BodyDefTable_Create();
	case TAG_BodySegmentConnectionHint:
		return BodySegmentConnectionHint_Create();
	case TAG_DirectiveSound:
		return DirectiveSound_Create();
	case TAG_Hierarchical3DMesh:
		return Hierarchical3DMesh_Create();
	case TAG_MaterialKey:
		return MaterialKey_Create();
	case TAG_PerceptualParameters:
		return PerceptualParameters_Create();
	case TAG_TemporalTransform:
		return TemporalTransform_Create();
	case TAG_TemporalGroup:
		return TemporalGroup_Create();
	case TAG_ServerCommand:
		return ServerCommand_Create();
	case TAG_InputSensor:
		return InputSensor_Create();
	case TAG_MatteTexture:
		return MatteTexture_Create();
	case TAG_MediaBuffer:
		return MediaBuffer_Create();
	case TAG_MediaControl:
		return MediaControl_Create();
	case TAG_MediaSensor:
		return MediaSensor_Create();
	case TAG_Clipper2D:
		return Clipper2D_Create();
	case TAG_ColorTransform:
		return ColorTransform_Create();
	case TAG_Ellipse:
		return Ellipse_Create();
	case TAG_LinearGradient:
		return LinearGradient_Create();
	case TAG_PathLayout:
		return PathLayout_Create();
	case TAG_RadialGradient:
		return RadialGradient_Create();
	case TAG_SynthesizedTexture:
		return SynthesizedTexture_Create();
	case TAG_TransformMatrix2D:
		return TransformMatrix2D_Create();
	case TAG_Viewport:
		return Viewport_Create();
	case TAG_XCurve2D:
		return XCurve2D_Create();
	case TAG_XFontStyle:
		return XFontStyle_Create();
	case TAG_XLineProperties:
		return XLineProperties_Create();
	default:
		return NULL;
	}
}

#ifndef NODE_USE_POINTERS
const char *GetNodeName(u32 NodeTag)
{
	switch (NodeTag) {
	case TAG_Anchor:
		return "Anchor";
	case TAG_AnimationStream:
		return "AnimationStream";
	case TAG_Appearance:
		return "Appearance";
	case TAG_AudioBuffer:
		return "AudioBuffer";
	case TAG_AudioClip:
		return "AudioClip";
	case TAG_AudioDelay:
		return "AudioDelay";
	case TAG_AudioFX:
		return "AudioFX";
	case TAG_AudioMix:
		return "AudioMix";
	case TAG_AudioSource:
		return "AudioSource";
	case TAG_AudioSwitch:
		return "AudioSwitch";
	case TAG_Background:
		return "Background";
	case TAG_Background2D:
		return "Background2D";
	case TAG_Billboard:
		return "Billboard";
	case TAG_Bitmap:
		return "Bitmap";
	case TAG_Box:
		return "Box";
	case TAG_Circle:
		return "Circle";
	case TAG_Collision:
		return "Collision";
	case TAG_Color:
		return "Color";
	case TAG_ColorInterpolator:
		return "ColorInterpolator";
	case TAG_CompositeTexture2D:
		return "CompositeTexture2D";
	case TAG_CompositeTexture3D:
		return "CompositeTexture3D";
	case TAG_Conditional:
		return "Conditional";
	case TAG_Cone:
		return "Cone";
	case TAG_Coordinate:
		return "Coordinate";
	case TAG_Coordinate2D:
		return "Coordinate2D";
	case TAG_CoordinateInterpolator:
		return "CoordinateInterpolator";
	case TAG_CoordinateInterpolator2D:
		return "CoordinateInterpolator2D";
	case TAG_Curve2D:
		return "Curve2D";
	case TAG_Cylinder:
		return "Cylinder";
	case TAG_CylinderSensor:
		return "CylinderSensor";
	case TAG_DirectionalLight:
		return "DirectionalLight";
	case TAG_DiscSensor:
		return "DiscSensor";
	case TAG_ElevationGrid:
		return "ElevationGrid";
	case TAG_Expression:
		return "Expression";
	case TAG_Extrusion:
		return "Extrusion";
	case TAG_Face:
		return "Face";
	case TAG_FaceDefMesh:
		return "FaceDefMesh";
	case TAG_FaceDefTables:
		return "FaceDefTables";
	case TAG_FaceDefTransform:
		return "FaceDefTransform";
	case TAG_FAP:
		return "FAP";
	case TAG_FDP:
		return "FDP";
	case TAG_FIT:
		return "FIT";
	case TAG_Fog:
		return "Fog";
	case TAG_FontStyle:
		return "FontStyle";
	case TAG_Form:
		return "Form";
	case TAG_Group:
		return "Group";
	case TAG_ImageTexture:
		return "ImageTexture";
	case TAG_IndexedFaceSet:
		return "IndexedFaceSet";
	case TAG_IndexedFaceSet2D:
		return "IndexedFaceSet2D";
	case TAG_IndexedLineSet:
		return "IndexedLineSet";
	case TAG_IndexedLineSet2D:
		return "IndexedLineSet2D";
	case TAG_Inline:
		return "Inline";
	case TAG_LOD:
		return "LOD";
	case TAG_Layer2D:
		return "Layer2D";
	case TAG_Layer3D:
		return "Layer3D";
	case TAG_Layout:
		return "Layout";
	case TAG_LineProperties:
		return "LineProperties";
	case TAG_ListeningPoint:
		return "ListeningPoint";
	case TAG_Material:
		return "Material";
	case TAG_Material2D:
		return "Material2D";
	case TAG_MovieTexture:
		return "MovieTexture";
	case TAG_NavigationInfo:
		return "NavigationInfo";
	case TAG_Normal:
		return "Normal";
	case TAG_NormalInterpolator:
		return "NormalInterpolator";
	case TAG_OrderedGroup:
		return "OrderedGroup";
	case TAG_OrientationInterpolator:
		return "OrientationInterpolator";
	case TAG_PixelTexture:
		return "PixelTexture";
	case TAG_PlaneSensor:
		return "PlaneSensor";
	case TAG_PlaneSensor2D:
		return "PlaneSensor2D";
	case TAG_PointLight:
		return "PointLight";
	case TAG_PointSet:
		return "PointSet";
	case TAG_PointSet2D:
		return "PointSet2D";
	case TAG_PositionInterpolator:
		return "PositionInterpolator";
	case TAG_PositionInterpolator2D:
		return "PositionInterpolator2D";
	case TAG_ProximitySensor2D:
		return "ProximitySensor2D";
	case TAG_ProximitySensor:
		return "ProximitySensor";
	case TAG_QuantizationParameter:
		return "QuantizationParameter";
	case TAG_Rectangle:
		return "Rectangle";
	case TAG_ScalarInterpolator:
		return "ScalarInterpolator";
	case TAG_Script:
		return "Script";
	case TAG_Shape:
		return "Shape";
	case TAG_Sound:
		return "Sound";
	case TAG_Sound2D:
		return "Sound2D";
	case TAG_Sphere:
		return "Sphere";
	case TAG_SphereSensor:
		return "SphereSensor";
	case TAG_SpotLight:
		return "SpotLight";
	case TAG_Switch:
		return "Switch";
	case TAG_TermCap:
		return "TermCap";
	case TAG_Text:
		return "Text";
	case TAG_TextureCoordinate:
		return "TextureCoordinate";
	case TAG_TextureTransform:
		return "TextureTransform";
	case TAG_TimeSensor:
		return "TimeSensor";
	case TAG_TouchSensor:
		return "TouchSensor";
	case TAG_Transform:
		return "Transform";
	case TAG_Transform2D:
		return "Transform2D";
	case TAG_Valuator:
		return "Valuator";
	case TAG_Viewpoint:
		return "Viewpoint";
	case TAG_VisibilitySensor:
		return "VisibilitySensor";
	case TAG_Viseme:
		return "Viseme";
	case TAG_WorldInfo:
		return "WorldInfo";
	case TAG_AcousticMaterial:
		return "AcousticMaterial";
	case TAG_AcousticScene:
		return "AcousticScene";
	case TAG_ApplicationWindow:
		return "ApplicationWindow";
	case TAG_BAP:
		return "BAP";
	case TAG_BDP:
		return "BDP";
	case TAG_Body:
		return "Body";
	case TAG_BodyDefTable:
		return "BodyDefTable";
	case TAG_BodySegmentConnectionHint:
		return "BodySegmentConnectionHint";
	case TAG_DirectiveSound:
		return "DirectiveSound";
	case TAG_Hierarchical3DMesh:
		return "Hierarchical3DMesh";
	case TAG_MaterialKey:
		return "MaterialKey";
	case TAG_PerceptualParameters:
		return "PerceptualParameters";
	case TAG_TemporalTransform:
		return "TemporalTransform";
	case TAG_TemporalGroup:
		return "TemporalGroup";
	case TAG_ServerCommand:
		return "ServerCommand";
	case TAG_InputSensor:
		return "InputSensor";
	case TAG_MatteTexture:
		return "MatteTexture";
	case TAG_MediaBuffer:
		return "MediaBuffer";
	case TAG_MediaControl:
		return "MediaControl";
	case TAG_MediaSensor:
		return "MediaSensor";
	case TAG_Clipper2D:
		return "Clipper2D";
	case TAG_ColorTransform:
		return "ColorTransform";
	case TAG_Ellipse:
		return "Ellipse";
	case TAG_LinearGradient:
		return "LinearGradient";
	case TAG_PathLayout:
		return "PathLayout";
	case TAG_RadialGradient:
		return "RadialGradient";
	case TAG_SynthesizedTexture:
		return "SynthesizedTexture";
	case TAG_TransformMatrix2D:
		return "TransformMatrix2D";
	case TAG_Viewport:
		return "Viewport";
	case TAG_XCurve2D:
		return "XCurve2D";
	case TAG_XFontStyle:
		return "XFontStyle";
	case TAG_XLineProperties:
		return "XLineProperties";
	default:
		return "Unknown Node";
	}
}

void Node_Del(SFNode *node)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor:
		Anchor_Del(node); return;
	case TAG_AnimationStream:
		AnimationStream_Del(node); return;
	case TAG_Appearance:
		Appearance_Del(node); return;
	case TAG_AudioBuffer:
		AudioBuffer_Del(node); return;
	case TAG_AudioClip:
		AudioClip_Del(node); return;
	case TAG_AudioDelay:
		AudioDelay_Del(node); return;
	case TAG_AudioFX:
		AudioFX_Del(node); return;
	case TAG_AudioMix:
		AudioMix_Del(node); return;
	case TAG_AudioSource:
		AudioSource_Del(node); return;
	case TAG_AudioSwitch:
		AudioSwitch_Del(node); return;
	case TAG_Background:
		Background_Del(node); return;
	case TAG_Background2D:
		Background2D_Del(node); return;
	case TAG_Billboard:
		Billboard_Del(node); return;
	case TAG_Bitmap:
		Bitmap_Del(node); return;
	case TAG_Box:
		Box_Del(node); return;
	case TAG_Circle:
		Circle_Del(node); return;
	case TAG_Collision:
		Collision_Del(node); return;
	case TAG_Color:
		Color_Del(node); return;
	case TAG_ColorInterpolator:
		ColorInterpolator_Del(node); return;
	case TAG_CompositeTexture2D:
		CompositeTexture2D_Del(node); return;
	case TAG_CompositeTexture3D:
		CompositeTexture3D_Del(node); return;
	case TAG_Conditional:
		Conditional_Del(node); return;
	case TAG_Cone:
		Cone_Del(node); return;
	case TAG_Coordinate:
		Coordinate_Del(node); return;
	case TAG_Coordinate2D:
		Coordinate2D_Del(node); return;
	case TAG_CoordinateInterpolator:
		CoordinateInterpolator_Del(node); return;
	case TAG_CoordinateInterpolator2D:
		CoordinateInterpolator2D_Del(node); return;
	case TAG_Curve2D:
		Curve2D_Del(node); return;
	case TAG_Cylinder:
		Cylinder_Del(node); return;
	case TAG_CylinderSensor:
		CylinderSensor_Del(node); return;
	case TAG_DirectionalLight:
		DirectionalLight_Del(node); return;
	case TAG_DiscSensor:
		DiscSensor_Del(node); return;
	case TAG_ElevationGrid:
		ElevationGrid_Del(node); return;
	case TAG_Expression:
		Expression_Del(node); return;
	case TAG_Extrusion:
		Extrusion_Del(node); return;
	case TAG_Face:
		Face_Del(node); return;
	case TAG_FaceDefMesh:
		FaceDefMesh_Del(node); return;
	case TAG_FaceDefTables:
		FaceDefTables_Del(node); return;
	case TAG_FaceDefTransform:
		FaceDefTransform_Del(node); return;
	case TAG_FAP:
		FAP_Del(node); return;
	case TAG_FDP:
		FDP_Del(node); return;
	case TAG_FIT:
		FIT_Del(node); return;
	case TAG_Fog:
		Fog_Del(node); return;
	case TAG_FontStyle:
		FontStyle_Del(node); return;
	case TAG_Form:
		Form_Del(node); return;
	case TAG_Group:
		Group_Del(node); return;
	case TAG_ImageTexture:
		ImageTexture_Del(node); return;
	case TAG_IndexedFaceSet:
		IndexedFaceSet_Del(node); return;
	case TAG_IndexedFaceSet2D:
		IndexedFaceSet2D_Del(node); return;
	case TAG_IndexedLineSet:
		IndexedLineSet_Del(node); return;
	case TAG_IndexedLineSet2D:
		IndexedLineSet2D_Del(node); return;
	case TAG_Inline:
		Inline_Del(node); return;
	case TAG_LOD:
		LOD_Del(node); return;
	case TAG_Layer2D:
		Layer2D_Del(node); return;
	case TAG_Layer3D:
		Layer3D_Del(node); return;
	case TAG_Layout:
		Layout_Del(node); return;
	case TAG_LineProperties:
		LineProperties_Del(node); return;
	case TAG_ListeningPoint:
		ListeningPoint_Del(node); return;
	case TAG_Material:
		Material_Del(node); return;
	case TAG_Material2D:
		Material2D_Del(node); return;
	case TAG_MovieTexture:
		MovieTexture_Del(node); return;
	case TAG_NavigationInfo:
		NavigationInfo_Del(node); return;
	case TAG_Normal:
		Normal_Del(node); return;
	case TAG_NormalInterpolator:
		NormalInterpolator_Del(node); return;
	case TAG_OrderedGroup:
		OrderedGroup_Del(node); return;
	case TAG_OrientationInterpolator:
		OrientationInterpolator_Del(node); return;
	case TAG_PixelTexture:
		PixelTexture_Del(node); return;
	case TAG_PlaneSensor:
		PlaneSensor_Del(node); return;
	case TAG_PlaneSensor2D:
		PlaneSensor2D_Del(node); return;
	case TAG_PointLight:
		PointLight_Del(node); return;
	case TAG_PointSet:
		PointSet_Del(node); return;
	case TAG_PointSet2D:
		PointSet2D_Del(node); return;
	case TAG_PositionInterpolator:
		PositionInterpolator_Del(node); return;
	case TAG_PositionInterpolator2D:
		PositionInterpolator2D_Del(node); return;
	case TAG_ProximitySensor2D:
		ProximitySensor2D_Del(node); return;
	case TAG_ProximitySensor:
		ProximitySensor_Del(node); return;
	case TAG_QuantizationParameter:
		QuantizationParameter_Del(node); return;
	case TAG_Rectangle:
		Rectangle_Del(node); return;
	case TAG_ScalarInterpolator:
		ScalarInterpolator_Del(node); return;
	case TAG_Script:
		Script_Del(node); return;
	case TAG_Shape:
		Shape_Del(node); return;
	case TAG_Sound:
		Sound_Del(node); return;
	case TAG_Sound2D:
		Sound2D_Del(node); return;
	case TAG_Sphere:
		Sphere_Del(node); return;
	case TAG_SphereSensor:
		SphereSensor_Del(node); return;
	case TAG_SpotLight:
		SpotLight_Del(node); return;
	case TAG_Switch:
		Switch_Del(node); return;
	case TAG_TermCap:
		TermCap_Del(node); return;
	case TAG_Text:
		Text_Del(node); return;
	case TAG_TextureCoordinate:
		TextureCoordinate_Del(node); return;
	case TAG_TextureTransform:
		TextureTransform_Del(node); return;
	case TAG_TimeSensor:
		TimeSensor_Del(node); return;
	case TAG_TouchSensor:
		TouchSensor_Del(node); return;
	case TAG_Transform:
		Transform_Del(node); return;
	case TAG_Transform2D:
		Transform2D_Del(node); return;
	case TAG_Valuator:
		Valuator_Del(node); return;
	case TAG_Viewpoint:
		Viewpoint_Del(node); return;
	case TAG_VisibilitySensor:
		VisibilitySensor_Del(node); return;
	case TAG_Viseme:
		Viseme_Del(node); return;
	case TAG_WorldInfo:
		WorldInfo_Del(node); return;
	case TAG_AcousticMaterial:
		AcousticMaterial_Del(node); return;
	case TAG_AcousticScene:
		AcousticScene_Del(node); return;
	case TAG_ApplicationWindow:
		ApplicationWindow_Del(node); return;
	case TAG_BAP:
		BAP_Del(node); return;
	case TAG_BDP:
		BDP_Del(node); return;
	case TAG_Body:
		Body_Del(node); return;
	case TAG_BodyDefTable:
		BodyDefTable_Del(node); return;
	case TAG_BodySegmentConnectionHint:
		BodySegmentConnectionHint_Del(node); return;
	case TAG_DirectiveSound:
		DirectiveSound_Del(node); return;
	case TAG_Hierarchical3DMesh:
		Hierarchical3DMesh_Del(node); return;
	case TAG_MaterialKey:
		MaterialKey_Del(node); return;
	case TAG_PerceptualParameters:
		PerceptualParameters_Del(node); return;
	case TAG_TemporalTransform:
		TemporalTransform_Del(node); return;
	case TAG_TemporalGroup:
		TemporalGroup_Del(node); return;
	case TAG_ServerCommand:
		ServerCommand_Del(node); return;
	case TAG_InputSensor:
		InputSensor_Del(node); return;
	case TAG_MatteTexture:
		MatteTexture_Del(node); return;
	case TAG_MediaBuffer:
		MediaBuffer_Del(node); return;
	case TAG_MediaControl:
		MediaControl_Del(node); return;
	case TAG_MediaSensor:
		MediaSensor_Del(node); return;
	case TAG_Clipper2D:
		Clipper2D_Del(node); return;
	case TAG_ColorTransform:
		ColorTransform_Del(node); return;
	case TAG_Ellipse:
		Ellipse_Del(node); return;
	case TAG_LinearGradient:
		LinearGradient_Del(node); return;
	case TAG_PathLayout:
		PathLayout_Del(node); return;
	case TAG_RadialGradient:
		RadialGradient_Del(node); return;
	case TAG_SynthesizedTexture:
		SynthesizedTexture_Del(node); return;
	case TAG_TransformMatrix2D:
		TransformMatrix2D_Del(node); return;
	case TAG_Viewport:
		Viewport_Del(node); return;
	case TAG_XCurve2D:
		XCurve2D_Del(node); return;
	case TAG_XFontStyle:
		XFontStyle_Del(node); return;
	case TAG_XLineProperties:
		XLineProperties_Del(node); return;
	default:
		return;
	}
}

u32 SFNode_GetFieldCount(SFNode *node, u8 code_mode)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor:return Anchor_get_field_count(node, code_mode);
	case TAG_AnimationStream:return AnimationStream_get_field_count(node, code_mode);
	case TAG_Appearance:return Appearance_get_field_count(node, code_mode);
	case TAG_AudioBuffer:return AudioBuffer_get_field_count(node, code_mode);
	case TAG_AudioClip:return AudioClip_get_field_count(node, code_mode);
	case TAG_AudioDelay:return AudioDelay_get_field_count(node, code_mode);
	case TAG_AudioFX:return AudioFX_get_field_count(node, code_mode);
	case TAG_AudioMix:return AudioMix_get_field_count(node, code_mode);
	case TAG_AudioSource:return AudioSource_get_field_count(node, code_mode);
	case TAG_AudioSwitch:return AudioSwitch_get_field_count(node, code_mode);
	case TAG_Background:return Background_get_field_count(node, code_mode);
	case TAG_Background2D:return Background2D_get_field_count(node, code_mode);
	case TAG_Billboard:return Billboard_get_field_count(node, code_mode);
	case TAG_Bitmap:return Bitmap_get_field_count(node, code_mode);
	case TAG_Box:return Box_get_field_count(node, code_mode);
	case TAG_Circle:return Circle_get_field_count(node, code_mode);
	case TAG_Collision:return Collision_get_field_count(node, code_mode);
	case TAG_Color:return Color_get_field_count(node, code_mode);
	case TAG_ColorInterpolator:return ColorInterpolator_get_field_count(node, code_mode);
	case TAG_CompositeTexture2D:return CompositeTexture2D_get_field_count(node, code_mode);
	case TAG_CompositeTexture3D:return CompositeTexture3D_get_field_count(node, code_mode);
	case TAG_Conditional:return Conditional_get_field_count(node, code_mode);
	case TAG_Cone:return Cone_get_field_count(node, code_mode);
	case TAG_Coordinate:return Coordinate_get_field_count(node, code_mode);
	case TAG_Coordinate2D:return Coordinate2D_get_field_count(node, code_mode);
	case TAG_CoordinateInterpolator:return CoordinateInterpolator_get_field_count(node, code_mode);
	case TAG_CoordinateInterpolator2D:return CoordinateInterpolator2D_get_field_count(node, code_mode);
	case TAG_Curve2D:return Curve2D_get_field_count(node, code_mode);
	case TAG_Cylinder:return Cylinder_get_field_count(node, code_mode);
	case TAG_CylinderSensor:return CylinderSensor_get_field_count(node, code_mode);
	case TAG_DirectionalLight:return DirectionalLight_get_field_count(node, code_mode);
	case TAG_DiscSensor:return DiscSensor_get_field_count(node, code_mode);
	case TAG_ElevationGrid:return ElevationGrid_get_field_count(node, code_mode);
	case TAG_Expression:return Expression_get_field_count(node, code_mode);
	case TAG_Extrusion:return Extrusion_get_field_count(node, code_mode);
	case TAG_Face:return Face_get_field_count(node, code_mode);
	case TAG_FaceDefMesh:return FaceDefMesh_get_field_count(node, code_mode);
	case TAG_FaceDefTables:return FaceDefTables_get_field_count(node, code_mode);
	case TAG_FaceDefTransform:return FaceDefTransform_get_field_count(node, code_mode);
	case TAG_FAP:return FAP_get_field_count(node, code_mode);
	case TAG_FDP:return FDP_get_field_count(node, code_mode);
	case TAG_FIT:return FIT_get_field_count(node, code_mode);
	case TAG_Fog:return Fog_get_field_count(node, code_mode);
	case TAG_FontStyle:return FontStyle_get_field_count(node, code_mode);
	case TAG_Form:return Form_get_field_count(node, code_mode);
	case TAG_Group:return Group_get_field_count(node, code_mode);
	case TAG_ImageTexture:return ImageTexture_get_field_count(node, code_mode);
	case TAG_IndexedFaceSet:return IndexedFaceSet_get_field_count(node, code_mode);
	case TAG_IndexedFaceSet2D:return IndexedFaceSet2D_get_field_count(node, code_mode);
	case TAG_IndexedLineSet:return IndexedLineSet_get_field_count(node, code_mode);
	case TAG_IndexedLineSet2D:return IndexedLineSet2D_get_field_count(node, code_mode);
	case TAG_Inline:return Inline_get_field_count(node, code_mode);
	case TAG_LOD:return LOD_get_field_count(node, code_mode);
	case TAG_Layer2D:return Layer2D_get_field_count(node, code_mode);
	case TAG_Layer3D:return Layer3D_get_field_count(node, code_mode);
	case TAG_Layout:return Layout_get_field_count(node, code_mode);
	case TAG_LineProperties:return LineProperties_get_field_count(node, code_mode);
	case TAG_ListeningPoint:return ListeningPoint_get_field_count(node, code_mode);
	case TAG_Material:return Material_get_field_count(node, code_mode);
	case TAG_Material2D:return Material2D_get_field_count(node, code_mode);
	case TAG_MovieTexture:return MovieTexture_get_field_count(node, code_mode);
	case TAG_NavigationInfo:return NavigationInfo_get_field_count(node, code_mode);
	case TAG_Normal:return Normal_get_field_count(node, code_mode);
	case TAG_NormalInterpolator:return NormalInterpolator_get_field_count(node, code_mode);
	case TAG_OrderedGroup:return OrderedGroup_get_field_count(node, code_mode);
	case TAG_OrientationInterpolator:return OrientationInterpolator_get_field_count(node, code_mode);
	case TAG_PixelTexture:return PixelTexture_get_field_count(node, code_mode);
	case TAG_PlaneSensor:return PlaneSensor_get_field_count(node, code_mode);
	case TAG_PlaneSensor2D:return PlaneSensor2D_get_field_count(node, code_mode);
	case TAG_PointLight:return PointLight_get_field_count(node, code_mode);
	case TAG_PointSet:return PointSet_get_field_count(node, code_mode);
	case TAG_PointSet2D:return PointSet2D_get_field_count(node, code_mode);
	case TAG_PositionInterpolator:return PositionInterpolator_get_field_count(node, code_mode);
	case TAG_PositionInterpolator2D:return PositionInterpolator2D_get_field_count(node, code_mode);
	case TAG_ProximitySensor2D:return ProximitySensor2D_get_field_count(node, code_mode);
	case TAG_ProximitySensor:return ProximitySensor_get_field_count(node, code_mode);
	case TAG_QuantizationParameter:return QuantizationParameter_get_field_count(node, code_mode);
	case TAG_Rectangle:return Rectangle_get_field_count(node, code_mode);
	case TAG_ScalarInterpolator:return ScalarInterpolator_get_field_count(node, code_mode);
	case TAG_Script:return Script_get_field_count(node, code_mode);
	case TAG_Shape:return Shape_get_field_count(node, code_mode);
	case TAG_Sound:return Sound_get_field_count(node, code_mode);
	case TAG_Sound2D:return Sound2D_get_field_count(node, code_mode);
	case TAG_Sphere:return Sphere_get_field_count(node, code_mode);
	case TAG_SphereSensor:return SphereSensor_get_field_count(node, code_mode);
	case TAG_SpotLight:return SpotLight_get_field_count(node, code_mode);
	case TAG_Switch:return Switch_get_field_count(node, code_mode);
	case TAG_TermCap:return TermCap_get_field_count(node, code_mode);
	case TAG_Text:return Text_get_field_count(node, code_mode);
	case TAG_TextureCoordinate:return TextureCoordinate_get_field_count(node, code_mode);
	case TAG_TextureTransform:return TextureTransform_get_field_count(node, code_mode);
	case TAG_TimeSensor:return TimeSensor_get_field_count(node, code_mode);
	case TAG_TouchSensor:return TouchSensor_get_field_count(node, code_mode);
	case TAG_Transform:return Transform_get_field_count(node, code_mode);
	case TAG_Transform2D:return Transform2D_get_field_count(node, code_mode);
	case TAG_Valuator:return Valuator_get_field_count(node, code_mode);
	case TAG_Viewpoint:return Viewpoint_get_field_count(node, code_mode);
	case TAG_VisibilitySensor:return VisibilitySensor_get_field_count(node, code_mode);
	case TAG_Viseme:return Viseme_get_field_count(node, code_mode);
	case TAG_WorldInfo:return WorldInfo_get_field_count(node, code_mode);
	case TAG_AcousticMaterial:return AcousticMaterial_get_field_count(node, code_mode);
	case TAG_AcousticScene:return AcousticScene_get_field_count(node, code_mode);
	case TAG_ApplicationWindow:return ApplicationWindow_get_field_count(node, code_mode);
	case TAG_BAP:return BAP_get_field_count(node, code_mode);
	case TAG_BDP:return BDP_get_field_count(node, code_mode);
	case TAG_Body:return Body_get_field_count(node, code_mode);
	case TAG_BodyDefTable:return BodyDefTable_get_field_count(node, code_mode);
	case TAG_BodySegmentConnectionHint:return BodySegmentConnectionHint_get_field_count(node, code_mode);
	case TAG_DirectiveSound:return DirectiveSound_get_field_count(node, code_mode);
	case TAG_Hierarchical3DMesh:return Hierarchical3DMesh_get_field_count(node, code_mode);
	case TAG_MaterialKey:return MaterialKey_get_field_count(node, code_mode);
	case TAG_PerceptualParameters:return PerceptualParameters_get_field_count(node, code_mode);
	case TAG_TemporalTransform:return TemporalTransform_get_field_count(node, code_mode);
	case TAG_TemporalGroup:return TemporalGroup_get_field_count(node, code_mode);
	case TAG_ServerCommand:return ServerCommand_get_field_count(node, code_mode);
	case TAG_InputSensor:return InputSensor_get_field_count(node, code_mode);
	case TAG_MatteTexture:return MatteTexture_get_field_count(node, code_mode);
	case TAG_MediaBuffer:return MediaBuffer_get_field_count(node, code_mode);
	case TAG_MediaControl:return MediaControl_get_field_count(node, code_mode);
	case TAG_MediaSensor:return MediaSensor_get_field_count(node, code_mode);
	case TAG_Clipper2D:return Clipper2D_get_field_count(node, code_mode);
	case TAG_ColorTransform:return ColorTransform_get_field_count(node, code_mode);
	case TAG_Ellipse:return Ellipse_get_field_count(node, code_mode);
	case TAG_LinearGradient:return LinearGradient_get_field_count(node, code_mode);
	case TAG_PathLayout:return PathLayout_get_field_count(node, code_mode);
	case TAG_RadialGradient:return RadialGradient_get_field_count(node, code_mode);
	case TAG_SynthesizedTexture:return SynthesizedTexture_get_field_count(node, code_mode);
	case TAG_TransformMatrix2D:return TransformMatrix2D_get_field_count(node, code_mode);
	case TAG_Viewport:return Viewport_get_field_count(node, code_mode);
	case TAG_XCurve2D:return XCurve2D_get_field_count(node, code_mode);
	case TAG_XFontStyle:return XFontStyle_get_field_count(node, code_mode);
	case TAG_XLineProperties:return XLineProperties_get_field_count(node, code_mode);
	default:
		return 0;
	}
}

M4Err SFNode_GetFieldIndex(SFNode *node, u32 inField, u8 code_mode, u32 *allIndex)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor: return Anchor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AnimationStream: return AnimationStream_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Appearance: return Appearance_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioBuffer: return AudioBuffer_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioClip: return AudioClip_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioDelay: return AudioDelay_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioFX: return AudioFX_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioMix: return AudioMix_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioSource: return AudioSource_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AudioSwitch: return AudioSwitch_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Background: return Background_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Background2D: return Background2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Billboard: return Billboard_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Bitmap: return Bitmap_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Box: return Box_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Circle: return Circle_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Collision: return Collision_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Color: return Color_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ColorInterpolator: return ColorInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_CompositeTexture2D: return CompositeTexture2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_CompositeTexture3D: return CompositeTexture3D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Conditional: return Conditional_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Cone: return Cone_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Coordinate: return Coordinate_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Coordinate2D: return Coordinate2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_CoordinateInterpolator: return CoordinateInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_CoordinateInterpolator2D: return CoordinateInterpolator2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Curve2D: return Curve2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Cylinder: return Cylinder_get_field_index(node, inField, code_mode, allIndex);
	case TAG_CylinderSensor: return CylinderSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_DirectionalLight: return DirectionalLight_get_field_index(node, inField, code_mode, allIndex);
	case TAG_DiscSensor: return DiscSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ElevationGrid: return ElevationGrid_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Expression: return Expression_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Extrusion: return Extrusion_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Face: return Face_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FaceDefMesh: return FaceDefMesh_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FaceDefTables: return FaceDefTables_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FaceDefTransform: return FaceDefTransform_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FAP: return FAP_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FDP: return FDP_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FIT: return FIT_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Fog: return Fog_get_field_index(node, inField, code_mode, allIndex);
	case TAG_FontStyle: return FontStyle_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Form: return Form_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Group: return Group_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ImageTexture: return ImageTexture_get_field_index(node, inField, code_mode, allIndex);
	case TAG_IndexedFaceSet: return IndexedFaceSet_get_field_index(node, inField, code_mode, allIndex);
	case TAG_IndexedFaceSet2D: return IndexedFaceSet2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_IndexedLineSet: return IndexedLineSet_get_field_index(node, inField, code_mode, allIndex);
	case TAG_IndexedLineSet2D: return IndexedLineSet2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Inline: return Inline_get_field_index(node, inField, code_mode, allIndex);
	case TAG_LOD: return LOD_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Layer2D: return Layer2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Layer3D: return Layer3D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Layout: return Layout_get_field_index(node, inField, code_mode, allIndex);
	case TAG_LineProperties: return LineProperties_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ListeningPoint: return ListeningPoint_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Material: return Material_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Material2D: return Material2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MovieTexture: return MovieTexture_get_field_index(node, inField, code_mode, allIndex);
	case TAG_NavigationInfo: return NavigationInfo_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Normal: return Normal_get_field_index(node, inField, code_mode, allIndex);
	case TAG_NormalInterpolator: return NormalInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_OrderedGroup: return OrderedGroup_get_field_index(node, inField, code_mode, allIndex);
	case TAG_OrientationInterpolator: return OrientationInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PixelTexture: return PixelTexture_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PlaneSensor: return PlaneSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PlaneSensor2D: return PlaneSensor2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PointLight: return PointLight_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PointSet: return PointSet_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PointSet2D: return PointSet2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PositionInterpolator: return PositionInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PositionInterpolator2D: return PositionInterpolator2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ProximitySensor2D: return ProximitySensor2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ProximitySensor: return ProximitySensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_QuantizationParameter: return QuantizationParameter_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Rectangle: return Rectangle_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ScalarInterpolator: return ScalarInterpolator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Script: return Script_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Shape: return Shape_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Sound: return Sound_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Sound2D: return Sound2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Sphere: return Sphere_get_field_index(node, inField, code_mode, allIndex);
	case TAG_SphereSensor: return SphereSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_SpotLight: return SpotLight_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Switch: return Switch_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TermCap: return TermCap_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Text: return Text_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TextureCoordinate: return TextureCoordinate_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TextureTransform: return TextureTransform_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TimeSensor: return TimeSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TouchSensor: return TouchSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Transform: return Transform_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Transform2D: return Transform2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Valuator: return Valuator_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Viewpoint: return Viewpoint_get_field_index(node, inField, code_mode, allIndex);
	case TAG_VisibilitySensor: return VisibilitySensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Viseme: return Viseme_get_field_index(node, inField, code_mode, allIndex);
	case TAG_WorldInfo: return WorldInfo_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AcousticMaterial: return AcousticMaterial_get_field_index(node, inField, code_mode, allIndex);
	case TAG_AcousticScene: return AcousticScene_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ApplicationWindow: return ApplicationWindow_get_field_index(node, inField, code_mode, allIndex);
	case TAG_BAP: return BAP_get_field_index(node, inField, code_mode, allIndex);
	case TAG_BDP: return BDP_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Body: return Body_get_field_index(node, inField, code_mode, allIndex);
	case TAG_BodyDefTable: return BodyDefTable_get_field_index(node, inField, code_mode, allIndex);
	case TAG_BodySegmentConnectionHint: return BodySegmentConnectionHint_get_field_index(node, inField, code_mode, allIndex);
	case TAG_DirectiveSound: return DirectiveSound_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Hierarchical3DMesh: return Hierarchical3DMesh_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MaterialKey: return MaterialKey_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PerceptualParameters: return PerceptualParameters_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TemporalTransform: return TemporalTransform_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TemporalGroup: return TemporalGroup_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ServerCommand: return ServerCommand_get_field_index(node, inField, code_mode, allIndex);
	case TAG_InputSensor: return InputSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MatteTexture: return MatteTexture_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MediaBuffer: return MediaBuffer_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MediaControl: return MediaControl_get_field_index(node, inField, code_mode, allIndex);
	case TAG_MediaSensor: return MediaSensor_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Clipper2D: return Clipper2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_ColorTransform: return ColorTransform_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Ellipse: return Ellipse_get_field_index(node, inField, code_mode, allIndex);
	case TAG_LinearGradient: return LinearGradient_get_field_index(node, inField, code_mode, allIndex);
	case TAG_PathLayout: return PathLayout_get_field_index(node, inField, code_mode, allIndex);
	case TAG_RadialGradient: return RadialGradient_get_field_index(node, inField, code_mode, allIndex);
	case TAG_SynthesizedTexture: return SynthesizedTexture_get_field_index(node, inField, code_mode, allIndex);
	case TAG_TransformMatrix2D: return TransformMatrix2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_Viewport: return Viewport_get_field_index(node, inField, code_mode, allIndex);
	case TAG_XCurve2D: return XCurve2D_get_field_index(node, inField, code_mode, allIndex);
	case TAG_XFontStyle: return XFontStyle_get_field_index(node, inField, code_mode, allIndex);
	case TAG_XLineProperties: return XLineProperties_get_field_index(node, inField, code_mode, allIndex);
	default:
		return M4BadParam;
	}
}

M4Err SFNode_GetField(SFNode *node, FieldInfo *field)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor: return Anchor_get_field(node, field);
	case TAG_AnimationStream: return AnimationStream_get_field(node, field);
	case TAG_Appearance: return Appearance_get_field(node, field);
	case TAG_AudioBuffer: return AudioBuffer_get_field(node, field);
	case TAG_AudioClip: return AudioClip_get_field(node, field);
	case TAG_AudioDelay: return AudioDelay_get_field(node, field);
	case TAG_AudioFX: return AudioFX_get_field(node, field);
	case TAG_AudioMix: return AudioMix_get_field(node, field);
	case TAG_AudioSource: return AudioSource_get_field(node, field);
	case TAG_AudioSwitch: return AudioSwitch_get_field(node, field);
	case TAG_Background: return Background_get_field(node, field);
	case TAG_Background2D: return Background2D_get_field(node, field);
	case TAG_Billboard: return Billboard_get_field(node, field);
	case TAG_Bitmap: return Bitmap_get_field(node, field);
	case TAG_Box: return Box_get_field(node, field);
	case TAG_Circle: return Circle_get_field(node, field);
	case TAG_Collision: return Collision_get_field(node, field);
	case TAG_Color: return Color_get_field(node, field);
	case TAG_ColorInterpolator: return ColorInterpolator_get_field(node, field);
	case TAG_CompositeTexture2D: return CompositeTexture2D_get_field(node, field);
	case TAG_CompositeTexture3D: return CompositeTexture3D_get_field(node, field);
	case TAG_Conditional: return Conditional_get_field(node, field);
	case TAG_Cone: return Cone_get_field(node, field);
	case TAG_Coordinate: return Coordinate_get_field(node, field);
	case TAG_Coordinate2D: return Coordinate2D_get_field(node, field);
	case TAG_CoordinateInterpolator: return CoordinateInterpolator_get_field(node, field);
	case TAG_CoordinateInterpolator2D: return CoordinateInterpolator2D_get_field(node, field);
	case TAG_Curve2D: return Curve2D_get_field(node, field);
	case TAG_Cylinder: return Cylinder_get_field(node, field);
	case TAG_CylinderSensor: return CylinderSensor_get_field(node, field);
	case TAG_DirectionalLight: return DirectionalLight_get_field(node, field);
	case TAG_DiscSensor: return DiscSensor_get_field(node, field);
	case TAG_ElevationGrid: return ElevationGrid_get_field(node, field);
	case TAG_Expression: return Expression_get_field(node, field);
	case TAG_Extrusion: return Extrusion_get_field(node, field);
	case TAG_Face: return Face_get_field(node, field);
	case TAG_FaceDefMesh: return FaceDefMesh_get_field(node, field);
	case TAG_FaceDefTables: return FaceDefTables_get_field(node, field);
	case TAG_FaceDefTransform: return FaceDefTransform_get_field(node, field);
	case TAG_FAP: return FAP_get_field(node, field);
	case TAG_FDP: return FDP_get_field(node, field);
	case TAG_FIT: return FIT_get_field(node, field);
	case TAG_Fog: return Fog_get_field(node, field);
	case TAG_FontStyle: return FontStyle_get_field(node, field);
	case TAG_Form: return Form_get_field(node, field);
	case TAG_Group: return Group_get_field(node, field);
	case TAG_ImageTexture: return ImageTexture_get_field(node, field);
	case TAG_IndexedFaceSet: return IndexedFaceSet_get_field(node, field);
	case TAG_IndexedFaceSet2D: return IndexedFaceSet2D_get_field(node, field);
	case TAG_IndexedLineSet: return IndexedLineSet_get_field(node, field);
	case TAG_IndexedLineSet2D: return IndexedLineSet2D_get_field(node, field);
	case TAG_Inline: return Inline_get_field(node, field);
	case TAG_LOD: return LOD_get_field(node, field);
	case TAG_Layer2D: return Layer2D_get_field(node, field);
	case TAG_Layer3D: return Layer3D_get_field(node, field);
	case TAG_Layout: return Layout_get_field(node, field);
	case TAG_LineProperties: return LineProperties_get_field(node, field);
	case TAG_ListeningPoint: return ListeningPoint_get_field(node, field);
	case TAG_Material: return Material_get_field(node, field);
	case TAG_Material2D: return Material2D_get_field(node, field);
	case TAG_MovieTexture: return MovieTexture_get_field(node, field);
	case TAG_NavigationInfo: return NavigationInfo_get_field(node, field);
	case TAG_Normal: return Normal_get_field(node, field);
	case TAG_NormalInterpolator: return NormalInterpolator_get_field(node, field);
	case TAG_OrderedGroup: return OrderedGroup_get_field(node, field);
	case TAG_OrientationInterpolator: return OrientationInterpolator_get_field(node, field);
	case TAG_PixelTexture: return PixelTexture_get_field(node, field);
	case TAG_PlaneSensor: return PlaneSensor_get_field(node, field);
	case TAG_PlaneSensor2D: return PlaneSensor2D_get_field(node, field);
	case TAG_PointLight: return PointLight_get_field(node, field);
	case TAG_PointSet: return PointSet_get_field(node, field);
	case TAG_PointSet2D: return PointSet2D_get_field(node, field);
	case TAG_PositionInterpolator: return PositionInterpolator_get_field(node, field);
	case TAG_PositionInterpolator2D: return PositionInterpolator2D_get_field(node, field);
	case TAG_ProximitySensor2D: return ProximitySensor2D_get_field(node, field);
	case TAG_ProximitySensor: return ProximitySensor_get_field(node, field);
	case TAG_QuantizationParameter: return QuantizationParameter_get_field(node, field);
	case TAG_Rectangle: return Rectangle_get_field(node, field);
	case TAG_ScalarInterpolator: return ScalarInterpolator_get_field(node, field);
	case TAG_Script: return Script_get_field(node, field);
	case TAG_Shape: return Shape_get_field(node, field);
	case TAG_Sound: return Sound_get_field(node, field);
	case TAG_Sound2D: return Sound2D_get_field(node, field);
	case TAG_Sphere: return Sphere_get_field(node, field);
	case TAG_SphereSensor: return SphereSensor_get_field(node, field);
	case TAG_SpotLight: return SpotLight_get_field(node, field);
	case TAG_Switch: return Switch_get_field(node, field);
	case TAG_TermCap: return TermCap_get_field(node, field);
	case TAG_Text: return Text_get_field(node, field);
	case TAG_TextureCoordinate: return TextureCoordinate_get_field(node, field);
	case TAG_TextureTransform: return TextureTransform_get_field(node, field);
	case TAG_TimeSensor: return TimeSensor_get_field(node, field);
	case TAG_TouchSensor: return TouchSensor_get_field(node, field);
	case TAG_Transform: return Transform_get_field(node, field);
	case TAG_Transform2D: return Transform2D_get_field(node, field);
	case TAG_Valuator: return Valuator_get_field(node, field);
	case TAG_Viewpoint: return Viewpoint_get_field(node, field);
	case TAG_VisibilitySensor: return VisibilitySensor_get_field(node, field);
	case TAG_Viseme: return Viseme_get_field(node, field);
	case TAG_WorldInfo: return WorldInfo_get_field(node, field);
	case TAG_AcousticMaterial: return AcousticMaterial_get_field(node, field);
	case TAG_AcousticScene: return AcousticScene_get_field(node, field);
	case TAG_ApplicationWindow: return ApplicationWindow_get_field(node, field);
	case TAG_BAP: return BAP_get_field(node, field);
	case TAG_BDP: return BDP_get_field(node, field);
	case TAG_Body: return Body_get_field(node, field);
	case TAG_BodyDefTable: return BodyDefTable_get_field(node, field);
	case TAG_BodySegmentConnectionHint: return BodySegmentConnectionHint_get_field(node, field);
	case TAG_DirectiveSound: return DirectiveSound_get_field(node, field);
	case TAG_Hierarchical3DMesh: return Hierarchical3DMesh_get_field(node, field);
	case TAG_MaterialKey: return MaterialKey_get_field(node, field);
	case TAG_PerceptualParameters: return PerceptualParameters_get_field(node, field);
	case TAG_TemporalTransform: return TemporalTransform_get_field(node, field);
	case TAG_TemporalGroup: return TemporalGroup_get_field(node, field);
	case TAG_ServerCommand: return ServerCommand_get_field(node, field);
	case TAG_InputSensor: return InputSensor_get_field(node, field);
	case TAG_MatteTexture: return MatteTexture_get_field(node, field);
	case TAG_MediaBuffer: return MediaBuffer_get_field(node, field);
	case TAG_MediaControl: return MediaControl_get_field(node, field);
	case TAG_MediaSensor: return MediaSensor_get_field(node, field);
	case TAG_Clipper2D: return Clipper2D_get_field(node, field);
	case TAG_ColorTransform: return ColorTransform_get_field(node, field);
	case TAG_Ellipse: return Ellipse_get_field(node, field);
	case TAG_LinearGradient: return LinearGradient_get_field(node, field);
	case TAG_PathLayout: return PathLayout_get_field(node, field);
	case TAG_RadialGradient: return RadialGradient_get_field(node, field);
	case TAG_SynthesizedTexture: return SynthesizedTexture_get_field(node, field);
	case TAG_TransformMatrix2D: return TransformMatrix2D_get_field(node, field);
	case TAG_Viewport: return Viewport_get_field(node, field);
	case TAG_XCurve2D: return XCurve2D_get_field(node, field);
	case TAG_XFontStyle: return XFontStyle_get_field(node, field);
	case TAG_XLineProperties: return XLineProperties_get_field(node, field);
	default:
		return M4BadParam;
	}
}

Bool SFNode_GetAQInfo(SFNode *node, u32 FieldIndex, u8 *QType, u8 *AType, Float *b_min, Float *b_max, u32 *QT13_bits)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor: return Anchor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AnimationStream: return AnimationStream_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Appearance: return Appearance_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioBuffer: return AudioBuffer_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioClip: return AudioClip_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioDelay: return AudioDelay_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioFX: return AudioFX_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioMix: return AudioMix_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioSource: return AudioSource_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AudioSwitch: return AudioSwitch_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Background: return Background_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Background2D: return Background2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Billboard: return Billboard_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Bitmap: return Bitmap_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Box: return Box_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Circle: return Circle_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Collision: return Collision_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Color: return Color_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ColorInterpolator: return ColorInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_CompositeTexture2D: return CompositeTexture2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_CompositeTexture3D: return CompositeTexture3D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Conditional: return Conditional_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Cone: return Cone_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Coordinate: return Coordinate_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Coordinate2D: return Coordinate2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_CoordinateInterpolator: return CoordinateInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_CoordinateInterpolator2D: return CoordinateInterpolator2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Curve2D: return Curve2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Cylinder: return Cylinder_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_CylinderSensor: return CylinderSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_DirectionalLight: return DirectionalLight_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_DiscSensor: return DiscSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ElevationGrid: return ElevationGrid_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Expression: return Expression_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Extrusion: return Extrusion_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Face: return Face_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FaceDefMesh: return FaceDefMesh_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FaceDefTables: return FaceDefTables_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FaceDefTransform: return FaceDefTransform_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FAP: return FAP_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FDP: return FDP_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FIT: return FIT_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Fog: return Fog_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_FontStyle: return FontStyle_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Form: return Form_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Group: return Group_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ImageTexture: return ImageTexture_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_IndexedFaceSet: return IndexedFaceSet_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_IndexedFaceSet2D: return IndexedFaceSet2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_IndexedLineSet: return IndexedLineSet_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_IndexedLineSet2D: return IndexedLineSet2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Inline: return Inline_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_LOD: return LOD_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Layer2D: return Layer2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Layer3D: return Layer3D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Layout: return Layout_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_LineProperties: return LineProperties_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ListeningPoint: return ListeningPoint_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Material: return Material_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Material2D: return Material2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MovieTexture: return MovieTexture_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_NavigationInfo: return NavigationInfo_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Normal: return Normal_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_NormalInterpolator: return NormalInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_OrderedGroup: return OrderedGroup_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_OrientationInterpolator: return OrientationInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PixelTexture: return PixelTexture_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PlaneSensor: return PlaneSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PlaneSensor2D: return PlaneSensor2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PointLight: return PointLight_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PointSet: return PointSet_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PointSet2D: return PointSet2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PositionInterpolator: return PositionInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PositionInterpolator2D: return PositionInterpolator2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ProximitySensor2D: return ProximitySensor2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ProximitySensor: return ProximitySensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_QuantizationParameter: return QuantizationParameter_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Rectangle: return Rectangle_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ScalarInterpolator: return ScalarInterpolator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Script: return Script_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Shape: return Shape_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Sound: return Sound_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Sound2D: return Sound2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Sphere: return Sphere_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_SphereSensor: return SphereSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_SpotLight: return SpotLight_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Switch: return Switch_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TermCap: return TermCap_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Text: return Text_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TextureCoordinate: return TextureCoordinate_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TextureTransform: return TextureTransform_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TimeSensor: return TimeSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TouchSensor: return TouchSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Transform: return Transform_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Transform2D: return Transform2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Valuator: return Valuator_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Viewpoint: return Viewpoint_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_VisibilitySensor: return VisibilitySensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Viseme: return Viseme_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_WorldInfo: return WorldInfo_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AcousticMaterial: return AcousticMaterial_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_AcousticScene: return AcousticScene_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ApplicationWindow: return ApplicationWindow_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_BAP: return BAP_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_BDP: return BDP_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Body: return Body_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_BodyDefTable: return BodyDefTable_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_BodySegmentConnectionHint: return BodySegmentConnectionHint_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_DirectiveSound: return DirectiveSound_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Hierarchical3DMesh: return Hierarchical3DMesh_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MaterialKey: return MaterialKey_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PerceptualParameters: return PerceptualParameters_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TemporalTransform: return TemporalTransform_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TemporalGroup: return TemporalGroup_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ServerCommand: return ServerCommand_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_InputSensor: return InputSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MatteTexture: return MatteTexture_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MediaBuffer: return MediaBuffer_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MediaControl: return MediaControl_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_MediaSensor: return MediaSensor_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Clipper2D: return Clipper2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_ColorTransform: return ColorTransform_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Ellipse: return Ellipse_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_LinearGradient: return LinearGradient_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_PathLayout: return PathLayout_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_RadialGradient: return RadialGradient_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_SynthesizedTexture: return SynthesizedTexture_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_TransformMatrix2D: return TransformMatrix2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_Viewport: return Viewport_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_XCurve2D: return XCurve2D_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_XFontStyle: return XFontStyle_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	case TAG_XLineProperties: return XLineProperties_get_aq_info(node, FieldIndex, QType, AType, b_min, b_max, QT13_bits);
	default:
		return 0;
	}
}

u32 Node_GetChildNDT(SFNode *node)
{
	switch (node->sgprivate->tag) {
	case TAG_Anchor: return NDT_SF3DNode;
	case TAG_AudioBuffer: return NDT_SFAudioNode;
	case TAG_AudioDelay: return NDT_SFAudioNode;
	case TAG_AudioFX: return NDT_SFAudioNode;
	case TAG_AudioMix: return NDT_SFAudioNode;
	case TAG_AudioSource: return NDT_SFAudioNode;
	case TAG_AudioSwitch: return NDT_SFAudioNode;
	case TAG_Billboard: return NDT_SF3DNode;
	case TAG_Collision: return NDT_SF3DNode;
	case TAG_CompositeTexture2D: return NDT_SF2DNode;
	case TAG_CompositeTexture3D: return NDT_SF3DNode;
	case TAG_Face: return NDT_SF3DNode;
	case TAG_FaceDefTables: return NDT_SFFaceDefMeshNode;
	case TAG_FDP: return NDT_SFFaceDefTablesNode;
	case TAG_Form: return NDT_SF2DNode;
	case TAG_Group: return NDT_SF3DNode;
	case TAG_LOD: return NDT_SF3DNode;
	case TAG_Layer2D: return NDT_SF2DNode;
	case TAG_Layer3D: return NDT_SF3DNode;
	case TAG_Layout: return NDT_SF2DNode;
	case TAG_OrderedGroup: return NDT_SF3DNode;
	case TAG_Switch: return NDT_SF3DNode;
	case TAG_Transform: return NDT_SF3DNode;
	case TAG_Transform2D: return NDT_SF2DNode;
	case TAG_BDP: return NDT_SFBodyDefTableNode;
	case TAG_Body: return NDT_SF3DNode;
	case TAG_TemporalTransform: return NDT_SF3DNode;
	case TAG_TemporalGroup: return NDT_SFTemporalNode;
	case TAG_Clipper2D: return NDT_SF2DNode;
	case TAG_ColorTransform: return NDT_SF3DNode;
	case TAG_PathLayout: return NDT_SF2DNode;
	case TAG_TransformMatrix2D: return NDT_SF2DNode;
	default:
		return 0;
	}
}



#endif
