/*
 *  PGFileNotificationCenter.h
 *  graphviz
 *
 *  Created by Glen Low on Wed Feb 18 2004.
 *  Copyright (c) 2003, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/macstl/
 *  macstl@pixelglow.com
 *
 *  You may redistribute or use this software in source and binary forms, with or without modification,
 *  provided that the following conditions are met:
 *  Redistributions of source code must retain the above copyright notice, this list of conditions
 *  and the following disclaimer.
 *  Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *  and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  All modified files must carry prominent notices stating the nature and date of the modification.
 *
 *  The copyright holders make no representations about the suitability of this software for any purpose.
 *  It is provided "as is" without express or implied warranty.
 */

#import <Foundation/Foundation.h>

@interface PGFileNotificationCenter: NSObject
	{
		@private
		
		NSFileHandle* writer_;
		
		CFMutableSetRef sequenceRecords_;
		CFMutableSetRef observerPathRecords_;
	}
	
+ (PGFileNotificationCenter*) defaultCenter;

- (void) addObserver: (id) observer selector: (SEL) selector path: (NSString*) path;
- (void) removeObserver: (id) observer path: (NSString*) path;

@end


