# package_windows.nsi
# =========================================================================
# This file is part of the GrInvIn project - http://www.grinvin.org
# 
# Copyright (C) 2005-2007 Universiteit Gent
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or (at
# your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# A copy of the GNU General Public License can be found in the file
# LICENSE.txt provided with this distribution. This license can also
# be found on the GNU website at http://www.gnu.org/licenses/gpl.html.
# 
# If you did not receive a copy of the GNU General Public License along
# with this program, contact the lead developer, or write to the Free
# Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.

# build script for Windows installer
!include "MUI.nsh"

Name "GrInvIn"

InstallDir $PROGRAMFILES\GrInvIn

InstallDirRegKey HKLM "Software\NSIS_GrInvIn" "Install_Dir"

#install macro's
Page custom DetectJRE
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
  !define MUI_FINISHPAGE_NOAUTOCLOSE
  !define MUI_FINISHPAGE_RUN
  !define MUI_FINISHPAGE_RUN_FUNCTION "LaunchLink"
  !define MUI_FINISHPAGE_SHOWREADME $INSTDIR\README.txt
#

# build script for windows installer
!insertmacro MUI_PAGE_FINISH

#uninstall macro's
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

#languages
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Dutch"

Section "-GrInvIn"

  SetOutPath $INSTDIR

  File "../build/grinvin.exe"
  File /r "../build/libs"
  CreateDirectory "$INSTDIR\bin"
  File /oname=bin\benzene.exe ../build/win32/benzene.exe
  File "../build/windows/README.txt"
  File "../build/windows/LICENSE.txt"
  File "../build/windows/COPYRIGHT.txt"

  WriteRegStr HKLM SOFTWARE\NSIS_GrInvIn "Install_Dir" "$INSTDIR"

  # write Windows Add/Remove uninstall information
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" "DisplayName" "GrInvIn -- The Graph Invariant Investigator"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegStr HKLM Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" "DisplayVersion" "1.0.2"
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" "NoRepair" 1

  WriteRegStr HKLM "Software\JavaSoft\Prefs\org\grinvin\preferences" "config.bindir" "$INSTDIR\bin"
  WriteUninstaller "uninstall.exe"

SectionEnd


Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\GrInvIn"
  CreateShortCut "$SMPROGRAMS\GrInvIn\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\GrInvIn\GrInvIn.lnk" "$INSTDIR\grinvin.exe" "" "$INSTDIR\grinvin.exe" 0
  CreateShortCut "$SMPROGRAMS\GrInvIn\README.lnk" "$INSTDIR\README.txt" "" "$INSTDIR\README.txt" 0
   
SectionEnd

Section "Uninstall"
  
  # Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn"
  DeleteRegKey HKLM SOFTWARE\NSIS_GrInvIn
  DeleteRegKey HKLM "Software\JavaSoft\Prefs\org\grinvin\preferences"
  DeleteRegKey /ifempty HKLM "Software\JavaSoft\Prefs\org\grinvin"
  DeleteRegKey /ifempty HKLM "Software\JavaSoft\Prefs\org"

  # Remove files and uninstaller
  Delete $INSTDIR\grinvin.exe
  Delete $INSTDIR\uninstall.exe
  Delete $INSTDIR\README.txt
  Delete $INSTDIR\COPYRIGHT.txt
  Delete $INSTDIR\LICENSE.txt
  RMDir /r /REBOOTOK "$INSTDIR\libs\"
  RMDir /r /REBOOTOK "$INSTDIR\bin\"

  # Remove shortcuts, if any
  Delete "$SMPROGRAMS\GrInvIn\*.*"

  # Remove directories used
  RMDir /REBOOTOK "$SMPROGRAMS\GrInvIn"
  RMDir /REBOOTOK "$INSTDIR"

SectionEnd

Function LaunchLink
  ExecShell "" "$INSTDIR\grinvin.exe"
FunctionEnd

Function DetectJRE
  ReadRegStr $2 HKLM "SOFTWARE\JavaSoft\Java Runtime Environment" \
             "CurrentVersion"
  StrCmp $2 "1.5" done
  StrCmp $2 "1.6" done
  
  Call JRENotFound
  
  done:
FunctionEnd

Function JRENotFound
        MessageBox MB_OK "GrInvIn uses Java 5.0 or higher, please download it \
                         from www.java.com"
        Quit
FunctionEnd

Function .onInit
 
  ReadRegStr $R0 HKLM \
  "Software\Microsoft\Windows\CurrentVersion\Uninstall\GrInvIn" \
  "UninstallString"
  StrCmp $R0 "" done
 
  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "GrInvIn is already installed. $\n$\nClick `OK` to remove the \
  previous version or `Cancel` to cancel this upgrade." \
  IDOK uninst
  Abort
  
#run the uninstaller
uninst:
  ClearErrors
  Exec $INSTDIR\uninstall.exe
  
done:
 
FunctionEnd
