void test_auto_beta (void);

void
test_auto_beta (void)
{
    TEST(gsl_cdf_beta_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e-10,1.3,2.7), 3.329258013904e-13, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000001e-09,1.3,2.7), 6.642743046207e-12, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e-08,1.3,2.7), 1.325401475350e-10, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.9999999999999995e-08,1.3,2.7), 2.644523387276e-09, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.9999999999999995e-07,1.3,2.7), 5.276513292646e-08, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000001e-05,1.3,2.7), 1.052793708285e-06, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e-04,1.3,2.7), 2.100417958505e-05, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e-03,1.3,2.7), 4.187261218400e-04, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e-02,1.3,2.7), 8.282559388393e-03, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000001e-01,1.3,2.7), 1.512194578010e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (2.0000000000000001e-01,1.3,2.7), 3.358123280407e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (2.9999999999999999e-01,1.3,2.7), 5.104163996495e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (4.0000000000000002e-01,1.3,2.7), 6.620682399410e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (5.0000000000000000e-01,1.3,2.7), 7.852786981833e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (5.9999999999999998e-01,1.3,2.7), 8.784005878950e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (8.0000000000000004e-01,1.3,2.7), 9.801824171406e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.0000000000000002e-01,1.3,2.7), 9.968736852365e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.8999999999999999e-01,1.3,2.7), 9.999936324464e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.9900000000000000e-01,1.3,2.7), 9.999999872699e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.9990000000000001e-01,1.3,2.7), 9.999999999746e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (9.9999000000000005e-01,1.3,2.7), 9.999999999999e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_P, (1.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_beta_Q, (1.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.9999000000000005e-01,1.3,2.7), 5.069044353228e-14, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.9990000000000001e-01,1.3,2.7), 2.540490259443e-11, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.9900000000000000e-01,1.3,2.7), 1.273010336738e-08, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.8999999999999999e-01,1.3,2.7), 6.367553598351e-06, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.0000000000000002e-01,1.3,2.7), 3.126314763488e-03, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (8.0000000000000004e-01,1.3,2.7), 1.981758285937e-02, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (5.9999999999999998e-01,1.3,2.7), 1.215994121050e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (5.0000000000000000e-01,1.3,2.7), 2.147213018167e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (4.0000000000000002e-01,1.3,2.7), 3.379317600590e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (2.9999999999999999e-01,1.3,2.7), 4.895836003505e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (2.0000000000000001e-01,1.3,2.7), 6.641876719593e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000001e-01,1.3,2.7), 8.487805421990e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000000e-02,1.3,2.7), 9.917174406116e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000000e-03,1.3,2.7), 9.995812738782e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000000e-04,1.3,2.7), 9.999789958204e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000001e-05,1.3,2.7), 9.999989472063e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.9999999999999995e-07,1.3,2.7), 9.999999472349e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (9.9999999999999995e-08,1.3,2.7), 9.999999973555e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000000e-08,1.3,2.7), 9.999999998675e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000001e-09,1.3,2.7), 9.999999999934e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (1.0000000000000000e-10,1.3,2.7), 9.999999999997e-01, TEST_TOL6);
    TEST(gsl_cdf_beta_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_fdist (void);

void
test_auto_fdist (void)
{
    TEST(gsl_cdf_fdist_P, (0.0000000000000000e+00,5.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e-10,5.3,2.7), 3.231380663090e-26, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000001e-09,5.3,2.7), 1.443404714791e-23, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e-08,5.3,2.7), 6.447451698511e-21, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (9.9999999999999995e-08,5.3,2.7), 2.879969407315e-18, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (9.9999999999999995e-07,5.3,2.7), 1.286428479993e-15, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000001e-05,5.3,2.7), 5.745970138195e-13, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e-04,5.3,2.7), 2.565314230632e-10, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e-03,5.3,2.7), 1.140026203760e-07, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e-02,5.3,2.7), 4.840333162527e-05, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000001e-01,5.3,2.7), 1.360698992545e-02, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+00,5.3,2.7), 4.532720490874e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+01,5.3,2.7), 9.461328174717e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+02,5.3,2.7), 9.973356976994e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+03,5.3,2.7), 9.998797338050e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+04,5.3,2.7), 9.999946222456e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+05,5.3,2.7), 9.999997597592e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+06,5.3,2.7), 9.999999892687e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+07,5.3,2.7), 9.999999995207e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+08,5.3,2.7), 9.999999999786e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+09,5.3,2.7), 9.999999999990e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_P, (1.0000000000000000e+10,5.3,2.7), 1.000000000000e-00, TEST_TOL6);

    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+10,5.3,2.7), 4.272202262298e-14, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+09,5.3,2.7), 9.564269502770e-13, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+08,5.3,2.7), 2.141173208523e-11, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+07,5.3,2.7), 4.793489218238e-10, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+06,5.3,2.7), 1.073127433440e-08, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+05,5.3,2.7), 2.402407758939e-07, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+04,5.3,2.7), 5.377754447932e-06, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+03,5.3,2.7), 1.202661950234e-04, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+02,5.3,2.7), 2.664302300604e-03, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+01,5.3,2.7), 5.386718252832e-02, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e+00,5.3,2.7), 5.467279509126e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000001e-01,5.3,2.7), 9.863930100746e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e-02,5.3,2.7), 9.999515966684e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e-03,5.3,2.7), 9.999998859974e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e-04,5.3,2.7), 9.999999997435e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000001e-05,5.3,2.7), 9.999999999994e-01, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (9.9999999999999995e-07,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (9.9999999999999995e-08,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e-08,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000001e-09,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (1.0000000000000000e-10,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_fdist_Q, (0.0000000000000000e+00,5.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_cauchy (void);

void
test_auto_cauchy (void)
{
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+10,1.3), 4.138028520389e-11, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285203892783e-11,1.3), -1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+09,1.3), 4.138028520389e-10, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285203892792e-10,1.3), -1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+08,1.3), 4.138028520389e-09, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285203892787e-09,1.3), -1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+07,1.3), 4.138028520389e-08, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285203892555e-08,1.3), -1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+06,1.3), 4.138028520387e-07, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285203869488e-07,1.3), -1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+05,1.3), 4.138028520156e-06, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380285201561693e-06,1.3), -1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+04,1.3), 4.138028497078e-05, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380284970783855e-05,1.3), -1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+03,1.3), 4.138026189302e-04, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1380261893022424e-04,1.3), -1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+02,1.3), 4.137795435084e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1377954350836910e-03,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+01,1.3), 4.114951182497e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.1149511824973506e-02,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e+00,1.3), 2.912855998398e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (2.9128559983984725e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000001e-01,1.3), 4.755627480278e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.7556274802780252e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e-02,1.3), 4.975515107069e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.9755151070688325e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e-03,1.3), 4.997551462897e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (4.9975514628969159e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e-04,1.3), 4.999755146242e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000001e-05,1.3), 4.999975514624e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-9.9999999999999995e-07,1.3), 4.999997551462e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-9.9999999999999995e-08,1.3), 4.999999755146e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e-08,1.3), 4.999999975515e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000001e-09,1.3), 4.999999997551e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (-1.0000000000000000e-10,1.3), 4.999999999755e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (5.0000000000000011e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e-10,1.3), 5.000000000245e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000001e-09,1.3), 5.000000002449e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e-08,1.3), 5.000000024485e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (9.9999999999999995e-08,1.3), 5.000000244854e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (9.9999999999999995e-07,1.3), 5.000002448538e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000001e-05,1.3), 5.000024485376e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e-04,1.3), 5.000244853758e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e-03,1.3), 5.002448537103e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (5.0024485371030836e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e-02,1.3), 5.024484892931e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (5.0244848929311670e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000001e-01,1.3), 5.244372519722e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (5.2443725197219748e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+00,1.3), 7.087144001602e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (7.0871440016015275e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+01,1.3), 9.588504881750e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (9.5885048817502649e-01,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+02,1.3), 9.958622045649e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (9.9586220456491636e-01,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+03,1.3), 9.995861973811e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Pinv, (9.9958619738106980e-01,1.3), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+04,1.3), 9.999586197150e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+05,1.3), 9.999958619715e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+06,1.3), 9.999995861971e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+07,1.3), 9.999999586197e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+08,1.3), 9.999999958620e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+09,1.3), 9.999999995862e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_P, (1.0000000000000000e+10,1.3), 9.999999999586e-01, TEST_TOL6);

    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+10,1.3), 4.138028520389e-11, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285203892783e-11,1.3), 1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+09,1.3), 4.138028520389e-10, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285203892792e-10,1.3), 1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+08,1.3), 4.138028520389e-09, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285203892787e-09,1.3), 1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+07,1.3), 4.138028520389e-08, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285203892555e-08,1.3), 1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+06,1.3), 4.138028520387e-07, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285203869488e-07,1.3), 1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+05,1.3), 4.138028520156e-06, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380285201561693e-06,1.3), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+04,1.3), 4.138028497078e-05, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380284970783855e-05,1.3), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+03,1.3), 4.138026189302e-04, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1380261893022424e-04,1.3), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+02,1.3), 4.137795435084e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1377954350836910e-03,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+01,1.3), 4.114951182497e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.1149511824973506e-02,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e+00,1.3), 2.912855998398e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (2.9128559983984725e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000001e-01,1.3), 4.755627480278e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.7556274802780252e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e-02,1.3), 4.975515107069e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.9755151070688325e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e-03,1.3), 4.997551462897e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (4.9975514628969159e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e-04,1.3), 4.999755146242e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000001e-05,1.3), 4.999975514624e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (9.9999999999999995e-07,1.3), 4.999997551462e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (9.9999999999999995e-08,1.3), 4.999999755146e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e-08,1.3), 4.999999975515e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000001e-09,1.3), 4.999999997551e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (1.0000000000000000e-10,1.3), 4.999999999755e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (5.0000000000000011e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e-10,1.3), 5.000000000245e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000001e-09,1.3), 5.000000002449e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e-08,1.3), 5.000000024485e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-9.9999999999999995e-08,1.3), 5.000000244854e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-9.9999999999999995e-07,1.3), 5.000002448538e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000001e-05,1.3), 5.000024485376e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e-04,1.3), 5.000244853758e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e-03,1.3), 5.002448537103e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (5.0024485371030836e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e-02,1.3), 5.024484892931e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (5.0244848929311670e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000001e-01,1.3), 5.244372519722e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (5.2443725197219748e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+00,1.3), 7.087144001602e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (7.0871440016015275e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+01,1.3), 9.588504881750e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (9.5885048817502649e-01,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+02,1.3), 9.958622045649e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (9.9586220456491636e-01,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+03,1.3), 9.995861973811e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Qinv, (9.9958619738106980e-01,1.3), -1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+04,1.3), 9.999586197150e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+05,1.3), 9.999958619715e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+06,1.3), 9.999995861971e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+07,1.3), 9.999999586197e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+08,1.3), 9.999999958620e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+09,1.3), 9.999999995862e-01, TEST_TOL6);
    TEST(gsl_cdf_cauchy_Q, (-1.0000000000000000e+10,1.3), 9.999999999586e-01, TEST_TOL6);
}

void test_auto_gaussian (void);

void
test_auto_gaussian (void)
{
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+02,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+01,1.3), 7.225229227927e-15, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (7.2252292279265077e-15,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e+00,1.3), 2.208781637125e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (2.2087816371245972e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000001e-01,1.3), 4.693423696034e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (4.6934236960338749e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e-02,1.3), 4.969312434916e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (4.9693124349158196e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e-03,1.3), 4.996931213530e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (4.9969312135303229e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e-04,1.3), 4.999693121323e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000001e-05,1.3), 4.999969312132e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-9.9999999999999995e-07,1.3), 4.999996931213e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-9.9999999999999995e-08,1.3), 4.999999693121e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e-08,1.3), 4.999999969312e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000001e-09,1.3), 4.999999996931e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (-1.0000000000000000e-10,1.3), 4.999999999693e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e-10,1.3), 5.000000000307e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000001e-09,1.3), 5.000000003069e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e-08,1.3), 5.000000030688e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (9.9999999999999995e-08,1.3), 5.000000306879e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (9.9999999999999995e-07,1.3), 5.000003068787e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000001e-05,1.3), 5.000030687868e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e-04,1.3), 5.000306878677e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e-03,1.3), 5.003068786470e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (5.0030687864696777e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e-02,1.3), 5.030687565084e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (5.0306875650841798e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000001e-01,1.3), 5.306576303966e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (5.3065763039661251e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+00,1.3), 7.791218362875e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Pinv, (7.7912183628754028e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+01,1.3), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_P, (1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+02,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+01,1.3), 7.225229227927e-15, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (7.2252292279265077e-15,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e+00,1.3), 2.208781637125e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (2.2087816371245972e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000001e-01,1.3), 4.693423696034e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (4.6934236960338749e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e-02,1.3), 4.969312434916e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (4.9693124349158196e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e-03,1.3), 4.996931213530e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (4.9969312135303229e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e-04,1.3), 4.999693121323e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000001e-05,1.3), 4.999969312132e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (9.9999999999999995e-07,1.3), 4.999996931213e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (9.9999999999999995e-08,1.3), 4.999999693121e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e-08,1.3), 4.999999969312e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000001e-09,1.3), 4.999999996931e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (1.0000000000000000e-10,1.3), 4.999999999693e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e-10,1.3), 5.000000000307e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000001e-09,1.3), 5.000000003069e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e-08,1.3), 5.000000030688e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-9.9999999999999995e-08,1.3), 5.000000306879e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-9.9999999999999995e-07,1.3), 5.000003068787e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000001e-05,1.3), 5.000030687868e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e-04,1.3), 5.000306878677e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e-03,1.3), 5.003068786470e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (5.0030687864696777e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e-02,1.3), 5.030687565084e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (5.0306875650841798e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000001e-01,1.3), 5.306576303966e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (5.3065763039661251e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+00,1.3), 7.791218362875e-01, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Qinv, (7.7912183628754028e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+01,1.3), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gaussian_Q, (-1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_laplace (void);

void
test_auto_laplace (void)
{
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+02,1.3), 1.957501779912e-34, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (1.9575017799122328e-34,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+01,1.3), 2.281619502905e-04, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (2.2816195029051560e-04,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e+00,1.3), 2.316846846156e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (2.3168468461558764e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000001e-01,1.3), 4.629805393212e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (4.6298053932115801e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e-02,1.3), 4.961686011956e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (4.9616860119557432e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e-03,1.3), 4.996155325065e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (4.9961553250645546e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e-04,1.3), 4.999615399408e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000001e-05,1.3), 4.999961538609e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-9.9999999999999995e-07,1.3), 4.999996153848e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-9.9999999999999995e-08,1.3), 4.999999615385e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e-08,1.3), 4.999999961538e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000001e-09,1.3), 4.999999996154e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (-1.0000000000000000e-10,1.3), 4.999999999615e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e-10,1.3), 5.000000000385e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000001e-09,1.3), 5.000000003846e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e-08,1.3), 5.000000038462e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (9.9999999999999995e-08,1.3), 5.000000384615e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (9.9999999999999995e-07,1.3), 5.000003846152e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000001e-05,1.3), 5.000038461391e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e-04,1.3), 5.000384600592e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e-03,1.3), 5.003844674935e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (5.0038446749354448e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e-02,1.3), 5.038313988044e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (5.0383139880442562e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000001e-01,1.3), 5.370194606788e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (5.3701946067884199e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+00,1.3), 7.683153153844e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (7.6831531538441233e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+01,1.3), 9.997718380497e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Pinv, (9.9977183804970948e-01,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_P, (1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+02,1.3), 1.957501779912e-34, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (1.9575017799122328e-34,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+01,1.3), 2.281619502905e-04, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (2.2816195029051560e-04,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e+00,1.3), 2.316846846156e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (2.3168468461558764e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000001e-01,1.3), 4.629805393212e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (4.6298053932115801e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e-02,1.3), 4.961686011956e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (4.9616860119557432e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e-03,1.3), 4.996155325065e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (4.9961553250645546e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e-04,1.3), 4.999615399408e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000001e-05,1.3), 4.999961538609e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (9.9999999999999995e-07,1.3), 4.999996153848e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (9.9999999999999995e-08,1.3), 4.999999615385e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e-08,1.3), 4.999999961538e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000001e-09,1.3), 4.999999996154e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (1.0000000000000000e-10,1.3), 4.999999999615e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e-10,1.3), 5.000000000385e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000001e-09,1.3), 5.000000003846e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e-08,1.3), 5.000000038462e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-9.9999999999999995e-08,1.3), 5.000000384615e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-9.9999999999999995e-07,1.3), 5.000003846152e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000001e-05,1.3), 5.000038461391e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e-04,1.3), 5.000384600592e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e-03,1.3), 5.003844674935e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (5.0038446749354448e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e-02,1.3), 5.038313988044e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (5.0383139880442562e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000001e-01,1.3), 5.370194606788e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (5.3701946067884199e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+00,1.3), 7.683153153844e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (7.6831531538441233e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+01,1.3), 9.997718380497e-01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Qinv, (9.9977183804970948e-01,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_laplace_Q, (-1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_rayleigh (void);

void
test_auto_rayleigh (void)
{
    TEST(gsl_cdf_rayleigh_P, (0.0000000000000000e+00,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e-10,1.3), 2.958579881657e-21, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816568050e-21,1.3), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000001e-09,1.3), 2.958579881657e-19, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816568049e-19,1.3), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e-08,1.3), 2.958579881657e-17, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816568048e-17,1.3), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (9.9999999999999995e-08,1.3), 2.958579881657e-15, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816568001e-15,1.3), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (9.9999999999999995e-07,1.3), 2.958579881656e-13, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816563665e-13,1.3), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000001e-05,1.3), 2.958579881613e-11, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798816130393e-11,1.3), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e-04,1.3), 2.958579877280e-09, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585798772802076e-09,1.3), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e-03,1.3), 2.958579443997e-07, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585794439971025e-07,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e-02,1.3), 2.958536116114e-05, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9585361161138382e-05,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000001e-01,1.3), 2.954207597179e-03, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.9542075971792496e-03,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+00,1.3), 2.561069378624e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Pinv, (2.5610693786235361e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+01,1.3), 9.999999999999e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_P, (1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+02,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+01,1.3), 1.415959498849e-13, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Qinv, (1.4159594988487832e-13,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e+00,1.3), 7.438930621376e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Qinv, (7.4389306213764639e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000001e-01,1.3), 9.970457924028e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Qinv, (9.9704579240282076e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e-02,1.3), 9.999704146388e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e-03,1.3), 9.999997041421e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e-04,1.3), 9.999999970414e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000001e-05,1.3), 9.999999999704e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (9.9999999999999995e-07,1.3), 9.999999999997e-01, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (9.9999999999999995e-08,1.3), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e-08,1.3), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000001e-09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (1.0000000000000000e-10,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_rayleigh_Q, (0.0000000000000000e+00,1.3), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_flat (void);

void
test_auto_flat (void)
{
    TEST(gsl_cdf_flat_P, (0.0000000000000000e+00,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e-10,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000001e-09,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e-08,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (9.9999999999999995e-08,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (9.9999999999999995e-07,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000001e-05,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e-04,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e-03,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e-02,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000001e-01,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+00,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+01,1.3,750.0), 1.162014157874e-02, TEST_TOL6);
    TEST(gsl_cdf_flat_Pinv, (1.1620141578738545e-02,1.3,750.0), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+02,1.3,750.0), 1.318285027381e-01, TEST_TOL6);
    TEST(gsl_cdf_flat_Pinv, (1.3182850273808142e-01,1.3,750.0), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+03,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+04,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+05,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+06,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+07,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+08,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+09,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_P, (1.0000000000000000e+10,1.3,750.0), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+10,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+09,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+08,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+07,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+06,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+05,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+04,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+03,1.3,750.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+02,1.3,750.0), 8.681714972619e-01, TEST_TOL6);
    TEST(gsl_cdf_flat_Qinv, (8.6817149726190368e-01,1.3,750.0), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+01,1.3,750.0), 9.883798584213e-01, TEST_TOL6);
    TEST(gsl_cdf_flat_Qinv, (9.8837985842125353e-01,1.3,750.0), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e+00,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000001e-01,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e-02,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e-03,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e-04,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000001e-05,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (9.9999999999999995e-07,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (9.9999999999999995e-08,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e-08,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000001e-09,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (1.0000000000000000e-10,1.3,750.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_flat_Q, (0.0000000000000000e+00,1.3,750.0), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_lognormal (void);

void
test_auto_lognormal (void)
{
    TEST(gsl_cdf_lognormal_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e-10,1.3,2.7), 1.034288276012e-19, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.0342882760115472e-19,1.3,2.7), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000001e-09,1.3,2.7), 1.720583234428e-16, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.7205832344275183e-16,1.3,2.7), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e-08,1.3,2.7), 1.397140696550e-13, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.3971406965496307e-13,1.3,2.7), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (9.9999999999999995e-08,1.3,2.7), 5.550354890102e-11, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (5.5503548901015757e-11,1.3,2.7), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (9.9999999999999995e-07,1.3,2.7), 1.082087222875e-08, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.0820872228749844e-08,1.3,2.7), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000001e-05,1.3,2.7), 1.039815967490e-06, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.0398159674903829e-06,1.3,2.7), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e-04,1.3,2.7), 4.956354352667e-05, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (4.9563543526667839e-05,1.3,2.7), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e-03,1.3,2.7), 1.183246775456e-03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.1832467754562060e-03,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e-02,1.3,2.7), 1.436760981041e-02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (1.4367609810406523e-02,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000001e-01,1.3,2.7), 9.105428982941e-02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (9.1054289829405582e-02,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+00,1.3,2.7), 3.150871690838e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (3.1508716908375517e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+01,1.3,2.7), 6.448033073717e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (6.4480330737174019e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+02,1.3,2.7), 8.895497448370e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (8.8954974483702642e-01,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+03,1.3,2.7), 9.810967467052e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (9.8109674670518154e-01,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+04,1.3,2.7), 9.983038570318e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (9.9830385703184354e-01,1.3,2.7), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+05,1.3,2.7), 9.999223897251e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Pinv, (9.9992238972508574e-01,1.3,2.7), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+06,1.3,2.7), 9.999982185389e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+07,1.3,2.7), 9.999999796956e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+08,1.3,2.7), 9.999999998859e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+09,1.3,2.7), 9.999999999997e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_P, (1.0000000000000000e+10,1.3,2.7), 1.000000000000e-00, TEST_TOL6);

    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+10,1.3,2.7), 4.255893513650e-16, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (4.2558935136502785e-16,1.3,2.7), 1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+09,1.3,2.7), 3.150574023842e-13, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (3.1505740238418296e-13,1.3,2.7), 1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+08,1.3,2.7), 1.141445550080e-10, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (1.1414455500802107e-10,1.3,2.7), 1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+07,1.3,2.7), 2.030439602858e-08, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (2.0304396028576915e-08,1.3,2.7), 1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+06,1.3,2.7), 1.781461076603e-06, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (1.7814610766031938e-06,1.3,2.7), 1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+05,1.3,2.7), 7.761027491429e-05, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (7.7610274914290006e-05,1.3,2.7), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+04,1.3,2.7), 1.696142968157e-03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (1.6961429681565346e-03,1.3,2.7), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+03,1.3,2.7), 1.890325329482e-02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (1.8903253294818529e-02,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+02,1.3,2.7), 1.104502551630e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (1.1045025516297369e-01,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+01,1.3,2.7), 3.551966926283e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (3.5519669262825992e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e+00,1.3,2.7), 6.849128309162e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (6.8491283091624500e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000001e-01,1.3,2.7), 9.089457101706e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (9.0894571017059467e-01,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e-02,1.3,2.7), 9.856323901896e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (9.8563239018959370e-01,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e-03,1.3,2.7), 9.988167532245e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Qinv, (9.9881675322454400e-01,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e-04,1.3,2.7), 9.999504364565e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000001e-05,1.3,2.7), 9.999989601840e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (9.9999999999999995e-07,1.3,2.7), 9.999999891791e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (9.9999999999999995e-08,1.3,2.7), 9.999999999445e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e-08,1.3,2.7), 9.999999999999e-01, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000001e-09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (1.0000000000000000e-10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_lognormal_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_gamma (void);

void
test_auto_gamma (void)
{
    TEST(gsl_cdf_gamma_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-10,1.3,2.7), 2.356478475164e-14, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (2.3564784751638661e-14,1.3,2.7), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-09,1.3,2.7), 4.701792696644e-13, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (4.7017926966439445e-13,1.3,2.7), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-08,1.3,2.7), 9.381309762735e-12, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (9.3813097627346386e-12,1.3,2.7), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (9.9999999999999995e-08,1.3,2.7), 1.871817348197e-10, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.8718173481972823e-10,1.3,2.7), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (9.9999999999999995e-07,1.3,2.7), 3.734765911711e-09, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (3.7347659117114240e-09,1.3,2.7), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-05,1.3,2.7), 7.451823639191e-08, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (7.4518236391910116e-08,1.3,2.7), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-04,1.3,2.7), 1.486806276026e-06, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.4868062760263472e-06,1.3,2.7), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-03,1.3,2.7), 2.966009681152e-05, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (2.9660096811518665e-05,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-02,1.3,2.7), 5.906831032950e-04, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (5.9068310329499826e-04,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-01,1.3,2.7), 1.156629233128e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.1566292331279586e-02,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+00,1.3,2.7), 1.921237769663e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.9212377696630473e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+01,1.3,2.7), 9.565035356115e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (9.5650353561153789e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+02,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+05,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+06,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+07,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+06,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+03,1.3,2.7), 9.292091038794e-161, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.2920910387939860e-161,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+02,1.3,2.7), 2.729167976527e-16, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (2.7291679765273174e-16,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+01,1.3,2.7), 4.349646438846e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (4.3496464388462192e-02,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+00,1.3,2.7), 8.078762230337e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (8.0787622303369533e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-01,1.3,2.7), 9.884337076687e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.8843370766872041e-01,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-02,1.3,2.7), 9.994093168967e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.9940931689670498e-01,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-03,1.3,2.7), 9.999703399032e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-04,1.3,2.7), 9.999985131937e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-05,1.3,2.7), 9.999999254818e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (9.9999999999999995e-07,1.3,2.7), 9.999999962652e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (9.9999999999999995e-08,1.3,2.7), 9.999999998128e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-08,1.3,2.7), 9.999999999906e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-09,1.3,2.7), 9.999999999995e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-10,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_chisq (void);

void
test_auto_chisq (void)
{
    TEST(gsl_cdf_chisq_P, (0.0000000000000000e+00,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e-10,1.3), 2.238884178785e-07, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (2.2388841787852728e-07,1.3), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000001e-09,1.3), 1.000072827212e-06, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (1.0000728272124926e-06,1.3), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e-08,1.3), 4.467161220799e-06, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (4.4671612207994108e-06,1.3), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (9.9999999999999995e-08,1.3), 1.995407585451e-05, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (1.9954075854510294e-05,1.3), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (9.9999999999999995e-07,1.3), 8.913156700686e-05, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (8.9131567006858211e-05,1.3), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000001e-05,1.3), 3.981353794611e-04, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (3.9813537946105002e-04,1.3), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e-04,1.3), 1.778373888800e-03, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (1.7783738888003920e-03,1.3), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e-03,1.3), 7.942296379590e-03, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (7.9422963795896199e-03,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e-02,1.3), 3.541413902540e-02, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (3.5414139025402407e-02,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000001e-01,1.3), 1.554268895840e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (1.5542688958403586e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+00,1.3), 5.878620132779e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (5.8786201327788579e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+01,1.3), 9.973867890205e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Pinv, (9.9738678902053046e-01,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_P, (1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+03,1.3), 5.840240518729e-219, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (5.8402405187288964e-219,1.3), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+02,1.3), 3.517864771108e-23, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (3.5178647711076648e-23,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+01,1.3), 2.613210979470e-03, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (2.6132109794696230e-03,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e+00,1.3), 4.121379867221e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (4.1213798672211427e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000001e-01,1.3), 8.445731104160e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (8.4457311041596417e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e-02,1.3), 9.645858609746e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (9.6458586097459775e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e-03,1.3), 9.920577036204e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (9.9205770362041057e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e-04,1.3), 9.982216261112e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (9.9822162611119969e-01,1.3), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000001e-05,1.3), 9.996018646205e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Qinv, (9.9960186462053913e-01,1.3), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (9.9999999999999995e-07,1.3), 9.999108684330e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (9.9999999999999995e-08,1.3), 9.999800459241e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e-08,1.3), 9.999955328388e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000001e-09,1.3), 9.999989999272e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (1.0000000000000000e-10,1.3), 9.999997761116e-01, TEST_TOL6);
    TEST(gsl_cdf_chisq_Q, (0.0000000000000000e+00,1.3), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_tdist (void);

void
test_auto_tdist (void)
{
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+10,1.3), 3.467848111850e-14, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (3.4678481118500305e-14,1.3), -1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+09,1.3), 6.919266651610e-13, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (6.9192666516103524e-13,1.3), -1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+08,1.3), 1.380575199718e-11, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (1.3805751997179027e-11,1.3), -1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+07,1.3), 2.754609668978e-10, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (2.7546096689777484e-10,1.3), -1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+06,1.3), 5.496168864957e-09, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (5.4961688649569980e-09,1.3), -1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+05,1.3), 1.096629861231e-07, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (1.0966298612314582e-07,1.3), -1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+04,1.3), 2.188064222827e-06, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (2.1880642228271703e-06,1.3), -1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+03,1.3), 4.365759541083e-05, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (4.3657595410833571e-05,1.3), -1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+02,1.3), 8.710327647608e-04, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (8.7103276476079201e-04,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+01,1.3), 1.727893386820e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (1.7278933868204446e-02,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e+00,1.3), 2.336211937932e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (2.3362119379322516e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000001e-01,1.3), 4.667575980083e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (4.6675759800826139e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e-02,1.3), 4.966660755117e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (4.9666607551169606e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e-03,1.3), 4.996665978189e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (4.9966659781887629e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e-04,1.3), 4.999666597722e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000001e-05,1.3), 4.999966659772e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-9.9999999999999995e-07,1.3), 4.999996665977e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-9.9999999999999995e-08,1.3), 4.999999666598e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e-08,1.3), 4.999999966660e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000001e-09,1.3), 4.999999996666e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (-1.0000000000000000e-10,1.3), 4.999999999667e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (4.9999999999999900e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e-10,1.3), 5.000000000333e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000001e-09,1.3), 5.000000003334e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e-08,1.3), 5.000000033340e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (9.9999999999999995e-08,1.3), 5.000000333402e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (9.9999999999999995e-07,1.3), 5.000003334023e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000001e-05,1.3), 5.000033340228e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e-04,1.3), 5.000333402278e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e-03,1.3), 5.003334021811e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (5.0033340218112365e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e-02,1.3), 5.033339244883e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (5.0333392448830394e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000001e-01,1.3), 5.332424019917e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (5.3324240199173856e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+00,1.3), 7.663788062068e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (7.6637880620677490e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+01,1.3), 9.827210661318e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (9.8272106613179555e-01,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+02,1.3), 9.991289672352e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Pinv, (9.9912896723523925e-01,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+03,1.3), 9.999563424046e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+04,1.3), 9.999978119358e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+05,1.3), 9.999998903370e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+06,1.3), 9.999999945038e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+07,1.3), 9.999999997245e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+08,1.3), 9.999999999862e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+09,1.3), 9.999999999993e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_P, (1.0000000000000000e+10,1.3), 1.000000000000e-00, TEST_TOL6);

    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+10,1.3), 3.467848111850e-14, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (3.4678481118500305e-14,1.3), 1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+09,1.3), 6.919266651610e-13, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (6.9192666516103524e-13,1.3), 1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+08,1.3), 1.380575199718e-11, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (1.3805751997179027e-11,1.3), 1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+07,1.3), 2.754609668978e-10, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (2.7546096689777484e-10,1.3), 1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+06,1.3), 5.496168864957e-09, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (5.4961688649569980e-09,1.3), 1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+05,1.3), 1.096629861231e-07, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (1.0966298612314582e-07,1.3), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+04,1.3), 2.188064222827e-06, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (2.1880642228271703e-06,1.3), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+03,1.3), 4.365759541083e-05, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (4.3657595410833571e-05,1.3), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+02,1.3), 8.710327647608e-04, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (8.7103276476079201e-04,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+01,1.3), 1.727893386820e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (1.7278933868204446e-02,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e+00,1.3), 2.336211937932e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (2.3362119379322516e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000001e-01,1.3), 4.667575980083e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (4.6675759800826139e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e-02,1.3), 4.966660755117e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (4.9666607551169606e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e-03,1.3), 4.996665978189e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (4.9966659781887629e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e-04,1.3), 4.999666597722e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000001e-05,1.3), 4.999966659772e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (9.9999999999999995e-07,1.3), 4.999996665977e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (9.9999999999999995e-08,1.3), 4.999999666598e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e-08,1.3), 4.999999966660e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000001e-09,1.3), 4.999999996666e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (1.0000000000000000e-10,1.3), 4.999999999667e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (4.9999999999999900e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e-10,1.3), 5.000000000333e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000001e-09,1.3), 5.000000003334e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e-08,1.3), 5.000000033340e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-9.9999999999999995e-08,1.3), 5.000000333402e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-9.9999999999999995e-07,1.3), 5.000003334023e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000001e-05,1.3), 5.000033340228e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e-04,1.3), 5.000333402278e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e-03,1.3), 5.003334021811e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (5.0033340218112365e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e-02,1.3), 5.033339244883e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (5.0333392448830394e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000001e-01,1.3), 5.332424019917e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (5.3324240199173856e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+00,1.3), 7.663788062068e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (7.6637880620677490e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+01,1.3), 9.827210661318e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (9.8272106613179555e-01,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+02,1.3), 9.991289672352e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Qinv, (9.9912896723523925e-01,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+03,1.3), 9.999563424046e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+04,1.3), 9.999978119358e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+05,1.3), 9.999998903370e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+06,1.3), 9.999999945038e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+07,1.3), 9.999999997245e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+08,1.3), 9.999999999862e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+09,1.3), 9.999999999993e-01, TEST_TOL6);
    TEST(gsl_cdf_tdist_Q, (-1.0000000000000000e+10,1.3), 1.000000000000e-00, TEST_TOL6);
}

void test_auto_gumbel1 (void);

void
test_auto_gumbel1 (void)
{
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+06,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+03,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+02,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+01,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e+00,1.3,2.7), 4.981965353092e-05, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (4.9819653530918237e-05,1.3,2.7), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000001e-01,1.3,2.7), 4.619717476780e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (4.6197174767798083e-02,1.3,2.7), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e-02,1.3,2.7), 6.487265128366e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.4872651283663055e-02,1.3,2.7), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e-03,1.3,2.7), 6.696988203722e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.6969882037217598e-02,1.3,2.7), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e-04,1.3,2.7), 6.718192621136e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.7181926211364873e-02,1.3,2.7), -1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000001e-05,1.3,2.7), 6.720315385232e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-9.9999999999999995e-07,1.3,2.7), 6.720527684866e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-9.9999999999999995e-08,1.3,2.7), 6.720548915062e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e-08,1.3,2.7), 6.720551038084e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000001e-09,1.3,2.7), 6.720551250386e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (-1.0000000000000000e-10,1.3,2.7), 6.720551271616e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (0.0000000000000000e+00,1.3,2.7), 6.720551273975e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.7205512739749951e-02,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e-10,1.3,2.7), 6.720551276334e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000001e-09,1.3,2.7), 6.720551297564e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e-08,1.3,2.7), 6.720551509866e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (9.9999999999999995e-08,1.3,2.7), 6.720553632889e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (9.9999999999999995e-07,1.3,2.7), 6.720574863136e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000001e-05,1.3,2.7), 6.720787167931e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e-04,1.3,2.7), 6.722910448133e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.7229104481333457e-02,1.3,2.7), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e-03,1.3,2.7), 6.744166476190e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.7441664761898834e-02,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e-02,1.3,2.7), 6.959050352518e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (6.9590503525179814e-02,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000001e-01,1.3,2.7), 9.340058564429e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (9.3400585644290435e-02,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+00,1.3,2.7), 4.791048360125e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Pinv, (4.7910483601248477e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+01,1.3,2.7), 9.999938971292e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+05,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+06,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+07,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_P, (1.0000000000000000e+10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+06,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+03,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+02,1.3,2.7), 9.398988467742e-57, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3989884677416057e-57,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+01,1.3,2.7), 6.102870776257e-06, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (6.1028707762572197e-06,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e+00,1.3,2.7), 5.208951639875e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (5.2089516398751523e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000001e-01,1.3,2.7), 9.065994143557e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.0659941435570957e-01,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e-02,1.3,2.7), 9.304094964748e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3040949647482019e-01,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e-03,1.3,2.7), 9.325583352381e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3255833523810117e-01,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e-04,1.3,2.7), 9.327708955187e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000001e-05,1.3,2.7), 9.327921283207e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (9.9999999999999995e-07,1.3,2.7), 9.327942513686e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (9.9999999999999995e-08,1.3,2.7), 9.327944636711e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e-08,1.3,2.7), 9.327944849013e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000001e-09,1.3,2.7), 9.327944870244e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (1.0000000000000000e-10,1.3,2.7), 9.327944872367e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (0.0000000000000000e+00,1.3,2.7), 9.327944872603e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3279448726025027e-01,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e-10,1.3,2.7), 9.327944872838e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000001e-09,1.3,2.7), 9.327944874961e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e-08,1.3,2.7), 9.327944896192e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-9.9999999999999995e-08,1.3,2.7), 9.327945108494e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-9.9999999999999995e-07,1.3,2.7), 9.327947231513e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000001e-05,1.3,2.7), 9.327968461477e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e-04,1.3,2.7), 9.328180737886e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e-03,1.3,2.7), 9.330301179628e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3303011796278246e-01,1.3,2.7), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e-02,1.3,2.7), 9.351273487163e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.3512734871633696e-01,1.3,2.7), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000001e-01,1.3,2.7), 9.538028252322e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.5380282523220195e-01,1.3,2.7), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+00,1.3,2.7), 9.999501803465e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Qinv, (9.9995018034646910e-01,1.3,2.7), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+05,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+06,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+07,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel1_Q, (-1.0000000000000000e+10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_gumbel2 (void);

void
test_auto_gumbel2 (void)
{
    TEST(gsl_cdf_gumbel2_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e-10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000001e-09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e-08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (9.9999999999999995e-08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (9.9999999999999995e-07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000001e-05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e-04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e-03,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e-02,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000001e-01,1.3,2.7), 4.014688368993e-24, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Pinv, (4.0146883689934746e-24,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+00,1.3,2.7), 6.720551273975e-02, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Pinv, (6.7205512739749743e-02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+01,1.3,2.7), 8.734358842463e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Pinv, (8.7343588424628138e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+02,1.3,2.7), 9.932408531257e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Pinv, (9.9324085312574451e-01,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+03,1.3,2.7), 9.996601479016e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Pinv, (9.9966014790162783e-01,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+04,1.3,2.7), 9.999829642968e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+05,1.3,2.7), 9.999991461854e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+06,1.3,2.7), 9.999999572079e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+07,1.3,2.7), 9.999999978553e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+08,1.3,2.7), 9.999999998925e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+09,1.3,2.7), 9.999999999946e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_P, (1.0000000000000000e+10,1.3,2.7), 9.999999999997e-01, TEST_TOL6);

    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+10,1.3,2.7), 2.700000000000e-13, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (2.6999999999996492e-13,1.3,2.7), 1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+09,1.3,2.7), 5.387208250401e-12, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (5.3872082504014914e-12,1.3,2.7), 1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+08,1.3,2.7), 1.074889360437e-10, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (1.0748893604366781e-10,1.3,2.7), 1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+07,1.3,2.7), 2.144686231456e-09, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (2.1446862314557286e-09,1.3,2.7), 1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+06,1.3,2.7), 4.279211528087e-08, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (4.2792115280867646e-08,1.3,2.7), 1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+05,1.3,2.7), 8.538146037456e-07, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (8.5381460374556900e-07,1.3,2.7), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+04,1.3,2.7), 1.703570319173e-05, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (1.7035703191725618e-05,1.3,2.7), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+03,1.3,2.7), 3.398520983725e-04, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (3.3985209837246249e-04,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+02,1.3,2.7), 6.759146874256e-03, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (6.7591468742558315e-03,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+01,1.3,2.7), 1.265641157537e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (1.2656411575371904e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e+00,1.3,2.7), 9.327944872603e-01, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Qinv, (9.3279448726025116e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000001e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e-02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e-03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e-04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000001e-05,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (9.9999999999999995e-07,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (9.9999999999999995e-08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e-08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000001e-09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (1.0000000000000000e-10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gumbel2_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_weibull (void);

void
test_auto_weibull (void)
{
    TEST(gsl_cdf_weibull_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e-10,1.3,2.7), 4.924395760785e-28, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (4.9243957607852698e-28,1.3,2.7), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000001e-09,1.3,2.7), 2.468044288634e-25, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (2.4680442886338381e-25,1.3,2.7), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e-08,1.3,2.7), 1.236952289490e-22, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (1.2369522894899823e-22,1.3,2.7), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (9.9999999999999995e-08,1.3,2.7), 6.199446960984e-20, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (6.1994469609840516e-20,1.3,2.7), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (9.9999999999999995e-07,1.3,2.7), 3.107083672395e-17, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (3.1070836723945982e-17,1.3,2.7), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000001e-05,1.3,2.7), 1.557230670416e-14, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (1.5572306704159031e-14,1.3,2.7), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e-04,1.3,2.7), 7.804641318223e-12, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (7.8046413182225018e-12,1.3,2.7), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e-03,1.3,2.7), 3.911586584098e-09, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (3.9115865840980536e-09,1.3,2.7), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e-02,1.3,2.7), 1.960435341356e-06, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (1.9604353413559907e-06,1.3,2.7), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000001e-01,1.3,2.7), 9.820635881537e-04, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (9.8206358815371392e-04,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+00,1.3,2.7), 3.888663329609e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Pinv, (3.8886633296085954e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+05,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+06,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+07,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_P, (1.0000000000000000e+10,1.3,2.7), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+06,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+03,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+02,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+01,1.3,2.7), 6.519262004070e-108, TEST_TOL6);
    TEST(gsl_cdf_weibull_Qinv, (6.5192620040698617e-108,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e+00,1.3,2.7), 6.111336670391e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Qinv, (6.1113366703914040e-01,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000001e-01,1.3,2.7), 9.990179364118e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Qinv, (9.9901793641184633e-01,1.3,2.7), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e-02,1.3,2.7), 9.999980395647e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e-03,1.3,2.7), 9.999999960884e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e-04,1.3,2.7), 9.999999999922e-01, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000001e-05,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (9.9999999999999995e-07,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (9.9999999999999995e-08,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e-08,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000001e-09,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (1.0000000000000000e-10,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_weibull_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_pareto (void);

void
test_auto_pareto (void)
{
    TEST(gsl_cdf_pareto_P, (0.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e-10,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000001e-09,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e-08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (9.9999999999999995e-08,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (9.9999999999999995e-07,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000001e-05,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e-04,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e-03,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e-02,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000001e-01,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+00,1.3,2.7), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+01,1.3,2.7), 8.177057822240e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_Pinv, (8.1770578222395374e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+02,1.3,2.7), 9.908636465287e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_Pinv, (9.9086364652869807e-01,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+03,1.3,2.7), 9.995420976279e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_Pinv, (9.9954209762786816e-01,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+04,1.3,2.7), 9.999770505177e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+05,1.3,2.7), 9.999988498013e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+06,1.3,2.7), 9.999999423535e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+07,1.3,2.7), 9.999999971109e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+08,1.3,2.7), 9.999999998552e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+09,1.3,2.7), 9.999999999928e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_P, (1.0000000000000000e+10,1.3,2.7), 9.999999999997e-01, TEST_TOL6);

    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+10,1.3,2.7), 3.637247829654e-13, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (3.6372478296536173e-13,1.3,2.7), 1.000000000000e+10, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+09,1.3,2.7), 7.257263524710e-12, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (7.2572635247102111e-12,1.3,2.7), 1.000000000000e+09, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+08,1.3,2.7), 1.448014442065e-10, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (1.4480144420652496e-10,1.3,2.7), 1.000000000000e+08, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+07,1.3,2.7), 2.889168647783e-09, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (2.8891686477834784e-09,1.3,2.7), 1.000000000000e+07, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+06,1.3,2.7), 5.764649324512e-08, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (5.7646493245119715e-08,1.3,2.7), 1.000000000000e+06, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+05,1.3,2.7), 1.150198755621e-06, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (1.1501987556209536e-06,1.3,2.7), 1.000000000000e+05, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+04,1.3,2.7), 2.294948231815e-05, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (2.2949482318145872e-05,1.3,2.7), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+03,1.3,2.7), 4.579023721744e-04, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (4.5790237217441070e-04,1.3,2.7), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+02,1.3,2.7), 9.136353471345e-03, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (9.1363534713445622e-03,1.3,2.7), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+01,1.3,2.7), 1.822942177761e-01, TEST_TOL6);
    TEST(gsl_cdf_pareto_Qinv, (1.8229421777608898e-01,1.3,2.7), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e+00,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000001e-01,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e-02,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e-03,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e-04,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000001e-05,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (9.9999999999999995e-07,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (9.9999999999999995e-08,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e-08,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000001e-09,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (1.0000000000000000e-10,1.3,2.7), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_pareto_Q, (0.0000000000000000e+00,1.3,2.7), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_logistic (void);

void
test_auto_logistic (void)
{
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+02,1.3), 3.915003559824e-34, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (3.9150035598244656e-34,1.3), -1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+01,1.3), 4.561157640565e-04, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (4.5611576405646045e-04,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e+00,1.3), 3.166455298122e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (3.1664552981221700e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000001e-01,1.3), 4.807787077894e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (4.8077870778939180e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e-02,1.3), 4.980769325595e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (4.9807693255949481e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e-03,1.3), 4.998076923172e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (4.9980769231717492e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e-04,1.3), 4.999807692308e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000001e-05,1.3), 4.999980769231e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-9.9999999999999995e-07,1.3), 4.999998076923e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-9.9999999999999995e-08,1.3), 4.999999807692e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e-08,1.3), 4.999999980769e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000001e-09,1.3), 4.999999998077e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (-1.0000000000000000e-10,1.3), 4.999999999808e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e-10,1.3), 5.000000000192e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000001e-09,1.3), 5.000000001923e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e-08,1.3), 5.000000019231e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (9.9999999999999995e-08,1.3), 5.000000192308e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (9.9999999999999995e-07,1.3), 5.000001923077e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000001e-05,1.3), 5.000019230769e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e-04,1.3), 5.000192307692e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e-03,1.3), 5.001923076828e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (5.0019230768282508e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e-02,1.3), 5.019230674405e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (5.0192306744050519e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000001e-01,1.3), 5.192212922106e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (5.1922129221060820e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+00,1.3), 6.833544701878e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (6.8335447018778295e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+01,1.3), 9.995438842359e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Pinv, (9.9954388423594354e-01,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_P, (1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+10,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+09,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+08,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+07,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+06,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+05,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+04,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+03,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+02,1.3), 3.915003559824e-34, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (3.9150035598244656e-34,1.3), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+01,1.3), 4.561157640565e-04, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (4.5611576405646045e-04,1.3), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e+00,1.3), 3.166455298122e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (3.1664552981221700e-01,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000001e-01,1.3), 4.807787077894e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (4.8077870778939180e-01,1.3), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e-02,1.3), 4.980769325595e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (4.9807693255949481e-01,1.3), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e-03,1.3), 4.998076923172e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (4.9980769231717492e-01,1.3), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e-04,1.3), 4.999807692308e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000001e-05,1.3), 4.999980769231e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (9.9999999999999995e-07,1.3), 4.999998076923e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (9.9999999999999995e-08,1.3), 4.999999807692e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e-08,1.3), 4.999999980769e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000001e-09,1.3), 4.999999998077e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (1.0000000000000000e-10,1.3), 4.999999999808e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (0.0000000000000000e+00,1.3), 5.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (5.0000000000000000e-01,1.3), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e-10,1.3), 5.000000000192e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000001e-09,1.3), 5.000000001923e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e-08,1.3), 5.000000019231e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-9.9999999999999995e-08,1.3), 5.000000192308e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-9.9999999999999995e-07,1.3), 5.000001923077e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000001e-05,1.3), 5.000019230769e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e-04,1.3), 5.000192307692e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e-03,1.3), 5.001923076828e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (5.0019230768282508e-01,1.3), -1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e-02,1.3), 5.019230674405e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (5.0192306744050519e-01,1.3), -1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000001e-01,1.3), 5.192212922106e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (5.1922129221060820e-01,1.3), -1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+00,1.3), 6.833544701878e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (6.8335447018778295e-01,1.3), -1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+01,1.3), 9.995438842359e-01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Qinv, (9.9954388423594354e-01,1.3), -1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+02,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+03,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+04,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+05,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+06,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+07,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+08,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+09,1.3), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_logistic_Q, (-1.0000000000000000e+10,1.3), 1.000000000000e+00, TEST_TOL6);
}

void test_auto_gammalarge (void);

void
test_auto_gammalarge (void)
{
    TEST(gsl_cdf_gamma_P, (0.0000000000000000e+00,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-10,1.3,123.0), 1.644976604681e-16, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.6449766046812008e-16,1.3,123.0), 1.000000000000e-10, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-09,1.3,123.0), 3.282159828312e-15, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (3.2821598283122862e-15,1.3,123.0), 1.000000000000e-09, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-08,1.3,123.0), 6.548769816865e-14, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (6.5487698168653935e-14,1.3,123.0), 1.000000000000e-08, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (9.9999999999999995e-08,1.3,123.0), 1.306651361959e-12, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.3066513619593202e-12,1.3,123.0), 1.000000000000e-07, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (9.9999999999999995e-07,1.3,123.0), 2.607112210538e-11, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (2.6071122105378624e-11,1.3,123.0), 1.000000000000e-06, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-05,1.3,123.0), 5.201872529446e-10, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (5.2018725294456393e-10,1.3,123.0), 1.000000000000e-05, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-04,1.3,123.0), 1.037909593275e-08, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.0379095932752980e-08,1.3,123.0), 1.000000000000e-04, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-03,1.3,123.0), 2.070893333124e-07, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (2.0708933331240137e-07,1.3,123.0), 1.000000000000e-03, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e-02,1.3,123.0), 4.131804542806e-06, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (4.1318045428061286e-06,1.3,123.0), 1.000000000000e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000001e-01,1.3,123.0), 8.240625287202e-05, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (8.2406252872017186e-05,1.3,123.0), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+00,1.3,123.0), 1.637438876041e-03, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (1.6374388760411608e-03,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+01,1.3,123.0), 3.135521671622e-02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (3.1355216716223523e-02,1.3,123.0), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+02,1.3,123.0), 4.240385705334e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (4.2403857053338523e-01,1.3,123.0), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+03,1.3,123.0), 9.993635318324e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Pinv, (9.9936353183235616e-01,1.3,123.0), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+04,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+05,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+06,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+07,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+08,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+09,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_P, (1.0000000000000000e+10,1.3,123.0), 1.000000000000e+00, TEST_TOL6);

    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+10,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+09,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+08,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+07,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+06,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+05,1.3,123.0), 0.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+04,1.3,123.0), 2.056363344745e-35, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (2.0563633447452943e-35,1.3,123.0), 1.000000000000e+04, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+03,1.3,123.0), 6.364681676440e-04, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (6.3646816764395531e-04,1.3,123.0), 1.000000000000e+03, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+02,1.3,123.0), 5.759614294666e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (5.7596142946661488e-01,1.3,123.0), 1.000000000000e+02, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+01,1.3,123.0), 9.686447832838e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.6864478328377646e-01,1.3,123.0), 1.000000000000e+01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e+00,1.3,123.0), 9.983625611240e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.9836256112395882e-01,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-01,1.3,123.0), 9.999175937471e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Qinv, (9.9991759374712796e-01,1.3,123.0), 1.000000000000e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-02,1.3,123.0), 9.999958681955e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-03,1.3,123.0), 9.999997929107e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-04,1.3,123.0), 9.999999896209e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-05,1.3,123.0), 9.999999994798e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (9.9999999999999995e-07,1.3,123.0), 9.999999999739e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (9.9999999999999995e-08,1.3,123.0), 9.999999999987e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-08,1.3,123.0), 9.999999999999e-01, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000001e-09,1.3,123.0), 1.000000000000e-00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (1.0000000000000000e-10,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
    TEST(gsl_cdf_gamma_Q, (0.0000000000000000e+00,1.3,123.0), 1.000000000000e+00, TEST_TOL6);
}

