/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class SortingVCFWriterBase
implements VCFWriter {
    private VCFWriter innerWriter = null;
    private PriorityQueue<VCFRecord> queue = null;
    protected Integer mostUpstreamWritableLoc;
    protected static final int BEFORE_MOST_UPSTREAM_LOC = 0;
    private Set<String> finishedChromosomes = null;
    private boolean takeOwnershipOfInner;

    public SortingVCFWriterBase(VCFWriter innerWriter, boolean takeOwnershipOfInner) {
        this.innerWriter = innerWriter;
        this.queue = new PriorityQueue<VCFRecord>(50, new VariantContextComparator());
        this.mostUpstreamWritableLoc = 0;
        this.finishedChromosomes = new TreeSet<String>();
        this.takeOwnershipOfInner = takeOwnershipOfInner;
    }

    public SortingVCFWriterBase(VCFWriter innerWriter) {
        this(innerWriter, false);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.innerWriter.writeHeader(header);
    }

    @Override
    public void close() {
        this.stopWaitingToSort();
        if (this.takeOwnershipOfInner) {
            this.innerWriter.close();
        }
    }

    private void stopWaitingToSort() {
        this.emitRecords(true);
        this.mostUpstreamWritableLoc = 0;
    }

    protected void emitSafeRecords() {
        this.emitRecords(false);
    }

    protected void noteCurrentRecord(VariantContext vc) {
        if (this.mostUpstreamWritableLoc != null && vc.getStart() < this.mostUpstreamWritableLoc) {
            throw new IllegalArgumentException("Permitted to write any record upstream of position " + this.mostUpstreamWritableLoc + ", but a record at " + vc.getChr() + ":" + vc.getStart() + " was just added.");
        }
    }

    @Override
    public void add(VariantContext vc, byte refBase) {
        VCFRecord firstRec = this.queue.peek();
        if (firstRec != null && !vc.getChr().equals(firstRec.vc.getChr())) {
            if (this.finishedChromosomes.contains(vc.getChr())) {
                throw new IllegalArgumentException("Added a record at " + vc.getChr() + ":" + vc.getStart() + ", but already finished with chromosome" + vc.getChr());
            }
            this.finishedChromosomes.add(firstRec.vc.getChr());
            this.stopWaitingToSort();
        }
        this.noteCurrentRecord(vc);
        this.queue.add(new VCFRecord(vc, refBase));
        this.emitSafeRecords();
    }

    private void emitRecords(boolean emitUnsafe) {
        while (!this.queue.isEmpty()) {
            VCFRecord firstRec = this.queue.peek();
            if (!emitUnsafe && this.mostUpstreamWritableLoc != null && firstRec.vc.getStart() > this.mostUpstreamWritableLoc) break;
            this.queue.poll();
            this.innerWriter.add(firstRec.vc, firstRec.refBase);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    private static class VCFRecord {
        public VariantContext vc;
        public byte refBase;

        public VCFRecord(VariantContext vc, byte refBase) {
            this.vc = vc;
            this.refBase = refBase;
        }
    }

    private static class VariantContextComparator
    implements Comparator<VCFRecord> {
        private VariantContextComparator() {
        }

        @Override
        public int compare(VCFRecord r1, VCFRecord r2) {
            return r1.vc.getStart() - r2.vc.getStart();
        }
    }
}

