/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.BitwiseUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExternalByteArrayCodec
extends AbstractBitCodec<byte[]> {
    private OutputStream os;
    private InputStream is;

    public ExternalByteArrayCodec(OutputStream os, InputStream is) {
        this.os = os;
        this.is = is;
    }

    @Override
    public byte[] read(BitInputStream bis, int len) throws IOException {
        return BitwiseUtils.readFully(this.is, len);
    }

    @Override
    public void readInto(BitInputStream bis, byte[] array, int offset, int valueLen) throws IOException {
        BitwiseUtils.readFully(this.is, array, offset, valueLen);
    }

    @Override
    public void skip(BitInputStream bis) throws IOException {
        this.is.skip(1L);
    }

    @Override
    public void skip(BitInputStream bis, int len) throws IOException {
        this.is.skip(len);
    }

    @Override
    public long write(BitOutputStream bos, byte[] object) throws IOException {
        this.os.write(object);
        return this.numberOfBits(object);
    }

    @Override
    public long numberOfBits(byte[] object) {
        return object.length * 8;
    }

    @Override
    public byte[] read(BitInputStream bis) throws IOException {
        throw new RuntimeException("Cannot read byte array of unknown length.");
    }
}

