/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.AbstractBitCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import java.io.IOException;

public class UnaryIntegerCodec
extends AbstractBitCodec<Integer> {
    private boolean stopBit = false;
    private int offset = 0;

    public UnaryIntegerCodec() {
        this(0, false);
    }

    public UnaryIntegerCodec(int offset) {
        this(offset, false);
    }

    public UnaryIntegerCodec(int offset, boolean stopBit) {
        this.stopBit = stopBit;
        this.offset = offset;
    }

    @Override
    public final Integer read(BitInputStream bis) throws IOException {
        int bits = 0;
        while (bis.readBit() != this.stopBit) {
            ++bits;
        }
        return bits - this.offset;
    }

    @Override
    public final long write(BitOutputStream bos, Integer value) throws IOException {
        int newValue = value + this.offset;
        if (newValue < 0) {
            throw new IllegalArgumentException("Unary codec, negative values not allowed: " + newValue);
        }
        int bits = newValue + 1;
        bos.write(!this.stopBit, (long)(bits - 1));
        bos.write(this.stopBit, 1L);
        return value + 1;
    }

    @Override
    public final long numberOfBits(Integer value) {
        return value + this.offset + 1;
    }

    public boolean isStopBit() {
        return this.stopBit;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setStopBit(boolean stopBit) {
        this.stopBit = stopBit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public Integer read(BitInputStream bis, int len) throws IOException {
        throw new RuntimeException("Not implemented.");
    }
}

