/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.huffman;

import htsjdk.samtools.cram.encoding.huffman.HuffmanLeaf;
import htsjdk.samtools.cram.encoding.huffman.HuffmanNode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;

public class HuffmanCode {
    @Deprecated
    public static <T> HuffmanTree<T> buildTreeUsingPriorityQueue(int[] charFreqs, T[] values) {
        PriorityQueue<HuffmanTree> queue = new PriorityQueue<HuffmanTree>();
        for (int i = 0; i < charFreqs.length; ++i) {
            if (charFreqs[i] <= 0) continue;
            queue.offer(new HuffmanLeaf<T>(charFreqs[i], values[i]));
        }
        while (queue.size() > 1) {
            HuffmanTree a = (HuffmanTree)queue.poll();
            HuffmanTree b = (HuffmanTree)queue.poll();
            queue.offer(new HuffmanNode(a, b));
        }
        return (HuffmanTree)queue.poll();
    }

    public static <T> HuffmanTree<T> buildTree(int[] charFreqs, T[] values) {
        LinkedList<HuffmanTree> list = new LinkedList<HuffmanTree>();
        for (int i = 0; i < charFreqs.length; ++i) {
            if (charFreqs[i] <= 0) continue;
            list.add(new HuffmanLeaf<T>(charFreqs[i], values[i]));
        }
        Comparator c = new Comparator<HuffmanTree<T>>(){

            @Override
            public int compare(HuffmanTree<T> o1, HuffmanTree<T> o2) {
                return o1.frequency - o2.frequency;
            }
        };
        while (list.size() > 1) {
            Collections.sort(list, c);
            HuffmanTree left = (HuffmanTree)list.remove();
            HuffmanTree right = (HuffmanTree)list.remove();
            list.add(new HuffmanNode(left, right));
        }
        return list.isEmpty() ? null : (HuffmanTree)list.remove();
    }

    public static <T> void getValuesAndBitLengths(List<T> values, List<Integer> lens, HuffmanTree<T> tree) {
        TreeMap codes = new TreeMap();
        HuffmanCode.getBitCode(tree, new HuffmanBitCode(), codes);
        for (Object value : codes.keySet()) {
            HuffmanBitCode code = (HuffmanBitCode)codes.get(value);
            values.add(value);
            lens.add(code.bitLentgh);
        }
    }

    public static void printTree(HuffmanTree<?> tree, StringBuffer prefix, PrintStream ps) {
        if (tree instanceof HuffmanLeaf) {
            HuffmanLeaf leaf = (HuffmanLeaf)tree;
            ps.println(leaf.value + "\t" + leaf.frequency + "\t" + prefix);
        } else if (tree instanceof HuffmanNode) {
            HuffmanNode node = (HuffmanNode)tree;
            prefix.append('0');
            HuffmanCode.printTree(node.left, prefix, ps);
            prefix.deleteCharAt(prefix.length() - 1);
            prefix.append('1');
            HuffmanCode.printTree(node.right, prefix, ps);
            prefix.deleteCharAt(prefix.length() - 1);
        }
    }

    public static <T> boolean equal(HuffmanTree<T> tree1, HuffmanTree<T> tree2) {
        if (tree1.compareTo(tree2) != 0) {
            return false;
        }
        if (tree1 instanceof HuffmanLeaf && tree2 instanceof HuffmanLeaf) {
            Object value1 = ((HuffmanLeaf)tree1).value;
            Object value2 = ((HuffmanLeaf)tree2).value;
            if (value1 == null && value2 == null) {
                return true;
            }
            return value1 != null && value1.equals(value2);
        }
        if (tree1 instanceof HuffmanNode && tree2 instanceof HuffmanNode) {
            HuffmanNode node1 = (HuffmanNode)tree1;
            HuffmanNode node2 = (HuffmanNode)tree2;
            if (!HuffmanCode.equal(node1.left, node2.left)) {
                return false;
            }
            return HuffmanCode.equal(node1.right, node2.right);
        }
        return false;
    }

    private static <T> void getBitCode(HuffmanTree<T> tree, HuffmanBitCode<T> code, Map<T, HuffmanBitCode<T>> codes) {
        if (tree instanceof HuffmanLeaf) {
            HuffmanLeaf leaf = (HuffmanLeaf)tree;
            HuffmanBitCode readyCode = new HuffmanBitCode();
            readyCode.bitCode = code.bitCode;
            readyCode.bitLentgh = code.bitLentgh;
            codes.put(leaf.value, readyCode);
            return;
        }
        if (tree instanceof HuffmanNode) {
            HuffmanNode node = (HuffmanNode)tree;
            code.bitCode <<= 1;
            ++code.bitLentgh;
            HuffmanCode.getBitCode(node.left, code, codes);
            code.bitCode >>>= 1;
            --code.bitLentgh;
            code.bitCode = code.bitCode << 1 | 1L;
            ++code.bitLentgh;
            HuffmanCode.getBitCode(node.right, code, codes);
            code.bitCode >>>= 1;
            --code.bitLentgh;
        }
    }

    private static class HuffmanBitCode<T> {
        long bitCode;
        int bitLentgh;
        T value;

        private HuffmanBitCode() {
        }
    }
}

