/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.ref;

import java.util.Arrays;

public class ReferenceTracks {
    private int sequenceId;
    private byte[] reference;
    private int position;
    private final byte[] bases;
    private final short[] coverage;
    private final short[] mismatches;

    public ReferenceTracks(int sequenceId, byte[] reference) {
        this(sequenceId, reference, 1000000);
    }

    public ReferenceTracks(int sequenceId, byte[] reference, int windowSize) {
        this.sequenceId = sequenceId;
        this.reference = reference;
        this.bases = new byte[Math.min(windowSize, reference.length)];
        this.coverage = new short[Math.min(windowSize, reference.length)];
        this.mismatches = new short[Math.min(windowSize, reference.length)];
        this.position = 1;
        this.reset();
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getWindowPosition() {
        return this.position;
    }

    public int getWindowLength() {
        return this.bases.length;
    }

    public int getReferenceLength() {
        return this.reference.length;
    }

    public void ensure(int start, int end) {
        if (end - start > this.bases.length) {
            throw new RuntimeException("Window is too small for start " + start + " end " + end);
        }
        if (this.position < start) {
            this.moveForwardTo(start);
        }
    }

    public void moveForwardTo(int newPos) {
        if (newPos - 1 >= this.reference.length) {
            throw new RuntimeException("New position is beyond the reference: " + newPos);
        }
        if (newPos < this.position) {
            throw new RuntimeException("Cannot shift to smaller position on the reference.");
        }
        if (newPos > this.reference.length - this.bases.length + 1) {
            newPos = this.reference.length - this.bases.length + 1;
        }
        if (newPos == this.position) {
            return;
        }
        System.arraycopy(this.reference, newPos - 1, this.bases, 0, Math.min(this.bases.length, this.reference.length - newPos + 1));
        if (newPos > this.position && this.position + this.bases.length - newPos > 0) {
            for (int i = 0; i < this.coverage.length; ++i) {
                if (i + newPos - this.position < this.coverage.length) {
                    this.coverage[i] = this.coverage[i + newPos - this.position];
                    this.mismatches[i] = this.mismatches[i + newPos - this.position];
                    continue;
                }
                this.coverage[i] = 0;
                this.mismatches[i] = 0;
            }
        } else {
            Arrays.fill(this.coverage, (short)0);
            Arrays.fill(this.mismatches, (short)0);
        }
        this.position = newPos;
    }

    public void reset() {
        System.arraycopy(this.reference, this.position - 1, this.bases, 0, Math.min(this.bases.length, this.reference.length - this.position + 1));
        Arrays.fill(this.coverage, (short)0);
        Arrays.fill(this.mismatches, (short)0);
    }

    public void ensureRange(int start, int length) {
        if (start < this.position) {
            throw new RuntimeException("Cannot move the window backwords: " + start);
        }
        if (start > this.position || start + length > this.position + this.bases.length) {
            this.moveForwardTo(start);
        }
    }

    public final byte baseAt(int pos) {
        if (pos - this.position < this.coverage.length) {
            return this.bases[pos - this.position];
        }
        return 78;
    }

    public final short coverageAt(int pos) {
        if (pos - this.position >= this.coverage.length) {
            return 0;
        }
        return this.coverage[pos - this.position];
    }

    public final short mismatchesAt(int pos) {
        if (pos - this.position >= this.coverage.length) {
            return 0;
        }
        return this.mismatches[pos - this.position];
    }

    public final void addCoverage(int pos, int amount) {
        if (pos - this.position < this.coverage.length) {
            int n = pos - this.position;
            this.coverage[n] = (short)(this.coverage[n] + amount);
        }
    }

    public final void addMismatches(int pos, int amount) {
        if (pos - this.position < this.coverage.length) {
            int n = pos - this.position;
            this.mismatches[n] = (short)(this.mismatches[n] + amount);
        }
    }
}

