/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFJMSPerDatabaseManager;
import oracle.jdbc.driver.NTFListener;
import oracle.jdbc.driver.NTFRegistration;
import oracle.jdbc.internal.OracleConnection;

class NTFManager {
    private Hashtable<Integer, NTFListener> nsListeners = new Hashtable();
    private Hashtable<Integer, NTFRegistration> ntfRegistrations = new Hashtable();
    private byte[] listOfJdbcRegId = new byte[20];
    private HashMap<String, NTFJMSPerDatabaseManager> jmsPerDatabaseManagers = new HashMap();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    NTFManager() {
    }

    synchronized boolean listenOnPortT4C(int[] nArray, boolean bl) throws SQLException {
        int n2 = nArray[0];
        boolean bl2 = false;
        while (this.nsListeners.get(n2) == null) {
            Serializable serializable;
            try {
                ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
                serverSocketChannel.configureBlocking(false);
                ServerSocket serverSocket = serverSocketChannel.socket();
                serializable = new InetSocketAddress(n2);
                try {
                    serverSocket.bind((SocketAddress)serializable);
                    bl2 = true;
                    NTFListener nTFListener = new NTFListener(this, serverSocketChannel, n2);
                    this.nsListeners.put(n2, nTFListener);
                    nTFListener.start();
                    break;
                }
                catch (BindException bindException) {
                    if (!bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    ++n2;
                }
                catch (IOException iOException) {
                    if (!bl) {
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 250);
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                    ++n2;
                }
            }
            catch (IOException iOException) {
                serializable = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
                serializable.fillInStackTrace();
                throw serializable;
            }
        }
        nArray[0] = n2;
        return bl2;
    }

    synchronized int getNextJdbcRegId() {
        int n2;
        for (n2 = 1; n2 < this.listOfJdbcRegId.length && this.listOfJdbcRegId[n2] != 0; ++n2) {
        }
        if (n2 == this.listOfJdbcRegId.length - 1) {
            byte[] byArray = new byte[this.listOfJdbcRegId.length * 2];
            System.arraycopy(this.listOfJdbcRegId, 0, byArray, 0, this.listOfJdbcRegId.length);
            this.listOfJdbcRegId = byArray;
        }
        this.listOfJdbcRegId[n2] = 2;
        return n2;
    }

    synchronized void addRegistration(NTFRegistration nTFRegistration) {
        Integer n2 = nTFRegistration.getJdbcRegId();
        Hashtable hashtable = (Hashtable)this.ntfRegistrations.clone();
        hashtable.put(n2, nTFRegistration);
        this.ntfRegistrations = hashtable;
    }

    synchronized boolean removeRegistration(NTFRegistration nTFRegistration) {
        Integer n2 = nTFRegistration.getJdbcRegId();
        Hashtable hashtable = (Hashtable)this.ntfRegistrations.clone();
        Object v2 = hashtable.remove(n2);
        this.ntfRegistrations = hashtable;
        boolean bl = false;
        if (v2 != null) {
            bl = true;
        }
        return bl;
    }

    synchronized void freeJdbcRegId(int n2) {
        if (this.listOfJdbcRegId != null && this.listOfJdbcRegId.length > n2) {
            this.listOfJdbcRegId[n2] = 0;
        }
    }

    synchronized void cleanListenersT4C(int n2) {
        Object object;
        Enumeration<Integer> enumeration = this.ntfRegistrations.keys();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            NTFRegistration nTFRegistration = this.ntfRegistrations.get(object);
            if (nTFRegistration.getClientTCPPort() != n2) continue;
            bl = true;
        }
        if (!bl && (object = this.nsListeners.get(n2)) != null) {
            ((NTFListener)object).closeThisListener();
            ((Thread)object).interrupt();
            this.nsListeners.remove(n2);
        }
    }

    NTFRegistration getRegistration(int n2) {
        Integer n3 = n2;
        Hashtable<Integer, NTFRegistration> hashtable = this.ntfRegistrations;
        NTFRegistration nTFRegistration = hashtable.get(n3);
        return nTFRegistration;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    synchronized NTFJMSPerDatabaseManager getJMSPerDatabaseManager(String string) {
        NTFJMSPerDatabaseManager nTFJMSPerDatabaseManager = this.jmsPerDatabaseManagers.get(string);
        if (nTFJMSPerDatabaseManager == null) {
            nTFJMSPerDatabaseManager = new NTFJMSPerDatabaseManager(string);
        }
        this.jmsPerDatabaseManagers.put(string, nTFJMSPerDatabaseManager);
        return nTFJMSPerDatabaseManager;
    }

    synchronized void removeJMSUtility(String string) {
        this.jmsPerDatabaseManagers.remove(string);
    }
}

