/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InitializationFinder;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;
import proguard.util.ArrayUtil;

public class LivenessAnalyzer
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final int MAX_VARIABLES_SIZE = 64;
    private final PartialEvaluator partialEvaluator;
    private final boolean runPartialEvaluator;
    private final InitializationFinder initializationFinder;
    private final boolean runInitializationFinder;
    private long[] isAliveBefore = new long[8096];
    private long[] isAliveAfter = new long[8096];
    private long[] isCategory2 = new long[8096];
    private boolean checkAgain;
    private long alive;

    public LivenessAnalyzer() {
        this(new ReferenceTracingValueFactory(new BasicValueFactory()));
    }

    private LivenessAnalyzer(ReferenceTracingValueFactory referenceTracingValueFactory) {
        this(new PartialEvaluator(referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(referenceTracingValueFactory)), true, referenceTracingValueFactory), true);
    }

    private LivenessAnalyzer(PartialEvaluator partialEvaluator, boolean bl) {
        this(partialEvaluator, bl, new InitializationFinder(partialEvaluator, false), true);
    }

    public LivenessAnalyzer(PartialEvaluator partialEvaluator, boolean bl, InitializationFinder initializationFinder, boolean bl2) {
        this.partialEvaluator = partialEvaluator;
        this.runPartialEvaluator = bl;
        this.initializationFinder = initializationFinder;
        this.runInitializationFinder = bl2;
    }

    public boolean isTraced(int n) {
        return this.partialEvaluator.isTraced(n);
    }

    public boolean isAliveBefore(int n, int n2) {
        return n2 >= 64 ? this.partialEvaluator.getVariablesBefore(n).getValue(n2) != null : (this.isAliveBefore[n] & 1L << n2) != 0L;
    }

    public void setAliveBefore(int n, int n2, boolean bl) {
        if (n2 < 64) {
            if (bl) {
                int n3 = n;
                this.isAliveBefore[n3] = this.isAliveBefore[n3] | 1L << n2;
            } else {
                int n4 = n;
                this.isAliveBefore[n4] = this.isAliveBefore[n4] & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isAliveAfter(int n, int n2) {
        return n2 >= 64 ? this.partialEvaluator.getVariablesAfter(n).getValue(n2) != null : (this.isAliveAfter[n] & 1L << n2) != 0L;
    }

    public void setAliveAfter(int n, int n2, boolean bl) {
        if (n2 < 64) {
            if (bl) {
                int n3 = n;
                this.isAliveAfter[n3] = this.isAliveAfter[n3] | 1L << n2;
            } else {
                int n4 = n;
                this.isAliveAfter[n4] = this.isAliveAfter[n4] & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    public boolean isCategory2(int n, int n2) {
        return n2 >= 64 ? this.partialEvaluator.getVariablesBefore(n).getValue(n2) != null && this.partialEvaluator.getVariablesBefore(n).getValue(n2).isCategory2() : (this.isCategory2[n] & 1L << n2) != 0L;
    }

    public void setCategory2(int n, int n2, boolean bl) {
        if (n2 < 64) {
            if (bl) {
                int n3 = n;
                this.isCategory2[n3] = this.isCategory2[n3] | 1L << n2;
            } else {
                int n4 = n;
                this.isCategory2[n4] = this.isCategory2[n4] & (1L << n2 ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Value value;
        int n;
        int n2 = codeAttribute.u4codeLength;
        int n3 = codeAttribute.u2maxLocals;
        this.isAliveBefore = ArrayUtil.ensureArraySize(this.isAliveBefore, n2, 0L);
        this.isAliveAfter = ArrayUtil.ensureArraySize(this.isAliveAfter, n2, 0L);
        this.isCategory2 = ArrayUtil.ensureArraySize(this.isCategory2, n2, 0L);
        if (this.runPartialEvaluator) {
            this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (this.runInitializationFinder) {
            this.initializationFinder.visitCodeAttribute(clazz, method, codeAttribute);
        }
        if (n3 > 64) {
            n3 = 64;
        }
        do {
            this.checkAgain = false;
            this.alive = 0L;
            for (n = n2 - 1; n >= 0; --n) {
                if (!this.partialEvaluator.isTraced(n)) continue;
                InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.branchTargets(n);
                if (instructionOffsetValue != null) {
                    this.alive = this.combinedLiveness(instructionOffsetValue);
                }
                this.alive |= this.isAliveAfter[n];
                this.isAliveAfter[n] = this.alive;
                codeAttribute.instructionAccept(clazz, method, n, this);
                this.alive |= this.isAliveBefore[n];
                if (((this.isAliveBefore[n] ^ 0xFFFFFFFFFFFFFFFFL) & this.alive) == 0L) continue;
                this.isAliveBefore[n] = this.alive;
                value = this.partialEvaluator.branchOrigins(n);
                if (value == null || n >= ((InstructionOffsetValue)value).maximumValue()) continue;
                this.checkAgain = true;
            }
            codeAttribute.exceptionsAccept(clazz, method, this);
        } while (this.checkAgain);
        for (n = 0; n < n2; ++n) {
            if (!this.partialEvaluator.isTraced(n)) continue;
            for (int i = 0; i < n3; ++i) {
                if (this.isAliveBefore(n, i) && (value = this.partialEvaluator.getVariablesBefore(n).getValue(i)) != null && value.isCategory2()) {
                    this.setCategory2(n, i, true);
                    this.setAliveBefore(n, i + 1, true);
                    this.setCategory2(n, i + 1, true);
                }
                if (!this.isAliveAfter(n, i) || (value = this.partialEvaluator.getVariablesAfter(n).getValue(i)) == null || !value.isCategory2()) continue;
                this.setCategory2(n, i, true);
                this.setAliveAfter(n, i + 1, true);
                this.setCategory2(n, i + 1, true);
            }
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        int n2 = variableInstruction.variableIndex;
        if (n2 < 64) {
            long l = 1L << n2;
            if (variableInstruction.isLoad()) {
                this.alive |= l;
            } else {
                this.alive &= l ^ 0xFFFFFFFFFFFFFFFFL;
                int n3 = n;
                this.isAliveAfter[n3] = this.isAliveAfter[n3] | l;
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        if (n == this.initializationFinder.superInitializationOffset()) {
            this.alive |= 1L;
        }
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        long l = this.isAliveBefore[exceptionInfo.u2handlerPC];
        if (l != 0L) {
            int n = exceptionInfo.u2startPC;
            int n2 = exceptionInfo.u2endPC;
            for (int i = n; i < n2; ++i) {
                if (!this.partialEvaluator.isTraced(i) || ((this.isAliveBefore[i] & this.isAliveAfter[i] ^ 0xFFFFFFFFFFFFFFFFL) & l) == 0L) continue;
                int n3 = i;
                this.isAliveBefore[n3] = this.isAliveBefore[n3] | l;
                int n4 = i;
                this.isAliveAfter[n4] = this.isAliveAfter[n4] | l;
                this.checkAgain = true;
            }
        }
    }

    private long combinedLiveness(InstructionOffsetValue instructionOffsetValue) {
        long l = 0L;
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            l |= this.isAliveBefore[instructionOffsetValue.instructionOffset(i)];
        }
        return l;
    }
}

