/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserInfo;
import com.sun.messaging.jmq.jmsserver.auth.usermgr.UserMgrException;
import com.sun.messaging.jmq.util.FileUtil;
import com.sun.messaging.jmq.util.MD5;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public class PasswdDB {
    public static boolean DEBUG = false;
    public static final char PASSWD_FIELD_SEPARATOR = ':';
    static String pas_file;

    public void setPasswordFileName(String string) {
        pas_file = string;
    }

    public String getPasswordFileName() {
        if (pas_file == null) {
            pas_file = Globals.JMQ_ETC_HOME + File.separator + "passwd";
            if (DEBUG) {
                System.out.println("Password Filename = " + pas_file);
            }
        }
        return pas_file;
    }

    public void addUser(String string, String string2, String string3) throws UserMgrException {
        int n;
        Hashtable hashtable = this.getUserTable();
        if (string3.equals("anonymous") && (n = this.getUserCount(hashtable, "anonymous")) != 0) {
            UserMgrException userMgrException = new UserMgrException(14);
            throw userMgrException;
        }
        if (DEBUG) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                System.out.println("\t" + string4 + " = " + hashtable.get(string4));
            }
        }
        if (hashtable.containsKey(string)) {
            UserMgrException userMgrException = new UserMgrException(10);
            userMgrException.setUserName(string);
            throw userMgrException;
        }
        UserInfo userInfo = new UserInfo(string, this.hashPassword(string, string2), string3);
        hashtable.put(string, userInfo);
        this.writeUserTable(hashtable);
        if (DEBUG) {
            System.err.println("Users in role ADMIN: " + this.getUserCount("admin"));
            System.err.println("Users in role USER: " + this.getUserCount("user"));
            System.err.println("Users in role ANONYMOUS: " + this.getUserCount("anonymous"));
        }
    }

    public void deleteUser(String string) throws UserMgrException {
        Hashtable hashtable = this.getUserTable();
        if (!hashtable.containsKey(string)) {
            UserMgrException userMgrException = new UserMgrException(9);
            userMgrException.setUserName(string);
            throw userMgrException;
        }
        hashtable.remove(string);
        this.writeUserTable(hashtable);
    }

    public void updateUser(String string, String string2, Boolean bl) throws UserMgrException {
        Hashtable hashtable = this.getUserTable();
        if (!this.userExists(string, hashtable)) {
            UserMgrException userMgrException = new UserMgrException(9);
            userMgrException.setUserName(string);
            throw userMgrException;
        }
        UserInfo userInfo = (UserInfo)hashtable.get(string);
        String string3 = userInfo.getPasswd();
        String string4 = userInfo.getRole();
        boolean bl2 = userInfo.isActive();
        String string5 = string2 == null ? string3 : this.hashPassword(string, string2);
        boolean bl3 = bl == null ? bl2 : bl;
        UserInfo userInfo2 = new UserInfo(string, string5, string4, bl3);
        hashtable.put(string, userInfo2);
        this.writeUserTable(hashtable);
    }

    public UserInfo getUserInfo(String string) throws UserMgrException {
        Hashtable hashtable = this.getUserTable();
        UserInfo userInfo = (UserInfo)hashtable.get(string);
        return userInfo;
    }

    public Enumeration getUsers() throws UserMgrException {
        Hashtable hashtable = this.getUserTable();
        return hashtable.elements();
    }

    public boolean userExists(String string, Hashtable hashtable) {
        return hashtable.containsKey(string);
    }

    public int getUserCount(String string) throws UserMgrException {
        Hashtable hashtable = this.getUserTable();
        return this.getUserCount(hashtable, string);
    }

    private int getUserCount(Hashtable hashtable, String string) throws UserMgrException {
        int n = 0;
        if (string == null || string.equals("")) {
            return hashtable.size();
        }
        Enumeration enumeration = this.getUsers();
        while (enumeration.hasMoreElements()) {
            UserInfo userInfo = (UserInfo)enumeration.nextElement();
            if (!userInfo.getRole().equals(string)) continue;
            ++n;
        }
        return n;
    }

    private String hashPassword(String string, String string2) throws UserMgrException {
        String string3;
        try {
            string3 = MD5.getHashString(string + ":" + string2);
        }
        catch (Exception exception) {
            UserMgrException userMgrException = new UserMgrException(20);
            userMgrException.setLinkedException(exception);
            throw userMgrException;
        }
        return string3;
    }

    private Hashtable getUserTable() throws UserMgrException {
        InputStreamReader inputStreamReader;
        Hashtable<String, UserInfo> hashtable = new Hashtable<String, UserInfo>(13);
        FileInputStream fileInputStream = null;
        String string = this.getPasswordFileName();
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UserMgrException userMgrException = new UserMgrException(7);
            userMgrException.setPasswordFile(FileUtil.getCanonicalPath(string));
            userMgrException.setLinkedException(fileNotFoundException);
            throw userMgrException;
        }
        try {
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            inputStreamReader = null;
        }
        if (inputStreamReader == null) {
            inputStreamReader = new InputStreamReader(fileInputStream);
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (DEBUG) {
                    System.out.println("Uname:Pwd read from file = " + string2);
                }
                int n = string2.indexOf(58);
                int n2 = string2.indexOf(58, n + 1);
                int n3 = string2.lastIndexOf(58);
                if (n == -1 || n2 == -1 || n3 == -1) {
                    throw new IOException(Globals.getBrokerResources().getString("B4117", "format error in passwd file " + FileUtil.getCanonicalPath(string)));
                }
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1, n2);
                String string5 = string2.substring(n2 + 1, n3);
                String string6 = string2.substring(n3 + 1);
                if (DEBUG) {
                    System.out.println("User name = " + string3 + " & Password = " + string4 + " & role = " + string5 + " & active = " + string6);
                }
                boolean bl = string6.equals("1");
                hashtable.put(string3, new UserInfo(string3, string4, string5, bl));
            }
        }
        catch (IOException iOException) {
            UserMgrException userMgrException = new UserMgrException(13);
            userMgrException.setPasswordFile(FileUtil.getCanonicalPath(string));
            userMgrException.setLinkedException(iOException);
            throw userMgrException;
        }
        return hashtable;
    }

    private void writeUserTable(Hashtable hashtable) throws UserMgrException {
        OutputStreamWriter outputStreamWriter;
        FileOutputStream fileOutputStream;
        String string = this.getPasswordFileName();
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            UserMgrException userMgrException = new UserMgrException(7);
            userMgrException.setPasswordFile(FileUtil.getCanonicalPath(string));
            userMgrException.setLinkedException(fileNotFoundException);
            throw userMgrException;
        }
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = null;
        }
        if (outputStreamWriter == null) {
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        }
        try {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                UserInfo userInfo = (UserInfo)hashtable.get(string2);
                outputStreamWriter.write(userInfo.getPasswdEntry() + "\n");
            }
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            UserMgrException userMgrException = new UserMgrException(12);
            userMgrException.setPasswordFile(string);
            userMgrException.setLinkedException(iOException);
            throw userMgrException;
        }
    }
}

