/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core.cluster;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.core.ClusterRouter;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.cluster.BrokerConsumers;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultibrokerRouter
implements ClusterRouter {
    public static boolean DEBUG = true;
    private static Logger logger = Globals.getLogger();
    ClusterBroadcast cb = null;
    Protocol p = null;
    BrokerConsumers bc = null;

    public MultibrokerRouter(ClusterBroadcast clusterBroadcast) {
        this.cb = clusterBroadcast;
        this.p = clusterBroadcast.getProtocol();
        this.bc = new BrokerConsumers(this.p);
    }

    public static String msgToString(int n) {
        switch (n) {
            case 0: {
                return "MSG_DELIVERED";
            }
            case 1: {
                return "MSG_ACKNOWLEDGED";
            }
            case 2: {
                return "MSG_TXN_ACKNOWLEDGED";
            }
            case 3: {
                return "MSG_PREPARED";
            }
            case 4: {
                return "MSG_ROLLEDBACK";
            }
            case 5: {
                return "MSG_IGNORED";
            }
            case 6: {
                return "MSG_UNDELIVERABLE";
            }
            case 7: {
                return "MSG_DEAD";
            }
        }
        return "UNKNOWN";
    }

    public void addConsumer(Consumer consumer) throws BrokerException, IOException, SelectorFormatException {
        this.bc.addConsumer(consumer);
    }

    public void removeConsumer(ConsumerUID consumerUID) throws BrokerException, IOException {
        this.bc.removeConsumer(consumerUID);
    }

    public void removeConsumers(ConnectionUID connectionUID) throws BrokerException, IOException {
        this.bc.removeConsumers(connectionUID);
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException, IOException {
        this.bc.brokerDown(brokerAddress);
    }

    public void forwardMessage(PacketReference packetReference, Collection collection) {
        this.bc.forwardMessageToRemote(packetReference, collection);
    }

    public void handleJMSMsg(Packet packet, List list, BrokerAddress brokerAddress, boolean bl) throws BrokerException {
        Serializable serializable;
        Consumer consumer;
        int n;
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            object2 = Consumer.getConsumer(consumerUID);
            if (object2 != null) {
                arrayList.add(object2);
                continue;
            }
            arrayList2.add(consumerUID);
        }
        boolean bl2 = false;
        object2 = Destination.get(packet.getSysMessageID());
        if (object2 != null) {
            bl2 = true;
            ((PacketReference)object2).setBrokerAddress(brokerAddress);
            if (packet.getRedelivered()) {
                ((PacketReference)object2).overrideRedeliver();
            }
        } else {
            object2 = PacketReference.createReference(packet, null);
            ((PacketReference)object2).setBrokerAddress(brokerAddress);
        }
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Consumer consumer2 = (Consumer)arrayList.get(i);
                ((PacketReference)object2).addMessageDeliveredAck(consumer2.getConsumerUID());
            }
        }
        try {
            if (object2 == null) {
                return;
            }
            object = Destination.getDestination(((PacketReference)object2).getDestinationUID().getName(), ((PacketReference)object2).getDestinationUID().isQueue() ? 1 : 2, true, true);
            if (object == null) {
                arrayList2.addAll(arrayList);
            } else if (!bl2 && !arrayList.isEmpty()) {
                ((PacketReference)object2).setNeverStore(true);
                ((PacketReference)object2).store(arrayList);
                ((Destination)object).queueMessage((PacketReference)object2, false);
            } else if (bl2) {
                ((PacketReference)object2).add(arrayList);
            }
        }
        catch (IOException iOException) {
            logger.logStack(8, "Internal Exception ", iOException);
            arrayList2.addAll(arrayList);
        }
        catch (BrokerException brokerException) {
            arrayList2.addAll(arrayList);
        }
        object = "\n";
        for (n = 0; n < arrayList.size(); ++n) {
            consumer = (Consumer)arrayList.get(n);
            if (!consumer.routeMessage((PacketReference)object2, false)) {
                try {
                    if (((PacketReference)object2).acknowledged(consumer.getConsumerUID(), consumer.getStoredConsumerUID(), true, false)) {
                        serializable = Destination.getDestination(((PacketReference)object2).getDestinationUID());
                        serializable.removeMessage(((PacketReference)object2).getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                }
                catch (Exception exception) {
                    logger.log(8, "Internal error processing ack", exception);
                }
            }
            if (!DEBUG) continue;
            object = (String)object + "\t" + consumer.getConsumerUID() + "\n";
        }
        if (DEBUG) {
            logger.log(1, "MessageBus: Delivering message to : {0}", object);
        }
        object = "\n";
        consumer = null;
        serializable = null;
        for (n = 0; n < arrayList2.size(); ++n) {
            try {
                consumer = arrayList2.get(n);
                serializable = consumer instanceof Consumer ? consumer.getConsumerUID() : (ConsumerUID)((Object)consumer);
                this.cb.acknowledgeMessage(brokerAddress, ((PacketReference)object2).getSysMessageID(), (ConsumerUID)serializable, 5, false, null, null);
            }
            catch (Exception exception) {
                logger.log(16, "sendMessageAck IGNORE failed to" + brokerAddress);
            }
            if (!DEBUG) continue;
            object = (String)object + "\t" + arrayList2.get(n) + "\n";
        }
        if (DEBUG && arrayList2.size() > 0) {
            logger.log(1, "MessageBus: Invalid targets : {0}", object);
        }
    }

    public void handleAck(int n, SysMessageID sysMessageID, ConsumerUID consumerUID, Map map, Long l, UID uID, UID uID2) throws BrokerException {
        logger.log(4, "RECEIVED " + MultibrokerRouter.msgToString(n) + " for " + sysMessageID + ":" + consumerUID + " TXN=" + l);
        TransactionUID transactionUID = null;
        if (l != null) {
            transactionUID = new TransactionUID(l);
        }
        TransactionList transactionList = Globals.getTransactionList();
        switch (n) {
            case 2: {
                Consumer consumer;
                Subscription subscription;
                TransactionState transactionState = transactionList.retrieveState(transactionUID);
                if (transactionState == null) {
                    transactionList.addRemoteTxn(consumerUID.getBrokerAddress(), transactionUID);
                }
                Consumer consumer2 = (subscription = (consumer = Consumer.getConsumer(consumerUID)).getSubscription()) == null ? consumer : subscription;
                transactionList.addAcknowledgement(transactionUID, sysMessageID, consumer2.getConsumerUID(), consumer2.getStoredConsumerUID(), !Globals.getHAEnabled());
                break;
            }
            case 3: {
                if (sysMessageID != null || consumerUID != null) {
                    throw new BrokerException("INTERNAL ERROR: bad protocol");
                }
                TransactionState transactionState = transactionList.retrieveState(transactionUID);
                if (transactionState == null) {
                    logger.log(4, "XXX PREPARE - state is not there for " + transactionUID);
                    break;
                }
                if (transactionState.getState() == 5) break;
                transactionState.setState(5);
                break;
            }
            case 4: {
                if (sysMessageID != null || consumerUID != null) {
                    throw new BrokerException("INTERNAL ERROR: bad protocol");
                }
                transactionList.rollbackRemoteTxn(transactionUID);
                break;
            }
            case 1: {
                if (transactionUID != null) {
                    if (sysMessageID != null || consumerUID != null) {
                        throw new BrokerException("INTERNAL ERROR: bad protocol");
                    }
                    transactionList.commitRemoteTxn(transactionUID);
                    break;
                }
            }
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                this.bc.acknowledgeMessageFromRemote(sysMessageID, consumerUID, n, map, l);
            }
        }
    }

    public void handleCtrlMsg(int n, HashMap hashMap) throws BrokerException {
    }
}

