/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class FlowHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean handle(IMQConnection iMQConnection, Packet packet) throws BrokerException {
        if (DEBUG) {
            this.logger.log(1, "FlowHandler: handle() [ Received Flow  Message]");
        }
        if (!$assertionsDisabled && packet.getPacketType() != 52) {
            throw new AssertionError();
        }
        Hashtable hashtable = null;
        try {
            hashtable = packet.getProperties();
        }
        catch (Exception exception) {
            this.logger.log(8, "Internal Error: unable to retrieve  properties from resume message " + packet, exception);
            hashtable = new Hashtable();
        }
        Integer n = null;
        Consumer consumer = null;
        if (hashtable != null) {
            Long l;
            n = (Integer)hashtable.get("JMQSize");
            if (n == null) {
                n = (Integer)hashtable.get("JMQRBufferSize");
            }
            if ((l = (Long)hashtable.get("JMQConsumerID")) != null) {
                ConsumerUID consumerUID = new ConsumerUID(l);
                consumer = Consumer.getConsumer(consumerUID);
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Setting JMQRBufferSize -" + n);
        }
        if (consumer != null) {
            try {
                consumer.resumeFlow(n == null ? -1 : n);
            }
            catch (Exception exception) {
                this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "protocol error, bad rbuf size"), exception);
                if (!$assertionsDisabled) {
                    throw new AssertionError(n);
                }
                consumer.resumeFlow(-1);
            }
        } else {
            iMQConnection.resumeFlow(n == null ? -1 : n);
        }
        return true;
    }

    static {
        $assertionsDisabled = !FlowHandler.class.desiredAssertionStatus();
        DEBUG = false;
    }
}

