/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.management.agent.ConnectorServerInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;

public class ConnectorServerManager
implements NotificationListener {
    private Logger logger;
    private BrokerConfig config;
    private Hashtable connectors;
    private Agent agent;
    private BrokerResources rb = Globals.getBrokerResources();

    public ConnectorServerManager(Agent agent) {
        this.logger = Globals.getLogger();
        this.config = Globals.getConfig();
        this.connectors = new Hashtable();
        this.agent = agent;
    }

    public JMXConnectorServer getConnectorServer(String string) {
        ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)this.connectors.get(string);
        if (connectorServerInfo != null) {
            return connectorServerInfo.getConnectorServer();
        }
        return null;
    }

    public void add(String string, boolean bl) throws BrokerException {
        ConnectorServerInfo connectorServerInfo = new ConnectorServerInfo(this.agent, string, bl, this);
        this.connectors.put(string, connectorServerInfo);
    }

    public void remove(String string) throws IOException, BrokerException {
        ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)this.connectors.get(string);
        if (connectorServerInfo == null) {
            throw new BrokerException(this.rb.getString("B2164", string));
        }
        if (connectorServerInfo.isActive()) {
            connectorServerInfo.stop();
        }
        try {
            JMXConnectorServer jMXConnectorServer = connectorServerInfo.getConnectorServer();
            jMXConnectorServer.removeNotificationListener(this);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw new BrokerException(this.rb.getString("B2165", listenerNotFoundException.toString()));
        }
        this.connectors.remove(string);
    }

    public void initConfiguredConnectorServers() throws BrokerException {
        List list = this.getAllJMXConnectorNames();
        Set set = this.connectors.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                this.remove(string);
            }
            catch (Exception exception) {
                this.logger.log(16, this.rb.getString("B2166", string), exception);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            this.add(string, this.connectorIsConfiguredActive(string));
        }
    }

    private boolean connectorIsConfiguredActive(String string) {
        List list = this.getAllActiveJMXConnectorNames();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public List getAllJMXConnectorNames() {
        return this.config.getList("imq.jmx.connector.list");
    }

    public List getAllActiveJMXConnectorNames() {
        return this.config.getList("imq.jmx.connector.activelist");
    }

    public void start(String string) throws IOException, BrokerException {
        ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)this.connectors.get(string);
        if (connectorServerInfo == null) {
            throw new BrokerException(this.rb.getString("B2167", string));
        }
        try {
            connectorServerInfo.start();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("url", connectorServerInfo.getJMXServiceURL().toString());
            Globals.getPortMapper().addService(string, connectorServerInfo.getProtocol(), "JMX", connectorServerInfo.getPort(), hashMap);
            this.logger.log(8, this.rb.getString("B1234", string, connectorServerInfo.getJMXServiceURL()));
        }
        catch (IOException iOException) {
            this.logger.log(16, this.rb.getString("B2163", string), iOException);
            throw iOException;
        }
    }

    public void start() throws IOException, BrokerException {
        Set set = this.connectors.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.connectorIsConfiguredActive(string)) continue;
            this.start(string);
        }
    }

    public void stop(String string) throws IOException, BrokerException {
        ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)this.connectors.get(string);
        if (connectorServerInfo == null) {
            throw new BrokerException(this.rb.getString("B2168", string));
        }
        if (!connectorServerInfo.isActive()) {
            throw new BrokerException(this.rb.getString("B2169", string));
        }
        try {
            connectorServerInfo.stop();
            Globals.getPortMapper().removeService(string);
            this.logger.log(8, this.rb.getString("B1235", string));
        }
        catch (IOException iOException) {
            this.logger.log(16, this.rb.getString("B2170", string), iOException);
            throw iOException;
        }
    }

    public void stop() throws IOException, BrokerException {
        Set set = this.connectors.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)this.connectors.get(string);
            if (!connectorServerInfo.isActive()) continue;
            this.stop(string);
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (notification instanceof JMXConnectionNotification) {
            JMXConnectionNotification jMXConnectionNotification = (JMXConnectionNotification)notification;
            ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)object;
            JMXConnectorServer jMXConnectorServer = connectorServerInfo.getConnectorServer();
            String string = jMXConnectionNotification.getMessage();
            String string2 = jMXConnectionNotification.getType();
            String string3 = jMXConnectionNotification.getConnectionId();
            String string4 = connectorServerInfo.getName();
            String[] stringArray = jMXConnectorServer.getConnectionIds();
            long l = jMXConnectionNotification.getSequenceNumber();
            long l2 = jMXConnectionNotification.getTimeStamp();
            Object[] objectArray = new Object[]{string4, string3, new Integer(stringArray.length)};
            if (string2.equals("jmx.remote.connection.opened")) {
                this.logger.log(8, this.rb.getString("B1236", objectArray));
            } else if (string2.equals("jmx.remote.connection.closed")) {
                this.logger.log(8, this.rb.getString("B1237", objectArray));
            } else {
                this.logger.log(8, this.rb.getString("B1238", objectArray));
            }
        }
    }

    public Vector getConnectorInfo() {
        Vector vector = new Vector();
        Collection collection = this.connectors.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ConnectorServerInfo connectorServerInfo = (ConnectorServerInfo)iterator.next();
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("name", connectorServerInfo.getName());
            hashtable.put("active", new Boolean(connectorServerInfo.isActive()));
            String string = connectorServerInfo.isActive() ? connectorServerInfo.getJMXServiceURL().toString() : "";
            hashtable.put("url", string);
            vector.add(hashtable);
        }
        return vector;
    }
}

