/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljava.lang.String;;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.util.JMQXid;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class TransactionManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] txnIdParam;
    private static MBeanOperationInfo[] ops;

    public Integer getNumTransactions() {
        TransactionList transactionList = Globals.getTransactionList();
        Vector vector = transactionList.getTransactions(-1);
        return new Integer(vector.size());
    }

    public void commit(String string) throws MBeanException {
        this.doRollbackCommit(string, false);
    }

    public String[] getTransactionIDs() throws MBeanException {
        TransactionList transactionList = Globals.getTransactionList();
        Vector vector = transactionList.getTransactions(-1);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            TransactionUID transactionUID = (TransactionUID)enumeration.nextElement();
            long l = transactionUID.longValue();
            try {
                String string;
                stringArray[n] = string = Long.toString(l);
            }
            catch (Exception exception) {
                this.handleOperationException("getTransactionIDs", exception);
            }
            ++n;
        }
        return stringArray;
    }

    public void rollback(String string) throws MBeanException {
        this.doRollbackCommit(string, true);
    }

    public void doRollbackCommit(String string, boolean bl) throws MBeanException {
        try {
            long l = 0L;
            if (string == null) {
                throw new Exception("Null transaction ID");
            }
            try {
                l = Long.parseLong(string);
            }
            catch (Exception exception) {
                throw new Exception("Invalid transaction ID: " + string);
            }
            TransactionUID transactionUID = new TransactionUID(l);
            TransactionList transactionList = Globals.getTransactionList();
            if (transactionList == null) {
                throw new Exception("Null transaction list");
            }
            TransactionState transactionState = transactionList.retrieveState(transactionUID);
            if (transactionState == null) {
                throw new Exception(this.rb.getString("B3113", transactionUID));
            }
            if (transactionState.getState() != 5) {
                throw new Exception(this.rb.getString("B3115", transactionUID));
            }
            JMQXid jMQXid = transactionList.UIDToXid(transactionUID);
            if (jMQXid == null) {
                throw new Exception(this.rb.getString("B3100", "Could not find Xid for " + transactionUID));
            }
            PacketRouter packetRouter = Globals.getPacketRouter(0);
            if (packetRouter == null) {
                throw new Exception(this.rb.getString("B3100", "Could not locate Packet Router"));
            }
            TransactionHandler transactionHandler = (TransactionHandler)packetRouter.getHandler(48);
            if (transactionHandler == null) {
                throw new Exception(this.rb.getString("B3100", "Could not locate Transaction Handler"));
            }
            if (bl) {
                transactionHandler.doRollback(transactionUID, jMQXid, null, transactionState, null, null);
            } else {
                transactionHandler.doCommit(transactionUID, jMQXid, new Integer(0), transactionState, null, false, null, null);
            }
        }
        catch (Exception exception) {
            String string2 = bl ? "rollback" : "commit";
            this.handleOperationException(string2, exception);
        }
    }

    public String getMBeanName() {
        return "TransactionManagerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1153");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[1];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumTransactions", Integer.class.getName(), mbr.getString("MB1154"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("transactionID", String.class.getName(), mbr.getString("MB1162"));
        txnIdParam = mBeanParameterInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("commit", mbr.getString("MB1157"), txnIdParam, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getTransactionIDs", mbr.getString("MB1158"), null, String;.class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("rollback", mbr.getString("MB1161"), txnIdParam, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
    }
}

