/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.SubscriptionIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class ClusterSubscriptionInfo {
    private Subscription subscription = null;
    private Consumer consumer = null;
    private Cluster c = null;
    private GPacket pkt = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private ClusterSubscriptionInfo(Subscription subscription) {
        this.subscription = subscription;
    }

    private ClusterSubscriptionInfo(Subscription subscription, Consumer consumer, Cluster cluster) {
        this.subscription = subscription;
        this.consumer = consumer;
        this.c = cluster;
    }

    private ClusterSubscriptionInfo(GPacket gPacket) {
        this.pkt = gPacket;
    }

    private ClusterSubscriptionInfo(GPacket gPacket, Cluster cluster) {
        this.pkt = gPacket;
        this.c = cluster;
    }

    public static ClusterSubscriptionInfo newInstance(Subscription subscription) {
        return new ClusterSubscriptionInfo(subscription);
    }

    public static ClusterSubscriptionInfo newInstance(Subscription subscription, Consumer consumer, Cluster cluster) {
        return new ClusterSubscriptionInfo(subscription, consumer, cluster);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket gPacket) {
        return new ClusterSubscriptionInfo(gPacket);
    }

    public static ClusterSubscriptionInfo newInstance(GPacket gPacket, Cluster cluster) {
        return new ClusterSubscriptionInfo(gPacket, cluster);
    }

    public GPacket getGPacket(short s) {
        return this.getGPacket(s, false);
    }

    public GPacket getGPacket(short s, boolean bl) {
        if (!$assertionsDisabled && this.subscription == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && s != 5 && s != 35 && s != 7) {
            throw new AssertionError();
        }
        if (bl && !$assertionsDisabled && s != 5 && s != 7) {
            throw new AssertionError();
        }
        GPacket gPacket = null;
        switch (s) {
            case 5: {
                ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(this.subscription, null);
                gPacket = clusterConsumerInfo.getGPacket(s);
                if (s != 5 || !bl) break;
                gPacket.putProp("N", new String(this.subscription.getDurableName()));
                gPacket.putProp("I", new String(this.subscription.getClientID()));
                gPacket.putProp("M", new Boolean(true));
                break;
            }
            case 35: {
                if (!$assertionsDisabled && this.consumer == null) {
                    throw new AssertionError();
                }
                gPacket = GPacket.getInstance();
                gPacket.setType(s);
                String string = this.subscription.getDurableName();
                if (string != null) {
                    gPacket.putProp("N", new String(string));
                }
                String string2 = this.subscription.getClientID();
                gPacket.putProp("I", new String(string2));
                gPacket.putProp("allowsNonDurable", new Boolean(true));
                this.c.marshalBrokerAddress(this.c.getSelfAddress(), gPacket);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    ClusterConsumerInfo.writeConsumer(this.consumer, dataOutputStream);
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                break;
            }
            case 7: {
                gPacket = GPacket.getInstance();
                gPacket.setType(s);
                gPacket.putProp("C", new Integer(1));
                String string = this.subscription.getDurableName();
                String string3 = this.subscription.getClientID();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeUTF(string3);
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gPacket.setPayload(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
                if (!bl) break;
                gPacket.putProp("N", new String(string));
                gPacket.putProp("I", new String(string3));
                gPacket.putProp("M", new Boolean(true));
            }
        }
        return gPacket;
    }

    public int getConsumerCount() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 5 && s != 9 && s != 7) {
            throw new AssertionError();
        }
        int n = (Integer)this.pkt.getProp("C");
        if (!$assertionsDisabled && n != 1) {
            throw new AssertionError();
        }
        return n;
    }

    public boolean isConfigSyncResponse() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        boolean bl = false;
        if (this.pkt.getProp("M") != null) {
            bl = (Boolean)this.pkt.getProp("M");
        }
        return bl;
    }

    public String getDurableName() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (String)this.pkt.getProp("N");
    }

    public String getClientID() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (String)this.pkt.getProp("I");
    }

    public Boolean allowsNonDurable() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return (Boolean)this.pkt.getProp("allowsNonDurable");
    }

    public Consumer getConsumer() throws Exception {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 35) {
            throw new AssertionError();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pkt.getPayload().array());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        Consumer consumer = ClusterConsumerInfo.readConsumer(dataInputStream);
        BrokerAddress brokerAddress = this.c.unmarshalBrokerAddress(this.pkt);
        if (brokerAddress != null) {
            consumer.getConsumerUID().setBrokerAddress(brokerAddress);
        }
        return consumer;
    }

    public Iterator getSubscriptions() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        short s = this.pkt.getType();
        if (!$assertionsDisabled && s != 7) {
            throw new AssertionError();
        }
        return new SubscriptionIterator(this.pkt.getPayload().array(), this.getConsumerCount());
    }

    public boolean needReply() {
        if (!$assertionsDisabled && this.pkt == null) {
            throw new AssertionError();
        }
        return this.pkt.getBit(1);
    }

    public static GPacket getReplyGPacket(short s, int n) {
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType(s);
        gPacket.putProp("S", new Integer(n));
        return gPacket;
    }

    static {
        $assertionsDisabled = !ClusterSubscriptionInfo.class.desiredAssertionStatus();
    }
}

