/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.multibroker.BrokerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackDispatcher;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterBrokerInfoReply;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ChangeRecord;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageAckInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterMessageInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterSubscriptionInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTakeoverInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.MessageAckReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyStatus;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ReplyTracker;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.Resource;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverCleanupThread;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakeoverPendingReplyWaiter;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.TakingoverEntry;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClientClosedHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ClusterFlowControlHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ConfigChangeEventHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.DestinationUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetConfigChangesHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GetInterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.GoodbyeHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.InterestUpdateHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.LockHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageAckHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.MessageDataHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.NewInterestHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.PingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.ReloadClusterHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.RemDurableHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverAbortHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverCompleteHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.TakeoverPendingHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers.UnknownPacketHandler;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MQThreadGroup;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.UniqueID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class RaptorProtocol
implements Protocol {
    public static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    protected BrokerResources br = Globals.getBrokerResources();
    protected static boolean DEBUG_CLUSTER_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.debug.all");
    protected static boolean DEBUG_CLUSTER_LOCK = Globals.getConfig().getBooleanProperty("imq.cluster.debug.lock");
    protected static boolean DEBUG_CLUSTER_CONN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.conn");
    protected static boolean DEBUG_CLUSTER_TAKEOVER = Globals.getConfig().getBooleanProperty("imq.cluster.debug.takeover");
    protected MessageBusCallback cb = null;
    protected Cluster c = null;
    protected BrokerAddress selfAddress = null;
    protected BrokerInfo selfInfo = null;
    protected CallbackDispatcher cbDispatcher = null;
    protected int version = ProtocolGlobals.getCurrentVersion();
    private boolean shutdown = false;
    protected Map brokerList = null;
    private Map takingoverBrokers = null;
    protected int lockTimeout = Globals.getConfig().getIntProperty("imq.cluster.locktimeout", 60);
    protected HashMap resTable = null;
    protected Random r = null;
    protected long startTime = 0L;
    protected boolean configSyncComplete = false;
    protected boolean storeDirtyFlag = false;
    protected boolean isMasterBroker = false;
    private Map eventLogWaiters = null;
    protected Object cfgSrvWaitObject = null;
    protected int cfgSrvRequestCount = 0;
    protected boolean cfgSrvRequestErr = false;
    protected Store store = null;
    protected GPacketHandler[] handlers;
    protected GPacketHandler unknownPacketHandler;
    protected boolean flowStopped = false;
    private ReplyTracker ackackTracker = null;
    private ReplyTracker takeoverPendingReplyTracker = null;
    private int takeoverPendingReplyTimeout = 60;
    private Map myPretakeovers = null;
    private ThreadGroup takeoverCleanupTG = new MQThreadGroup("TakeoverCleanup");
    private FaultInjection fi = null;
    private HashMap ackCounts = new HashMap();

    public RaptorProtocol(MessageBusCallback messageBusCallback, Cluster cluster, BrokerAddress brokerAddress, BrokerInfo brokerInfo) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Initializing RaptorProtocol");
        }
        this.cb = messageBusCallback;
        this.c = cluster;
        this.selfAddress = brokerAddress;
        this.selfInfo = brokerInfo;
        this.cbDispatcher = new CallbackDispatcher(messageBusCallback);
        this.store = Globals.getStore();
        this.resTable = new HashMap();
        this.r = new Random();
        this.brokerList = Collections.synchronizedMap(new LinkedHashMap());
        this.takingoverBrokers = Collections.synchronizedMap(new LinkedHashMap());
        this.myPretakeovers = Collections.synchronizedMap(new LinkedHashMap());
        this.cfgSrvWaitObject = new Object();
        this.eventLogWaiters = Collections.synchronizedMap(new LinkedHashMap());
        this.initHandlers();
        String string = Globals.getConfig().getProperty("imq.cluster.masterbroker.backup");
        String string2 = Globals.getConfig().getProperty("imq.cluster.masterbroker.restore");
        if (string != null) {
            this.configServerBackup(string);
        }
        if (string2 != null) {
            this.configServerRestore(string2);
        }
        this.ackackTracker = new ReplyTracker();
        this.takeoverPendingReplyTracker = new ReplyTracker();
        this.fi = FaultInjection.getInjection();
    }

    private void addHandler(int n, GPacketHandler gPacketHandler) {
        if (n > 46) {
            throw new ArrayIndexOutOfBoundsException("Bad ProtocolHandler");
        }
        this.handlers[n] = gPacketHandler;
    }

    private void initHandlers() {
        if (DEBUG) {
            this.logger.log(4, "Initializing RaptorProtocol handlers");
        }
        this.handlers = new GPacketHandler[47];
        GPacketHandler gPacketHandler = new MessageDataHandler(this);
        this.addHandler(1, gPacketHandler);
        this.addHandler(2, gPacketHandler);
        gPacketHandler = new MessageAckHandler(this);
        this.addHandler(3, gPacketHandler);
        this.addHandler(4, gPacketHandler);
        gPacketHandler = new NewInterestHandler(this);
        this.addHandler(5, gPacketHandler);
        this.addHandler(6, gPacketHandler);
        this.addHandler(35, gPacketHandler);
        this.addHandler(36, gPacketHandler);
        gPacketHandler = new RemDurableHandler(this);
        this.addHandler(7, gPacketHandler);
        this.addHandler(8, gPacketHandler);
        gPacketHandler = new InterestUpdateHandler(this);
        this.addHandler(9, gPacketHandler);
        this.addHandler(10, gPacketHandler);
        gPacketHandler = new LockHandler(this);
        this.addHandler(11, gPacketHandler);
        this.addHandler(12, gPacketHandler);
        gPacketHandler = new DestinationUpdateHandler(this);
        this.addHandler(13, gPacketHandler);
        this.addHandler(14, gPacketHandler);
        this.addHandler(15, gPacketHandler);
        this.addHandler(16, gPacketHandler);
        gPacketHandler = new ConfigChangeEventHandler(this);
        this.addHandler(17, gPacketHandler);
        this.addHandler(18, gPacketHandler);
        gPacketHandler = new GetConfigChangesHandler(this);
        this.addHandler(19, gPacketHandler);
        this.addHandler(20, gPacketHandler);
        gPacketHandler = new ClientClosedHandler(this);
        this.addHandler(21, gPacketHandler);
        this.addHandler(22, gPacketHandler);
        gPacketHandler = new ClusterFlowControlHandler(this);
        this.addHandler(23, gPacketHandler);
        this.addHandler(24, gPacketHandler);
        this.addHandler(25, gPacketHandler);
        this.addHandler(26, gPacketHandler);
        gPacketHandler = new ReloadClusterHandler(this);
        this.addHandler(27, gPacketHandler);
        this.addHandler(28, gPacketHandler);
        gPacketHandler = new GetInterestUpdateHandler(this);
        this.addHandler(29, gPacketHandler);
        this.addHandler(30, gPacketHandler);
        gPacketHandler = new PingHandler(this);
        this.addHandler(33, gPacketHandler);
        this.addHandler(34, gPacketHandler);
        gPacketHandler = new GoodbyeHandler(this);
        this.addHandler(37, gPacketHandler);
        this.addHandler(38, gPacketHandler);
        gPacketHandler = new TakeoverCompleteHandler(this);
        this.addHandler(41, gPacketHandler);
        gPacketHandler = new TakeoverPendingHandler(this);
        this.addHandler(39, gPacketHandler);
        this.addHandler(40, gPacketHandler);
        gPacketHandler = new TakeoverAbortHandler(this);
        this.addHandler(43, gPacketHandler);
        this.unknownPacketHandler = new UnknownPacketHandler(this);
    }

    public int getHighestSupportedVersion() {
        return ProtocolGlobals.getCurrentVersion();
    }

    public int getClusterVersion() {
        return this.version;
    }

    public void receiveUnicast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            this.logger.log(2, "RaptorProtocol.receiveUnicast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 46) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, GPacket gPacket) {
        short s;
        if (DEBUG) {
            this.logger.log(2, "RaptorProtocol.receiveBroadcast(GPacket) from : " + brokerAddress + " Packet :\n" + gPacket.toLongString());
        }
        if ((s = gPacket.getType()) > 46) {
            this.unknownPacketHandler.handle(brokerAddress, gPacket);
            return;
        }
        switch (s) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 21: 
            case 22: 
            case 35: 
            case 36: {
                this.cbDispatcher.processGPacket(brokerAddress, gPacket, this);
                return;
            }
        }
        this.handlers[s].handle(brokerAddress, gPacket);
    }

    public void handleGPacket(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        this.handlers[gPacket.getType()].handle(messageBusCallback, brokerAddress, gPacket);
    }

    public void receiveUnicast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        this.logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray) {
        this.logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public void receiveBroadcast(BrokerAddress brokerAddress, int n, byte[] byArray, boolean bl) {
        this.logger.log(16, "Protocol Mismatch. sender = " + brokerAddress);
        Thread.dumpStack();
    }

    public BrokerInfo getBrokerInfo() {
        this.logger.logStack(32, "B3100", "Unexpected call", (Throwable)new Exception());
        return null;
    }

    public ClusterBrokerInfoReply getBrokerInfoReply(BrokerInfo brokerInfo) throws Exception {
        this.checkUIDPrefixClash(brokerInfo);
        int n = 0;
        if (this.isTakeoverTarget(brokerInfo.getBrokerAddr())) {
            n = 1;
        }
        ClusterBrokerInfoReply clusterBrokerInfoReply = ClusterBrokerInfoReply.newInstance(this.selfInfo, n);
        return clusterBrokerInfoReply;
    }

    private void checkUIDPrefixClash(BrokerInfo brokerInfo) throws BrokerException {
        if (this.c.getConfigServer() == null && UniqueID.getPrefix(brokerInfo.getBrokerAddr().getBrokerSessionUID().longValue()) == UniqueID.getPrefix(this.selfInfo.getBrokerAddr().getBrokerSessionUID().longValue())) {
            BrokerAddress brokerAddress = brokerInfo.getBrokerAddr();
            if (this.selfInfo.getStartTime() > brokerInfo.getStartTime() || this.selfInfo.getStartTime() == brokerInfo.getStartTime() && this.selfInfo.getBrokerAddr().getMQAddress().toString().compareTo(brokerAddress.getMQAddress().toString()) > 0) {
                String string = this.br.getKString("B3185", brokerAddress);
                BrokerException brokerException = new BrokerException(string);
                this.logger.logStack(32, string, brokerException);
                BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
                brokerStateHandler.initiateShutdown("cluster", 0L, false, brokerStateHandler.getRestartCode(), true);
                throw brokerException;
            }
        }
    }

    public void setMatchProps(Properties properties) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.setMatchProps :\n" + properties);
        }
        this.c.setMatchProps(properties);
    }

    public void startClusterIO() {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.startClusterIO");
        }
        try {
            BrokerAddress brokerAddress = this.c.getConfigServer();
            if (brokerAddress == null) {
                this.configSyncComplete = true;
                if (DEBUG) {
                    this.logger.log(4, "No master broker. configSyncComplete=true");
                }
            } else if (brokerAddress.equals(this.selfAddress)) {
                this.initConfigServer();
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest(this.selfAddress, l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopClusterIO(boolean bl) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.shutdown");
        }
        Object object = this.brokerList;
        synchronized (object) {
            this.shutdown = true;
        }
        this.cbDispatcher.shutdown();
        object = ClusterGoodbyeInfo.newInstance(bl, this.c);
        Map map = this.brokerList;
        synchronized (map) {
            Iterator iterator = this.brokerList.values().iterator();
            while (iterator.hasNext()) {
                BrokerInfoEx brokerInfoEx = (BrokerInfoEx)iterator.next();
                BrokerAddress brokerAddress = brokerInfoEx.getBrokerInfo().getBrokerAddr();
                GPacket gPacket = ((ClusterGoodbyeInfo)object).getGPacket();
                try {
                    Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), "[" + object + "]", brokerAddress};
                    this.logger.log(8, this.br.getKString("B1172", objectArray));
                    this.c.unicast(brokerAddress, gPacket);
                    brokerInfoEx.goodbyeSent();
                }
                catch (IOException iOException) {
                    this.logger.logStack(16, this.br.getKString("B2110", ProtocolGlobals.getPacketTypeDisplayString(gPacket.getType()), brokerAddress), iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReceived(BrokerAddress brokerAddress, ClusterGoodbyeInfo clusterGoodbyeInfo) {
        Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(37), "[" + clusterGoodbyeInfo + "]", brokerAddress};
        this.logger.log(8, this.br.getKString("B1173", objectArray));
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.setGoodbyeInfo(clusterGoodbyeInfo);
                brokerInfoEx.goodbyeReceived();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplySent(BrokerAddress brokerAddress) {
        boolean bl = false;
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.goodbyeReplySent();
                if (DEBUG) {
                    this.logger.log(8, "Sent GOODBYE_REPLY to " + brokerAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goodbyeReplyReceived(BrokerAddress brokerAddress) {
        boolean bl = false;
        Map map = this.brokerList;
        synchronized (map) {
            BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
            if (brokerInfoEx != null) {
                brokerInfoEx.goodbyeReplyReceived();
                if (DEBUG) {
                    this.logger.log(8, "Received GOODBYE_REPLY from " + brokerAddress);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGoodbye(BrokerAddress brokerAddress) {
        try {
            Map map = this.brokerList;
            synchronized (map) {
                BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                if (brokerInfoEx != null) {
                    if (brokerInfoEx.sentGoodbye()) {
                        return;
                    }
                    brokerInfoEx.goodbyeSent();
                }
            }
            this.c.unicast(brokerAddress, ClusterGoodbyeInfo.newInstance(this.c).getGPacket());
            if (DEBUG) {
                this.logger.log(8, "Sent GOODBYE to " + brokerAddress);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(16, "Unable to send GOODBYE to " + brokerAddress, exception);
        }
    }

    private BrokerAddress[] getBrokerList() {
        return this.getBrokerList(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BrokerAddress[] getBrokerList(BrokerAddress brokerAddress) {
        BrokerAddress[] brokerAddressArray = null;
        Map map = this.brokerList;
        synchronized (map) {
            brokerAddressArray = brokerAddress == null || this.brokerList.get(brokerAddress) == null ? new BrokerAddress[this.brokerList.size()] : new BrokerAddress[this.brokerList.size() - 1];
            int n = 0;
            Collection collection = this.brokerList.values();
            Iterator iterator = collection.iterator();
            BrokerAddress brokerAddress2 = null;
            while (iterator.hasNext()) {
                BrokerInfoEx brokerInfoEx = (BrokerInfoEx)iterator.next();
                brokerAddress2 = brokerInfoEx.getBrokerInfo().getBrokerAddr();
                if (brokerAddress != null && brokerAddress2.equals(brokerAddress)) continue;
                brokerAddressArray[n++] = brokerAddress2;
            }
        }
        return brokerAddressArray;
    }

    public boolean isTakeoverTarget(BrokerAddress brokerAddress) {
        if (!Globals.getHAEnabled()) {
            return false;
        }
        TakingoverEntry takingoverEntry = (TakingoverEntry)this.takingoverBrokers.get(new TakingoverEntry(brokerAddress.getBrokerID(), brokerAddress.getStoreSessionUID()));
        if (takingoverEntry == null) {
            return false;
        }
        return takingoverEntry.isTakeoverTarget(brokerAddress);
    }

    public void preTakeover(String string, UID uID, String string2, UID uID2) {
        this.logger.log(8, this.br.getKString("B1175", "[brokerID=" + string + ", storeSession=" + uID + "]"));
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID, string2, uID2, l, true);
        TakingoverEntry takingoverEntry = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        this.myPretakeovers.put(takingoverEntry, l);
        this.takeoverCleanup(takingoverEntry, false);
        this.takeoverPendingConvergecast(null, clusterTakeoverInfo);
        takingoverEntry.preTakeoverDone(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverPendingConvergecast(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        if (!clusterTakeoverInfo.isFromTaker()) {
            return;
        }
        BrokerAddress[] brokerAddressArray = null;
        Map map = this.brokerList;
        synchronized (map) {
            brokerAddressArray = this.getBrokerList(brokerAddress);
            if (brokerAddressArray.length == 0) {
                this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, 200, null);
                return;
            }
            this.takeoverPendingReplyTracker.addWaiter(clusterTakeoverInfo.getXid(), new TakeoverPendingReplyWaiter(brokerAddressArray));
        }
        try {
            try {
                for (int i = 0; i < brokerAddressArray.length; ++i) {
                    this.c.unicast(brokerAddressArray[i], clusterTakeoverInfo.getGPacket((short)39));
                }
            }
            catch (Exception exception) {
                this.logger.log(16, exception.getMessage());
            }
            ReplyStatus replyStatus = null;
            int n = 200;
            String string = null;
            try {
                replyStatus = this.takeoverPendingReplyTracker.waitForReply(clusterTakeoverInfo.getXid(), this.takeoverPendingReplyTimeout);
                if (replyStatus != null && replyStatus.getStatus() != 200) {
                    n = replyStatus.getStatus();
                    string = replyStatus.getReason();
                    this.logger.log(16, this.br.getKString("B2111", ProtocolGlobals.getPacketTypeDisplayString(40), Status.getString(n)));
                }
            }
            catch (BrokerException brokerException) {
                n = brokerException.getStatusCode();
                string = brokerException.getMessage();
                this.logger.log(16, this.br.getKString("B2112", ProtocolGlobals.getPacketTypeDisplayString(40), string));
            }
            this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, n, string);
        }
        finally {
            this.takeoverPendingReplyTracker.removeWaiter(clusterTakeoverInfo.getXid());
        }
    }

    private void sendTakeoverPendingReply(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo, int n, String string) {
        if (brokerAddress != null && clusterTakeoverInfo.needReply()) {
            GPacket gPacket = clusterTakeoverInfo.getReplyGPacket((short)40, n, string);
            try {
                this.c.unicast(brokerAddress, gPacket);
            }
            catch (IOException iOException) {
                this.logger.logStack(16, "Unable send to " + brokerAddress + " TAKEOVER_PENDING reply " + ClusterTakeoverInfo.toString(gPacket), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeoverCleanup(TakingoverEntry takingoverEntry, boolean bl) {
        if (takingoverEntry.isTakeoverTarget(this.selfAddress)) {
            String string = this.br.getKString("B3187");
            this.logger.logStack(32, string, new BrokerException(string));
            BrokerStateHandler brokerStateHandler = Globals.getBrokerStateHandler();
            brokerStateHandler.initiateShutdown("cluster", 0L, true, brokerStateHandler.getRestartCode(), true);
            return;
        }
        BrokerAddress brokerAddress = null;
        BrokerInfoEx brokerInfoEx = null;
        Map map = this.brokerList;
        synchronized (map) {
            Iterator iterator = this.brokerList.keySet().iterator();
            while (iterator.hasNext()) {
                brokerAddress = (BrokerAddress)iterator.next();
                brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                if (!takingoverEntry.isTakeoverTarget(brokerAddress)) continue;
                if (bl) {
                    this.logger.log(16, "Force closing broker link to " + brokerAddress + " because it has been TAKEOVER");
                } else {
                    this.logger.log(16, "Force closing broker link to " + brokerAddress + " because it is being TAKEOVER");
                }
                this.c.closeLink(brokerAddress, true);
                BrokerInfoEx brokerInfoEx2 = brokerInfoEx;
                synchronized (brokerInfoEx2) {
                    while (brokerInfoEx.deactivated()) {
                        this.logger.log(8, "Waiting for broker link to " + brokerAddress + " deactivated ..");
                        try {
                            brokerInfoEx.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public void postTakeover(String string, UID uID, boolean bl) {
        if (bl) {
            this.logger.log(8, this.br.getKString("B1176", "[brokerID=" + string + ", storeSession=" + uID + "]"));
            Long l = (Long)this.myPretakeovers.get(new TakingoverEntry(string, uID));
            ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID, null, null, l, true);
            GPacket gPacket = null;
            try {
                gPacket = clusterTakeoverInfo.getGPacket((short)43);
                this.c.broadcast(gPacket);
            }
            catch (Exception exception) {
                if (gPacket == null) {
                    this.logger.logStack(32, "B3100", exception);
                }
                this.logger.logStack(16, "Unable to broadcast TAKEOVER_ABORT " + ClusterTakeoverInfo.newInstance(gPacket), exception);
            }
            this.receivedTakeoverAbort(null, clusterTakeoverInfo);
            return;
        }
        try {
            ClusterTakeoverInfo clusterTakeoverInfo = ClusterTakeoverInfo.newInstance(string, uID);
            this.logger.log(8, this.br.getKString("B1177", "[brokerID=" + string + ", storeSession=" + uID + "]"));
            this.receivedTakeoverComplete(null, clusterTakeoverInfo);
            this.c.broadcast(clusterTakeoverInfo.getGPacket((short)41));
        }
        catch (Exception exception) {
            this.logger.logStack(16, "Broadcast TAKEOVER_COMPLETE got exception", exception);
        }
    }

    public void receivedTakeoverComplete(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        Object[] objectArray;
        if (brokerAddress != null) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(41), "[" + clusterTakeoverInfo + "]", brokerAddress};
            this.logger.log(8, this.br.getKString("B1178", objectArray));
        }
        if ((objectArray = TakingoverEntry.takeoverComplete(this.takingoverBrokers, clusterTakeoverInfo)) == null) {
            return;
        }
        TakeoverCleanupThread takeoverCleanupThread = new TakeoverCleanupThread(this.takeoverCleanupTG, this, brokerAddress, clusterTakeoverInfo, (TakingoverEntry)objectArray, 41);
        takeoverCleanupThread.start();
    }

    public void receivedTakeoverPending(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        Object[] objectArray;
        TakingoverEntry takingoverEntry = TakingoverEntry.addTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        if (takingoverEntry != null || DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(39), "[" + clusterTakeoverInfo + "]", brokerAddress};
            this.logger.log(8, this.br.getKString("B1178", objectArray));
        }
        if (takingoverEntry == null || this.getBrokerList(brokerAddress).length == 0) {
            this.sendTakeoverPendingReply(brokerAddress, clusterTakeoverInfo, 200, null);
            return;
        }
        objectArray = new TakeoverCleanupThread(this.takeoverCleanupTG, this, brokerAddress, clusterTakeoverInfo, takingoverEntry, 39);
        objectArray.start();
    }

    public void receivedTakeoverPendingReply(BrokerAddress brokerAddress, GPacket gPacket) {
        Object[] objectArray;
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_TAKEOVER) {
            objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(gPacket) + "]", brokerAddress};
            this.logger.log(8, this.br.getKString("B1173", objectArray));
        }
        if ((objectArray = ClusterTakeoverInfo.getReplyXid(gPacket)) == null) {
            this.logger.log(32, "B3100", "Received takeover reply without correlation ID from " + brokerAddress + " : " + ClusterTakeoverInfo.toString(gPacket));
            return;
        }
        if (!this.takeoverPendingReplyTracker.notifyReply((Long)objectArray, brokerAddress, gPacket)) {
            Object[] objectArray2 = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(40), "[" + ClusterTakeoverInfo.toString(gPacket) + "]", brokerAddress};
            this.logger.log(16, this.br.getKString("B2114", objectArray2));
        }
    }

    public void receivedTakeoverAbort(BrokerAddress brokerAddress, ClusterTakeoverInfo clusterTakeoverInfo) {
        if (brokerAddress != null) {
            Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(43), "[" + clusterTakeoverInfo + "]", brokerAddress};
            this.logger.log(8, this.br.getKString("B1178", objectArray));
        }
        TakingoverEntry.removeTakingoverEntry(this.takingoverBrokers, clusterTakeoverInfo);
        this.takeoverPendingReplyTracker.abortWaiter(clusterTakeoverInfo.getXid());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardTakeoverBrokers(BrokerAddress brokerAddress, boolean bl) {
        if (!Globals.getHAEnabled()) {
            return;
        }
        if (bl) {
            TakingoverEntry takingoverEntry = null;
            GPacket[] gPacketArray = null;
            Map map = this.takingoverBrokers;
            synchronized (map) {
                Iterator iterator = this.takingoverBrokers.keySet().iterator();
                while (iterator.hasNext()) {
                    takingoverEntry = (TakingoverEntry)iterator.next();
                    gPacketArray = takingoverEntry.getGPackets();
                    for (int i = 0; i < gPacketArray.length; ++i) {
                        try {
                            this.c.unicast(brokerAddress, gPacketArray[i]);
                            continue;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            return;
        }
        TakingoverEntry takingoverEntry = (TakingoverEntry)this.takingoverBrokers.get(new TakingoverEntry(brokerAddress.getBrokerID(), brokerAddress.getStoreSessionUID()));
        if (takingoverEntry == null) {
            return;
        }
        GPacket gPacket = takingoverEntry.getGPacket(brokerAddress);
        if (gPacket == null) {
            return;
        }
        try {
            this.c.unicastAndClose(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initConfigServer() {
        Object[] objectArray;
        this.isMasterBroker = true;
        this.logger.log(8, "B1069");
        boolean bl = false;
        BrokerAddress brokerAddress = this.getLastConfigServer();
        BrokerMQAddress brokerMQAddress = this.selfAddress.getMQAddress();
        if (brokerAddress != null) {
            objectArray = brokerAddress.getMQAddress();
            if (!this.selfAddress.equals(brokerAddress) && brokerMQAddress.getHost().getCanonicalHostName().equals(objectArray.getHost().getCanonicalHostName()) && this.selfAddress.getInstanceName().equals(brokerAddress.getInstanceName())) {
                this.logger.log(8, this.br.getKString("B1226", brokerAddress, this.selfAddress));
                bl = true;
            }
        }
        try {
            objectArray = this.store.getAllConfigRecords();
            byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
            if (((ArrayList)objectArray[1]).size() == 0) {
                this.logger.log(8, "B1068");
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            } else if (bl) {
                ArrayList arrayList = this.compressConfigRecords(objectArray);
                this.store.clearAllConfigChangeRecords(false);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
                ChangeRecord changeRecord = null;
                for (int i = 0; i < arrayList.size(); ++i) {
                    changeRecord = (ChangeRecord)arrayList.get(i);
                    if (changeRecord.discard) continue;
                    this.store.storeConfigChangeRecord(System.currentTimeMillis(), changeRecord.getBytes(), false);
                }
            }
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", "Master broker initialization failed.", (Throwable)exception);
        }
    }

    public void reloadCluster() {
        this.logger.log(8, "B1074");
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)27);
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.c.reloadCluster();
    }

    public void stopMessageFlow() {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = true;
        this.sendFlowControlUpdate(null);
    }

    public void resumeMessageFlow() {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.stopMessageFlow()");
        }
        this.flowStopped = false;
        this.sendFlowControlUpdate(null);
    }

    private void sendFlowControlUpdate(BrokerAddress brokerAddress) {
        GPacket gPacket = GPacket.getInstance();
        if (this.flowStopped) {
            gPacket.setType((short)23);
        } else {
            gPacket.setType((short)25);
        }
        try {
            if (brokerAddress == null) {
                this.c.broadcast(gPacket);
            } else {
                this.c.unicast(brokerAddress, gPacket);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean waitForConfigSync() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            return true;
        }
        if (brokerAddress == null) {
            return false;
        }
        if (brokerAddress.equals(this.selfAddress)) {
            return false;
        }
        return !this.configSyncComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(PacketReference packetReference, Collection collection, boolean bl) {
        ArrayList<Object> arrayList;
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        HashMap<Object, ArrayList<Object>> hashMap = new HashMap<Object, ArrayList<Object>>();
        if (DEBUG) {
            this.logger.log(2, "MessageBus: sending message {0} to {1} targets.", (Object)packetReference.getSysMessageID(), Integer.toString(collection.size()));
        }
        StringBuffer stringBuffer = new StringBuffer("\n");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            object2 = (Consumer)iterator.next();
            serializable2 = ((Consumer)object2).getConsumerUID();
            serializable = ((Consumer)object2).getStoredConsumerUID();
            try {
                packetReference.delivered((ConsumerUID)serializable2, (ConsumerUID)serializable, ((ConsumerUID)serializable2).isUnsafeAck(), true);
            }
            catch (Exception exception) {
                this.logger.logStack(16, "B3100", "saving redeliver flag for " + packetReference.getSysMessageID() + " to " + serializable2, (Throwable)exception);
            }
            object = ((Consumer)object2).getConsumerUID().getBrokerAddress();
            arrayList = (ArrayList)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(object, arrayList);
            }
            arrayList.add(object2);
            stringBuffer.append("\t").append(((Consumer)object2).toString()).append("\n");
        }
        if (DEBUG) {
            this.logger.log(1, "MessageBus: Local Targets = {0}", stringBuffer);
        }
        object2 = hashMap.keySet().iterator();
        while (object2.hasNext()) {
            serializable2 = (BrokerAddress)object2.next();
            serializable = (ArrayList)hashMap.get(serializable2);
            object = ClusterMessageInfo.newInstance(packetReference, (ArrayList)serializable, bl, this.c);
            try {
                arrayList = this.brokerList;
                synchronized (arrayList) {
                    BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(serializable2);
                    if (brokerInfoEx == null) {
                        throw new BrokerException("NOTFOUND: Could not deliver message " + ((ClusterMessageInfo)object).toString() + " to " + serializable2);
                    }
                    if (brokerInfoEx.sentGoodbye()) {
                        throw new BrokerException("GOODBYE: Could not deliver message " + ((ClusterMessageInfo)object).toString() + " to " + serializable2);
                    }
                }
                this.c.unicast((BrokerAddress)serializable2, ((ClusterMessageInfo)object).getGPacket(), true);
                if (!DEBUG) continue;
                this.logger.log(1, "MessageBus: Broker {0} Targets = {1}", (Object)serializable2, stringBuffer + ((ClusterMessageInfo)object).toString());
            }
            catch (Exception exception) {
                for (int i = 0; i < ((ArrayList)serializable).size(); ++i) {
                    ConsumerUID consumerUID = ((Consumer)((ArrayList)serializable).get(i)).getConsumerUID();
                    try {
                        this.cb.processRemoteAck(packetReference.getSysMessageID(), consumerUID, 5, null, null, this.selfAddress.getBrokerSessionUID(), this.selfAddress.getStoreSessionUID());
                        continue;
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(16, brokerException.getMessage(), brokerException);
                    }
                }
                if (!DEBUG) continue;
                this.logger.log(1, "RaptorProtocol: Could not deliver message to broker {0}", serializable2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageAck(BrokerAddress brokerAddress, SysMessageID sysMessageID, ConsumerUID consumerUID, int n, boolean bl, Map map, Long l) throws BrokerException {
        block22: {
            if (FaultInjection.FAULT_INJECTION) {
                ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_P, FaultInjection.STAGE_1);
            }
            Long l2 = null;
            if (bl) {
                l2 = this.ackackTracker.addWaiter(new MessageAckReplyWaiter(brokerAddress));
            }
            ClusterMessageAckInfo clusterMessageAckInfo = ClusterMessageAckInfo.newInstance(sysMessageID, consumerUID, n, l2, map, l, brokerAddress, this.c);
            if (DEBUG) {
                this.logger.log(1, "MessageBus: Sending message ack: " + clusterMessageAckInfo.toString());
            }
            try {
                Object object = this.brokerList;
                synchronized (object) {
                    BrokerInfoEx brokerInfoEx = (BrokerInfoEx)this.brokerList.get(brokerAddress);
                    if (brokerInfoEx == null) {
                        throw new BrokerException(this.br.getKString("B4249", clusterMessageAckInfo.toString(), brokerAddress), 500);
                    }
                    if (brokerInfoEx.sentGoodbye() || brokerInfoEx.gotGoodbye()) {
                        throw new BrokerException(this.br.getKString("B4247", clusterMessageAckInfo.toString(), brokerAddress), 500);
                    }
                    if (this.isTakeoverTarget(brokerAddress)) {
                        throw new BrokerException(this.br.getKString("B4244", clusterMessageAckInfo.toString(), brokerAddress), 500);
                    }
                    this.c.unicast(brokerAddress, clusterMessageAckInfo.getGPacket());
                    if (FaultInjection.FAULT_INJECTION) {
                        ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_P, FaultInjection.STAGE_2);
                    }
                }
                if (!bl) break block22;
                object = null;
                try {
                    object = this.ackackTracker.waitForReply(l2, 180000L);
                }
                catch (BrokerException brokerException) {
                    if (brokerException.getStatusCode() == 410) {
                        throw new BrokerException(this.br.getKString("B4245", clusterMessageAckInfo.toString(), brokerAddress), 500);
                    }
                    throw brokerException;
                }
                if (((ReplyStatus)object).getStatus() != 200) {
                    this.logger.log(16, this.br.getKString("B2117", ClusterMessageAckInfo.toString(((ReplyStatus)object).getReply()), brokerAddress));
                    throw new BrokerException(((ReplyStatus)object).getReason(), ((ReplyStatus)object).getStatus());
                }
                if (FaultInjection.FAULT_INJECTION) {
                    ClusterMessageAckInfo.CHECKFAULT(this.ackCounts, n, l, FaultInjection.MSG_REMOTE_ACK_P, FaultInjection.STAGE_3);
                }
            }
            catch (Exception exception) {
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                throw new BrokerException(exception.getMessage(), exception, 500);
            }
            finally {
                if (bl) {
                    this.ackackTracker.removeWaiter(l2);
                }
            }
        }
    }

    public void receivedMessageAckReply(BrokerAddress brokerAddress, GPacket gPacket) {
        Long l = ClusterMessageAckInfo.getAckAckXid(gPacket);
        if (l == null) {
            this.logger.log(32, "B3100", "Received message ack reply without correlation ID from " + brokerAddress + " : " + ClusterMessageAckInfo.toString(gPacket));
            return;
        }
        if (!this.ackackTracker.notifyReply(l, brokerAddress, gPacket)) {
            Object[] objectArray = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(4), "[" + ClusterMessageAckInfo.toString(gPacket) + "]", brokerAddress};
            this.logger.log(16, this.br.getKString("B2114", objectArray));
        }
    }

    public static byte[] prepareResetPersistenceRecord() {
        if (DEBUG) {
            Globals.getLogger().log(4, "RaptorProtocol.prepareResetPersistenceRecord");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)31);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void sendNewInterestUpdate(Consumer consumer) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendNewInterestUpdate : " + consumer.toString());
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(consumer, this.c);
        try {
            this.c.broadcast(clusterConsumerInfo.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendNewInterestUpdate(BrokerAddress brokerAddress, Collection collection) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendNewInterestUpdate to " + brokerAddress);
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(collection, this.c);
        try {
            this.c.unicast(brokerAddress, clusterConsumerInfo.getGPacket((short)5));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendAttachDurable(Subscription subscription, Consumer consumer) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendAttachDurable : " + subscription.getDurableName() + ":" + subscription.getClientID() + " --- " + consumer);
        }
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription, consumer, this.c);
        try {
            this.c.broadcast(clusterSubscriptionInfo.getGPacket((short)35));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendRemDurableUpdate(Consumer consumer) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendRemDurableUpdate : " + consumer);
        }
        Subscription subscription = null;
        subscription = consumer instanceof Subscription ? (Subscription)consumer : consumer.getSubscription();
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        try {
            this.c.broadcast(clusterSubscriptionInfo.getGPacket((short)7, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInterestUpdate(Consumer consumer, int n) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendInterestUpdate. interest = " + consumer);
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(consumer, this.c);
        try {
            this.c.broadcast(clusterConsumerInfo.getGPacket((short)9, n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInterestUpdate(BrokerAddress brokerAddress, Collection collection, int n) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendInterestUpdate. to = " + brokerAddress);
        }
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(collection, this.c);
        try {
            this.c.unicast(brokerAddress, clusterConsumerInfo.getGPacket((short)9, n));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendClientClosedUpdate(ConnectionUID connectionUID) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendClientClosedUpdate. conid = " + connectionUID);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)21);
        gPacket.putProp("I", new Long(connectionUID.longValue()));
        try {
            this.c.broadcast(gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientClosed(ConnectionUID connectionUID, boolean bl) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.clientClosed. conid = " + connectionUID);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            object = this.resTable.keySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                if (!connectionUID.equals(resource.getOwner())) continue;
                arrayList.add(string);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            this.unlockResource((String)object);
        }
        if (bl) {
            this.sendClientClosedUpdate(connectionUID);
            this.cbDispatcher.clientDown(connectionUID);
        }
    }

    public int lockSharedResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID, true);
    }

    public int lockResource(String string, ConnectionUID connectionUID) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", owner = " + connectionUID);
        }
        return this.lockResource(string, 0L, connectionUID);
    }

    public int lockResource(String string, long l, ConnectionUID connectionUID) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.lockResource. resId = " + string + ", timestamp = " + l + ", owner = " + connectionUID);
        }
        return this.lockResource(string, l, connectionUID, false);
    }

    private int lockResource(String string, long l, ConnectionUID connectionUID, boolean bl) {
        int n = 1;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = this.tryLockResource(string, l, connectionUID, bl)) == 0 || n3 == 1) {
                if (DEBUG) {
                    this.logger.log(4, "Lock resId = " + string + "returned : " + n3);
                }
                return n3;
            }
            if (++n2 == 10) break;
            int n4 = this.r.nextInt(n *= 2);
            try {
                Thread.sleep(n4 * 1000);
            }
            catch (Exception exception) {}
        }
        this.logger.log(16, "B2034", string);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryLockResource(String string, long l, ConnectionUID connectionUID, boolean bl) {
        Resource resource;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.tryLockResource.resId = " + string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
            if (resource != null) {
                if (bl && resource.getShared()) {
                    return 0;
                }
                return 1;
            }
            resource = new Resource(string, this.c);
            resource.setShared(bl);
            resource.setOwner(connectionUID);
            if (l != 0L) {
                resource.setTimestamp(l);
            }
            this.resTable.put(string, resource);
        }
        resource.setLockState(0);
        block15: while (true) {
            if (DEBUG) {
                this.logger.log(4, "MessageBus: Trying to lock resource {0}", string);
            }
            int n = 0;
            if (this.brokerList.size() > 0) {
                this.sendLockRequest(resource);
                n = resource.waitForStatusChange(this.lockTimeout);
            } else {
                n = 0;
            }
            if (DEBUG) {
                this.logger.log(4, "MessageBus: Lock attempt status = {0} for resource {1}", (Object)Integer.toString(n), string);
            }
            switch (n) {
                case 0: {
                    resource.setLockState(1);
                    return n;
                }
                case 1: 
                case 2: {
                    HashMap hashMap2 = this.resTable;
                    synchronized (hashMap2) {
                        this.resTable.remove(string);
                    }
                    return n;
                }
                case -1: {
                    this.logger.log(16, "B2062", (Object)resource.getResId(), resource.showRecipients());
                    HashMap hashMap3 = this.resTable;
                    synchronized (hashMap3) {
                        this.resTable.remove(string);
                    }
                    return 1;
                }
                case 3: {
                    if (!DEBUG_CLUSTER_ALL && !DEBUG_CLUSTER_LOCK) continue block15;
                    this.logger.log(4, "Active brokerlist changed. Restarting Lock election for {0}." + resource.getResId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockResource(String string) {
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            this.logger.log(4, "MessageBus: Unlocking resource = {0}", string);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Resource resource = (Resource)this.resTable.remove(string);
            if (resource != null) {
                resource.impliedFailure();
            }
        }
    }

    private void sendLockRequest(Resource resource) {
        Object object;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendLockRequest");
        }
        long l = System.currentTimeMillis();
        BrokerAddress[] brokerAddressArray = this.getBrokerList();
        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) {
            object = "";
            for (int i = 0; i < brokerAddressArray.length; ++i) {
                object = (String)object + "\n\t" + brokerAddressArray[i];
            }
            this.logger.log(4, "Sending resource lock request for : " + resource.getResId() + "\nExpecting responses from : " + (String)object);
        }
        resource.prepareLockRequest(brokerAddressArray, l);
        object = GPacket.getInstance();
        ((GPacket)object).setType((short)11);
        ((GPacket)object).putProp("I", new String(resource.getResId()));
        ((GPacket)object).putProp("TS", new Long(resource.getTimestamp()));
        ((GPacket)object).putProp("X", new Long(l));
        ((GPacket)object).putProp("SH", new Boolean(resource.getShared()));
        try {
            this.c.broadcast((GPacket)object);
        }
        catch (Exception exception) {
            this.logger.log(8, "Unexpected protocol exception broadcasing msgs", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockRequest(BrokerAddress brokerAddress, String string, long l, long l2, boolean bl) {
        int n;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveLockRequest. resId = " + string + ", xid = " + l2);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null || bl && resource.getShared()) {
            n = 0;
        } else if (resource.getLockState() == 1) {
            n = 1;
        } else if (l < resource.getTimestamp()) {
            resource.impliedFailure();
            n = 0;
        } else {
            n = l > resource.getTimestamp() ? 1 : 2;
        }
        this.sendLockResponse(brokerAddress, string, l2, n);
    }

    private void sendLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendLockResponse. resId = " + string + ", xid = " + l + "to = " + brokerAddress + ", response = " + n);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)12);
        gPacket.putProp("I", new String(string));
        gPacket.putProp("X", new Long(l));
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            this.logger.log(16, this.br.getString("B2101", string, brokerAddress.toString()), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveLockResponse(BrokerAddress brokerAddress, String string, long l, int n) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveLockResponse. resId = " + string + ", xid = " + l + "from = " + brokerAddress + ", response = " + n);
        }
        Resource resource = null;
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            resource = (Resource)this.resTable.get(string);
        }
        if (resource == null) {
            return;
        }
        if ((DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_LOCK) && resource.getXid() == l) {
            this.logger.log(4, "Received Lock Response.\n\tSender = " + brokerAddress + "\n\tResource = " + resource.getResId() + "\n\tResponse = " + ProtocolGlobals.lockResponseStrings[n]);
        }
        resource.consumeResponse(l, brokerAddress, n);
    }

    public void recordUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.recordUpdateDestination");
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        this.recordConfigChangeEvent(clusterDestInfo.getGPacket((short)13, true));
    }

    public void recordRemoveDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.recordRemoveDestination");
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        this.recordConfigChangeEvent(clusterDestInfo.getGPacket((short)15, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordConfigChangeEvent(GPacket gPacket) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.recordConfigChangeEvent");
        }
        if (DEBUG) {
            this.logger.log(1, "Event = " + gPacket.toLongString());
        }
        if (this.c.getConfigServer() == null) {
            return 2;
        }
        Long l = new Long(UniqueID.generateID(UID.getPrefix()));
        EventLogWaiter eventLogWaiter = new EventLogWaiter(0);
        this.eventLogWaiters.put(l, eventLogWaiter);
        try {
            EventLogWaiter eventLogWaiter2 = eventLogWaiter;
            synchronized (eventLogWaiter2) {
                this.sendConfigChangeEvent(l, gPacket);
                while (eventLogWaiter.getStatus() == 0) {
                    try {
                        eventLogWaiter.wait();
                    }
                    catch (Exception exception) {}
                }
                if (eventLogWaiter.getStatus() == 1) {
                    this.storeDirtyFlag = true;
                }
                return eventLogWaiter.getStatus();
            }
        }
        catch (BrokerException brokerException) {
            this.eventLogWaiters.remove(l);
            if (DEBUG) {
                this.logger.logStack(16, brokerException.getMessage() + ": " + gPacket.toLongString(), brokerException);
            }
            throw brokerException;
        }
    }

    private void sendConfigChangeEvent(Long l, GPacket gPacket) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendConfigChangeEvent. xid = " + l);
        }
        BrokerAddress brokerAddress = this.c.getConfigServer();
        GPacket gPacket2 = GPacket.getInstance();
        gPacket2.setType((short)17);
        gPacket2.putProp("X", l);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket2.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket2);
        }
        catch (Exception exception) {
            throw new BrokerException(this.br.getKString("B4094"), "B4094", null, 403);
        }
    }

    public void receiveConfigChangeEvent(BrokerAddress brokerAddress, Long l, byte[] byArray) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveConfigChangeEvent. xid = " + l);
        }
        try {
            this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            this.sendConfigChangeEventAck(brokerAddress, l, 1);
        }
        catch (Exception exception) {
            this.sendConfigChangeEventAck(brokerAddress, l, 2);
            return;
        }
    }

    private void sendConfigChangeEventAck(BrokerAddress brokerAddress, Long l, int n) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendConfigChangeEventAck. xid = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)18);
        gPacket.putProp("X", l);
        gPacket.putProp("S", new Integer(n));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangeEventReply(BrokerAddress brokerAddress, Long l, int n) {
        EventLogWaiter eventLogWaiter;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveConfigChangeEventAck. xid = " + l);
        }
        if ((eventLogWaiter = (EventLogWaiter)this.eventLogWaiters.remove(l)) == null) {
            Object[] objectArray = new String[]{String.valueOf(l), String.valueOf(n)};
            this.logger.log(16, "B2107", objectArray);
            return;
        }
        EventLogWaiter eventLogWaiter2 = eventLogWaiter;
        synchronized (eventLogWaiter2) {
            eventLogWaiter.setStatus(n);
            eventLogWaiter.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendConfigChangesRequest. timestamp = " + l);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)19);
        gPacket.putProp("TS", new Long(l));
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            try {
                this.c.unicast(brokerAddress, gPacket);
                ++this.cfgSrvRequestCount;
                this.cfgSrvRequestErr = false;
            }
            catch (Exception exception) {
                this.cfgSrvRequestCount = 0;
                this.cfgSrvRequestErr = true;
                this.cfgSrvWaitObject.notifyAll();
            }
        }
    }

    public void receiveConfigChangesRequest(BrokerAddress brokerAddress, long l) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveConfigChangesRequest. from = " + brokerAddress);
        }
        try {
            ArrayList arrayList = this.store.getConfigChangeRecordsSince(l);
            long l2 = System.currentTimeMillis();
            this.sendConfigChangesResponse(brokerAddress, l2, arrayList);
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", "Could not send config change response..", (Throwable)exception);
            return;
        }
    }

    private void sendConfigChangesResponse(BrokerAddress brokerAddress, long l, ArrayList arrayList) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendConfigChangesResponse. to = " + brokerAddress);
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)20);
        gPacket.putProp("TS", new Long(l));
        gPacket.putProp("C", new Integer(arrayList.size()));
        gPacket.putProp("S", new Integer(200));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                byte[] byArray = (byte[])arrayList.get(i);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        gPacket.setPayload(ByteBuffer.wrap(byArray));
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveConfigChangesReply(BrokerAddress brokerAddress, long l, int n, byte[] byArray) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.receiveConfigChangesResponse.");
        }
        boolean bl = false;
        BrokerAddress brokerAddress2 = this.getLastConfigServer();
        if (brokerAddress2 != null && !brokerAddress2.equals(brokerAddress)) {
            bl = true;
            if (n == 0) {
                this.logger.log(32, "B3095");
                Broker.getBroker().exit(1, this.br.getString("B3095"), 2);
            }
        }
        DataInputStream dataInputStream = null;
        if (byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            dataInputStream = new DataInputStream(byteArrayInputStream);
        }
        try {
            boolean bl2 = false;
            ArrayList<GPacket> arrayList = null;
            for (int i = 0; i < n; ++i) {
                GPacket gPacket = GPacket.getInstance();
                gPacket.read(dataInputStream);
                if (i == 0) {
                    if (gPacket.getType() == 31) {
                        bl2 = true;
                        arrayList = new ArrayList<GPacket>();
                    }
                    if (bl && !bl2) {
                        this.logger.log(32, "B3095");
                        Broker.getBroker().exit(1, this.br.getString("B3095"), 2);
                    }
                }
                if (bl2) {
                    arrayList.add(gPacket);
                    continue;
                }
                this.receiveBroadcast(brokerAddress, gPacket);
            }
            if (bl2) {
                this.applyPersistentStateChanges(brokerAddress, arrayList);
            }
            if (!this.configSyncComplete) {
                this.configSyncComplete = true;
                this.cbDispatcher.configSyncComplete();
                this.sendGetInterestUpdate(brokerAddress);
                this.logger.log(8, "B1075");
            }
            Object object = this.cfgSrvWaitObject;
            synchronized (object) {
                --this.cfgSrvRequestCount;
                if (this.cfgSrvRequestCount == 0) {
                    this.cfgSrvWaitObject.notifyAll();
                }
            }
            this.storeLastRefreshTime(l - 120000L);
            this.storeLastConfigServer(brokerAddress);
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B3100", "Error while applying the config changes...", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitConfigChangesResponse() {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.waitConfigChangesResponse.");
        }
        Object object = this.cfgSrvWaitObject;
        synchronized (object) {
            while (this.cfgSrvRequestCount > 0) {
                try {
                    this.cfgSrvWaitObject.wait();
                }
                catch (Exception exception) {}
            }
            if (DEBUG) {
                this.logger.log(4, "RaptorProtocol.waitConfigChangesResponse returning :" + !this.cfgSrvRequestErr);
            }
            return !this.cfgSrvRequestErr;
        }
    }

    private void applyPersistentStateChanges(BrokerAddress brokerAddress, ArrayList arrayList) throws Exception {
        Object object;
        Object object2;
        Serializable serializable;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.applyPersistentStateChanges.");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<DestinationUID, Serializable> hashMap2 = new HashMap<DestinationUID, Serializable>();
        Set set = Subscription.getAllSubscriptions(null);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (Subscription)iterator.next();
            object2 = ((Consumer)serializable).getConsumerUID();
            object = ((Subscription)serializable).getDurableName() + ":" + ((Subscription)serializable).getClientID();
            hashMap.put((String)object, object2);
        }
        set = null;
        iterator = Destination.getAllDestinations();
        while (iterator.hasNext()) {
            serializable = (Destination)iterator.next();
            if (((Destination)serializable).isAutoCreated() || ((Destination)serializable).isInternal() || ((Destination)serializable).isTemporary() || ((Destination)serializable).isDMQ()) continue;
            hashMap2.put(((Destination)serializable).getDestinationUID(), serializable);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            object2 = (GPacket)arrayList.get(i);
            if (((GPacket)object2).getType() == 31) {
                if (!DEBUG) continue;
                this.logger.log(4, "applyPersistentStateChanges : RESET_PERSISTENCE");
                continue;
            }
            if (((GPacket)object2).getType() == 5 || ((GPacket)object2).getType() == 7) {
                this.receiveBroadcast(brokerAddress, (GPacket)object2);
                object = ClusterSubscriptionInfo.newInstance((GPacket)object2);
                string = ((ClusterSubscriptionInfo)object).getDurableName() + ":" + ((ClusterSubscriptionInfo)object).getClientID();
                hashMap.remove(string);
                if (!DEBUG) continue;
                if (((GPacket)object2).getType() == 5) {
                    this.logger.log(4, "Added subscription : " + string);
                    continue;
                }
                this.logger.log(4, "Remove subscription : " + string);
                continue;
            }
            if (((GPacket)object2).getType() != 13 && ((GPacket)object2).getType() != 15) continue;
            object = ClusterDestInfo.newInstance((GPacket)object2);
            string = ((ClusterDestInfo)object).getDestName();
            int n = ((ClusterDestInfo)object).getDestType();
            DestinationUID destinationUID = DestinationUID.getUID(string, DestType.isQueue(n));
            Destination destination = (Destination)hashMap2.get(destinationUID);
            if (((GPacket)object2).getType() == 13 && destination != null && destination.getType() != n) {
                DestinationUID destinationUID2 = DestinationUID.getUID(destination.getDestinationName(), DestType.isQueue(destination.getType()));
                this.cbDispatcher.notifyDestroyDestination(destinationUID2);
            }
            this.receiveBroadcast(brokerAddress, (GPacket)object2);
            hashMap2.remove(destinationUID);
            if (!DEBUG) continue;
            if (((GPacket)object2).getType() == 13) {
                this.logger.log(4, "Updated destination : " + destinationUID);
                continue;
            }
            this.logger.log(4, "Removed destination : " + destinationUID);
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ConsumerUID consumerUID = (ConsumerUID)iterator.next();
            object2 = Consumer.getConsumer(consumerUID);
            if (object2 == null) continue;
            this.cbDispatcher.interestRemoved((Consumer)object2);
            if (!DEBUG) continue;
            this.logger.log(4, "Removed stale subscription : " + object2);
        }
        iterator = hashMap2.keySet().iterator();
        while (iterator.hasNext()) {
            DestinationUID destinationUID = (DestinationUID)iterator.next();
            this.cbDispatcher.notifyDestroyDestination(destinationUID);
            if (!DEBUG) continue;
            this.logger.log(4, "Removed stale destination : " + destinationUID);
        }
    }

    public void sendNewDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Sending New Destination " + destination);
        }
        this.sendUpdateDestination(destination);
    }

    public void sendUpdateDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Sending Update Destination " + destination);
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        try {
            this.c.broadcast(clusterDestInfo.getGPacket((short)13, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendRemovedDestination(Destination destination) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Sending New Destination " + destination);
        }
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
        try {
            this.c.broadcast(clusterDestInfo.getGPacket((short)15, false));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void recordCreateSubscription(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.recordCreateSubscription");
        }
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        this.recordConfigChangeEvent(clusterSubscriptionInfo.getGPacket((short)5, true));
    }

    public void recordUnsubscribe(Subscription subscription) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.recordUnsubscribe");
        }
        ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
        this.recordConfigChangeEvent(clusterSubscriptionInfo.getGPacket((short)7, true));
    }

    public void sendNewSubscription(Subscription subscription, Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendNewSubscription");
        }
        this.sendNewInterestUpdate(subscription);
        this.sendAttachDurable(subscription, consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendNewConsumer(Consumer consumer, boolean bl) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendNewConsumer");
        }
        this.sendNewInterestUpdate(consumer);
        if (bl) {
            this.sendInterestUpdate(consumer, 4);
        }
    }

    public void sendRemovedConsumer(Consumer consumer) throws BrokerException {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendRemovedConsumer");
        }
        if (consumer instanceof Subscription) {
            this.sendRemDurableUpdate(consumer);
        } else if (consumer.getSubscription() != null) {
            this.sendInterestUpdate(consumer, 3);
        } else {
            this.sendInterestUpdate(consumer, 2);
        }
    }

    private void sendGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.sendGetInterestUpdate");
        }
        GPacket gPacket = GPacket.getInstance();
        gPacket.setType((short)29);
        try {
            this.c.unicast(brokerAddress, gPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void receiveGetInterestUpdate(BrokerAddress brokerAddress) {
        if (DEBUG) {
            this.logger.log(4, "MessageBus: Received request for a full interest update from {0}.", brokerAddress);
        }
        this.forwardLocalInterests(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int addBrokerInfo(BrokerInfo brokerInfo) {
        Object object;
        block29: {
            if (DEBUG) {
                this.logger.log(4, "RaptorProtocol.addBrokerInfo : " + brokerInfo);
            }
            if (brokerInfo.getClusterProtocolVersion() == null) {
                this.logger.log(16, "B2086", brokerInfo.getBrokerAddr());
                return 2;
            }
            if (brokerInfo.getClusterProtocolVersion() >= 400) {
                try {
                    this.checkUIDPrefixClash(brokerInfo);
                }
                catch (Exception exception) {
                    return 2;
                }
            }
            if (brokerInfo.getClusterProtocolVersion() < 400 && Globals.getHAEnabled()) {
                this.logger.log(16, this.br.getKString("B2118", brokerInfo.getBrokerAddr()));
                return 2;
            }
            if (brokerInfo.getBrokerAddr().getHAEnabled() != Globals.getHAEnabled()) {
                this.logger.log(16, "HA mode not match with remote broker " + brokerInfo.getBrokerAddr());
                return 2;
            }
            object = this.brokerList;
            synchronized (object) {
                if (this.shutdown) {
                    return 2;
                }
                if (this.isTakeoverTarget(brokerInfo.getBrokerAddr())) {
                    this.logger.log(16, this.br.getKString("B2119", brokerInfo));
                    this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), false);
                    return 1;
                }
                Object v = this.brokerList.get(brokerInfo.getBrokerAddr());
                if (v != null) {
                    this.logger.log(16, this.br.getKString("B2120", brokerInfo));
                    return 1;
                }
                BrokerInfoEx brokerInfoEx = new BrokerInfoEx(brokerInfo);
                this.brokerList.put(brokerInfo.getBrokerAddr(), brokerInfoEx);
            }
            if (!this.configSyncComplete) {
                try {
                    object = this.c.getConfigServer();
                    if (object != null && ((BrokerAddress)object).equals(brokerInfo.getBrokerAddr())) {
                        long l = -1L;
                        l = this.getLastRefreshTime();
                        this.sendConfigChangesRequest((BrokerAddress)object, l);
                        if (DEBUG_CLUSTER_ALL || DEBUG_CLUSTER_CONN) {
                            this.logger.log(8, "B1070");
                        }
                        break block29;
                    }
                    if (DEBUG) {
                        this.logger.log(4, "Config sync not complete. Rejecting addBrokerInfo : " + brokerInfo);
                    }
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (DEBUG) {
            this.logger.log(4, "MessageBus: New Broker : {0}", brokerInfo);
        }
        try {
            object = this.c.getConfigServer();
            if (brokerInfo.getStoreDirtyFlag() && object != null && !((BrokerAddress)object).equals(brokerInfo.getBrokerAddr())) {
                long l = -1L;
                l = this.getLastRefreshTime();
                this.sendConfigChangesRequest((BrokerAddress)object, l);
                if (!this.waitConfigChangesResponse()) {
                    this.brokerList.remove(brokerInfo.getBrokerAddr());
                    return 2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (brokerInfo.getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getBrokerID(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), (Object)brokerInfo);
            }
            Globals.getClusterManager().activateBroker(brokerInfo.getBrokerAddr().getMQAddress(), brokerInfo.getBrokerAddr().getBrokerSessionUID(), null);
        }
        catch (Exception exception) {
            this.logger.logStack(32, this.br.getKString("B2115", brokerInfo, exception.getMessage()), exception);
            this.brokerList.remove(brokerInfo.getBrokerAddr());
            return 1;
        }
        this.logger.log(8, this.br.getKString("B1179", brokerInfo));
        if (Globals.getHAEnabled()) {
            this.forwardTakeoverBrokers(brokerInfo.getBrokerAddr(), true);
        }
        if (this.flowStopped) {
            this.sendFlowControlUpdate(brokerInfo.getBrokerAddr());
        }
        this.forwardLocalInterests(brokerInfo.getBrokerAddr());
        this.restartElections(brokerInfo.getBrokerAddr());
        this.logger.log(64, "B1071", brokerInfo.getBrokerAddr().toString());
        return 0;
    }

    private void forwardLocalInterests(BrokerAddress brokerAddress) {
        Serializable serializable;
        Consumer consumer;
        Serializable serializable2;
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.forwardLocalInterests to : " + brokerAddress);
        }
        Iterator iterator = Destination.getTempDestinations(this.selfAddress);
        while (iterator.hasNext()) {
            serializable2 = (Destination)iterator.next();
            try {
                this.sendUpdateDestination((Destination)serializable2);
            }
            catch (BrokerException brokerException) {
                this.logger.logStack(4, brokerException.getMessage(), brokerException);
            }
        }
        serializable2 = new HashSet();
        HashSet<Consumer> hashSet = new HashSet<Consumer>();
        HashSet<Consumer> hashSet2 = new HashSet<Consumer>();
        HashSet<Subscription> hashSet3 = new HashSet<Subscription>();
        iterator = Consumer.getAllConsumers();
        while (iterator.hasNext()) {
            consumer = (Consumer)iterator.next();
            serializable = consumer.getDestination();
            if (((Destination)serializable).getIsLocal() || consumer instanceof Subscription) continue;
            ConsumerUID consumerUID = consumer.getConsumerUID();
            if (this.selfAddress == consumerUID.getBrokerAddress()) {
                if (consumer.getSubscription() != null) {
                    Subscription subscription = consumer.getSubscription();
                    hashSet2.add(consumer);
                    if (!consumer.getSubscription().isDurable()) {
                        hashSet3.add(subscription);
                    } else {
                        hashSet3.add(subscription);
                    }
                } else {
                    serializable2.add(consumer);
                }
            }
            if (!consumer.getIsActiveConsumer() || serializable == null || ((Destination)serializable).getMaxActiveConsumers() != 1) continue;
            hashSet.add(consumer);
        }
        if (!hashSet2.isEmpty()) {
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                this.sendNewInterestUpdate(consumer);
            }
            iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                consumer = (Consumer)iterator.next();
                serializable = consumer.getSubscription();
                this.sendAttachDurable((Subscription)serializable, consumer);
            }
        }
        if (!serializable2.isEmpty()) {
            this.sendNewInterestUpdate(brokerAddress, (Collection)((Object)serializable2));
        }
        if (!hashSet.isEmpty()) {
            this.sendInterestUpdate(brokerAddress, hashSet, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restartElections(BrokerAddress brokerAddress) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.restartElections. broker : " + brokerAddress);
        }
        HashMap hashMap = this.resTable;
        synchronized (hashMap) {
            Set set = this.resTable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Resource resource = (Resource)this.resTable.get(string);
                resource.brokerAdded(brokerAddress);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeBrokerInfo(BrokerAddress brokerAddress) {
        Object object;
        Object object2;
        Iterator iterator;
        Set set;
        Object object3;
        BrokerInfoEx brokerInfoEx;
        block28: {
            if (DEBUG) {
                this.logger.log(4, "RaptorProtocol.removeBrokerInfo. broker : " + brokerAddress);
            }
            brokerInfoEx = null;
            brokerInfoEx = (BrokerInfoEx)this.brokerList.remove(brokerAddress);
            if (DEBUG) {
                this.logger.log(4, "Broker down " + brokerAddress);
            }
            try {
                if (!this.c.getConfigServer().equals(brokerAddress)) break block28;
                Long l = null;
                object3 = null;
                set = this.eventLogWaiters.keySet();
                iterator = this.eventLogWaiters;
                synchronized (iterator) {
                    object2 = set.iterator();
                    while (object2.hasNext()) {
                        l = (Long)object2.next();
                        object3 = (EventLogWaiter)this.eventLogWaiters.get(l);
                        object2.remove();
                        object = object3;
                        synchronized (object) {
                            if (((EventLogWaiter)object3).getStatus() == 0) {
                                ((EventLogWaiter)object3).setStatus(2);
                            }
                            object3.notify();
                        }
                    }
                }
                iterator = this.cfgSrvWaitObject;
                synchronized (iterator) {
                    if (this.cfgSrvRequestCount > 0) {
                        this.cfgSrvRequestCount = 0;
                        this.cfgSrvRequestErr = true;
                        this.cfgSrvWaitObject.notifyAll();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logger.log(64, "B1072", brokerAddress.toString());
        this.cbDispatcher.brokerDown(brokerAddress);
        boolean bl = false;
        if (brokerInfoEx != null) {
            bl = brokerInfoEx.goodbyeDone();
        }
        this.ackackTracker.removeBroker(brokerAddress, bl, this.shutdown);
        this.takeoverPendingReplyTracker.removeBroker(brokerAddress, bl, this.shutdown);
        object3 = this.resTable;
        synchronized (object3) {
            set = this.resTable.keySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Resource)this.resTable.get(object2);
                ((Resource)object).brokerRemoved(brokerAddress);
            }
        }
        if (brokerInfoEx == null) {
            return;
        }
        object3 = brokerInfoEx.getBrokerInfo();
        try {
            if (brokerInfoEx.getBrokerInfo().getBrokerAddr().getHAEnabled()) {
                Globals.getClusterManager().deactivateBroker(((BrokerInfo)object3).getBrokerAddr().getBrokerID(), (Object)((BrokerInfo)object3).getBrokerAddr().getBrokerSessionUID());
            } else {
                Globals.getClusterManager().deactivateBroker(((BrokerInfo)object3).getBrokerAddr().getMQAddress(), (Object)((BrokerInfo)object3).getBrokerAddr().getBrokerSessionUID());
            }
            this.logger.log(8, this.br.getKString("B1180", object3));
        }
        catch (NoSuchElementException noSuchElementException) {
            if (DEBUG) {
                this.logger.logStack(8, "Unable to deactivate " + object3, noSuchElementException);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(16, this.br.getKString("B2116", object3, exception.getMessage()), exception);
        }
        brokerInfoEx.deactivated();
    }

    private void configServerBackup(String string) {
        if (DEBUG) {
            this.logger.log(4, "ConfigServerBackup. fileName : " + string);
        }
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = this.c.getConfigServer();
        }
        catch (Exception exception) {
            this.logger.log(16, "B2054");
            return;
        }
        if (brokerAddress == null || !brokerAddress.equals(this.selfAddress)) {
            this.logger.log(16, "B2054");
            return;
        }
        try {
            File file = new File(string);
            if (!file.createNewFile()) {
                this.logger.log(16, "B2055", string);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Object[] objectArray = this.store.getAllConfigRecords();
            ArrayList arrayList = this.compressConfigRecords(objectArray);
            dataOutputStream.writeInt(this.version);
            dataOutputStream.writeUTF("imq.cluster.masterbroker.backup");
            byte[] byArray = RaptorProtocol.prepareResetPersistenceRecord();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray, 0, byArray.length);
            for (int i = 0; i < arrayList.size(); ++i) {
                ChangeRecord changeRecord = (ChangeRecord)arrayList.get(i);
                if (changeRecord.discard) continue;
                byte[] byArray2 = changeRecord.getBytes();
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            dataOutputStream.writeInt(0);
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B2056", exception);
        }
        if (DEBUG) {
            this.logger.log(4, "ConfigServerBackup complete.");
        }
    }

    private ArrayList compressConfigRecords(Object[] objectArray) throws Exception {
        ArrayList arrayList = (ArrayList)objectArray[1];
        ArrayList<ChangeRecord> arrayList2 = new ArrayList<ChangeRecord>();
        HashMap<String, ChangeRecord> hashMap = new HashMap<String, ChangeRecord>();
        if (DEBUG) {
            this.logger.log(4, "CompressConfigRecords: Retrieved " + arrayList.size() + " change records");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            byte[] byArray = (byte[])arrayList.get(i);
            ChangeRecord changeRecord = ChangeRecord.makeChangeRecord(byArray);
            if (DEBUG) {
                this.logger.log(4, "CompressConfigRecords: #" + i + " " + ((ArrayList)objectArray[0]).get(i) + " " + ProtocolGlobals.getPacketTypeString(changeRecord.getOperation()) + " key=" + changeRecord.getUniqueKey());
            }
            arrayList2.add(changeRecord);
            ChangeRecord changeRecord2 = (ChangeRecord)hashMap.get(changeRecord.getUniqueKey());
            if (changeRecord2 != null) {
                changeRecord2.discard = true;
                if (DEBUG) {
                    this.logger.log(4, ">>>>CompressConfigRecords: discard previous record " + ProtocolGlobals.getPacketTypeString(changeRecord2.getOperation()) + " key=" + changeRecord.getUniqueKey());
                }
            }
            if (!changeRecord.isAddOp()) {
                changeRecord.discard = true;
                if (DEBUG) {
                    this.logger.log(4, ">>>>CompressConfigRecords: discard this 'non-add' record ");
                }
            }
            hashMap.put(changeRecord.getUniqueKey(), changeRecord);
        }
        return arrayList2;
    }

    private void configServerRestore(String string) {
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.configServerRestore. fileName = " + string);
        }
        try {
            int n;
            File file = new File(string);
            if (!file.exists()) {
                this.logger.log(16, "B2057", string);
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            int n2 = dataInputStream.readInt();
            String string2 = dataInputStream.readUTF();
            if (!string2.equals("imq.cluster.masterbroker.backup")) {
                this.logger.log(16, "B2058", string);
                return;
            }
            if (n2 < 350 || n2 > this.version) {
                this.logger.log(16, "B2059");
                return;
            }
            this.store.clearAllConfigChangeRecords(false);
            while ((n = dataInputStream.readInt()) != 0) {
                byte[] byArray = new byte[n];
                dataInputStream.readFully(byArray, 0, n);
                this.store.storeConfigChangeRecord(System.currentTimeMillis(), byArray, false);
            }
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.logger.logStack(16, "B2060", exception);
            return;
        }
        if (DEBUG) {
            this.logger.log(4, "RaptorProtocol.configServerRestore complete.");
        }
    }

    private void storeLastConfigServer(BrokerAddress brokerAddress) throws BrokerException {
        this.store.updateProperty("MessageBus.lastConfigServer", brokerAddress, false);
    }

    private BrokerAddress getLastConfigServer() {
        BrokerAddress brokerAddress = null;
        try {
            brokerAddress = (BrokerAddress)this.store.getProperty("MessageBus.lastConfigServer");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return brokerAddress;
    }

    private void storeLastRefreshTime(long l) throws BrokerException {
        Long l2 = new Long(l);
        this.store.updateProperty("MessageBus.lastRefreshTime", l2, false);
    }

    private long getLastRefreshTime() {
        Long l = null;
        try {
            l = (Long)this.store.getProperty("MessageBus.lastRefreshTime");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l == null) {
            return -1L;
        }
        return l;
    }

    public boolean getConfigSyncComplete() {
        return this.configSyncComplete;
    }

    private static byte[] getEventData(GPacket gPacket) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gPacket.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] generateAddDurableRecord(Subscription subscription) {
        try {
            ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
            return RaptorProtocol.getEventData(clusterSubscriptionInfo.getGPacket((short)5, true));
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateAddDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDurableRecord(Subscription subscription) {
        try {
            ClusterSubscriptionInfo clusterSubscriptionInfo = ClusterSubscriptionInfo.newInstance(subscription);
            return RaptorProtocol.getEventData(clusterSubscriptionInfo.getGPacket((short)7, true));
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDurableRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateAddDestinationRecord(Destination destination) {
        try {
            ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
            GPacket gPacket = clusterDestInfo.getGPacket((short)13, true);
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    public static byte[] generateRemDestinationRecord(Destination destination) {
        try {
            ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(destination);
            GPacket gPacket = clusterDestInfo.getGPacket((short)15, true);
            return RaptorProtocol.getEventData(gPacket);
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(8, "Internal Error: generateRemDestinationRecord failed.", exception);
            return null;
        }
    }

    class EventLogWaiter {
        private int status = 2;

        public EventLogWaiter(int n) {
            this.status = n;
        }

        public synchronized int getStatus() {
            return this.status;
        }

        public synchronized void setStatus(int n) {
            this.status = n;
        }
    }

    class BrokerInfoEx {
        private int GOODBYE_SENT = 1;
        private int GOODBYE_RECEIVED = 2;
        private int GOODBYE_REPLY_SENT = 4;
        private int GOODBYE_REPLY_RECEIVED = 8;
        private int finStatus = 0;
        private BrokerInfo info = null;
        private ClusterGoodbyeInfo cgi = null;
        private boolean deactivated = false;

        public BrokerInfoEx(BrokerInfo brokerInfo) {
            this.info = brokerInfo;
        }

        public synchronized boolean deactivated() {
            return this.deactivated;
        }

        public synchronized void deactivate() {
            this.deactivated = true;
            this.notifyAll();
        }

        public synchronized void setGoodbyeInfo(ClusterGoodbyeInfo clusterGoodbyeInfo) {
            this.cgi = clusterGoodbyeInfo;
        }

        public synchronized ClusterGoodbyeInfo getGoodbyeInfo() {
            return this.cgi;
        }

        public BrokerInfo getBrokerInfo() {
            return this.info;
        }

        public void setBrokerInfo(BrokerInfo brokerInfo) {
            this.info = brokerInfo;
        }

        public synchronized boolean goodbyeDone() {
            return this.sentGoodbyeReply() && this.gotGoodbyeReply();
        }

        public synchronized void goodbyeSent() {
            this.finStatus |= this.GOODBYE_SENT;
        }

        public synchronized void goodbyeReceived() {
            this.finStatus |= this.GOODBYE_RECEIVED;
        }

        public synchronized void goodbyeReplySent() {
            this.finStatus |= this.GOODBYE_REPLY_SENT;
        }

        public synchronized void goodbyeReplyReceived() {
            this.finStatus |= this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean gotGoodbye() {
            return this.cgi != null && (this.finStatus & this.GOODBYE_RECEIVED) == this.GOODBYE_RECEIVED;
        }

        public synchronized boolean sentGoodbye() {
            return (this.finStatus & this.GOODBYE_SENT) == this.GOODBYE_SENT;
        }

        public synchronized boolean gotGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_RECEIVED) == this.GOODBYE_REPLY_RECEIVED;
        }

        public synchronized boolean sentGoodbyeReply() {
            return (this.finStatus & this.GOODBYE_REPLY_SENT) == this.GOODBYE_REPLY_SENT;
        }
    }
}

