/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.util.Iterator;

public class InterestUpdateHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public InterestUpdateHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        if (DEBUG) {
            this.logger.log(4, "InterestUpdateHandler");
        }
        if (gPacket.getType() == 9) {
            this.handleInterestUpdate(messageBusCallback, brokerAddress, gPacket);
        } else if (gPacket.getType() == 10) {
            this.handleInterestUpdateReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "InterestUpdateHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    private void handleInterestUpdate(MessageBusCallback messageBusCallback, BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterConsumerInfo clusterConsumerInfo = ClusterConsumerInfo.newInstance(gPacket, this.c);
        int n = clusterConsumerInfo.getConsumerCount();
        int n2 = clusterConsumerInfo.getSubtype();
        try {
            Iterator iterator = clusterConsumerInfo.getConsumerUIDs();
            switch (n2) {
                case 2: 
                case 3: {
                    while (iterator.hasNext()) {
                        ConsumerUID consumerUID = (ConsumerUID)iterator.next();
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer == null) continue;
                        messageBusCallback.interestRemoved(consumer);
                    }
                    break;
                }
                case 4: {
                    while (iterator.hasNext()) {
                        ConsumerUID consumerUID = (ConsumerUID)iterator.next();
                        Consumer consumer = Consumer.getConsumer(consumerUID);
                        if (consumer == null) continue;
                        messageBusCallback.activeStateChanged(consumer);
                    }
                    break;
                }
            }
        }
        catch (Exception exception) {
            this.logger.logStack(4, "Exception processing packet ", exception);
        }
    }

    private void handleInterestUpdateReply(BrokerAddress brokerAddress, GPacket gPacket) {
        this.logger.log(4, "MessageBus: Received G_INTEREST_UPDATE_REPLY from {0} : STATUS = {1}", (Object)brokerAddress, (Integer)gPacket.getProp("S"));
    }
}

