/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class StoreManager {
    private static final String PERSIST_PROP = "imq.persist.";
    private static final String CLASS_PROP = ".class";
    private static final String STORE_TYPE_PROP = "imq.persist.store";
    private static final String DEFAULT_STORE_TYPE = "file";
    private static final String DEFAULT_FILESTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.file.FileStore";
    private static final String DEFAULT_JDBCSTORE_CLASS = "com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore";
    private static Store store = null;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Store getStore() throws BrokerException {
        block15: {
            Logger logger = Globals.getLogger();
            BrokerResources brokerResources = Globals.getBrokerResources();
            if (store == null) {
                String string;
                BrokerConfig brokerConfig = Globals.getConfig();
                String string2 = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
                if (Store.DEBUG) {
                    logger.log(4, "imq.persist.store=" + string2);
                }
                if ((string = brokerConfig.getProperty(PERSIST_PROP + string2 + CLASS_PROP)) == null || string.equals("")) {
                    string = string2.equals(DEFAULT_STORE_TYPE) ? DEFAULT_FILESTORE_CLASS : (string2.equals("jdbc") ? DEFAULT_JDBCSTORE_CLASS : null);
                }
                if (string == null) {
                    logger.log(32, "B3005", string2);
                    throw new BrokerException(brokerResources.getString("B3005", string2));
                }
                if (Store.DEBUG) {
                    logger.log(4, PERSIST_PROP + string2 + CLASS_PROP + "=" + string);
                }
                ReflectiveOperationException reflectiveOperationException = null;
                try {
                    store = (Store)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    reflectiveOperationException = classNotFoundException;
                    return reflectiveOperationException;
                }
                catch (InstantiationException instantiationException) {
                    reflectiveOperationException = instantiationException;
                    return reflectiveOperationException;
                }
                catch (IllegalAccessException illegalAccessException) {
                    reflectiveOperationException = illegalAccessException;
                    return reflectiveOperationException;
                }
                finally {
                    if (reflectiveOperationException == null) break block15;
                    if (reflectiveOperationException instanceof BrokerException) {
                        throw (BrokerException)((Object)reflectiveOperationException);
                    }
                    throw new BrokerException(brokerResources.getString("B3006"), reflectiveOperationException);
                }
            }
        }
        return store;
    }

    public static synchronized void releaseStore(boolean bl) throws BrokerException {
        if (store != null) {
            if (!store.closed()) {
                store.close(bl);
            }
            store = null;
        }
    }

    public static Store getStoreForTonga() throws BrokerException {
        BrokerConfig brokerConfig = Globals.getConfig();
        String string = brokerConfig.getProperty(STORE_TYPE_PROP, DEFAULT_STORE_TYPE);
        if (string.equals("jdbc")) {
            brokerConfig.put("imq.persist.jdbc.lockstore.enabled", "false");
            brokerConfig.put("imq.persist.jdbcconnection.limit", "2");
        }
        return StoreManager.getStore();
    }
}

