/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

class HABrokers {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected BrokerConfig config = Globals.getConfig();
    static final String BASENAME = "habrokers";
    static final int MAGIC = 305419896;
    private ArrayList bkrIDList = new ArrayList();
    private ArrayList takeOverBkrIDList = new ArrayList();
    private ArrayList urlList = new ArrayList();
    private ArrayList bkrVersionList = new ArrayList();
    private ArrayList bkrStateList = new ArrayList();
    private ArrayList bkrSessionIDList = new ArrayList();
    private ArrayList bkrHeartBeatList = new ArrayList();
    private File backingFile = null;
    private RandomAccessFile raf = null;

    HABrokers(File file, boolean bl) throws BrokerException {
        try {
            this.backingFile = new File(file, BASENAME);
            this.raf = new RandomAccessFile(this.backingFile, "rw");
            if (bl) {
                this.clearAll(false);
                if (Store.DEBUG) {
                    this.logger.log(1, "HABrokers initialized with clear option");
                }
            } else {
                this.loadData(this.backingFile, this.raf, this.bkrIDList, this.takeOverBkrIDList, this.urlList, this.bkrVersionList, this.bkrStateList, this.bkrSessionIDList, this.bkrHeartBeatList, true);
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4242", iOException);
            throw new BrokerException(this.br.getString("B4242"), iOException);
        }
    }

    public void addBrokerInfo(String string, String string2, String string3, int n, int n2, long l, long l2) throws BrokerException {
        this.bkrIDList.add(string);
        this.takeOverBkrIDList.add(string2);
        this.urlList.add(string3);
        this.bkrStateList.add(new Integer(n));
        this.bkrVersionList.add(new Integer(n2));
        this.bkrSessionIDList.add(new Long(l));
        this.bkrHeartBeatList.add(new Long(l2));
        try {
            this.appendFile(string, string2, string3, n, n2, l, l2, true);
        }
        catch (IOException iOException) {
            this.bkrIDList.remove(this.bkrIDList.size() - 1);
            this.takeOverBkrIDList.remove(this.takeOverBkrIDList.size() - 1);
            this.urlList.remove(this.urlList.size() - 1);
            this.bkrStateList.remove(this.bkrStateList.size() - 1);
            this.bkrVersionList.remove(this.bkrVersionList.size() - 1);
            this.bkrSessionIDList.remove(this.bkrSessionIDList.size() - 1);
            this.bkrHeartBeatList.remove(this.bkrHeartBeatList.size() - 1);
            this.logger.log(32, "B4083");
            throw new BrokerException(this.br.getString("B4083"), iOException);
        }
    }

    public HashMap getAllBrokerInfos() throws BrokerException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.bkrIDList.size(); ++i) {
            HABrokerInfo hABrokerInfo = new HABrokerInfo((String)this.bkrIDList.get(i), (String)this.takeOverBkrIDList.get(i), (String)this.urlList.get(i), (Integer)this.bkrStateList.get(i), (Integer)this.bkrVersionList.get(i), (Long)this.bkrSessionIDList.get(i), (Long)this.bkrHeartBeatList.get(i));
            hashMap.put(this.bkrIDList.get(i), hABrokerInfo);
        }
        return hashMap;
    }

    void clearAll(boolean bl) throws BrokerException {
        if (Store.DEBUG) {
            this.logger.log(1, "HABrokers.clearAll() called");
        }
        this.bkrIDList.clear();
        this.takeOverBkrIDList.clear();
        this.urlList.clear();
        this.bkrStateList.clear();
        this.bkrVersionList.clear();
        this.bkrSessionIDList.clear();
        this.bkrHeartBeatList.clear();
        try {
            this.raf.setLength(0L);
            this.raf.writeInt(305419896);
            if (bl) {
                this.sync();
            }
        }
        catch (IOException iOException) {
            this.logger.log(32, "B4243", iOException);
        }
    }

    void close(boolean bl) {
        block3: {
            if (Store.DEBUG) {
                this.logger.log(1, "HABrokers : closing, " + this.bkrIDList.size() + " persisted records");
            }
            try {
                this.raf.close();
            }
            catch (IOException iOException) {
                if (!Store.DEBUG) break block3;
                this.logger.log(4, "Got IOException while closing:" + this.backingFile, iOException);
                iOException.printStackTrace();
            }
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("HA broker records", String.valueOf(this.bkrIDList.size()));
        return hashtable;
    }

    void printInfo(PrintStream printStream) {
        printStream.println("\n HA broker Records");
        printStream.println("---------------------------");
        printStream.println("backing file: " + this.backingFile);
        printStream.println("number of records: " + this.bkrIDList.size());
    }

    void sync() throws BrokerException {
        try {
            this.raf.getChannel().force(false);
        }
        catch (IOException iOException) {
            throw new BrokerException("Failed to synchronize file: " + this.backingFile, iOException);
        }
    }

    private void loadData(File file, RandomAccessFile randomAccessFile, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6, ArrayList arrayList7, boolean bl) throws IOException {
        if (randomAccessFile.length() == 0L) {
            if (bl) {
                randomAccessFile.writeInt(305419896);
                if (Store.DEBUG) {
                    this.logger.log(1, "initialized new file with magic number, " + file);
                }
            }
            return;
        }
        this.loadData(file, randomAccessFile, arrayList, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6, arrayList7);
    }

    private void loadData(File file, RandomAccessFile randomAccessFile, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, ArrayList arrayList5, ArrayList arrayList6, ArrayList arrayList7) throws IOException {
        boolean bl = false;
        if (randomAccessFile.length() == 0L) {
            return;
        }
        int n = randomAccessFile.readInt();
        if (n != 305419896) {
            throw new StreamCorruptedException(this.br.getString("B3188", file));
        }
        long l = randomAccessFile.getFilePointer();
        while (!bl) {
            try {
                int n2 = randomAccessFile.readInt();
                byte[] byArray = new byte[n2];
                randomAccessFile.readFully(byArray);
                arrayList.add(new String(byArray));
                n2 = randomAccessFile.readInt();
                byArray = new byte[n2];
                randomAccessFile.readFully(byArray);
                arrayList2.add(new String(byArray));
                n2 = randomAccessFile.readInt();
                byArray = new byte[n2];
                randomAccessFile.readFully(byArray);
                arrayList3.add(new String(byArray));
                arrayList4.add(new Integer(randomAccessFile.readInt()));
                arrayList5.add(new Integer(randomAccessFile.readInt()));
                arrayList6.add(new Long(randomAccessFile.readLong()));
                arrayList7.add(new Long(randomAccessFile.readLong()));
                l = randomAccessFile.getFilePointer();
            }
            catch (EOFException eOFException) {
                if (l != randomAccessFile.getFilePointer()) {
                    randomAccessFile.setLength(l);
                    this.logger.log(16, "B2074", (Object)file, new Long(l));
                }
                bl = true;
            }
            catch (IOException iOException) {
                this.logger.log(16, "B2113", new Integer(arrayList.size()), new Long(l), iOException);
                randomAccessFile.setLength(l);
                bl = true;
            }
        }
        if (Store.DEBUG) {
            this.logger.log(1, "loaded " + arrayList.size() + " records from " + file);
        }
    }

    private void appendFile(String string, String string2, String string3, int n, int n2, long l, long l2, boolean bl) throws IOException, BrokerException {
        long l3 = this.raf.getFilePointer();
        try {
            byte[] byArray = string.getBytes();
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
            byArray = string2.getBytes();
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
            byArray = string3.getBytes();
            this.raf.writeInt(byArray.length);
            this.raf.write(byArray);
            this.raf.writeInt(n);
            this.raf.writeInt(n2);
            this.raf.writeLong(l);
            this.raf.writeLong(l2);
            if (bl) {
                this.sync();
            }
        }
        catch (IOException iOException) {
            this.raf.setLength(l3);
            throw iOException;
        }
        if (Store.DEBUG) {
            this.logger.log(4, "habrokers : appended for broker id = " + string + ".");
        }
    }
}

