/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class DBConnectionPool
implements DBConstants {
    public static final String NUM_CONN_PROP = "imq.persist.jdbcconnection.limit";
    static final String USE_TRUNCATE_PROP = "imq.persist.jdbcsql.useTruncate";
    static final int DEFAULT_NUM_CONN = 5;
    private static int numConnections = 5;
    private static boolean initialized = false;
    private static Object lock = new Object();
    private static LinkedList idleConnections = new LinkedList();
    private static HashSet activeConnections = new HashSet();
    private static DBManager dbmgr = null;
    private static Logger logger = Globals.getLogger();
    private static BrokerResources br = Globals.getBrokerResources();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init() throws BrokerException {
        if (!initialized) {
            Object object = lock;
            synchronized (object) {
                if (initialized) {
                    return;
                }
                dbmgr = DBManager.getDBManager();
                numConnections = Globals.getConfig().getIntProperty(NUM_CONN_PROP, 5);
                if (numConnections < 1) {
                    numConnections = 5;
                    logger.log(4, "Bad number of connection specified, set to default of 5");
                }
                if (dbmgr.getCreateDBURL() != null && Globals.getConfig().getBooleanProperty("imq.persist.storecreate.all", false)) {
                    try {
                        Connection connection = dbmgr.connectToCreate();
                        connection.close();
                    }
                    catch (Exception exception) {
                        String string = dbmgr.getCreateDBURL();
                        logger.log(32, "B3073", (Object)string, (Throwable)exception);
                        throw new BrokerException(br.getString("B3073", string, exception));
                    }
                }
                for (int i = 0; i < numConnections; ++i) {
                    Connection connection = dbmgr.newConnection(true);
                    idleConnections.add(connection);
                }
                initialized = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        if (!initialized) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            Iterator iterator = idleConnections.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    logger.log(16, "B4103", sQLException);
                }
            }
            idleConnections.clear();
            initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection() throws BrokerException {
        Object object = lock;
        synchronized (object) {
            while (idleConnections.isEmpty()) {
                try {
                    lock.wait();
                }
                catch (Exception exception) {
                    logger.log(4, "DBConnectionPool.getConnection(): " + exception);
                }
            }
            Connection connection = (Connection)idleConnections.removeFirst();
            boolean bl = false;
            try {
                bl = connection.isClosed();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (bl) {
                try {
                    Connection connection2;
                    connection = connection2 = dbmgr.newConnection(true);
                    logger.log(8, br.getString("B1149", dbmgr.getOpenDBURL()));
                }
                catch (BrokerException brokerException) {
                    logger.log(32, br.getString("B4206", dbmgr.getOpenDBURL()), brokerException);
                    idleConnections.add(connection);
                    throw brokerException;
                }
            }
            activeConnections.add(connection);
            if (Store.DEBUG) {
                logger.log(4, "DBConnectionPool.getConnection(): check out connection: " + connection);
            }
            return connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeConnection(Connection connection) {
        if (Store.DEBUG) {
            logger.log(4, "DBConnectionPool.freeConnection(): check in connection: " + connection);
        }
        Object object = lock;
        synchronized (object) {
            activeConnections.remove(connection);
            idleConnections.add(connection);
            lock.notify();
        }
    }

    static boolean validate(Connection connection) {
        try {
            connection.getMetaData();
        }
        catch (Exception exception) {
            logger.log(4, "DBConnectionPool.validate(): Lost database connection to " + dbmgr.getOpenDBURL(), exception);
            return false;
        }
        return true;
    }

    static boolean handleException(Connection connection, Throwable throwable) {
        if (DBConnectionPool.validate(connection)) {
            logger.log(4, "connection is good; return false (no need to retry)");
            return false;
        }
        return true;
    }
}

