/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.DestMetricsCounters;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class MessageDAOImpl
extends BaseDAOImpl
implements MessageDAO {
    protected String tableName;
    protected static int msgColumnType = -2147483647;
    protected String insertSQL;
    protected String updateDestinationSQL;
    protected String deleteSQL;
    protected String deleteByDstSQL;
    protected String selectSQL;
    protected String selectForUpdateSQL;
    protected String selectBrokerSQL;
    protected String selectCountSQL;
    protected String selectCountByDstSQL;
    protected String selectCountByBrokerSQL;
    protected String selectCountByConsumerAckedSQL;
    protected String selectIDsByDstSQL;
    protected String selectExistSQL;
    protected String selectTakeoverSQL;
    protected String takeoverSQL;

    MessageDAOImpl() throws BrokerException {
        DBManager dBManager = DBManager.getDBManager();
        this.tableName = dBManager.getTableName("MQMSG40");
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("BROKER_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("SYSMESSAGE_ID").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, ? )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ?, ").append("MESSAGE").append(" = ?").append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.deleteByDstSQL = new StringBuffer(128).append("DELETE FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectCountSQL = new StringBuffer(128).append("SELECT COUNT(*) ").append(" FROM ").append(this.tableName).toString();
        this.selectCountByBrokerSQL = new StringBuffer(128).append("SELECT COUNT(*) ").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.selectCountByDstSQL = new StringBuffer(128).append("SELECT totalmsg, totalsize, ").append("ID").append(" FROM ").append(dBManager.getTableName("MQDST40")).append(", (SELECT COUNT(").append("ID").append(") totalmsg, SUM(").append("MESSAGE_SIZE").append(") totalsize").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("DESTINATION_ID").append(" = ?) msgtable").append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectCountByConsumerAckedSQL = new StringBuffer(128).append("SELECT COUNT(*) total, SUM(CASE WHEN ").append("STATE").append(" = ").append(2).append(" THEN 1 ELSE 0 END) totalAcked").append(" FROM ").append(this.tableName).append(", ").append(dBManager.getTableName("MQCONSTATE40")).append(" WHERE ").append("ID").append(" = ?").append(" AND ").append("ID").append(" = ").append("MESSAGE_ID").toString();
        this.selectSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectForUpdateSQL = new StringBuffer(128).append(this.selectSQL).append(" FOR UPDATE").toString();
        this.selectBrokerSQL = new StringBuffer(128).append("SELECT ").append("BROKER_ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectIDsByDstSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").append(" AND ").append("DESTINATION_ID").append(" = ?").toString();
        this.selectExistSQL = new StringBuffer(128).append("SELECT ").append("ID").append(" FROM ").append(this.tableName).append(" WHERE ").append("ID").append(" = ?").toString();
        this.selectTakeoverSQL = new StringBuffer(128).append("SELECT ").append("MESSAGE").append(" FROM ").append(this.tableName).append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
        this.takeoverSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("BROKER_ID").append(" = ?").append(" WHERE ").append("BROKER_ID").append(" = ?").toString();
    }

    public final String getTableNamePrefix() {
        return "MQMSG40";
    }

    public String getTableName() {
        return this.tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, String string, long l, boolean bl) throws BrokerException {
        block17: {
            PreparedStatement preparedStatement;
            block16: {
                SysMessageID sysMessageID = packet.getSysMessageID();
                String string2 = sysMessageID.getUniqueName();
                String string3 = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                int n = packet.getPacketSize();
                long l2 = packet.getTransactionID();
                boolean bl2 = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl2 = true;
                    }
                    if (bl) {
                        if (this.hasMessage(connection, string2)) {
                            throw new BrokerException(this.br.getKString("B3008", string2));
                        }
                        dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string3);
                    }
                    if (string == null) {
                        string = dBManager.getBrokerID();
                    }
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
                        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                        sysMessageID.writeID(dataOutputStream);
                        dataOutputStream.flush();
                        byteArrayOutputStream.flush();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        dataOutputStream.close();
                        byteArrayOutputStream.close();
                        byteArrayOutputStream = new ByteArrayOutputStream(n);
                        packet.writePacket(byteArrayOutputStream);
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        byteArrayOutputStream.close();
                        byteArrayOutputStream = null;
                        preparedStatement = connection.prepareStatement(this.insertSQL);
                        preparedStatement.setString(1, string2);
                        preparedStatement.setInt(2, n);
                        preparedStatement.setString(3, string);
                        preparedStatement.setString(4, string3);
                        Util.setLong(preparedStatement, 5, l2 == 0L ? -1L : l2);
                        preparedStatement.setLong(6, l);
                        preparedStatement.setBytes(7, byArray);
                        ByteArrayInputStream byteArrayInputStream = Util.setBytes(preparedStatement, 8, byArray2);
                        byteArrayInputStream.close();
                        preparedStatement.executeUpdate();
                        if (consumerUIDArray != null) {
                            dBManager.getDAOFactory().getConsumerStateDAO().insert(connection, sysMessageID, consumerUIDArray, nArray, false);
                        }
                        if (bl2) {
                            connection.commit();
                        }
                    }
                    catch (Exception exception) {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4004", string2), exception2);
                    }
                    if (!bl2) break block16;
                }
                catch (Throwable throwable) {
                    if (bl2) {
                        Util.close(null, preparedStatement, connection);
                    } else {
                        Util.close(null, preparedStatement, null);
                    }
                    throw throwable;
                }
                Util.close(null, preparedStatement, connection);
                break block17;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void moveMessage(Connection connection, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        block15: {
            PreparedStatement preparedStatement;
            block14: {
                SysMessageID sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
                String string = sysMessageID.getUniqueName();
                int n = packet.getPacketSize();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                    packet.writePacket(byteArrayOutputStream);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                    preparedStatement = connection.prepareStatement(this.updateDestinationSQL);
                    preparedStatement.setString(1, destinationUID2.toString());
                    preparedStatement.setInt(2, n);
                    ByteArrayInputStream byteArrayInputStream = Util.setBytes(preparedStatement, 3, byArray);
                    byteArrayInputStream.close();
                    preparedStatement.setString(4, string);
                    if (preparedStatement.executeUpdate() == 0) {
                        throw new BrokerException(this.br.getKString("B3007", string), 404);
                    }
                    ConsumerStateDAO consumerStateDAO = dBManager.getDAOFactory().getConsumerStateDAO();
                    consumerStateDAO.deleteByMessageID(connection, sysMessageID);
                    if (consumerUIDArray != null || nArray != null) {
                        consumerStateDAO.insert(connection, sysMessageID, consumerUIDArray, nArray, false);
                    }
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block14;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)exception) : exception;
                        Object[] objectArray = new Object[]{string, destinationUID, destinationUID2};
                        throw new BrokerException(this.br.getKString("B4187", objectArray), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block15;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void delete(Connection connection, SysMessageID sysMessageID, DestinationUID destinationUID) throws BrokerException {
        block13: {
            PreparedStatement preparedStatement;
            block12: {
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    this.checkMessage(connection, string);
                    dBManager.getDAOFactory().getConsumerStateDAO().deleteByMessageID(connection, sysMessageID);
                    preparedStatement = connection.prepareStatement(this.deleteSQL);
                    preparedStatement.setString(1, string);
                    preparedStatement.executeUpdate();
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4033", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block13;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteByDestination(Connection connection, Destination destination) throws BrokerException {
        block13: {
            PreparedStatement preparedStatement;
            block12: {
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string);
                    dBManager.getDAOFactory().getConsumerStateDAO().deleteByDestination(connection, destination);
                    preparedStatement = connection.prepareStatement(this.deleteByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.executeUpdate();
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block12;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.deleteByDstSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4150", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block13;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void deleteAll(Connection connection) throws BrokerException {
        String string = null;
        if (Globals.getHAEnabled()) {
            string = new StringBuffer(128).append("BROKER_ID").append(" = '").append(DBManager.getDBManager().getBrokerID()).append("'").toString();
        }
        this.deleteAll(connection, string, null, 0);
    }

    public List takeover(Connection connection, String string, String string2) throws BrokerException {
        List list = Collections.EMPTY_LIST;
        String string3 = null;
        PreparedStatement preparedStatement = null;
        try {
            string3 = this.selectTakeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            list = (List)this.loadData(resultSet, false);
            resultSet.close();
            preparedStatement.close();
            string3 = this.takeoverSQL;
            preparedStatement = connection.prepareStatement(string3);
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string2);
            int n = preparedStatement.executeUpdate();
            if (n != list.size()) {
                Object[] objectArray = new String[]{string2, String.valueOf(list.size()), String.valueOf(n)};
                throw new BrokerException(this.br.getKString("B3175", objectArray));
            }
        }
        catch (Exception exception) {
            try {
                try {
                    if (connection != null && !connection.getAutoCommit()) {
                        connection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    this.logger.log(32, "B4080", sQLException);
                }
                if (exception instanceof BrokerException) {
                    throw (BrokerException)exception;
                }
                Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + string3 + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + string3 + "]", (SQLException)exception) : exception);
                throw new BrokerException(this.br.getKString("B3176", string2), exception2);
            }
            catch (Throwable throwable) {
                Util.close(null, preparedStatement, null);
                throw throwable;
            }
        }
        Util.close(null, preparedStatement, null);
        return list;
    }

    public Packet getMessage(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        String string = sysMessageID.getUniqueName();
        Packet packet = this.getMessage(connection, string);
        if (packet == null) {
            throw new BrokerException(this.br.getKString("B3007", string), 404);
        }
        return packet;
    }

    public Packet getMessage(Connection connection, String string) throws BrokerException {
        Packet packet;
        block9: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block8: {
                packet = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    packet = (Packet)this.loadData(resultSet, true);
                    if (!bl) break block8;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.selectSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectSQL + "]", (SQLException)exception) : exception);
                        throw new BrokerException(this.br.getKString("B4107", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block9;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return packet;
    }

    public String getBroker(Connection connection, String string) throws BrokerException {
        String string2;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                string2 = null;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3007", string), 404);
                    }
                    string2 = resultSet.getString(1);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4107", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return string2;
    }

    public List getMessagesByDestination(Connection connection, Destination destination) throws BrokerException {
        ArrayList<String> arrayList;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                arrayList = new ArrayList<String>();
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectIDsByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        arrayList.add(string2);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectIDsByDstSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4145"), string, exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration messageEnumeration(Destination destination) throws BrokerException {
        Connection connection = null;
        try {
            DBManager dBManager = DBManager.getDBManager();
            connection = dBManager.getConnection(true);
            dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, destination.getUniqueName());
            Iterator iterator = this.getMessagesByDestination(connection, destination).iterator();
            MsgEnumeration msgEnumeration = new MsgEnumeration(this, iterator);
            return msgEnumeration;
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    public boolean hasMessageBeenAcked(Connection connection, SysMessageID sysMessageID) throws BrokerException {
        int n;
        int n2;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n2 = -1;
                n = -1;
                String string = sysMessageID.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByConsumerAckedSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3007", string), 404);
                    }
                    n2 = resultSet.getInt(1);
                    n = resultSet.getInt(2);
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByConsumerAckedSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4107", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n2 != -1 && n != -1 && n2 == n;
    }

    public boolean hasMessage(Connection connection, String string) throws BrokerException {
        boolean bl;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                bl = false;
                boolean bl2 = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl2 = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectExistSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        bl = true;
                    }
                    if (!bl2) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectExistSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4107", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl2) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return bl;
    }

    public void checkMessage(Connection connection, String string) throws BrokerException {
        if (!this.hasMessage(connection, string)) {
            throw new BrokerException(this.br.getKString("B3007", string), 404);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap getDebugInfo(Connection connection) {
        int n;
        HashMap<String, String> hashMap;
        block16: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            boolean bl;
            block15: {
                hashMap = new HashMap<String, String>();
                n = -1;
                bl = false;
                preparedStatement = null;
                resultSet = null;
                if (connection == null) {
                    connection = DBManager.getDBManager().getConnection(true);
                    bl = true;
                }
                if (!(resultSet = (preparedStatement = connection.prepareStatement(this.selectCountSQL)).executeQuery()).next()) break block15;
                n = resultSet.getInt(1);
            }
            try {
                if (bl) {
                    Util.close(resultSet, preparedStatement, connection);
                    break block16;
                }
                Util.close(resultSet, preparedStatement, null);
            }
            catch (BrokerException brokerException) {
                this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
            }
            break block16;
            catch (Exception exception) {
                try {
                    this.logger.log(32, "B4166", (Object)this.selectCountSQL, (Throwable)exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                    }
                    catch (BrokerException brokerException) {
                        this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                    }
                    throw throwable;
                }
                try {
                    if (bl) {
                        Util.close(resultSet, preparedStatement, connection);
                    }
                    Util.close(resultSet, preparedStatement, null);
                }
                catch (BrokerException brokerException) {
                    this.logger.log(32, brokerException.getMessage(), brokerException.getCause());
                }
            }
        }
        hashMap.put("Messages(" + this.tableName + ")", String.valueOf(n));
        return hashMap;
    }

    public int getMessageCount(Connection connection, String string) throws BrokerException {
        int n;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                n = -1;
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByBrokerSQL);
                    preparedStatement.setString(1, string);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        n = resultSet.getInt(1);
                    }
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByBrokerSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4230", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return n;
    }

    public HashMap getMessageStorageInfo(Connection connection, Destination destination) throws BrokerException {
        HashMap<String, Number> hashMap;
        block10: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            block9: {
                hashMap = new HashMap<String, Number>(2);
                String string = destination.getUniqueName();
                boolean bl = false;
                preparedStatement = null;
                resultSet = null;
                try {
                    DBManager dBManager = DBManager.getDBManager();
                    if (connection == null) {
                        connection = DBManager.getDBManager().getConnection(true);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(this.selectCountByDstSQL);
                    preparedStatement.setString(1, dBManager.getBrokerID());
                    preparedStatement.setString(2, string);
                    preparedStatement.setString(3, string);
                    resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3013", string), 404);
                    }
                    hashMap.put(DestMetricsCounters.CURRENT_MESSAGES, new Integer(resultSet.getInt(1)));
                    hashMap.put(DestMetricsCounters.CURRENT_MESSAGE_BYTES, new Long(resultSet.getLong(2)));
                    if (!bl) break block9;
                }
                catch (Exception exception) {
                    try {
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.selectCountByDstSQL + "]", (SQLException)exception) : exception;
                        throw new BrokerException(this.br.getKString("B4152", string), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(resultSet, preparedStatement, connection);
                        } else {
                            Util.close(resultSet, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(resultSet, preparedStatement, connection);
                break block10;
            }
            Util.close(resultSet, preparedStatement, null);
        }
        return hashMap;
    }

    protected Object loadData(ResultSet resultSet, boolean bl) throws IOException, SQLException {
        ArrayList<Packet> arrayList = null;
        if (!bl) {
            arrayList = new ArrayList<Packet>(100);
        }
        while (resultSet.next()) {
            Packet packet = new Packet(false);
            packet.generateTimestamp(false);
            packet.generateSequenceNumber(false);
            InputStream inputStream = null;
            if (this.getMsgColumnType(resultSet, 1) == 2004) {
                Blob blob = resultSet.getBlob(1);
                inputStream = blob.getBinaryStream();
            } else {
                inputStream = resultSet.getBinaryStream(1);
            }
            packet.readPacket(inputStream);
            inputStream.close();
            if (Store.DEBUG) {
                this.logger.log(4, "Loaded message from database for " + packet.getMessageID());
            }
            if (bl) {
                return packet;
            }
            arrayList.add(packet);
        }
        return arrayList;
    }

    protected int getMsgColumnType(ResultSet resultSet, int n) throws SQLException {
        if (msgColumnType == -2147483647) {
            msgColumnType = resultSet.getMetaData().getColumnType(n);
        }
        return msgColumnType;
    }

    private static class MsgEnumeration
    implements Enumeration {
        MessageDAO msgDAO = null;
        Iterator msgIDItr = null;
        Object msgToReturn = null;

        MsgEnumeration(MessageDAO messageDAO, Iterator iterator) {
            this.msgDAO = messageDAO;
            this.msgIDItr = iterator;
        }

        public boolean hasMoreElements() {
            Packet packet = null;
            while (this.msgIDItr.hasNext()) {
                String string = null;
                try {
                    string = (String)this.msgIDItr.next();
                    packet = this.msgDAO.getMessage(null, string);
                    this.msgToReturn = packet;
                    return true;
                }
                catch (Exception exception) {
                    Globals.getLogger().logStack(32, "B4107", string, (Throwable)exception);
                }
            }
            this.msgToReturn = null;
            return false;
        }

        public Object nextElement() {
            if (this.msgToReturn != null) {
                return this.msgToReturn;
            }
            throw new NoSuchElementException();
        }
    }
}

