/*
 * @(#) 1.11
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

#ifndef MQ_SSL_H
#define MQ_SSL_H

/*
 * declaration for initializing SSL library
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "mqtypes.h"  

/**
 * This function initializes the SSL library.  It must be called before
 * connecting to the broker over SSL.  
 *
 * @param certificateDatabasePath the path to the NSS certificate database
 * @return the status of the function call.  Pass this value to
 *         MQStatusIsError to determine if the call was
 *         successful.  */
EXPORTED_SYMBOL MQStatus 
MQInitializeSSL(ConstMQString certificateDatabasePath);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MQ_SSL_H */
