#!/bin/sh

TMP_IMQTESTDIR=/tmp/imqtest-java
IMQTESTJAVA_ZIP=imqtest-java.zip
WSTOP=$1

if [ -d "$TMP_IMQTESTDIR" ]; then
   echo Warning: "$TMP_IMQTESTDIR" already exists.
   echo Please remove "$TMP_IMQTESTDIR" before running this target.
   exit 1
fi
echo "-----------------------------------------------------------"
echo "Creating $IMQTESTJAVA_ZIP.  This will take a few minutes..."
echo "Use at your own risk."
echo "Note: This will create an test file of the java tests (no C tests)."
echo "Note: If your workspace is not updated, the $IMQTESTJAVA_ZIP"
echo "      file will be invalid."

mkdir $TMP_IMQTESTDIR
find src test -name GNUmakefile -print > $TMP_IMQTESTDIR/exclude_file

tar cfFX - $TMP_IMQTESTDIR/exclude_file test/setup | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file test/src | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file test/testlist | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file binary/share/opt/classes/test | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file binary/solaris/opt/testbin | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file test/test.map | (cd $TMP_IMQTESTDIR; tar xfBp -)
tar cfFX - $TMP_IMQTESTDIR/exclude_file test/doc | (cd $TMP_IMQTESTDIR; tar xfBp -)

cd /tmp
rm -f $TMP_IMQTESTDIR/exclude_file
zip -r $IMQTESTJAVA_ZIP imqtest-java
cd $WSTOP
rm -f dist/bundles/$IMQTESTJAVA_ZIP
mv -f /tmp/$IMQTESTJAVA_ZIP $WSTOP/dist/bundles
#rm -rf $TMP_IMQTESTDIR
echo "Done."
echo "-----------------------------------------------------------"
echo "Test file created at: $WSTOP/dist/bundles/$IMQTESTJAVA_ZIP"
echo " "
