/*
 * @(#)ExternalManager.java	1.2 01/11/30
 * Original @(#)ExternalManager.java	1.7 00/11/21
 * 
 * Copyright 2000-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 */
package com.sun.jms.spi;

import java.security.GeneralSecurityException;

public interface ExternalManager {

    /**
     * Returns the printwriter to use for the error log. If not set
     * explicitly then System.err should be returned.
     * @return PrintStream to use for output of error text.
     */
    java.io.PrintWriter getErrorLog();


    /**
     * Returns the printwriter to use for the trace or debug log. If
     * not set explicitly then System.out should be returned.
     * @return PrintStream to use for output of trace or debug text.
     */
    java.io.PrintWriter getOutputLog();


    /**
     * Returns the printwriter to use for the event log. If
     * not set explicitly then System.out should be returned.
     * @return PrintStream to use for output of event text.
     */
    java.io.PrintWriter getEventLog();
    
    /**
     * Authenticate username and password.
     * @throws GeneralSecurityException if authenticate fails.
     */
    public void authenticate(String username, String password)
        throws GeneralSecurityException;

   /**
    * Returns flag indicating if aut-recovery is enabled for distributed
    * transactions. If so then JMS must recover prepared transactions.
    * services for JMS.
    * @return boolean if true then auto-recover 
    */
   public boolean getAutoRecover();





}






