/*
 * @(#)JMSXAQueueConnection.java	1.2 01/11/30
 * Original @(#)JMSXAQueueConnection.java	1.3 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** JMSXAQueueConnection creates JMSXAQueueSession and provides the QueueConnection associated
  * with this JMSXAQueueConnection.
  *
  *
  * @version     1.0 - 13 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.spi.xa.XAConnection
  */

public interface JMSXAQueueConnection 
	extends JMSXAConnection {

    /** Create an XAQueueSession.
      *  
      * @exception JMSException if JMS Connection fails to create a
      *                         XA queue session due to some internal error.
      */ 

    JMSXAQueueSession
    createXAQueueSession(boolean transacted, int acknowledgeMode) throws JMSException;

    /** get an QueueConnection associated with this XAQueueConnection object.
      *  
      * @return a QueueConnection.
      */ 
    QueueConnection getQueueConnection();
}
